#include <iostream>
#include "DVB.hh"

enum {Q_YESNO, Q_INTEGER, Q_FLOAT};

int ask(const char *qe, int type, void *r)
{
        char ans[80];
        cerr << qe << " ?";
        switch(type){
        case Q_YESNO:
                cerr << " (y/N) ";
                cin >> ans;
                if ( ans[0] == 'Y' ) return 1;
                if ( ans[0] == 'y' ) return 1;
                return 0;

        case Q_INTEGER:
        {
                int *i = (int *)r;
                *i = 0;
                cin >> *i;
        }
        return 0;

        case Q_FLOAT:
        {
                float *d = (float *)r;
                *d = 0;
                cin >> *d;
        }
                return 0;
        }
        return -1;
}

int main(int argc, char **argv)
{
        ifstream con(argv[1]);	
	DVB dvb(0);
	int n=0;

	con >> dvb;
	if (ask("Clear all channels", Q_YESNO, NULL)){
		for (int i=0; i<dvb.num[CHAN]; i++) {
			dvb.chans[i].clearall();
		}
		dvb.num[CHAN]=0;
	}
	for (int s=0; s < dvb.num[SAT]; s++){
		ostringstream satq;
                uint16_t satid;

		satq << "Check " << dvb.sats[s].name << " satellite" << ends;
		if (!ask(satq.str().data(), Q_YESNO, NULL)) continue;
		satid = dvb.sats[s].id;
		for (int t=0; t < dvb.num[TRANS]; t++){
			if (dvb.tps[t].satid == satid){
				uint16_t tpid;
				int c=0;
				tpid = dvb.tps[t].id;

				c = dvb.search_in_TP(tpid, satid, 0,1);
				n+=c;
				cerr << " found " << c << " channel(s)" 
				     << endl; 
			}
		}
	}
		
	cerr << "Found " << n << " new channels" << endl;
	
	cout << dvb;
}
