/******************************************************************************
 * Preamble
 ******************************************************************************/

#include <fcntl.h>                                                   /* open */
#include <stdio.h>                                                 /* printf */
#include "getopt.h"                                              /* getopt() */
#include <stdlib.h>                                                  /* atoi */
#include <sys/stat.h>                                               /* fstat */
#include <sys/time.h>                                             /* timeval */
#include <sys/types.h>
#include <pthread.h>                                            /* pthread_* */
#include <unistd.h>                                    /* usleep (not POSIX) */
#include <sys/socket.h>
#include <netinet/in.h>                                             /* ntohl */
#include <sys/ioctl.h>                                              /* ioctl */
#include <netdb.h>                                              /* inet_ntoa */
#include <net/if.h>                                        /* for netutils.h */
#include <string.h>                                                 /* errno */
#include <errno.h>                                                  /* errno */

#include "error.h"                                                /* err_sys */
#include "types.h"                                                     /* u8 */
#include "timebase_const.h"                             /* PCR_FREQUENCY_KHZ */
#include "netutils.h"                /* netutils (get the broadcast address) */

/******************************************************************************
 * Types and defines
 ******************************************************************************/

/* The buffer must be large enough (3s for a TS at 8Mbits/s) to be sure to
 * find 2 TS packets containing a PCR inside. This is the condition to
 * calibrate the encoder clock.
 */
#define TS_BUFFER_SIZE (797*3)

#define PS_METHOD 1
#define TS_METHOD 2

#define TS_PACKET_SIZE 188
#define TS_IN_UDP 7

#define REQUESTED_AC3 0
#define REQUESTED_MPEG 1
#define REQUESTED_LPCM 2
#define REQUESTED_NOAUDIO 255

#define MAX_AUDIO_CHANNEL 15
#define MAX_SUBTITLES_CHANNEL 31
#define NO_SUBTITLES 255

typedef u8 file_ts_packet[TS_PACKET_SIZE];
typedef file_ts_packet udp_packet[TS_IN_UDP];

typedef struct synchro_struct
{
    s64     delta_clock;
    s64     slope;
    s64     last_pcr_time;
    
    file_ts_packet *last_pcr;
} synchro_t;

struct s_in_data
{
    int start, end;
    pthread_mutex_t lock;
    pthread_cond_t notfull;
    pthread_cond_t notempty;
    int b_die;
    udp_packet buf[TS_BUFFER_SIZE+1];
};

struct s_own_pcr
{
    int start, end;
    pthread_mutex_t lock;
    file_ts_packet *buf[(TS_BUFFER_SIZE+1)*TS_IN_UDP+1];
};

struct s_netthread
{
    unsigned int left;
    int out;
    struct sockaddr_in remote_addr;
};

typedef struct s_options
{
    unsigned int pcr_pid;
    unsigned int method;
    unsigned int audio_type;
    unsigned int audio_channel;
    unsigned int subtitles_channel;
    unsigned int ttl;
    unsigned int loop;
    int in; 
    char *host;
    char *dev;
    char **playlist;
    int i_list_index;
    int i_list_size;
} options_t;

/******************************************************************************
 * Globals
 ******************************************************************************/

struct s_in_data in_data;
struct s_own_pcr own_pcr;
ssize_t safe_read( options_t *options, unsigned char *buf, int count );
synchro_t synchro;

int keep_pcr(int pcr_pid, file_ts_packet *ts);
void *network_thread(void *arg);

