/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.ArrayList;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;

class Comment {
    protected static final int CMT_DEFAULT = 0;
    protected static final int CMT_LEGEND = 1;
    protected static final int CMT_GPRINT = 2;
    protected static final int CMT_NOLEGEND = 3;
    protected static final Byte TKN_ALF = new Byte(1);
    protected static final Byte TKN_ARF = new Byte(2);
    protected static final Byte TKN_ACF = new Byte(3);
    protected static final Byte TKN_AL = new Byte(4);
    protected static final Byte TKN_AR = new Byte(5);
    protected static final Byte TKN_AC = new Byte(6);
    protected static final Byte TKN_NULL = null;
    protected int lineCount = 0;
    protected boolean endLf = false;
    protected boolean addSpacer = true;
    protected boolean trimString = false;
    protected int commentType = 0;
    protected Byte lfToken = TKN_ALF;
    protected String text;
    protected ArrayList oList = new ArrayList(3);

    Comment() {
    }

    Comment(String string) throws RrdException {
        this.text = string;
        if (string != null) {
            this.parseComment();
        }
    }

    void parseComment() throws RrdException {
        String string = this.text;
        int n = string.indexOf("@g");
        if (n >= 0 && n == string.length() - 2) {
            this.addSpacer = false;
            this.trimString = true;
            string = string.substring(0, string.length() - 2);
        } else {
            n = string.indexOf("@G");
            if (n >= 0 && n == string.length() - 2) {
                this.addSpacer = false;
                this.trimString = false;
                string = string.substring(0, string.length() - 2);
            }
        }
        int n2 = 0;
        n = string.indexOf("@");
        int n3 = string.indexOf("\n");
        if (n == string.length()) {
            n = -1;
        }
        if (n3 == string.length()) {
            n3 = -1;
        }
        while (n >= 0 || n3 >= 0) {
            Byte by;
            if (n >= 0 && n3 >= 0) {
                if (n < n3) {
                    by = this.getToken(string.charAt(n + 1));
                    if (by != TKN_NULL) {
                        this.oList.add(string.substring(n2, n));
                        this.oList.add(by);
                        n2 = n + 2;
                        n = string.indexOf("@", n2);
                    } else {
                        n = string.indexOf("@", n + 1);
                    }
                } else {
                    this.oList.add(string.substring(n2, n3));
                    this.oList.add(this.lfToken);
                    this.endLf = true;
                    ++this.lineCount;
                    n2 = n3 + 1;
                    n3 = string.indexOf("\n", n2);
                }
            } else if (n >= 0) {
                by = this.getToken(string.charAt(n + 1));
                if (by != TKN_NULL) {
                    this.oList.add(string.substring(n2, n));
                    this.oList.add(by);
                    n2 = n + 2;
                    n = string.indexOf("@", n2);
                } else {
                    n = string.indexOf("@", n + 1);
                }
            } else {
                this.oList.add(string.substring(n2, n3));
                this.oList.add(this.lfToken);
                this.endLf = true;
                ++this.lineCount;
                n2 = n3 + 1;
                n3 = string.indexOf("\n", n2);
            }
            if (n == string.length()) {
                n = -1;
            }
            if (n3 != string.length()) continue;
            n3 = -1;
        }
        if (n2 < string.length()) {
            this.oList.add(string.substring(n2));
            this.oList.add(TKN_NULL);
        }
    }

    Byte getToken(char c) {
        switch (c) {
            case 'l': {
                ++this.lineCount;
                this.endLf = true;
                return TKN_ALF;
            }
            case 'L': {
                return TKN_AL;
            }
            case 'r': {
                ++this.lineCount;
                this.endLf = true;
                return TKN_ARF;
            }
            case 'R': {
                return TKN_AR;
            }
            case 'c': {
                ++this.lineCount;
                this.endLf = true;
                return TKN_ACF;
            }
            case 'C': {
                return TKN_AC;
            }
        }
        return TKN_NULL;
    }

    boolean isCompleteLine() {
        return this.endLf;
    }

    ArrayList getTokens() {
        return this.oList;
    }

    int getLineCount() {
        return this.lineCount;
    }

    boolean addSpacer() {
        return this.addSpacer;
    }

    boolean trimString() {
        return this.trimString;
    }

    String getText() {
        return this.text;
    }

    void exportXmlTemplate(XmlWriter xmlWriter) {
        xmlWriter.writeTag("comment", this.getText());
    }
}

