/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.servers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.VlServer;

public class ServersAddValidator implements Validator {

    public boolean supports(Class arg0) {
        return arg0.equals(ServersAdd.class);
    }

    public void validate(Object arg0, Errors arg1) {
        ServersAdd serversAdd = (ServersAdd) arg0;

        if (serversAdd == null) {
            arg1.rejectValue("name", "servers.add.error.not-specified");
            return;
        } else {
            if ("".equals(serversAdd.getName())) {
                arg1.rejectValue("name", "servers.add.error.invalidname");
                return;
            }
            InetAddress serverAddress;
            if ("".equals(serversAdd.getAddress())) {
                arg1.rejectValue("address", "servers.add.error.invalidaddress");
                return;
            }
            try {
                serverAddress = InetAddress.getByName(serversAdd.getAddress());
            } catch (UnknownHostException e) {
                arg1.rejectValue("address", "servers.add.error.invalidaddress");
                return;
            }
            IVlData data = serversAdd.getData();
            List<VlServer> servers = data.getServers();
            if (servers != null)
            {
            for (VlServer server : servers) {
                if (server.getName() == serversAdd.getName()) {
                    arg1.rejectValue("name", "servers.add.error.existingname");
                    return;
                }
                if (serverAddress.equals(server.getIp())) {
                    arg1.rejectValue("address",
                            "servers.add.error.existingaddress");
                    return;
                }
            }
            }
        }
    }

}
