/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import vlcskineditor.GlobalVariables;
import vlcskineditor.Item;
import vlcskineditor.Layout;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Resource;
import vlcskineditor.Window;
import vlcskineditor.XML;
import vlcskineditor.history.ThemeEditEvent;
import vlcskineditor.items.Group;
import vlcskineditor.items.Panel;
import vlcskineditor.resources.Bitmap;
import vlcskineditor.resources.BitmapFont;
import vlcskineditor.resources.Font;
import vlcskineditor.resources.SubBitmap;

public class Skin
implements ActionListener {
    public List<Resource> resources = new LinkedList<Resource>();
    public List<Window> windows = new LinkedList<Window>();
    final String HEADER = "<!DOCTYPE Theme PUBLIC \"-//VideoLAN//DTD VLC Skins V2.0//EN\" \"skin.dtd\">";
    final String THEME_VERSION_DEFAULT = "2.0";
    final String THEME_TOOLTIPFONT_DEFAULT = "defaultfont";
    final int THEME_MAGNET_DEFAULT = 15;
    final int THEME_ALPHA_DEFAULT = 255;
    final int THEME_MOVEALPHA_DEFAULT = 255;
    String theme_version = "2.0";
    String theme_tooltipfont = "defaultfont";
    public int theme_magnet = 15;
    public int theme_alpha = 255;
    public int theme_movealpha = 255;
    final String THEMEINFO_NAME_DEFAULT = "Unnamed Theme";
    final String THEMEINFO_AUTHOR_DEFAULT = "Unknown Author";
    final String THEMEINFO_EMAIL_DEFAULT = "Unknown";
    final String THEMEINFO_WEBPAGE_DEFAULT = "http://www.videolan.org/vlc/";
    public String themeinfo_name = "Unnamed Theme";
    public String themeinfo_author = "Unknown Author";
    public String themeinfo_email = "Unknown";
    public String themeinfo_webpage = "Unknown";
    File skinfile;
    public String skinfolder;
    public Main m;
    Window active_window = null;
    Layout active_layout = null;
    int unnamed_ids = 0;
    JFrame theme_frame;
    JTextField themeinfo_name_tf;
    JTextField themeinfo_author_tf;
    JTextField themeinfo_email_tf;
    JTextField themeinfo_webpage_tf;
    JTextField theme_magnet_tf;
    JTextField theme_alpha_tf;
    JTextField theme_movealpha_tf;
    JButton theme_ok_btn;
    JButton theme_cancel_btn;
    JButton theme_help_btn;
    public GlobalVariables gvars = new GlobalVariables();
    public JFrame edit_frame;
    public static String indentation = "  ";

    public Skin(Main main) {
        this.m = main;
    }

    public void createNew(File file) {
        this.skinfile = file;
        this.skinfolder = file.getParentFile().getAbsolutePath() + File.separator;
        try {
            this.skinfile.createNewFile();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), "Error while creating new skin file!", 0);
        }
    }

    public void open(File file) {
        this.resources.clear();
        this.windows.clear();
        this.skinfile = file;
        this.skinfolder = file.getParentFile().getAbsolutePath() + File.separator;
        try {
            this.parse(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = "";
            for (int i = 0; i < exception.getStackTrace().length; ++i) {
                string = string + exception.getStackTrace()[i].toString() + "\n";
            }
            JOptionPane.showMessageDialog(null, exception.toString() + "\n\n" + string, exception.getMessage(), 0);
            this.update();
        }
        this.update();
    }

    private void parse(File file) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = bufferedReader.readLine();
        if (string.indexOf("//VideoLAN//DTD VLC Skins") == -1) {
            bufferedReader.close();
            throw new Exception("File appears not to be a valid VLC Theme!\nInvalid Header:\n" + string);
        }
        boolean bl = false;
        String string2 = "";
        while (!bl) {
            String string3;
            boolean bl2;
            try {
                string2 = bufferedReader.readLine();
                if (string2 == null) break;
                string2 = string2.trim();
            }
            catch (Exception exception) {
                bl = true;
                break;
            }
            if (string2.startsWith("<!--")) {
                while (string2.indexOf("-->") == -1) {
                    string2 = bufferedReader.readLine();
                }
                continue;
            }
            if (string2.startsWith("<ThemeInfo")) {
                if (string2.indexOf("name") != -1) {
                    this.themeinfo_name = XML.getValue(string2, "name");
                }
                if (string2.indexOf("author") != -1) {
                    this.themeinfo_author = XML.getValue(string2, "author");
                }
                if (string2.indexOf("email") != -1) {
                    this.themeinfo_email = XML.getValue(string2, "email");
                }
                if (string2.indexOf("webpage") == -1) continue;
                this.themeinfo_webpage = XML.getValue(string2, "webpage");
                continue;
            }
            if (string2.startsWith("<Theme")) {
                if (string2.indexOf("version") != -1) {
                    this.theme_version = XML.getValue(string2, "version");
                }
                if (string2.indexOf("tooltipfont") != -1) {
                    this.theme_tooltipfont = XML.getValue(string2, "tooltipfont");
                }
                if (string2.indexOf("magnet") != -1) {
                    this.theme_magnet = Integer.parseInt(XML.getValue(string2, "magnet"));
                }
                if (string2.indexOf(" alpha") != -1) {
                    this.theme_alpha = Integer.parseInt(XML.getValue(string2, "alpha"));
                }
                if (string2.indexOf("movealpha") == -1) continue;
                this.theme_movealpha = Integer.parseInt(XML.getValue(string2, "movealpha"));
                continue;
            }
            if (string2.startsWith("<Bitmap")) {
                if (string2.indexOf("/>") != -1) {
                    this.resources.add(new Bitmap(string2, this));
                    continue;
                }
                bl2 = false;
                string3 = "";
                while (!bl2) {
                    try {
                        string3 = bufferedReader.readLine();
                        string3 = string3.trim();
                    }
                    catch (Exception exception) {
                        bl2 = true;
                    }
                    if (string3.startsWith("</Bitmap>")) {
                        string2 = string2 + "\n" + string3;
                        bl2 = true;
                        continue;
                    }
                    string2 = string2 + "\n" + string3;
                }
                this.resources.add(new Bitmap(string2, this));
                continue;
            }
            if (string2.startsWith("<Font")) {
                this.resources.add(new Font(string2, this));
                continue;
            }
            if (string2.startsWith("<BitmapFont")) {
                this.resources.add(new BitmapFont(string2, this));
                continue;
            }
            if (!string2.startsWith("<Window")) continue;
            bl2 = false;
            string3 = "";
            while (!bl2) {
                try {
                    string3 = bufferedReader.readLine();
                    string3 = string3.trim();
                }
                catch (Exception exception) {
                    bl2 = true;
                }
                if (string3.startsWith("</Window>")) {
                    string2 = string2 + "\n" + string3;
                    bl2 = true;
                    continue;
                }
                string2 = string2 + "\n" + string3;
            }
            this.windows.add(new Window(string2, this));
        }
        bufferedReader.close();
    }

    private void parseXML(File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        if (!document.getDoctype().getName().equals("Theme")) {
            throw new Exception("Selected file is not a valid VLC skin file!");
        }
        NodeList nodeList = document.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            this.parseElement(element);
        }
    }

    private void parseElement(Element element) throws Exception {
        String string = element.getTagName();
        if (string.equals("Theme")) {
            if (element.hasAttribute("version")) {
                this.theme_version = element.getAttribute("version");
            }
            if (Double.parseDouble(this.theme_version) != 2.0) {
                throw new Exception("The version of the theme used in the selected skin is not yet supported!");
            }
        } else if (string.equals("ThemeInfo")) {
            if (element.hasAttribute("author")) {
                this.themeinfo_author = element.getAttribute("author");
            }
            if (element.hasAttribute("name")) {
                this.themeinfo_name = element.getAttribute("name");
            }
            if (element.hasAttribute("email")) {
                this.themeinfo_email = element.getAttribute("email");
            }
            if (element.hasAttribute("webpage")) {
                this.themeinfo_webpage = element.getAttribute("webpage");
            }
        } else if (string.equals("Bitmap")) {
            this.resources.add(new Bitmap(element, this));
        } else if (string.equals("SubBitmap")) {
            Node node = element.getParentNode();
            String string2 = node.getAttributes().getNamedItem("id").getNodeValue();
            Bitmap bitmap = (Bitmap)this.getResource(string2);
            bitmap.SubBitmaps.add(new SubBitmap(element, this, bitmap));
        } else if (string.equals("Font")) {
            this.resources.add(new Font(element, this));
        }
    }

    public void save() {
        try {
            FileWriter fileWriter = new FileWriter(this.skinfile);
            fileWriter.write(this.returnCode());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), "Error while saving skin file!", 0);
        }
    }

    public void showThemeOptions() {
        if (this.theme_frame == null) {
            this.theme_frame = new JFrame("Theme settings");
            this.theme_frame.setResizable(false);
            this.theme_frame.setLayout(new FlowLayout());
            this.theme_frame.setDefaultCloseOperation(1);
            JLabel jLabel = new JLabel("Name:");
            this.themeinfo_name_tf = new JTextField();
            JLabel jLabel2 = new JLabel("Author:");
            this.themeinfo_author_tf = new JTextField();
            JLabel jLabel3 = new JLabel("Author's E-Mail:");
            this.themeinfo_email_tf = new JTextField();
            JLabel jLabel4 = new JLabel("Author's webpage:");
            this.themeinfo_webpage_tf = new JTextField();
            JLabel jLabel5 = new JLabel("Magnet:");
            this.theme_magnet_tf = new JTextField();
            this.theme_magnet_tf.setDocument(new NumbersOnlyDocument(false));
            this.theme_magnet_tf.setToolTipText("When the distance between the border of the screen and an anchor of a window is less than this value, the window will stick to the border");
            JLabel jLabel6 = new JLabel("Opacity:");
            this.theme_alpha_tf = new JTextField();
            this.theme_alpha_tf.setDocument(new NumbersOnlyDocument(false));
            this.theme_alpha_tf.setToolTipText("Sets the alpha transparency of the windows. The value must be between 1 (nearly total transparency) and 255 (total opacity). Low values should be avoided.");
            JLabel jLabel7 = new JLabel("Opacity when moving:");
            this.theme_movealpha_tf = new JTextField();
            this.theme_alpha_tf.setDocument(new NumbersOnlyDocument(false));
            this.theme_alpha_tf.setToolTipText("Sets the alpha transparency of the windows when they are moved.");
            this.theme_ok_btn = new JButton("OK");
            this.theme_ok_btn.addActionListener(this);
            this.theme_ok_btn.setPreferredSize(new Dimension(70, 25));
            this.theme_cancel_btn = new JButton("Cancel");
            this.theme_cancel_btn.addActionListener(this);
            this.theme_cancel_btn.setPreferredSize(new Dimension(70, 25));
            this.theme_help_btn = new JButton("Help");
            this.theme_help_btn.addActionListener(this);
            this.theme_help_btn.setPreferredSize(new Dimension(70, 25));
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.themeinfo_name_tf);
            jLabel.setBounds(5, 15, 150, 24);
            this.themeinfo_name_tf.setBounds(160, 15, 150, 24);
            jPanel.add(jLabel2);
            jPanel.add(this.themeinfo_author_tf);
            jLabel2.setBounds(5, 45, 150, 24);
            this.themeinfo_author_tf.setBounds(160, 45, 150, 24);
            jPanel.add(jLabel3);
            jPanel.add(this.themeinfo_email_tf);
            jLabel3.setBounds(5, 75, 150, 24);
            this.themeinfo_email_tf.setBounds(160, 75, 150, 24);
            jPanel.add(jLabel4);
            jPanel.add(this.themeinfo_webpage_tf);
            jLabel4.setBounds(5, 105, 150, 24);
            this.themeinfo_webpage_tf.setBounds(160, 105, 150, 24);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Theme Information"));
            jPanel.setMinimumSize(new Dimension(315, 135));
            jPanel.setMaximumSize(new Dimension(315, 135));
            jPanel.setPreferredSize(new Dimension(315, 135));
            this.theme_frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel5);
            jPanel2.add(this.theme_magnet_tf);
            jLabel5.setBounds(5, 15, 150, 24);
            this.theme_magnet_tf.setBounds(160, 15, 150, 24);
            jPanel2.add(jLabel6);
            jPanel2.add(this.theme_alpha_tf);
            jLabel6.setBounds(5, 45, 150, 24);
            this.theme_alpha_tf.setBounds(160, 45, 150, 24);
            jPanel2.add(jLabel7);
            jPanel2.add(this.theme_movealpha_tf);
            jLabel7.setBounds(5, 75, 150, 24);
            this.theme_movealpha_tf.setBounds(160, 75, 150, 24);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Theme Attributes"));
            jPanel2.setMinimumSize(new Dimension(315, 105));
            jPanel2.setMaximumSize(new Dimension(315, 105));
            jPanel2.setPreferredSize(new Dimension(315, 105));
            this.theme_frame.add(jPanel2);
            this.theme_frame.add(this.theme_ok_btn);
            this.theme_frame.add(this.theme_cancel_btn);
            this.theme_frame.add(this.theme_help_btn);
            this.theme_frame.setMinimumSize(new Dimension(325, 330));
            this.theme_frame.setPreferredSize(new Dimension(325, 330));
            this.theme_frame.setMaximumSize(new Dimension(325, 330));
            this.theme_frame.pack();
        }
        this.themeinfo_name_tf.setText(this.themeinfo_name);
        this.themeinfo_author_tf.setText(this.themeinfo_author);
        this.themeinfo_email_tf.setText(this.themeinfo_email);
        this.themeinfo_webpage_tf.setText(this.themeinfo_webpage);
        this.theme_magnet_tf.setText(String.valueOf(this.theme_magnet));
        this.theme_alpha_tf.setText(String.valueOf(this.theme_alpha));
        this.theme_movealpha_tf.setText(String.valueOf(this.theme_movealpha));
        this.theme_frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.theme_ok_btn)) {
            if (Integer.parseInt(this.theme_alpha_tf.getText()) > 255 || Integer.parseInt(this.theme_alpha_tf.getText()) < 1) {
                JOptionPane.showMessageDialog(this.theme_frame, "Please enter a valid alpha value!", "Alpha value not valid", 1);
                return;
            }
            if (Integer.parseInt(this.theme_movealpha_tf.getText()) > 255 || Integer.parseInt(this.theme_movealpha_tf.getText()) < 1) {
                JOptionPane.showMessageDialog(this.theme_frame, "Please enter a valid movealpha value!", "Movealpha value not valid", 1);
                return;
            }
            ThemeEditEvent themeEditEvent = new ThemeEditEvent(this);
            this.themeinfo_name = this.themeinfo_name_tf.getText();
            this.themeinfo_author = this.themeinfo_author_tf.getText();
            this.themeinfo_email = this.themeinfo_email_tf.getText();
            this.themeinfo_webpage = this.themeinfo_webpage_tf.getText();
            this.theme_magnet = Integer.parseInt(this.theme_magnet_tf.getText());
            this.theme_alpha = Integer.parseInt(this.theme_alpha_tf.getText());
            this.theme_movealpha = Integer.parseInt(this.theme_movealpha_tf.getText());
            this.theme_frame.setVisible(false);
            this.theme_frame.dispose();
            this.theme_frame = null;
            themeEditEvent.setNew();
            this.m.hist.addEvent(themeEditEvent);
        } else if (actionEvent.getSource().equals(this.theme_help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/theme.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skins2-create.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.theme_cancel_btn)) {
            this.theme_frame.setVisible(false);
            this.theme_frame.dispose();
            this.theme_frame = null;
        }
    }

    public int getNewId() {
        ++this.unnamed_ids;
        return this.unnamed_ids;
    }

    public boolean idExists(String string) {
        if (this.getResource(string) != null) {
            return true;
        }
        for (Window window : this.windows) {
            if (window.id.equals(string)) {
                return true;
            }
            for (Layout layout : window.layouts) {
                if (layout.id.equals(string)) {
                    return true;
                }
                if (layout.getItem(string) == null) continue;
                return true;
            }
        }
        return false;
    }

    public Resource getResource(String string) {
        for (Resource resource : this.resources) {
            if (resource.id.equals(string)) {
                return resource;
            }
            if (resource.getClass() != Bitmap.class) continue;
            Bitmap bitmap = (Bitmap)resource;
            for (SubBitmap subBitmap : bitmap.SubBitmaps) {
                if (!subBitmap.id.equals(string)) continue;
                return subBitmap;
            }
        }
        return null;
    }

    public BufferedImage getBitmapImage(String string) {
        Resource resource = this.getResource(string);
        if (resource == null) {
            return null;
        }
        if (resource.getClass() == Bitmap.class) {
            Bitmap bitmap = (Bitmap)resource;
            return bitmap.image;
        }
        if (resource.getClass() == SubBitmap.class) {
            SubBitmap subBitmap = (SubBitmap)resource;
            return subBitmap.image;
        }
        return null;
    }

    public java.awt.Font getFont(String string) {
        if (string.equals("defaultfont")) {
            return new java.awt.Font("SansSerif", 0, 12);
        }
        Resource resource = this.getResource(string);
        if (resource == null) {
            return new java.awt.Font("SansSerif", 0, 12);
        }
        try {
            if (resource.getClass() == Font.class) {
                Font font = (Font)resource;
                return font.f;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new java.awt.Font("SansSerif", 0, 12);
        }
        return new java.awt.Font("SansSerif", 0, 12);
    }

    public Window getWindow(String string) {
        Window window = null;
        for (int i = 0; i < this.windows.size(); ++i) {
            if (!this.windows.get((int)i).id.equals(string)) continue;
            window = this.windows.get(i);
        }
        return window;
    }

    public boolean isUsed(String string) {
        for (Window window : this.windows) {
            for (Layout layout : window.layouts) {
                if (!layout.uses(string)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Item> getParentListOf(String string) {
        return this.active_layout.getParentListOf(string);
    }

    public List<Item> getListOf(String string) {
        Item item = this.getItem(string);
        List<Item> list = null;
        try {
            Panel panel = (Panel)item;
            list = panel.items;
        }
        catch (Exception exception) {
            try {
                Group group = (Group)item;
                list = group.items;
            }
            catch (Exception exception2) {
                System.out.println(exception2);
            }
        }
        return list;
    }

    public Item getItem(String string) {
        this.active_window = null;
        this.active_layout = null;
        if (this.m.selected_window != null && this.m.selected_layout != null) {
            this.active_window = this.getWindow(this.m.selected_window);
            if (this.active_window != null) {
                this.active_layout = this.active_window.getLayout(this.m.selected_layout);
            }
        }
        if (this.active_layout != null) {
            return this.active_layout.getItem(string);
        }
        return null;
    }

    public DefaultMutableTreeNode getResourcesTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root: Resources");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Root: Bitmaps");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Root: Fonts");
        for (Resource resource : this.resources) {
            if (resource.getClass() != Bitmap.class) continue;
            defaultMutableTreeNode2.add(resource.getTreeNode());
        }
        for (Resource resource : this.resources) {
            if (resource.getClass() != Font.class) continue;
            DefaultMutableTreeNode defaultMutableTreeNode4 = resource.getTreeNode();
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getWindowsTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root: Windows");
        for (int i = 0; i < this.windows.size(); ++i) {
            defaultMutableTreeNode.add(this.windows.get(i).getTreeNode());
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getItemsTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root: Items");
        if (this.m.selected_window != null && this.m.selected_layout != null) {
            this.active_window = this.getWindow(this.m.selected_window);
            if (this.active_window != null) {
                this.active_layout = this.active_window.getLayout(this.m.selected_layout);
            }
        }
        if (this.active_layout != null) {
            for (int i = 0; i < this.active_layout.items.size(); ++i) {
                defaultMutableTreeNode.add(this.active_layout.items.get(i).getTreeNode());
            }
        }
        return defaultMutableTreeNode;
    }

    public String returnCode() {
        int n;
        String string = "";
        string = string + "<!DOCTYPE Theme PUBLIC \"-//VideoLAN//DTD VLC Skins V2.0//EN\" \"skin.dtd\">\n";
        string = string + "<Theme version=\"" + this.theme_version + "\"";
        if (!this.theme_tooltipfont.equals("defaultfont")) {
            string = string + " tooltipfont=\"" + this.theme_tooltipfont + "\"";
        }
        if (this.theme_magnet != 15) {
            string = string + " magnet=\"" + String.valueOf(this.theme_magnet) + "\"";
        }
        if (this.theme_alpha != 255) {
            string = string + " alpha=\"" + String.valueOf(this.theme_alpha) + "\"";
        }
        if (this.theme_movealpha != 255) {
            string = string + " movealpha=\"" + String.valueOf(this.theme_movealpha) + "\"";
        }
        string = string + ">\n";
        string = string + indentation + "<ThemeInfo";
        string = string + " name=\"" + this.themeinfo_name + "\"";
        string = string + " author=\"" + this.themeinfo_author + "\"";
        string = string + " email=\"" + this.themeinfo_email + "\"";
        string = string + " webpage=\"" + this.themeinfo_webpage + "\"";
        string = string + "/>\n\n";
        string = string + indentation + "<!-- Created using the VLC Skin Editor " + this.m.VERSION + " (http://www.videolan.org/vlc/skineditor.php)-->\n\n";
        for (n = 0; n < this.resources.size(); ++n) {
            string = string + this.resources.get(n).returnCode(indentation);
        }
        string = string + "\n";
        for (n = 0; n < this.windows.size(); ++n) {
            string = string + this.windows.get(n).returnCode(indentation);
        }
        string = string + "\n</Theme>";
        return string;
    }

    public void updateResources() {
        this.m.res_tree_model.setRoot(this.getResourcesTree());
        this.m.saved = false;
    }

    public void expandResource(String string) {
        Object object;
        Resource resource = this.getResource(string);
        if (resource == null) {
            return;
        }
        if (resource.type.equals("Bitmap")) {
            object = this.findInTree(this.m.res_tree, "Root: Bitmaps");
            this.m.res_tree.expandPath((TreePath)object);
        } else if (resource.type.equals("Font")) {
            object = this.findInTree(this.m.res_tree, "Root: Fonts");
            this.m.res_tree.expandPath((TreePath)object);
        } else {
            System.err.println("Resource of the given id is neither a Font nor a Bitmap its a " + resource.type);
            return;
        }
        object = resource;
        for (Resource resource2 : this.resources) {
            if (resource2.getParentOf(string) == null) continue;
            TreePath treePath = this.findInTree(this.m.res_tree, resource2.id);
            if (treePath == null) {
                System.err.println("Could not find Parent: " + resource2.id);
                return;
            }
            this.m.res_tree.expandPath(treePath);
            TreePath treePath2 = this.findInTree(this.m.res_tree, string);
            if (treePath2 == null) {
                return;
            }
            this.m.res_tree.setSelectionPath(treePath2);
            break;
        }
    }

    public void expandLayout(String string) {
        TreePath treePath = null;
        treePath = this.active_window != null ? this.findInTree(this.m.win_tree, this.active_window.id) : this.findInTree(this.m.win_tree, this.m.selected_window);
        if (treePath == null) {
            return;
        }
        this.m.win_tree.expandPath(treePath);
        TreePath treePath2 = this.findInTree(this.m.win_tree, string);
        if (treePath2 == null) {
            return;
        }
        this.m.win_tree.setSelectionPath(treePath2);
    }

    public void updateWindows() {
        this.m.win_tree_model.setRoot(this.getWindowsTree());
        this.m.saved = false;
    }

    public void updateItems() {
        this.m.items_tree_model.setRoot(this.getItemsTree());
        this.m.saved = false;
    }

    public void expandItem(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Item item = this.getItem(string);
        if (item == null) {
            return;
        }
        while ((item = this.active_layout.getParentOf(item.id)) != null) {
            linkedList.add(item.id);
        }
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            TreePath treePath = this.findInTree(this.m.items_tree, (String)linkedList.get(i));
            if (treePath == null) {
                System.err.println("Could not find Parent: " + (String)linkedList.get(i));
                return;
            }
            this.m.items_tree.expandPath(treePath);
            TreePath treePath2 = this.findInTree(this.m.items_tree, string);
            if (treePath2 == null) {
                return;
            }
            this.m.items_tree.setSelectionPath(treePath2);
        }
    }

    public TreePath findInTree(JTree jTree, String string) {
        int n = jTree.getRowCount();
        int n2 = 0;
        do {
            TreePath treePath;
            String string2;
            if ((string2 = (treePath = jTree.getPathForRow(n2)).getLastPathComponent().toString()).toUpperCase().indexOf(string.toUpperCase()) == -1) continue;
            return treePath;
        } while ((n2 = (n2 + 1 + n) % n) != 0);
        return null;
    }

    public void update() {
        this.updateResources();
        this.updateWindows();
        this.updateItems();
        this.m.saved = false;
    }
}

