/*
** FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
** Copyright (C) 2003 M. Bakker, Ahead Software AG, http://www.nero.com
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** Any non-GPL usage of this software or parts of this software is strictly
** forbidden.
**
** Commercial non-GPL licensing of this software is possible.
** For more info contact Ahead Software through Mpeg4AAClicense@nero.com.
**
** $Id: cfft_tab.h,v 1.3 2003/07/29 08:20:12 menno Exp $
**/

#ifndef __CFFT_TAB_H__
#define __CFFT_TAB_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef FIXED_POINT

complex_t cfft_tab_512[] =
{
    { 0x10000000, 0x0 },
    { 0xFFFB110, 0x3243A4 },
    { 0xFFEC430, 0x648558 },
    { 0xFFD3970, 0x96C32C },
    { 0xFFB10F0, 0xC8FB30 },
    { 0xFF84AB0, 0xFB2B75 },
    { 0xFF4E6D0, 0x12D520A },
    { 0xFF0E580, 0x15F6D02 },
    { 0xFEC46D0, 0x1917A6C },
    { 0xFE70B00, 0x1C3785C },
    { 0xFE13240, 0x1F564E6 },
    { 0xFDABCC0, 0x2273E1C },
    { 0xFD3AAC0, 0x259020C },
    { 0xFCBFC90, 0x28AAED8 },
    { 0xFC3B280, 0x2BC428C },
    { 0xFBACCD0, 0x2EDBB3C },
    { 0xFB14BE0, 0x31F1708 },
    { 0xFA73020, 0x3505408 },
    { 0xF9C79D0, 0x381704C },
    { 0xF912980, 0x3B26A00 },
    { 0xF853F80, 0x3E33F34 },
    { 0xF78BC50, 0x413EE08 },
    { 0xF6BA070, 0x44474A0 },
    { 0xF5DEC60, 0x474D110 },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xF40BDD0, 0x4D50430 },
    { 0xF314470, 0x504D728 },
    { 0xF213520, 0x5347898 },
    { 0xF109080, 0x563E6A0 },
    { 0xEFF5730, 0x5931F78 },
    { 0xEED89E0, 0x5C22150 },
    { 0xEDB2930, 0x5F0EA50 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xEB4B0C0, 0x64DCAA0 },
    { 0xEA09A60, 0x67BDE58 },
    { 0xE8BF3B0, 0x6A9B210 },
    { 0xE76BD80, 0x6D74400 },
    { 0xE60F880, 0x7049278 },
    { 0xE4AA590, 0x7319BA8 },
    { 0xE33C5A0, 0x75E5DD8 },
    { 0xE1C5970, 0x78AD750 },
    { 0xE046210, 0x7B70650 },
    { 0xDEBE050, 0x7E2E940 },
    { 0xDD2D530, 0x80E7E40 },
    { 0xDB941A0, 0x839C3D0 },
    { 0xD9F26A0, 0x864B830 },
    { 0xD848530, 0x88F59B0 },
    { 0xD695E50, 0x8B9A6B0 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xD318480, 0x90D3CD0 },
    { 0xD14D3D0, 0x93682B0 },
    { 0xCF7A1F0, 0x95F6DA0 },
    { 0xCD9F020, 0x987FC00 },
    { 0xCBBBF80, 0x9B02C50 },
    { 0xC9D1120, 0x9D7FD20 },
    { 0xC7DE650, 0x9FF6CB0 },
    { 0xC5E4030, 0xA2679A0 },
    { 0xC3E2000, 0xA4D2250 },
    { 0xC1D8700, 0xA736560 },
    { 0xBFC7670, 0xA994150 },
    { 0xBDAEF90, 0xABEB4A0 },
    { 0xBB8F3B0, 0xAE3BDE0 },
    { 0xB968420, 0xB085BB0 },
    { 0xB73A220, 0xB2C8CA0 },
    { 0xB504F30, 0xB504F30 },
    { 0xB2C8C90, 0xB73A230 },
    { 0xB085BA0, 0xB968420 },
    { 0xAE3BDE0, 0xBB8F3B0 },
    { 0xABEB490, 0xBDAEFA0 },
    { 0xA994140, 0xBFC7670 },
    { 0xA736550, 0xC1D8710 },
    { 0xA4D2250, 0xC3E2010 },
    { 0xA267990, 0xC5E4030 },
    { 0x9FF6CA0, 0xC7DE660 },
    { 0x9D7FD10, 0xC9D1120 },
    { 0x9B02C50, 0xCBBBF80 },
    { 0x987FC00, 0xCD9F020 },
    { 0x95F6D90, 0xCF7A1F0 },
    { 0x93682A0, 0xD14D3D0 },
    { 0x90D3CD0, 0xD318490 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x8B9A6B0, 0xD695E50 },
    { 0x88F59B0, 0xD848530 },
    { 0x864B820, 0xD9F26A0 },
    { 0x839C3C0, 0xDB941B0 },
    { 0x80E7E50, 0xDD2D530 },
    { 0x7E2E938, 0xDEBE050 },
    { 0x7B70648, 0xE046220 },
    { 0x78AD738, 0xE1C5980 },
    { 0x75E5DD8, 0xE33C5A0 },
    { 0x7319BA0, 0xE4AA590 },
    { 0x7049268, 0xE60F880 },
    { 0x6D74408, 0xE76BD80 },
    { 0x6A9B208, 0xE8BF3C0 },
    { 0x67BDE48, 0xEA09A70 },
    { 0x64DCA80, 0xEB4B0C0 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x5F0EA40, 0xEDB2930 },
    { 0x5C22138, 0xEED89E0 },
    { 0x5931F78, 0xEFF5730 },
    { 0x563E698, 0xF109080 },
    { 0x5347880, 0xF213530 },
    { 0x504D710, 0xF314480 },
    { 0x4D50430, 0xF40BDD0 },
    { 0x4A50180, 0xF4FA0B0 },
    { 0x474D0F8, 0xF5DEC70 },
    { 0x4447498, 0xF6BA070 },
    { 0x413EE00, 0xF78BC50 },
    { 0x3E33F20, 0xF853F80 },
    { 0x3B26A04, 0xF912980 },
    { 0x3817048, 0xF9C79D0 },
    { 0x35053F8, 0xFA73020 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0x2EDBB3C, 0xFBACCD0 },
    { 0x2BC4280, 0xFC3B280 },
    { 0x28AAEC4, 0xFCBFC90 },
    { 0x2590214, 0xFD3AAC0 },
    { 0x2273E14, 0xFDABCC0 },
    { 0x1F564D8, 0xFE13240 },
    { 0x1C37844, 0xFE70B00 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0x15F6CF6, 0xFF0E580 },
    { 0x12D51F6, 0xFF4E6D0 },
    { 0xFB2B77, 0xFF84AB0 },
    { 0xC8FB29, 0xFFB10F0 },
    { 0x96C31C, 0xFFD3980 },
    { 0x64853F, 0xFFEC430 },
    { 0x3243A1, 0xFFFB110 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFFCDBC47, 0xFFFB110 },
    { 0xFF9B7AAA, 0xFFEC430 },
    { 0xFF693CCD, 0xFFD3970 },
    { 0xFF3704BF, 0xFFB10F0 },
    { 0xFF04D472, 0xFF84AB0 },
    { 0xFED2ADF4, 0xFF4E6D0 },
    { 0xFEA092F2, 0xFF0E580 },
    { 0xFE6E857E, 0xFEC46D0 },
    { 0xFE3C87A4, 0xFE70B00 },
    { 0xFE0A9B12, 0xFE13230 },
    { 0xFDD8C1D4, 0xFDABCB0 },
    { 0xFDA6FDD8, 0xFD3AAC0 },
    { 0xFD755124, 0xFCBFC90 },
    { 0xFD43BD68, 0xFC3B280 },
    { 0xFD1244AC, 0xFBACCD0 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xFCAFABF0, 0xFA73020 },
    { 0xFC7E8FA0, 0xF9C79D0 },
    { 0xFC4D95E8, 0xF912970 },
    { 0xFC1CC0CC, 0xF853F80 },
    { 0xFBEC11F0, 0xF78BC50 },
    { 0xFBBB8B50, 0xF6BA070 },
    { 0xFB8B2EF0, 0xF5DEC60 },
    { 0xFB5AFE68, 0xF4FA0A0 },
    { 0xFB2AFBB8, 0xF40BDD0 },
    { 0xFAFB28E0, 0xF314470 },
    { 0xFACB8768, 0xF213520 },
    { 0xFA9C1950, 0xF109080 },
    { 0xFA6CE070, 0xEFF5720 },
    { 0xFA3DDEB0, 0xEED89E0 },
    { 0xFA0F15A8, 0xEDB2930 },
    { 0xF9E08740, 0xEC835E0 },
    { 0xF9B23568, 0xEB4B0C0 },
    { 0xF98421A8, 0xEA09A60 },
    { 0xF9564E00, 0xE8BF3C0 },
    { 0xF928BC00, 0xE76BD80 },
    { 0xF8FB6D88, 0xE60F870 },
    { 0xF8CE6450, 0xE4AA590 },
    { 0xF8A1A210, 0xE33C590 },
    { 0xF8752898, 0xE1C5970 },
    { 0xF848F988, 0xE046200 },
    { 0xF81D16D0, 0xDEBE060 },
    { 0xF7F181C0, 0xDD2D530 },
    { 0xF7C63C30, 0xDB941A0 },
    { 0xF79B47D0, 0xD9F2690 },
    { 0xF770A640, 0xD848520 },
    { 0xF7465930, 0xD695E40 },
    { 0xF71C6240, 0xD4DB300 },
    { 0xF6F2C340, 0xD318490 },
    { 0xF6C97D60, 0xD14D3D0 },
    { 0xF6A09260, 0xCF7A1F0 },
    { 0xF67803F0, 0xCD9F020 },
    { 0xF64FD390, 0xCBBBF70 },
    { 0xF62802D0, 0xC9D1110 },
    { 0xF6009330, 0xC7DE630 },
    { 0xF5D98670, 0xC5E4040 },
    { 0xF5B2DDB0, 0xC3E2000 },
    { 0xF58C9AA0, 0xC1D8700 },
    { 0xF566BEB0, 0xBFC7660 },
    { 0xF5414B50, 0xBDAEF80 },
    { 0xF51C4200, 0xBB8F390 },
    { 0xF4F7A430, 0xB968400 },
    { 0xF4D37370, 0xB73A230 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF48C5DD0, 0xB2C8C90 },
    { 0xF4697BD0, 0xB085BA0 },
    { 0xF4470C40, 0xAE3BDD0 },
    { 0xF4251050, 0xABEB480 },
    { 0xF4038970, 0xA994120 },
    { 0xF3E27900, 0xA736560 },
    { 0xF3C1DFF0, 0xA4D2250 },
    { 0xF3A1BFC0, 0xA267990 },
    { 0xF38219A0, 0x9FF6CA0 },
    { 0xF362EED0, 0x9D7FD00 },
    { 0xF3444070, 0x9B02C40 },
    { 0xF3260FC0, 0x987FBD0 },
    { 0xF3085E10, 0x95F6D90 },
    { 0xF2EB2C30, 0x93682A0 },
    { 0xF2CE7B70, 0x90D3CC0 },
    { 0xF2B24CE0, 0x8E39D90 },
    { 0xF296A1A0, 0x8B9A690 },
    { 0xF27B7AC0, 0x88F5980 },
    { 0xF260D940, 0x864B800 },
    { 0xF246BE60, 0x839C3D0 },
    { 0xF22D2AD0, 0x80E7E40 },
    { 0xF2141FA0, 0x7E2E928 },
    { 0xF1FB9DE0, 0x7B70640 },
    { 0xF1E3A670, 0x78AD730 },
    { 0xF1CC3A50, 0x75E5DB0 },
    { 0xF1B55A70, 0x7319BB0 },
    { 0xF19F0780, 0x7049278 },
    { 0xF1894280, 0x6D743F8 },
    { 0xF1740C40, 0x6A9B1F8 },
    { 0xF15F6590, 0x67BDE38 },
    { 0xF14B4F40, 0x64DCA78 },
    { 0xF137CA00, 0x61F7880 },
    { 0xF124D6D0, 0x5F0EA58 },
    { 0xF1127620, 0x5C22150 },
    { 0xF100A8D0, 0x5931F70 },
    { 0xF0EF6F70, 0x563E690 },
    { 0xF0DECAD0, 0x5347878 },
    { 0xF0CEBB80, 0x504D700 },
    { 0xF0BF4220, 0x4D50408 },
    { 0xF0B05F50, 0x4A50198 },
    { 0xF0A213A0, 0x474D110 },
    { 0xF0945F90, 0x4447490 },
    { 0xF08743B0, 0x413EDF0 },
    { 0xF07AC080, 0x3E33F14 },
    { 0xF06ED680, 0x3B269D8 },
    { 0xF0638620, 0x3817020 },
    { 0xF058CFE0, 0x350540C },
    { 0xF04EB410, 0x31F1704 },
    { 0xF0453330, 0x2EDBB30 },
    { 0xF03C4D80, 0x2BC4274 },
    { 0xF0340370, 0x28AAEB8 },
    { 0xF02C5540, 0x25901E8 },
    { 0xF0254340, 0x2273DE8 },
    { 0xF01ECDD0, 0x1F564EC },
    { 0xF018F500, 0x1C3785A },
    { 0xF013B930, 0x1917A60 },
    { 0xF00F1A80, 0x15F6CEA },
    { 0xF00B1920, 0x12D51EA },
    { 0xF007B550, 0xFB2B4B },
    { 0xF004EF10, 0xC8FAFD },
    { 0xF002C690, 0x96C330 },
    { 0xF0013BD0, 0x648553 },
    { 0xF0004EF0, 0x324395 },
    { 0x10000000, 0x0 },
    { 0xFFEC430, 0x648558 },
    { 0xFFB10F0, 0xC8FB30 },
    { 0xFF4E6D0, 0x12D520A },
    { 0xFEC46D0, 0x1917A6C },
    { 0xFE13240, 0x1F564E6 },
    { 0xFD3AAC0, 0x259020C },
    { 0xFC3B280, 0x2BC428C },
    { 0xFB14BE0, 0x31F1708 },
    { 0xF9C79D0, 0x381704C },
    { 0xF853F80, 0x3E33F34 },
    { 0xF6BA070, 0x44474A0 },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xF314470, 0x504D728 },
    { 0xF109080, 0x563E6A0 },
    { 0xEED89E0, 0x5C22150 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xEA09A60, 0x67BDE58 },
    { 0xE76BD80, 0x6D74400 },
    { 0xE4AA590, 0x7319BA8 },
    { 0xE1C5970, 0x78AD750 },
    { 0xDEBE050, 0x7E2E940 },
    { 0xDB941A0, 0x839C3D0 },
    { 0xD848530, 0x88F59B0 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xD14D3D0, 0x93682B0 },
    { 0xCD9F020, 0x987FC00 },
    { 0xC9D1120, 0x9D7FD20 },
    { 0xC5E4030, 0xA2679A0 },
    { 0xC1D8700, 0xA736560 },
    { 0xBDAEF90, 0xABEB4A0 },
    { 0xB968420, 0xB085BB0 },
    { 0xB504F30, 0xB504F30 },
    { 0xB085BA0, 0xB968420 },
    { 0xABEB490, 0xBDAEFA0 },
    { 0xA736550, 0xC1D8710 },
    { 0xA267990, 0xC5E4030 },
    { 0x9D7FD10, 0xC9D1120 },
    { 0x987FC00, 0xCD9F020 },
    { 0x93682A0, 0xD14D3D0 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x88F59B0, 0xD848530 },
    { 0x839C3C0, 0xDB941B0 },
    { 0x7E2E938, 0xDEBE050 },
    { 0x78AD738, 0xE1C5980 },
    { 0x7319BA0, 0xE4AA590 },
    { 0x6D74408, 0xE76BD80 },
    { 0x67BDE48, 0xEA09A70 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x5C22138, 0xEED89E0 },
    { 0x563E698, 0xF109080 },
    { 0x504D710, 0xF314480 },
    { 0x4A50180, 0xF4FA0B0 },
    { 0x4447498, 0xF6BA070 },
    { 0x3E33F20, 0xF853F80 },
    { 0x3817048, 0xF9C79D0 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0x2BC4280, 0xFC3B280 },
    { 0x2590214, 0xFD3AAC0 },
    { 0x1F564D8, 0xFE13240 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0x12D51F6, 0xFF4E6D0 },
    { 0xC8FB29, 0xFFB10F0 },
    { 0x64853F, 0xFFEC430 },
    { 0x10000000, 0x0 },
    { 0xFFB10F0, 0xC8FB30 },
    { 0xFEC46D0, 0x1917A6C },
    { 0xFD3AAC0, 0x259020C },
    { 0xFB14BE0, 0x31F1708 },
    { 0xF853F80, 0x3E33F34 },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xF109080, 0x563E6A0 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xE76BD80, 0x6D74400 },
    { 0xE1C5970, 0x78AD750 },
    { 0xDB941A0, 0x839C3D0 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xCD9F020, 0x987FC00 },
    { 0xC5E4030, 0xA2679A0 },
    { 0xBDAEF90, 0xABEB4A0 },
    { 0xB504F30, 0xB504F30 },
    { 0xABEB490, 0xBDAEFA0 },
    { 0xA267990, 0xC5E4030 },
    { 0x987FC00, 0xCD9F020 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x839C3C0, 0xDB941B0 },
    { 0x78AD738, 0xE1C5980 },
    { 0x6D74408, 0xE76BD80 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x563E698, 0xF109080 },
    { 0x4A50180, 0xF4FA0B0 },
    { 0x3E33F20, 0xF853F80 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0x2590214, 0xFD3AAC0 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0xC8FB29, 0xFFB10F0 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFF3704BF, 0xFFB10F0 },
    { 0xFE6E857E, 0xFEC46D0 },
    { 0xFDA6FDD8, 0xFD3AAC0 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xFC1CC0CC, 0xF853F80 },
    { 0xFB5AFE68, 0xF4FA0A0 },
    { 0xFA9C1950, 0xF109080 },
    { 0xF9E08740, 0xEC835E0 },
    { 0xF928BC00, 0xE76BD80 },
    { 0xF8752898, 0xE1C5970 },
    { 0xF7C63C30, 0xDB941A0 },
    { 0xF71C6240, 0xD4DB300 },
    { 0xF67803F0, 0xCD9F020 },
    { 0xF5D98670, 0xC5E4040 },
    { 0xF5414B50, 0xBDAEF80 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF4251050, 0xABEB480 },
    { 0xF3A1BFC0, 0xA267990 },
    { 0xF3260FC0, 0x987FBD0 },
    { 0xF2B24CE0, 0x8E39D90 },
    { 0xF246BE60, 0x839C3D0 },
    { 0xF1E3A670, 0x78AD730 },
    { 0xF1894280, 0x6D743F8 },
    { 0xF137CA00, 0x61F7880 },
    { 0xF0EF6F70, 0x563E690 },
    { 0xF0B05F50, 0x4A50198 },
    { 0xF07AC080, 0x3E33F14 },
    { 0xF04EB410, 0x31F1704 },
    { 0xF02C5540, 0x25901E8 },
    { 0xF013B930, 0x1917A60 },
    { 0xF004EF10, 0xC8FAFD },
    { 0x10000000, 0x0 },
    { 0xFF4E6D0, 0x12D520A },
    { 0xFD3AAC0, 0x259020C },
    { 0xF9C79D0, 0x381704C },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xEED89E0, 0x5C22150 },
    { 0xE76BD80, 0x6D74400 },
    { 0xDEBE050, 0x7E2E940 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xC9D1130, 0x9D7FD10 },
    { 0xBDAEF90, 0xABEB4A0 },
    { 0xB085BA0, 0xB968420 },
    { 0xA267990, 0xC5E4030 },
    { 0x93682B0, 0xD14D3D0 },
    { 0x839C3C0, 0xDB941B0 },
    { 0x7319BA0, 0xE4AA590 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x504D728, 0xF314470 },
    { 0x3E33F40, 0xF853F80 },
    { 0x2BC4280, 0xFC3B280 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0x64855F, 0xFFEC430 },
    { 0xFF3704BF, 0xFFB10F0 },
    { 0xFE0A9B12, 0xFE13230 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xFBBB8B70, 0xF6BA070 },
    { 0xFA9C1970, 0xF109080 },
    { 0xF98421A8, 0xEA09A60 },
    { 0xF8752898, 0xE1C5970 },
    { 0xF770A640, 0xD848520 },
    { 0xF67803F0, 0xCD9F020 },
    { 0xF58C9AA0, 0xC1D8700 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF3E27900, 0xA736560 },
    { 0xF3260FE0, 0x987FC10 },
    { 0xF27B7AE0, 0x88F59C0 },
    { 0xF1E3A690, 0x78AD768 },
    { 0xF15F6590, 0x67BDE38 },
    { 0xF0EF6F70, 0x563E690 },
    { 0xF0945F90, 0x4447490 },
    { 0xF04EB410, 0x31F1704 },
    { 0xF01ECDD0, 0x1F564EC },
    { 0xF004EF10, 0xC8FB3D },
    { 0xF0013BD0, 0xFF9B7ABE },
    { 0xF013B930, 0xFE6E8572 },
    { 0xF03C4D80, 0xFD43BD5C },
    { 0xF07AC080, 0xFC1CC0C0 },
    { 0xF0CEBB90, 0xFAFB28D0 },
    { 0xF137CA20, 0xF9E08758 },
    { 0xF1B55A70, 0xF8CE6460 },
    { 0xF246BE50, 0xF7C63C40 },
    { 0xF2EB2C20, 0xF6C97D70 },
    { 0xF3A1BFB0, 0xF5D98680 },
    { 0xF4697BF0, 0xF4F7A440 },
    { 0xF5414B70, 0xF4251060 },
    { 0xF62802F0, 0xF362EED0 },
    { 0xF71C62A0, 0xF2B24CC0 },
    { 0xF81D16C8, 0xF2141FB0 },
    { 0xF928BC28, 0xF1894270 },
    { 0xFA3DDEA0, 0xF1127630 },
    { 0xFB5AFE98, 0xF0B05F50 },
    { 0xFC7E8F90, 0xF0638630 },
    { 0xFDA6FE04, 0xF02C5540 },
    { 0xFED2ADC2, 0xF00B1930 },
    { 0x10000000, 0x0 },
    { 0xFEC46D0, 0x1917A6C },
    { 0xFB14BE0, 0x31F1708 },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xE1C5970, 0x78AD750 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xC5E4030, 0xA2679A0 },
    { 0xB504F30, 0xB504F30 },
    { 0xA267990, 0xC5E4030 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x78AD738, 0xE1C5980 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x4A50180, 0xF4FA0B0 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0x10000000, 0x0 },
    { 0xFB14BE0, 0x31F1708 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xB504F30, 0xB504F30 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xF9E08740, 0xEC835E0 },
    { 0xF71C6240, 0xD4DB300 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF2B24CE0, 0x8E39D90 },
    { 0xF137CA00, 0x61F7880 },
    { 0xF04EB410, 0x31F1704 },
    { 0x10000000, 0x0 },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xA267990, 0xC5E4030 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xF8752898, 0xE1C5970 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF1E3A690, 0x78AD768 },
    { 0xF04EB410, 0x31F1704 },
    { 0xF013B930, 0xFE6E8572 },
    { 0xF137CA20, 0xF9E08758 },
    { 0xF3A1BFB0, 0xF5D98680 },
    { 0xF71C62A0, 0xF2B24CC0 },
    { 0xFB5AFE98, 0xF0B05F50 },
    { 0x10000000, 0x0 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xB504F30, 0xB504F30 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x10000000, 0x0 },
    { 0xB504F30, 0xB504F30 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0x10000000, 0x0 },
    { 0x61F78A8, 0xEC835E0 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF137CA20, 0xF9E08758 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x3, 0xF0000000 }
};

complex_t cfft_tab_480[] =
{
    { 0x10000000, 0x0 },
    { 0xFFFA630, 0x359D6F },
    { 0xFFE98B0, 0x6B3885 },
    { 0xFFCD790, 0xA0CEE7 },
    { 0xFFA62F0, 0xD65E3B },
    { 0xFF73AF0, 0x10BE428 },
    { 0xFF35F90, 0x1415E54 },
    { 0xFEED120, 0x176CA68 },
    { 0xFE98FD0, 0x1AC260A },
    { 0xFE39BC0, 0x1E16EE6 },
    { 0xFDCF550, 0x216A2A4 },
    { 0xFD59CB0, 0x24BBEEC },
    { 0xFCD9250, 0x280C170 },
    { 0xFC4D670, 0x2B5A7D4 },
    { 0xFBB6980, 0x2EA6FCC },
    { 0xFB14BE0, 0x31F1708 },
    { 0xFA67E20, 0x3539B38 },
    { 0xF9B0090, 0x387FA0C },
    { 0xF8ED3C0, 0x3BC3138 },
    { 0xF81F840, 0x3F03E70 },
    { 0xF746EA0, 0x4241F70 },
    { 0xF663770, 0x457D1F0 },
    { 0xF575360, 0x48B53B0 },
    { 0xF47C300, 0x4BEA268 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xF26A030, 0x5249DB0 },
    { 0xF150F40, 0x55745E0 },
    { 0xF02D4F0, 0x589B210 },
    { 0xEEFF200, 0x5BBE008 },
    { 0xEDC6770, 0x5EDCDA0 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xEB35E60, 0x650DEF8 },
    { 0xE9DE1D0, 0x681FE48 },
    { 0xE87C120, 0x6B2D490 },
    { 0xE70FD40, 0x6E35FA0 },
    { 0xE599740, 0x7139D58 },
    { 0xE419010, 0x7438B90 },
    { 0xE28E8D0, 0x7732838 },
    { 0xE0FA280, 0x7A27140 },
    { 0xDF5BE60, 0x7D16488 },
    { 0xDDB3D70, 0x8000000 },
    { 0xDC020F0, 0x82E41B0 },
    { 0xDA46A00, 0x85C2770 },
    { 0xD8819E0, 0x889AF60 },
    { 0xD6B31D0, 0x8B6D770 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xD2F9EF0, 0x9100000 },
    { 0xD10F6B0, 0x93BFCA0 },
    { 0xCF1BBD0, 0x9679180 },
    { 0xCD1EF80, 0x992BCD0 },
    { 0xCB19340, 0x9BD7CA0 },
    { 0xC90A870, 0x9E7CF10 },
    { 0xC6F3090, 0xA11B240 },
    { 0xC4D2D10, 0xA3B2460 },
    { 0xC2A9F70, 0xA6423B0 },
    { 0xC078920, 0xA8CAE40 },
    { 0xBE3EBD0, 0xAB4C250 },
    { 0xBBFC8F0, 0xADC5E30 },
    { 0xB9B2230, 0xB038010 },
    { 0xB75F900, 0xB2A2660 },
    { 0xB504F30, 0xB504F30 },
    { 0xB2A2650, 0xB75F910 },
    { 0xB038010, 0xB9B2230 },
    { 0xADC5E20, 0xBBFC900 },
    { 0xAB4C240, 0xBE3EBE0 },
    { 0xA8CAE30, 0xC078930 },
    { 0xA6423A0, 0xC2A9F70 },
    { 0xA3B2460, 0xC4D2D20 },
    { 0xA11B240, 0xC6F30A0 },
    { 0x9E7CF10, 0xC90A880 },
    { 0x9BD7C90, 0xCB19350 },
    { 0x992BCD0, 0xCD1EF90 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x93BFC90, 0xD10F6C0 },
    { 0x9100000, 0xD2F9EF0 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x8B6D760, 0xD6B31E0 },
    { 0x889AF60, 0xD8819E0 },
    { 0x85C2760, 0xDA46A10 },
    { 0x82E41B0, 0xDC020F0 },
    { 0x7FFFFF8, 0xDDB3D80 },
    { 0x7D16470, 0xDF5BE70 },
    { 0x7A27138, 0xE0FA290 },
    { 0x7732828, 0xE28E8D0 },
    { 0x7438B90, 0xE419010 },
    { 0x7139D48, 0xE599740 },
    { 0x6E35F88, 0xE70FD50 },
    { 0x6B2D490, 0xE87C120 },
    { 0x681FE40, 0xE9DE1E0 },
    { 0x650DEE0, 0xEB35E70 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x5EDCD98, 0xEDC6770 },
    { 0x5BBDFF0, 0xEEFF210 },
    { 0x589B208, 0xF02D4F0 },
    { 0x55745D0, 0xF150F40 },
    { 0x5249DB8, 0xF26A030 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x4BEA250, 0xF47C300 },
    { 0x48B53A8, 0xF575360 },
    { 0x457D1E0, 0xF663780 },
    { 0x4241F78, 0xF746EA0 },
    { 0x3F03E68, 0xF81F840 },
    { 0x3BC3124, 0xF8ED3C0 },
    { 0x387FA0C, 0xF9B0090 },
    { 0x3539B2C, 0xFA67E20 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0x2EA6FCC, 0xFBB6980 },
    { 0x2B5A7C4, 0xFC4D670 },
    { 0x280C154, 0xFCD9250 },
    { 0x24BBEE4, 0xFD59CB0 },
    { 0x216A290, 0xFDCF550 },
    { 0x1E16EE6, 0xFE39BC0 },
    { 0x1AC25FE, 0xFE98FD0 },
    { 0x176CA50, 0xFEED120 },
    { 0x1415E50, 0xFF35F90 },
    { 0x10BE418, 0xFF73AF0 },
    { 0xD65E3F, 0xFFA62F0 },
    { 0xA0CEDF, 0xFFCD790 },
    { 0x6B3871, 0xFFE98B0 },
    { 0x359D70, 0xFFFA630 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFFCA6279, 0xFFFA630 },
    { 0xFF94C777, 0xFFE98B0 },
    { 0xFF5F3109, 0xFFCD790 },
    { 0xFF29A1AA, 0xFFA62F0 },
    { 0xFEF41BD0, 0xFF73AF0 },
    { 0xFEBEA198, 0xFF35F90 },
    { 0xFE893598, 0xFEED120 },
    { 0xFE53D9EA, 0xFE98FD0 },
    { 0xFE1E9102, 0xFE39BC0 },
    { 0xFDE95D58, 0xFDCF550 },
    { 0xFDB44104, 0xFD59CB0 },
    { 0xFD7F3E98, 0xFCD9250 },
    { 0xFD4A5824, 0xFC4D670 },
    { 0xFD159020, 0xFBB6980 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xFCAC64BC, 0xFA67E10 },
    { 0xFC7805E0, 0xF9B0080 },
    { 0xFC43CEC4, 0xF8ED3C0 },
    { 0xFC0FC180, 0xF81F840 },
    { 0xFBDBE070, 0xF746EA0 },
    { 0xFBA82E08, 0xF663770 },
    { 0xFB74AC40, 0xF575350 },
    { 0xFB415DA0, 0xF47C300 },
    { 0xFB0E4428, 0xF378700 },
    { 0xFADB6230, 0xF26A030 },
    { 0xFAA8BA20, 0xF150F40 },
    { 0xFA764DE8, 0xF02D4E0 },
    { 0xFA441FF8, 0xEEFF210 },
    { 0xFA123250, 0xEDC6760 },
    { 0xF9E08740, 0xEC835E0 },
    { 0xF9AF2110, 0xEB35E70 },
    { 0xF97E01A8, 0xE9DE1D0 },
    { 0xF94D2B58, 0xE87C110 },
    { 0xF91CA060, 0xE70FD40 },
    { 0xF8EC62C0, 0xE599740 },
    { 0xF8BC7458, 0xE419000 },
    { 0xF88CD7C0, 0xE28E8C0 },
    { 0xF85D8ED0, 0xE0FA290 },
    { 0xF82E9B60, 0xDF5BE50 },
    { 0xF7FFFFF0, 0xDDB3D70 },
    { 0xF7D1BE60, 0xDC020F0 },
    { 0xF7A3D870, 0xDA469F0 },
    { 0xF7765090, 0xD8819E0 },
    { 0xF7492890, 0xD6B31D0 },
    { 0xF71C6240, 0xD4DB300 },
    { 0xF6EFFFF0, 0xD2F9EE0 },
    { 0xF6C40360, 0xD10F6C0 },
    { 0xF6986E90, 0xCF1BBD0 },
    { 0xF66D4320, 0xCD1EF70 },
    { 0xF6428360, 0xCB19340 },
    { 0xF6183100, 0xC90A880 },
    { 0xF5EE4DA0, 0xC6F3080 },
    { 0xF5C4DB90, 0xC4D2D10 },
    { 0xF59BDC60, 0xC2A9F70 },
    { 0xF57351B0, 0xC078910 },
    { 0xF54B3DA0, 0xBE3EBD0 },
    { 0xF523A1D0, 0xBBFC8F0 },
    { 0xF4FC7FD0, 0xB9B2210 },
    { 0xF4D5D9A0, 0xB75F8F0 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF48A06E0, 0xB2A2630 },
    { 0xF464DDC0, 0xB038000 },
    { 0xF4403700, 0xADC5E20 },
    { 0xF41C1410, 0xAB4C220 },
    { 0xF3F876C0, 0xA8CAE20 },
    { 0xF3D56080, 0xA6423A0 },
    { 0xF3B2D2F0, 0xA3B2470 },
    { 0xF390CF50, 0xA11B220 },
    { 0xF36F5780, 0x9E7CF00 },
    { 0xF34E6CC0, 0x9BD7CA0 },
    { 0xF32E1060, 0x992BCB0 },
    { 0xF30E4420, 0x9679170 },
    { 0xF2EF0940, 0x93BFCA0 },
    { 0xF2D060F0, 0x90FFFE0 },
    { 0xF2B24CE0, 0x8E39D90 },
    { 0xF294CE30, 0x8B6D770 },
    { 0xF277E600, 0x889AF30 },
    { 0xF25B95F0, 0x85C2760 },
    { 0xF23FDF10, 0x82E41A0 },
    { 0xF224C290, 0x8000010 },
    { 0xF20A4190, 0x7D16468 },
    { 0xF1F05D70, 0x7A27130 },
    { 0xF1D71730, 0x7732840 },
    { 0xF1BE6FE0, 0x7438B68 },
    { 0xF1A668C0, 0x7139D40 },
    { 0xF18F02C0, 0x6E35FA0 },
    { 0xF1783ED0, 0x6B2D468 },
    { 0xF1621E20, 0x681FE38 },
    { 0xF14CA190, 0x650DEF0 },
    { 0xF137CA00, 0x61F7880 },
    { 0xF1239890, 0x5EDCD88 },
    { 0xF1100DF0, 0x5BBE000 },
    { 0xF0FD2B00, 0x589B1E0 },
    { 0xF0EAF0B0, 0x55745C0 },
    { 0xF0D95FC0, 0x5249DB0 },
    { 0xF0C878E0, 0x4F1BB98 },
    { 0xF0B83CF0, 0x4BEA240 },
    { 0xF0A8ACA0, 0x48B53A0 },
    { 0xF099C890, 0x457D1F8 },
    { 0xF08B9150, 0x4241F50 },
    { 0xF07E07B0, 0x3F03E60 },
    { 0xF0712C40, 0x3BC3138 },
    { 0xF064FF70, 0x387F9E0 },
    { 0xF05981E0, 0x3539B20 },
    { 0xF04EB410, 0x31F1704 },
    { 0xF0449680, 0x2EA6FA0 },
    { 0xF03B2990, 0x2B5A7B8 },
    { 0xF0326DB0, 0x280C168 },
    { 0xF02A6340, 0x24BBEB8 },
    { 0xF0230AB0, 0x216A284 },
    { 0xF01C6440, 0x1E16EDA },
    { 0xF0167030, 0x1AC2612 },
    { 0xF0112ED0, 0x176CA44 },
    { 0xF00CA060, 0x1415E44 },
    { 0xF008C510, 0x10BE42C },
    { 0xF0059D00, 0xD65E13 },
    { 0xF0032870, 0xA0CED3 },
    { 0xF0016750, 0x6B3886 },
    { 0xF00059D0, 0x359D44 },
    { 0x10000000, 0x0 },
    { 0xFFE98B0, 0x6B3885 },
    { 0xFFA62F0, 0xD65E3B },
    { 0xFF35F90, 0x1415E54 },
    { 0xFE98FD0, 0x1AC260A },
    { 0xFDCF550, 0x216A2A4 },
    { 0xFCD9250, 0x280C170 },
    { 0xFBB6980, 0x2EA6FCC },
    { 0xFA67E20, 0x3539B38 },
    { 0xF8ED3C0, 0x3BC3138 },
    { 0xF746EA0, 0x4241F70 },
    { 0xF575360, 0x48B53B0 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xF150F40, 0x55745E0 },
    { 0xEEFF200, 0x5BBE008 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xE9DE1D0, 0x681FE48 },
    { 0xE70FD40, 0x6E35FA0 },
    { 0xE419010, 0x7438B90 },
    { 0xE0FA280, 0x7A27140 },
    { 0xDDB3D70, 0x8000000 },
    { 0xDA46A00, 0x85C2770 },
    { 0xD6B31D0, 0x8B6D770 },
    { 0xD2F9EF0, 0x9100000 },
    { 0xCF1BBD0, 0x9679180 },
    { 0xCB19340, 0x9BD7CA0 },
    { 0xC6F3090, 0xA11B240 },
    { 0xC2A9F70, 0xA6423B0 },
    { 0xBE3EBD0, 0xAB4C250 },
    { 0xB9B2230, 0xB038010 },
    { 0xB504F30, 0xB504F30 },
    { 0xB038010, 0xB9B2230 },
    { 0xAB4C240, 0xBE3EBE0 },
    { 0xA6423A0, 0xC2A9F70 },
    { 0xA11B240, 0xC6F30A0 },
    { 0x9BD7C90, 0xCB19350 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x9100000, 0xD2F9EF0 },
    { 0x8B6D760, 0xD6B31E0 },
    { 0x85C2760, 0xDA46A10 },
    { 0x7FFFFF8, 0xDDB3D80 },
    { 0x7A27138, 0xE0FA290 },
    { 0x7438B90, 0xE419010 },
    { 0x6E35F88, 0xE70FD50 },
    { 0x681FE40, 0xE9DE1E0 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x5BBDFF0, 0xEEFF210 },
    { 0x55745D0, 0xF150F40 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x48B53A8, 0xF575360 },
    { 0x4241F78, 0xF746EA0 },
    { 0x3BC3124, 0xF8ED3C0 },
    { 0x3539B2C, 0xFA67E20 },
    { 0x2EA6FCC, 0xFBB6980 },
    { 0x280C154, 0xFCD9250 },
    { 0x216A290, 0xFDCF550 },
    { 0x1AC25FE, 0xFE98FD0 },
    { 0x1415E50, 0xFF35F90 },
    { 0xD65E3F, 0xFFA62F0 },
    { 0x6B3871, 0xFFE98B0 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFF94C777, 0xFFE98B0 },
    { 0xFF29A1AA, 0xFFA62F0 },
    { 0xFEBEA198, 0xFF35F90 },
    { 0xFE53D9EA, 0xFE98FD0 },
    { 0xFDE95D58, 0xFDCF550 },
    { 0xFD7F3E98, 0xFCD9250 },
    { 0xFD159020, 0xFBB6980 },
    { 0xFCAC64BC, 0xFA67E10 },
    { 0xFC43CEC4, 0xF8ED3C0 },
    { 0xFBDBE070, 0xF746EA0 },
    { 0xFB74AC40, 0xF575350 },
    { 0xFB0E4428, 0xF378700 },
    { 0xFAA8BA20, 0xF150F40 },
    { 0xFA441FF8, 0xEEFF210 },
    { 0xF9E08740, 0xEC835E0 },
    { 0xF97E01A8, 0xE9DE1D0 },
    { 0xF91CA060, 0xE70FD40 },
    { 0xF8BC7458, 0xE419000 },
    { 0xF85D8ED0, 0xE0FA290 },
    { 0x10000000, 0x0 },
    { 0xFFA62F0, 0xD65E3B },
    { 0xFE98FD0, 0x1AC260A },
    { 0xFCD9250, 0x280C170 },
    { 0xFA67E20, 0x3539B38 },
    { 0xF746EA0, 0x4241F70 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xEEFF200, 0x5BBE008 },
    { 0xE9DE1D0, 0x681FE48 },
    { 0xE419010, 0x7438B90 },
    { 0xDDB3D70, 0x8000000 },
    { 0xD6B31D0, 0x8B6D770 },
    { 0xCF1BBD0, 0x9679180 },
    { 0xC6F3090, 0xA11B240 },
    { 0xBE3EBD0, 0xAB4C250 },
    { 0xB504F30, 0xB504F30 },
    { 0xAB4C240, 0xBE3EBE0 },
    { 0xA11B240, 0xC6F30A0 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x8B6D760, 0xD6B31E0 },
    { 0x7FFFFF8, 0xDDB3D80 },
    { 0x7438B90, 0xE419010 },
    { 0x681FE40, 0xE9DE1E0 },
    { 0x5BBDFF0, 0xEEFF210 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x4241F78, 0xF746EA0 },
    { 0x3539B2C, 0xFA67E20 },
    { 0x280C154, 0xFCD9250 },
    { 0x1AC25FE, 0xFE98FD0 },
    { 0xD65E3F, 0xFFA62F0 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFF29A1AA, 0xFFA62F0 },
    { 0xFE53D9EA, 0xFE98FD0 },
    { 0xFD7F3E98, 0xFCD9250 },
    { 0xFCAC64BC, 0xFA67E10 },
    { 0xFBDBE070, 0xF746EA0 },
    { 0xFB0E4428, 0xF378700 },
    { 0xFA441FF8, 0xEEFF210 },
    { 0xF97E01A8, 0xE9DE1D0 },
    { 0xF8BC7458, 0xE419000 },
    { 0xF7FFFFF0, 0xDDB3D70 },
    { 0xF7492890, 0xD6B31D0 },
    { 0xF6986E90, 0xCF1BBD0 },
    { 0xF5EE4DA0, 0xC6F3080 },
    { 0xF54B3DA0, 0xBE3EBD0 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF41C1410, 0xAB4C220 },
    { 0xF390CF50, 0xA11B220 },
    { 0xF30E4420, 0x9679170 },
    { 0xF294CE30, 0x8B6D770 },
    { 0xF224C290, 0x8000010 },
    { 0xF1BE6FE0, 0x7438B68 },
    { 0xF1621E20, 0x681FE38 },
    { 0xF1100DF0, 0x5BBE000 },
    { 0xF0C878E0, 0x4F1BB98 },
    { 0xF08B9150, 0x4241F50 },
    { 0xF05981E0, 0x3539B20 },
    { 0xF0326DB0, 0x280C168 },
    { 0xF0167030, 0x1AC2612 },
    { 0xF0059D00, 0xD65E13 },
    { 0xF0000000, 0xFFFFFFE9 },
    { 0xF0059D10, 0xFF29A1BE },
    { 0xF0167040, 0xFE53D9BE },
    { 0xF0326DC0, 0xFD7F3E6C },
    { 0xF05981F0, 0xFCAC64B0 },
    { 0xF08B9160, 0xFBDBE088 },
    { 0xF0C878F0, 0xFB0E4438 },
    { 0xF1100E00, 0xFA441FD0 },
    { 0xF1621E30, 0xF97E01A0 },
    { 0xF1BE6FF0, 0xF8BC7468 },
    { 0xF224C2B0, 0xF7FFFFD0 },
    { 0xF294CE40, 0xF7492870 },
    { 0xF30E4440, 0xF6986E60 },
    { 0xF390CF70, 0xF5EE4DB0 },
    { 0xF41C1430, 0xF54B3DB0 },
    { 0xF4AFB0F0, 0xF4AFB0B0 },
    { 0xF54B3DD0, 0xF41C1420 },
    { 0xF5EE4DD0, 0xF390CF60 },
    { 0xF6986EB0, 0xF30E4410 },
    { 0xF7492880, 0xF294CE30 },
    { 0x10000000, 0x0 },
    { 0xFF35F90, 0x1415E54 },
    { 0xFCD9250, 0x280C170 },
    { 0xF8ED3C0, 0x3BC3138 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xE419010, 0x7438B90 },
    { 0xDA46A00, 0x85C2770 },
    { 0xCF1BBD0, 0x9679180 },
    { 0xC2A9F70, 0xA6423B0 },
    { 0xB504F30, 0xB504F30 },
    { 0xA6423A0, 0xC2A9F70 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x85C2760, 0xDA46A10 },
    { 0x7438B90, 0xE419010 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x3BC3124, 0xF8ED3C0 },
    { 0x280C154, 0xFCD9250 },
    { 0x1415E50, 0xFF35F90 },
    { 0x10000000, 0x0 },
    { 0xFCD9250, 0x280C170 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xE419010, 0x7438B90 },
    { 0xCF1BBD0, 0x9679180 },
    { 0xB504F30, 0xB504F30 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x7438B90, 0xE419010 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x280C154, 0xFCD9250 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFD7F3E98, 0xFCD9250 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF8BC7458, 0xE419000 },
    { 0xF6986E90, 0xCF1BBD0 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF30E4420, 0x9679170 },
    { 0xF1BE6FE0, 0x7438B68 },
    { 0xF0C878E0, 0x4F1BB98 },
    { 0xF0326DB0, 0x280C168 },
    { 0x10000000, 0x0 },
    { 0xF8ED3C0, 0x3BC3138 },
    { 0xE419010, 0x7438B90 },
    { 0xC2A9F70, 0xA6423B0 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x280C154, 0xFCD9250 },
    { 0xFEBEA198, 0xFF35F90 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF7A3D870, 0xDA469F0 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF25B95F0, 0x85C2760 },
    { 0xF0C878E0, 0x4F1BB98 },
    { 0xF00CA060, 0x1415E44 },
    { 0xF0326DC0, 0xFD7F3E6C },
    { 0xF137CA20, 0xF9E08758 },
    { 0xF30E4440, 0xF6986E60 },
    { 0xF59BDC80, 0xF3D56070 },
    { 0xF8BC74C0, 0xF1BE6FD0 },
    { 0xFC43CEB4, 0xF0712C40 },
    { 0x10000000, 0x0 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xCF1BBD0, 0x9679180 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x10000000, 0x0 },
    { 0xCF1BBD0, 0x9679180 },
    { 0x4F1BBC8, 0xF378710 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF30E4420, 0x9679170 },
    { 0x10000000, 0x0 },
    { 0x9679180, 0xCF1BBD0 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF0C878E0, 0x4F1BB98 },
    { 0xF30E4440, 0xF6986E60 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x4F1BBF0, 0xF0C87900 }
};

complex_t cfft_tab_64[] =
{
    { 0x10000000, 0x0 },
    { 0xFEC46D0, 0x1917A6C },
    { 0xFB14BE0, 0x31F1708 },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xE1C5970, 0x78AD750 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xC5E4030, 0xA2679A0 },
    { 0xB504F30, 0xB504F30 },
    { 0xA267990, 0xC5E4030 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x78AD738, 0xE1C5980 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x4A50180, 0xF4FA0B0 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0x10000000, 0x0 },
    { 0xFB14BE0, 0x31F1708 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xB504F30, 0xB504F30 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xF9E08740, 0xEC835E0 },
    { 0xF71C6240, 0xD4DB300 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF2B24CE0, 0x8E39D90 },
    { 0xF137CA00, 0x61F7880 },
    { 0xF04EB410, 0x31F1704 },
    { 0x10000000, 0x0 },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xA267990, 0xC5E4030 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xF8752898, 0xE1C5970 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF1E3A690, 0x78AD768 },
    { 0xF04EB410, 0x31F1704 },
    { 0xF013B930, 0xFE6E8572 },
    { 0xF137CA20, 0xF9E08758 },
    { 0xF3A1BFB0, 0xF5D98680 },
    { 0xF71C62A0, 0xF2B24CC0 },
    { 0xFB5AFE98, 0xF0B05F50 },
    { 0x10000000, 0x0 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xB504F30, 0xB504F30 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x10000000, 0x0 },
    { 0xB504F30, 0xB504F30 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0x10000000, 0x0 },
    { 0x61F78A8, 0xEC835E0 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF137CA20, 0xF9E08758 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x3, 0xF0000000 }
};

complex_t cfft_tab_60[] =
{
    { 0x10000000, 0x0 },
    { 0xFE98FD0, 0x1AC260A },
    { 0xFA67E20, 0x3539B38 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xE9DE1D0, 0x681FE48 },
    { 0xDDB3D70, 0x8000000 },
    { 0xCF1BBD0, 0x9679180 },
    { 0xBE3EBD0, 0xAB4C250 },
    { 0xAB4C240, 0xBE3EBE0 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x7FFFFF8, 0xDDB3D80 },
    { 0x681FE40, 0xE9DE1E0 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x3539B2C, 0xFA67E20 },
    { 0x1AC25FE, 0xFE98FD0 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFE53D9EA, 0xFE98FD0 },
    { 0xFCAC64BC, 0xFA67E10 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF97E01A8, 0xE9DE1D0 },
    { 0x10000000, 0x0 },
    { 0xFA67E20, 0x3539B38 },
    { 0xE9DE1D0, 0x681FE48 },
    { 0xCF1BBD0, 0x9679180 },
    { 0xAB4C240, 0xBE3EBE0 },
    { 0x7FFFFF8, 0xDDB3D80 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x1AC25FE, 0xFE98FD0 },
    { 0xFE53D9EA, 0xFE98FD0 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF7FFFFF0, 0xDDB3D70 },
    { 0xF54B3DA0, 0xBE3EBD0 },
    { 0xF30E4420, 0x9679170 },
    { 0xF1621E20, 0x681FE38 },
    { 0xF05981E0, 0x3539B20 },
    { 0xF0000000, 0xFFFFFFE9 },
    { 0xF05981F0, 0xFCAC64B0 },
    { 0xF1621E30, 0xF97E01A0 },
    { 0xF30E4440, 0xF6986E60 },
    { 0xF54B3DD0, 0xF41C1420 },
    { 0x10000000, 0x0 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xCF1BBD0, 0x9679180 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x10000000, 0x0 },
    { 0xCF1BBD0, 0x9679180 },
    { 0x4F1BBC8, 0xF378710 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF30E4420, 0x9679170 },
    { 0x10000000, 0x0 },
    { 0x9679180, 0xCF1BBD0 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF0C878E0, 0x4F1BB98 },
    { 0xF30E4440, 0xF6986E60 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x4F1BBF0, 0xF0C87900 }
};

#ifdef LD_DEC

complex_t cfft_tab_256[] =
{
    { 0x10000000, 0x0 },
    { 0xFFEC430, 0x648558 },
    { 0xFFB10F0, 0xC8FB30 },
    { 0xFF4E6D0, 0x12D520A },
    { 0xFEC46D0, 0x1917A6C },
    { 0xFE13240, 0x1F564E6 },
    { 0xFD3AAC0, 0x259020C },
    { 0xFC3B280, 0x2BC428C },
    { 0xFB14BE0, 0x31F1708 },
    { 0xF9C79D0, 0x381704C },
    { 0xF853F80, 0x3E33F34 },
    { 0xF6BA070, 0x44474A0 },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xF314470, 0x504D728 },
    { 0xF109080, 0x563E6A0 },
    { 0xEED89E0, 0x5C22150 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xEA09A60, 0x67BDE58 },
    { 0xE76BD80, 0x6D74400 },
    { 0xE4AA590, 0x7319BA8 },
    { 0xE1C5970, 0x78AD750 },
    { 0xDEBE050, 0x7E2E940 },
    { 0xDB941A0, 0x839C3D0 },
    { 0xD848530, 0x88F59B0 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xD14D3D0, 0x93682B0 },
    { 0xCD9F020, 0x987FC00 },
    { 0xC9D1120, 0x9D7FD20 },
    { 0xC5E4030, 0xA2679A0 },
    { 0xC1D8700, 0xA736560 },
    { 0xBDAEF90, 0xABEB4A0 },
    { 0xB968420, 0xB085BB0 },
    { 0xB504F30, 0xB504F30 },
    { 0xB085BA0, 0xB968420 },
    { 0xABEB490, 0xBDAEFA0 },
    { 0xA736550, 0xC1D8710 },
    { 0xA267990, 0xC5E4030 },
    { 0x9D7FD10, 0xC9D1120 },
    { 0x987FC00, 0xCD9F020 },
    { 0x93682A0, 0xD14D3D0 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x88F59B0, 0xD848530 },
    { 0x839C3C0, 0xDB941B0 },
    { 0x7E2E938, 0xDEBE050 },
    { 0x78AD738, 0xE1C5980 },
    { 0x7319BA0, 0xE4AA590 },
    { 0x6D74408, 0xE76BD80 },
    { 0x67BDE48, 0xEA09A70 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x5C22138, 0xEED89E0 },
    { 0x563E698, 0xF109080 },
    { 0x504D710, 0xF314480 },
    { 0x4A50180, 0xF4FA0B0 },
    { 0x4447498, 0xF6BA070 },
    { 0x3E33F20, 0xF853F80 },
    { 0x3817048, 0xF9C79D0 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0x2BC4280, 0xFC3B280 },
    { 0x2590214, 0xFD3AAC0 },
    { 0x1F564D8, 0xFE13240 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0x12D51F6, 0xFF4E6D0 },
    { 0xC8FB29, 0xFFB10F0 },
    { 0x64853F, 0xFFEC430 },
    { 0x10000000, 0x0 },
    { 0xFFB10F0, 0xC8FB30 },
    { 0xFEC46D0, 0x1917A6C },
    { 0xFD3AAC0, 0x259020C },
    { 0xFB14BE0, 0x31F1708 },
    { 0xF853F80, 0x3E33F34 },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xF109080, 0x563E6A0 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xE76BD80, 0x6D74400 },
    { 0xE1C5970, 0x78AD750 },
    { 0xDB941A0, 0x839C3D0 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xCD9F020, 0x987FC00 },
    { 0xC5E4030, 0xA2679A0 },
    { 0xBDAEF90, 0xABEB4A0 },
    { 0xB504F30, 0xB504F30 },
    { 0xABEB490, 0xBDAEFA0 },
    { 0xA267990, 0xC5E4030 },
    { 0x987FC00, 0xCD9F020 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x839C3C0, 0xDB941B0 },
    { 0x78AD738, 0xE1C5980 },
    { 0x6D74408, 0xE76BD80 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x563E698, 0xF109080 },
    { 0x4A50180, 0xF4FA0B0 },
    { 0x3E33F20, 0xF853F80 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0x2590214, 0xFD3AAC0 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0xC8FB29, 0xFFB10F0 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFF3704BF, 0xFFB10F0 },
    { 0xFE6E857E, 0xFEC46D0 },
    { 0xFDA6FDD8, 0xFD3AAC0 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xFC1CC0CC, 0xF853F80 },
    { 0xFB5AFE68, 0xF4FA0A0 },
    { 0xFA9C1950, 0xF109080 },
    { 0xF9E08740, 0xEC835E0 },
    { 0xF928BC00, 0xE76BD80 },
    { 0xF8752898, 0xE1C5970 },
    { 0xF7C63C30, 0xDB941A0 },
    { 0xF71C6240, 0xD4DB300 },
    { 0xF67803F0, 0xCD9F020 },
    { 0xF5D98670, 0xC5E4040 },
    { 0xF5414B50, 0xBDAEF80 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF4251050, 0xABEB480 },
    { 0xF3A1BFC0, 0xA267990 },
    { 0xF3260FC0, 0x987FBD0 },
    { 0xF2B24CE0, 0x8E39D90 },
    { 0xF246BE60, 0x839C3D0 },
    { 0xF1E3A670, 0x78AD730 },
    { 0xF1894280, 0x6D743F8 },
    { 0xF137CA00, 0x61F7880 },
    { 0xF0EF6F70, 0x563E690 },
    { 0xF0B05F50, 0x4A50198 },
    { 0xF07AC080, 0x3E33F14 },
    { 0xF04EB410, 0x31F1704 },
    { 0xF02C5540, 0x25901E8 },
    { 0xF013B930, 0x1917A60 },
    { 0xF004EF10, 0xC8FAFD },
    { 0x10000000, 0x0 },
    { 0xFF4E6D0, 0x12D520A },
    { 0xFD3AAC0, 0x259020C },
    { 0xF9C79D0, 0x381704C },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xEED89E0, 0x5C22150 },
    { 0xE76BD80, 0x6D74400 },
    { 0xDEBE050, 0x7E2E940 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xC9D1130, 0x9D7FD10 },
    { 0xBDAEF90, 0xABEB4A0 },
    { 0xB085BA0, 0xB968420 },
    { 0xA267990, 0xC5E4030 },
    { 0x93682B0, 0xD14D3D0 },
    { 0x839C3C0, 0xDB941B0 },
    { 0x7319BA0, 0xE4AA590 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x504D728, 0xF314470 },
    { 0x3E33F40, 0xF853F80 },
    { 0x2BC4280, 0xFC3B280 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0x64855F, 0xFFEC430 },
    { 0xFF3704BF, 0xFFB10F0 },
    { 0xFE0A9B12, 0xFE13230 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xFBBB8B70, 0xF6BA070 },
    { 0xFA9C1970, 0xF109080 },
    { 0xF98421A8, 0xEA09A60 },
    { 0xF8752898, 0xE1C5970 },
    { 0xF770A640, 0xD848520 },
    { 0xF67803F0, 0xCD9F020 },
    { 0xF58C9AA0, 0xC1D8700 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF3E27900, 0xA736560 },
    { 0xF3260FE0, 0x987FC10 },
    { 0xF27B7AE0, 0x88F59C0 },
    { 0xF1E3A690, 0x78AD768 },
    { 0xF15F6590, 0x67BDE38 },
    { 0xF0EF6F70, 0x563E690 },
    { 0xF0945F90, 0x4447490 },
    { 0xF04EB410, 0x31F1704 },
    { 0xF01ECDD0, 0x1F564EC },
    { 0xF004EF10, 0xC8FB3D },
    { 0xF0013BD0, 0xFF9B7ABE },
    { 0xF013B930, 0xFE6E8572 },
    { 0xF03C4D80, 0xFD43BD5C },
    { 0xF07AC080, 0xFC1CC0C0 },
    { 0xF0CEBB90, 0xFAFB28D0 },
    { 0xF137CA20, 0xF9E08758 },
    { 0xF1B55A70, 0xF8CE6460 },
    { 0xF246BE50, 0xF7C63C40 },
    { 0xF2EB2C20, 0xF6C97D70 },
    { 0xF3A1BFB0, 0xF5D98680 },
    { 0xF4697BF0, 0xF4F7A440 },
    { 0xF5414B70, 0xF4251060 },
    { 0xF62802F0, 0xF362EED0 },
    { 0xF71C62A0, 0xF2B24CC0 },
    { 0xF81D16C8, 0xF2141FB0 },
    { 0xF928BC28, 0xF1894270 },
    { 0xFA3DDEA0, 0xF1127630 },
    { 0xFB5AFE98, 0xF0B05F50 },
    { 0xFC7E8F90, 0xF0638630 },
    { 0xFDA6FE04, 0xF02C5540 },
    { 0xFED2ADC2, 0xF00B1930 },
    { 0x10000000, 0x0 },
    { 0xFEC46D0, 0x1917A6C },
    { 0xFB14BE0, 0x31F1708 },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xE1C5970, 0x78AD750 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xC5E4030, 0xA2679A0 },
    { 0xB504F30, 0xB504F30 },
    { 0xA267990, 0xC5E4030 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x78AD738, 0xE1C5980 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x4A50180, 0xF4FA0B0 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0x10000000, 0x0 },
    { 0xFB14BE0, 0x31F1708 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xB504F30, 0xB504F30 },
    { 0x8E39D90, 0xD4DB320 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x31F16F0, 0xFB14BF0 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xF9E08740, 0xEC835E0 },
    { 0xF71C6240, 0xD4DB300 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF2B24CE0, 0x8E39D90 },
    { 0xF137CA00, 0x61F7880 },
    { 0xF04EB410, 0x31F1704 },
    { 0x10000000, 0x0 },
    { 0xF4FA0B0, 0x4A50188 },
    { 0xD4DB310, 0x8E39DA0 },
    { 0xA267990, 0xC5E4030 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x1917A6A, 0xFEC46D0 },
    { 0xFCE0E8F8, 0xFB14BE0 },
    { 0xF8752898, 0xE1C5970 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF1E3A690, 0x78AD768 },
    { 0xF04EB410, 0x31F1704 },
    { 0xF013B930, 0xFE6E8572 },
    { 0xF137CA20, 0xF9E08758 },
    { 0xF3A1BFB0, 0xF5D98680 },
    { 0xF71C62A0, 0xF2B24CC0 },
    { 0xFB5AFE98, 0xF0B05F50 },
    { 0x10000000, 0x0 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xB504F30, 0xB504F30 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x10000000, 0x0 },
    { 0xB504F30, 0xB504F30 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0x10000000, 0x0 },
    { 0x61F78A8, 0xEC835E0 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF137CA20, 0xF9E08758 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x3, 0xF0000000 }
};

complex_t cfft_tab_240[] =
{
    { 0x10000000, 0x0 },
    { 0xFFE98B0, 0x6B3885 },
    { 0xFFA62F0, 0xD65E3B },
    { 0xFF35F90, 0x1415E54 },
    { 0xFE98FD0, 0x1AC260A },
    { 0xFDCF550, 0x216A2A4 },
    { 0xFCD9250, 0x280C170 },
    { 0xFBB6980, 0x2EA6FCC },
    { 0xFA67E20, 0x3539B38 },
    { 0xF8ED3C0, 0x3BC3138 },
    { 0xF746EA0, 0x4241F70 },
    { 0xF575360, 0x48B53B0 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xF150F40, 0x55745E0 },
    { 0xEEFF200, 0x5BBE008 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xE9DE1D0, 0x681FE48 },
    { 0xE70FD40, 0x6E35FA0 },
    { 0xE419010, 0x7438B90 },
    { 0xE0FA280, 0x7A27140 },
    { 0xDDB3D70, 0x8000000 },
    { 0xDA46A00, 0x85C2770 },
    { 0xD6B31D0, 0x8B6D770 },
    { 0xD2F9EF0, 0x9100000 },
    { 0xCF1BBD0, 0x9679180 },
    { 0xCB19340, 0x9BD7CA0 },
    { 0xC6F3090, 0xA11B240 },
    { 0xC2A9F70, 0xA6423B0 },
    { 0xBE3EBD0, 0xAB4C250 },
    { 0xB9B2230, 0xB038010 },
    { 0xB504F30, 0xB504F30 },
    { 0xB038010, 0xB9B2230 },
    { 0xAB4C240, 0xBE3EBE0 },
    { 0xA6423A0, 0xC2A9F70 },
    { 0xA11B240, 0xC6F30A0 },
    { 0x9BD7C90, 0xCB19350 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x9100000, 0xD2F9EF0 },
    { 0x8B6D760, 0xD6B31E0 },
    { 0x85C2760, 0xDA46A10 },
    { 0x7FFFFF8, 0xDDB3D80 },
    { 0x7A27138, 0xE0FA290 },
    { 0x7438B90, 0xE419010 },
    { 0x6E35F88, 0xE70FD50 },
    { 0x681FE40, 0xE9DE1E0 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x5BBDFF0, 0xEEFF210 },
    { 0x55745D0, 0xF150F40 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x48B53A8, 0xF575360 },
    { 0x4241F78, 0xF746EA0 },
    { 0x3BC3124, 0xF8ED3C0 },
    { 0x3539B2C, 0xFA67E20 },
    { 0x2EA6FCC, 0xFBB6980 },
    { 0x280C154, 0xFCD9250 },
    { 0x216A290, 0xFDCF550 },
    { 0x1AC25FE, 0xFE98FD0 },
    { 0x1415E50, 0xFF35F90 },
    { 0xD65E3F, 0xFFA62F0 },
    { 0x6B3871, 0xFFE98B0 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFF94C777, 0xFFE98B0 },
    { 0xFF29A1AA, 0xFFA62F0 },
    { 0xFEBEA198, 0xFF35F90 },
    { 0xFE53D9EA, 0xFE98FD0 },
    { 0xFDE95D58, 0xFDCF550 },
    { 0xFD7F3E98, 0xFCD9250 },
    { 0xFD159020, 0xFBB6980 },
    { 0xFCAC64BC, 0xFA67E10 },
    { 0xFC43CEC4, 0xF8ED3C0 },
    { 0xFBDBE070, 0xF746EA0 },
    { 0xFB74AC40, 0xF575350 },
    { 0xFB0E4428, 0xF378700 },
    { 0xFAA8BA20, 0xF150F40 },
    { 0xFA441FF8, 0xEEFF210 },
    { 0xF9E08740, 0xEC835E0 },
    { 0xF97E01A8, 0xE9DE1D0 },
    { 0xF91CA060, 0xE70FD40 },
    { 0xF8BC7458, 0xE419000 },
    { 0xF85D8ED0, 0xE0FA290 },
    { 0x10000000, 0x0 },
    { 0xFFA62F0, 0xD65E3B },
    { 0xFE98FD0, 0x1AC260A },
    { 0xFCD9250, 0x280C170 },
    { 0xFA67E20, 0x3539B38 },
    { 0xF746EA0, 0x4241F70 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xEEFF200, 0x5BBE008 },
    { 0xE9DE1D0, 0x681FE48 },
    { 0xE419010, 0x7438B90 },
    { 0xDDB3D70, 0x8000000 },
    { 0xD6B31D0, 0x8B6D770 },
    { 0xCF1BBD0, 0x9679180 },
    { 0xC6F3090, 0xA11B240 },
    { 0xBE3EBD0, 0xAB4C250 },
    { 0xB504F30, 0xB504F30 },
    { 0xAB4C240, 0xBE3EBE0 },
    { 0xA11B240, 0xC6F30A0 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x8B6D760, 0xD6B31E0 },
    { 0x7FFFFF8, 0xDDB3D80 },
    { 0x7438B90, 0xE419010 },
    { 0x681FE40, 0xE9DE1E0 },
    { 0x5BBDFF0, 0xEEFF210 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x4241F78, 0xF746EA0 },
    { 0x3539B2C, 0xFA67E20 },
    { 0x280C154, 0xFCD9250 },
    { 0x1AC25FE, 0xFE98FD0 },
    { 0xD65E3F, 0xFFA62F0 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFF29A1AA, 0xFFA62F0 },
    { 0xFE53D9EA, 0xFE98FD0 },
    { 0xFD7F3E98, 0xFCD9250 },
    { 0xFCAC64BC, 0xFA67E10 },
    { 0xFBDBE070, 0xF746EA0 },
    { 0xFB0E4428, 0xF378700 },
    { 0xFA441FF8, 0xEEFF210 },
    { 0xF97E01A8, 0xE9DE1D0 },
    { 0xF8BC7458, 0xE419000 },
    { 0xF7FFFFF0, 0xDDB3D70 },
    { 0xF7492890, 0xD6B31D0 },
    { 0xF6986E90, 0xCF1BBD0 },
    { 0xF5EE4DA0, 0xC6F3080 },
    { 0xF54B3DA0, 0xBE3EBD0 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF41C1410, 0xAB4C220 },
    { 0xF390CF50, 0xA11B220 },
    { 0xF30E4420, 0x9679170 },
    { 0xF294CE30, 0x8B6D770 },
    { 0xF224C290, 0x8000010 },
    { 0xF1BE6FE0, 0x7438B68 },
    { 0xF1621E20, 0x681FE38 },
    { 0xF1100DF0, 0x5BBE000 },
    { 0xF0C878E0, 0x4F1BB98 },
    { 0xF08B9150, 0x4241F50 },
    { 0xF05981E0, 0x3539B20 },
    { 0xF0326DB0, 0x280C168 },
    { 0xF0167030, 0x1AC2612 },
    { 0xF0059D00, 0xD65E13 },
    { 0xF0000000, 0xFFFFFFE9 },
    { 0xF0059D10, 0xFF29A1BE },
    { 0xF0167040, 0xFE53D9BE },
    { 0xF0326DC0, 0xFD7F3E6C },
    { 0xF05981F0, 0xFCAC64B0 },
    { 0xF08B9160, 0xFBDBE088 },
    { 0xF0C878F0, 0xFB0E4438 },
    { 0xF1100E00, 0xFA441FD0 },
    { 0xF1621E30, 0xF97E01A0 },
    { 0xF1BE6FF0, 0xF8BC7468 },
    { 0xF224C2B0, 0xF7FFFFD0 },
    { 0xF294CE40, 0xF7492870 },
    { 0xF30E4440, 0xF6986E60 },
    { 0xF390CF70, 0xF5EE4DB0 },
    { 0xF41C1430, 0xF54B3DB0 },
    { 0xF4AFB0F0, 0xF4AFB0B0 },
    { 0xF54B3DD0, 0xF41C1420 },
    { 0xF5EE4DD0, 0xF390CF60 },
    { 0xF6986EB0, 0xF30E4410 },
    { 0xF7492880, 0xF294CE30 },
    { 0x10000000, 0x0 },
    { 0xFF35F90, 0x1415E54 },
    { 0xFCD9250, 0x280C170 },
    { 0xF8ED3C0, 0x3BC3138 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xEC835E0, 0x61F78B0 },
    { 0xE419010, 0x7438B90 },
    { 0xDA46A00, 0x85C2770 },
    { 0xCF1BBD0, 0x9679180 },
    { 0xC2A9F70, 0xA6423B0 },
    { 0xB504F30, 0xB504F30 },
    { 0xA6423A0, 0xC2A9F70 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x85C2760, 0xDA46A10 },
    { 0x7438B90, 0xE419010 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x3BC3124, 0xF8ED3C0 },
    { 0x280C154, 0xFCD9250 },
    { 0x1415E50, 0xFF35F90 },
    { 0x10000000, 0x0 },
    { 0xFCD9250, 0x280C170 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xE419010, 0x7438B90 },
    { 0xCF1BBD0, 0x9679180 },
    { 0xB504F30, 0xB504F30 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x7438B90, 0xE419010 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x280C154, 0xFCD9250 },
    { 0xFFFFFFF5, 0x10000000 },
    { 0xFD7F3E98, 0xFCD9250 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF8BC7458, 0xE419000 },
    { 0xF6986E90, 0xCF1BBD0 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF30E4420, 0x9679170 },
    { 0xF1BE6FE0, 0x7438B68 },
    { 0xF0C878E0, 0x4F1BB98 },
    { 0xF0326DB0, 0x280C168 },
    { 0x10000000, 0x0 },
    { 0xF8ED3C0, 0x3BC3138 },
    { 0xE419010, 0x7438B90 },
    { 0xC2A9F70, 0xA6423B0 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x61F78A8, 0xEC835E0 },
    { 0x280C154, 0xFCD9250 },
    { 0xFEBEA198, 0xFF35F90 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF7A3D870, 0xDA469F0 },
    { 0xF4AFB0D0, 0xB504F30 },
    { 0xF25B95F0, 0x85C2760 },
    { 0xF0C878E0, 0x4F1BB98 },
    { 0xF00CA060, 0x1415E44 },
    { 0xF0326DC0, 0xFD7F3E6C },
    { 0xF137CA20, 0xF9E08758 },
    { 0xF30E4440, 0xF6986E60 },
    { 0xF59BDC80, 0xF3D56070 },
    { 0xF8BC74C0, 0xF1BE6FD0 },
    { 0xFC43CEB4, 0xF0712C40 },
    { 0x10000000, 0x0 },
    { 0xF378710, 0x4F1BBD0 },
    { 0xCF1BBD0, 0x9679180 },
    { 0x9679180, 0xCF1BBD0 },
    { 0x4F1BBC8, 0xF378710 },
    { 0x10000000, 0x0 },
    { 0xCF1BBD0, 0x9679180 },
    { 0x4F1BBC8, 0xF378710 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF30E4420, 0x9679170 },
    { 0x10000000, 0x0 },
    { 0x9679180, 0xCF1BBD0 },
    { 0xFB0E4428, 0xF378700 },
    { 0xF0C878E0, 0x4F1BB98 },
    { 0xF30E4440, 0xF6986E60 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x10000000, 0x0 },
    { 0x4F1BBF0, 0xF0C87900 }
};

#endif

#endif

#ifdef __cplusplus
}
#endif
#endif
