/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.File;
import java.io.IOException;
import org.videolan.LockFile;
import org.videolan.Logger;

class CacheDir {
    private static File cacheRoot = null;
    private static LockFile lockFile = null;
    private static final String baseDir = System.getProperty("java.io.tmpdir") + File.separator + "libbluray-bdj-cache" + File.separator;
    private static final Logger logger = Logger.getLogger(CacheDir.class.getName());

    CacheDir() {
    }

    private static LockFile lockCache(String path) {
        return LockFile.create(path + File.separator + "lock");
    }

    private static void cleanupCache() {
        File[] files = new File(baseDir).listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                LockFile lock;
                File dir = files[i];
                if (!dir.isDirectory() || (lock = CacheDir.lockCache(dir.getPath())) == null) continue;
                lock.release();
                CacheDir.removeImpl(dir);
            }
        }
    }

    private static synchronized File getCacheRoot() throws IOException {
        if (cacheRoot != null) {
            return cacheRoot;
        }
        CacheDir.cleanupCache();
        for (int i = 0; i < 100; ++i) {
            File tmpDir = new File(baseDir + System.nanoTime());
            if ((tmpDir = new File(tmpDir.getCanonicalPath())).mkdirs()) {
                cacheRoot = tmpDir;
                lockFile = CacheDir.lockCache(cacheRoot.getPath());
                logger.info("Created cache in " + tmpDir.getPath());
                return cacheRoot;
            }
            logger.error("error creating " + tmpDir.getPath());
        }
        logger.error("failed to create temporary cache directory");
        throw new IOException();
    }

    public static synchronized File create(String domain) throws IOException {
        File tmpDir = new File(CacheDir.getCacheRoot().getPath() + File.separator + domain);
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            logger.error("Error creating " + tmpDir.getPath());
            throw new IOException();
        }
        return tmpDir;
    }

    public static File create(String domain, String name) throws IOException {
        return CacheDir.create(domain + File.separator + name);
    }

    private static void removeImpl(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    CacheDir.removeImpl(file);
                    continue;
                }
                if (file.delete()) continue;
                logger.info("Error removing " + file.getPath());
            }
        }
        if (!dir.delete()) {
            logger.error("Error removing " + dir.getPath());
        }
    }

    public static synchronized void remove(File dir) {
        String path = dir.getPath();
        if (path.indexOf(cacheRoot.getPath()) != 0) {
            logger.error("Error removing " + dir.getPath() + ": not inside cache !");
            return;
        }
        if (path.indexOf("..") >= 0) {
            logger.error("Error removing " + dir.getPath() + ": not canonical path !");
            return;
        }
        CacheDir.removeImpl(dir);
    }

    public static synchronized void remove() {
        if (lockFile != null) {
            lockFile.release();
            lockFile = null;
        }
        if (cacheRoot != null) {
            CacheDir.remove(cacheRoot);
            cacheRoot = null;
        }
    }
}

