
/* msm_fourcc.h
 *
 * Copyright (c) 2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MSM_FOURCC_H_
#define MSM_FOURCC_H_

/* This is from the trident fourcc definition */

#define FOURCC_RGB565 0x36315652
#define XVIMAGE_RGB565 \
   { \
        FOURCC_RGB565, \
        XvRGB,\
        LSBFirst,\
       {'R','V','1','6',\
       0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},\
       16,\
       XvPacked,\
       1,\
       16, 0xF800, 0x07E0, 0x001F,\
       0, 0, 0,\
       0, 0, 0,\
       0, 0, 0,\
       {'R','G','B',0,\
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},\
       XvTopToBottom\
    }

#define FOURCC_NV12 0x3231564E

#define XVIMAGE_NV12 \
  { \
    FOURCC_NV12,				\
    XvYUV,					\
    LSBFirst, \
    {'N','V','1','2', \
    0x00,0x00,0x00,0x10,0x80,0x00,0x00,0xAA,0x00,0x38,0x9B,0x71}, \
    12, \
    XvPlanar, \
    2, \
    0, 0, 0, 0 , \
    8, 8, 8, \
    1, 2, 2, \
    1, 2, 2, \
    {'Y','U','V',0, \
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, \
    XvTopToBottom \
  }

#define FOURCC_NV21 0x3132564E

#define XVIMAGE_NV21 \
  { \
    FOURCC_NV21,				\
    XvYUV,					\
    LSBFirst, \
    {'N','V','3','2', \
    0x00,0x00,0x00,0x10,0x80,0x00,0x00,0xAA,0x00,0x38,0x9B,0x71}, \
    12, \
    XvPlanar, \
    2, \
    0, 0, 0, 0 , \
    8, 8, 8, \
    1, 2, 2, \
    1, 2, 2, \
    {'Y','V','U',0, \
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, \
    XvTopToBottom \
  }

#endif
