#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.util.simple_logger import Logger
logger=Logger("xpra_server_test", log_colour=Logger.RED, _debug=True)
from winswitch.util.main_loop import test_loop

def xpra_detect():
	from winswitch.objects.server_settings import ServerSettings
	config = ServerSettings()
	from winswitch.virt.xpra_server_util import XpraServerUtil
	def add_session(*args):
		logger.slog(None, *args)
	def remove_session(*args):
		logger.slog(None, *args)
	def update_session_status(*args):
		logger.slog(None, *args)
	def session_failed(*args):
		logger.slog(None, *args)
	xss = XpraServerUtil(config, add_session, remove_session, update_session_status, session_failed)
	xss.prelaunch_enabled = False
	xss.init()

	xss.detect_existing_sessions([])
	xss.setup_directory_watcher()


def main():
	test_loop(xpra_detect)


if __name__ == "__main__":
	main()
