/*
 * Copyright (c) 2019 Andri Yngvason
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#pragma once

#include <stdint.h>
#include <wayland-client.h>

struct seat {
	struct wl_seat* wl_seat;
	struct wl_list link;

	uint32_t id;
	uint32_t capabilities;
	char name[256];

	uint32_t occupancy;
};

struct seat* seat_new(struct wl_seat* wl_seat, uint32_t id);
void seat_destroy(struct seat* self);
void seat_list_destroy(struct wl_list* list);

struct seat* seat_find_by_name(struct wl_list* list, const char* name);
struct seat* seat_find_by_id(struct wl_list* list, uint32_t id);
struct seat* seat_find_unoccupied(struct wl_list* list);
struct seat* seat_first(struct wl_list* list);
