// This is core/vpgl/algo/vpgl_triangulate_points.h
#ifndef VPGL_TRIANGULATE_POINTS_H
#define VPGL_TRIANGULATE_POINTS_H
//:
// \file
// \brief Determines the 3D location of a point in world space given the 2D location of the point as seen by a collection of cameras.
// \author Andrew Hoelscher
// \date August 28, 2011

#include <vcl_vector.h>

#include <vgl/vgl_point_2d.h>
#include <vgl/vgl_point_3d.h>

#include <vpgl/vpgl_perspective_camera.h>


class vpgl_triangulate_points
{
  public:
    //: Calculates the best 3D point corresponding to a set of 2D camera points.
    // Takes in a list of points and cameras, and finds the
    // least-squared solution to the intersection of the rays
    // generated by the points. Assumes that point i is viewed
    // by camera i. The result is placed into point_3d. Returns
    // the sum of squared errors.
    static double triangulate(
        const vcl_vector<vgl_point_2d<double> > &points,
        const vcl_vector<vpgl_perspective_camera<double> > &cameras,
        vgl_point_3d<double> &point_3d);
};

#endif // VPGL_TRIANGULATE_POINTS_H
