/*
 *            Copyright 2009-2020 The VOTCA Development Team
 *                       (http://www.votca.org)
 *
 *      Licensed under the Apache License, Version 2.0 (the "License")
 *
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *              http://www.apache.org/licenses/LICENSe-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include "gauss_laguerre_quadrature.h"

// Gauss-Laguerre quadrature points and adapted weights as exported from
// https://keisan.casio.com/exec/system/1329114617
// with 50 digits, alpha=0

namespace votca {
namespace xtp {

void Gauss_Laguerre_Quadrature::FillPoints() {
  Eigen::VectorXd points_8(8);
  points_8 << 0.17027963230510099978886185660829724468251824708548,
      0.9037017767993799121860202235550898922166525972985,
      2.2510866298661306893071183669686351538381871358948,
      4.2667001702876587936494218269006396344821222793532,
      7.0459054023934656972793254821193584980087387492524,
      10.758516010180995224059956788032034147832602219141,
      15.740678641278004578028761158402835874146032041614,
      22.863131736889264105700534297413109554793146730361;
  _map_points[8] = points_8;
  Eigen::VectorXd points_10(10);
  points_10 << 0.1377934705404924308307725056527111881079916807458,
      0.7294545495031704981603731216760787810760727333122,
      1.8083429017403160482329200757506088332830602823715,
      3.4014336978548995144825322214083906792731566142035,
      5.5524961400638036324175584868687628579740642873178,
      8.330152746764496700238767197274522182709438972031,
      11.843785837900065564918538919141613985802816909465,
      16.279257831378102099532653935833622335255995603033,
      21.996585811980761951277090195594493976806732340002,
      29.920697012273891559908793340799195179710670577518;
  _map_points[10] = points_10;
  Eigen::VectorXd points_12(12);
  points_12 << 0.11572211735802067526719642824049422371981805287062,
      0.6117574845151306653916300530416698801066213555077,
      1.512610269776418786781737926866697246973609916394,
      2.8337513377435072286274717765721434586744749567016,
      4.5992276394183484846057292248505333063864850146524,
      6.8445254531151773477543304184938407896643044488694,
      9.6213168424568670439123823492309910941421457731566,
      13.006054993306347720346052429401001984505838945536,
      17.116855187462255728184052800759193917914019230472,
      22.151090379397005669921895083663788010407725298709,
      28.48796725098400031256860723252153419851162040233,
      37.099121044466920336638914276358111888993336604802;
  _map_points[12] = points_12;
  Eigen::VectorXd points_14(14);
  points_14 << 0.0997475070325975745736829452514337328496035798394,
      0.5268576488519028964045834515021405172634500388511,
      1.3006291212514964817084202211569857435644440547503,
      2.4308010787308446361699975103839831795758034729374,
      3.93210282229321888213134366777639017436772314625,
      5.825536218301708419338999838984992693945922492875,
      8.1402401415651450300597804605200400135811494427105,
      10.916499507366018840813051090408562918776029134103,
      14.210805011161288683105978082509492366054109733828,
      18.104892220218098412554627208297871875299155685169,
      22.723381628269624823228088698478093397573388953516,
      28.272981723248205695415892321792259432913212010101,
      35.149443660592426582864312136374578367282950253361,
      44.366081711117423041631242366563175586953058001708;
  _map_points[14] = points_14;
  Eigen::VectorXd points_16(16);
  points_16 << 0.0876494104789278403601980973401034621419572269307,
      0.462696328915080831880838260664253790647713617829,
      1.141057774831226856877945018105178437344393273812,
      2.129283645098380616326159070658178825103674723855,
      3.437086633893206645235107016751850636368112142398,
      5.0780186145497679129230583081419290650410566835825,
      7.0703385350482341303959894708013377973907115507906,
      9.4383143363919387839472467291128233157596833315712,
      12.214223368866158736939124608824202825826006388601,
      15.441527368781617076764774162213510172456158693868,
      19.18015685675313485466314094973963152074358424594,
      23.515905693991908531823187275156254224431439633643,
      28.578729742882140367520613709877699560720238612648,
      34.583398702286625814527687177752583364021196976611,
      41.940452647688332635472233025186596374902502248119,
      51.7011603395433183643426971196738666271015706498;
  _map_points[16] = points_16;
  Eigen::VectorXd points_18(18);
  points_18 << 0.0781691666697054712986747615334420233702209795519,
      0.4124900852591292910391015365358187181177146313242,
      1.0165201796235396891909368618668855701206401569414,
      1.894888509969760914267278319541264842564557062806,
      3.054353113202659751152411307188873720946276545317,
      4.5042055388898928263379557145489659831509941873015,
      6.2567250739491114527420911632631325424397973997244,
      8.3278251566056300217047026156366702569736425802806,
      10.73799004775760933521790333966296316427852438555,
      13.513656207555089819086381210822127397981969779753,
      16.689306281930105937818398416274447581466477919728,
      20.310767626267742856131376455327358444583306013385,
      24.44068135928370276564422579804482604635135712019,
      29.168208662579616131298067780459902617589068898445,
      34.627927065660172145401242943827329353360610031535,
      41.041816772808758139294861428387138227755853533312,
      48.833922716086522748658609329001988025490585699449,
      59.090546435901250703715781018076865483458403075406;
  _map_points[18] = points_18;
  Eigen::VectorXd points_20(20);
  points_20 << 0.0705398896919887533666890045842150958693606298353,
      0.3721268180016114437942413887611466366740282101562,
      0.916582102483273564667716277074183187205604198043,
      1.7073065310283438806876896674130507061879399482153,
      2.7491992553094321296450304604948133842756169174058,
      4.0489253138508869223749533691333321965066524470376,
      5.6151749708616165141045398856518923479177568766444,
      7.4590174536710633097688602183718175953844771201739,
      9.594392869581096772473672734282798378150637894214,
      12.038802546964316309623409298865515868227553873675,
      14.814293442630739978512679710047975674250757105644,
      17.948895520519376017365790992612509648678004429199,
      21.47878824028501097573517036959466921620975569711,
      25.451702793186905503518677484641541838163511223646,
      29.932554631700612006713656135165823251660560350598,
      35.013434240479000006284935906688139581765928732597,
      40.8330570567285710620295677078075526717076597492,
      47.619994047346502139941627152851121113143970342575,
      55.810795750063898890750773444497235628385311248334,
      66.524416525615753818640318791460665979634913005697;
  _map_points[20] = points_20;
  Eigen::VectorXd points_40(40);
  points_40 << 0.0357003943088883851220844712866008554471707628149,
      0.18816228315869851600358934621909591394293666113791,
      0.462694281314576453564937524561190364453607375302,
      0.859772963972934922257272224688722412787336248772,
      1.3800108205273371864980003295952655980266946580187,
      2.024209135922826733442066002800130755138249586785,
      2.79336935350681645765351448602664039646411766026,
      3.688702677908270209591526351908686985322684278108,
      4.7116411465549726936187228362774736997704383014234,
      5.863850878343718114273164237995829873706333665906,
      7.147247908102288250685691951979423627162742562622,
      8.564017017586163762718522042088132329834223235875,
      10.116634048451939406849629656395244803078763144976,
      11.80789229400458484284158670436063044361624976829,
      13.640933712537087228371676360650120272664977583724,
      15.619285893339073837201963652188014575529877065963,
      17.74690595009566304257387749542437728612928336178,
      20.028232834574890529612614810175117254644494661203,
      22.468249983498418351371786228994536610130643377903,
      25.072560772426203794396086209400976984928647204804,
      27.84748000916886272075170414045579970497710334522,
      30.800145739445462700754385196191111466806525240079,
      33.938657084913719609098858586281999025873238496244,
      37.272245880476004328320760990607420709008825810101,
      40.811492823886920466155675581600642667953251587249,
      44.568603175334462707123020634498355945521081304283,
      48.557763533059992280962048806706793661448765941115,
      52.795611187216932969352021137391763864681330119913,
      57.301863323393627495033746995892165165394807293789,
      62.100179072775111612168199057898992128296274498277,
      67.219370927126998799080277551888705482491990862762,
      72.695158847612462117521927724261938587543180945972,
      78.572802911571309280543896833481259682513746165071,
      84.911231135704984542701564709666318673805455422378,
      91.789874671236376992337193480627315365272611690889,
      99.32080871744680825010905416548681232546713909599,
      107.67244063938827252079676761132266456489436636241,
      117.12230951269068880765064412355070215650915273018,
      128.20184198825565119254110438963126356905018343001,
      142.28004446915999788834883535954176420971149849241;
  _map_points[40] = points_40;
  Eigen::VectorXd points_100(100);
  points_100 << 0.014386146995419669464436032421084281688512050966,
      0.075803612023357124642993170677619621890564537719,
      0.186314102057187173711460039042000603546202143312,
      0.345969180991429090805378304989176665916272749467,
      0.554810937580915509598340862968475972057253331879,
      0.812891284115668845038081302089693108916678219316,
      1.120273835007540148567503208138516870987060387277,
      1.4770343299238270697185615900119702038820488303,
      1.883260826342394705801824648360138069613386116537,
      2.339053849646034171844423329865789475081345368214,
      2.844526542755359066517119246955045643779362386548,
      3.399804827445711944287159094946990679966759356644,
      4.005027581758652017464900403271417436365020069786,
      4.6603468355689084595040280266228479367781522394339,
      5.3659279855851170148835307002113124177735600130764,
      6.121950030804019789061373794621522567393863248656,
      6.928605829376173055020578689898725880965610515716,
      7.786102377862517434336654189095964321122329875985,
      8.69466111392216798920445606412688315055307201065,
      9.654518243555080727805574157972236574607597645112,
      10.665925094121675550534495350158743760803952603248,
      11.729148494472225071619721912253497544647053283665,
      12.844471183641030571565638150584109591717836412828,
      14.012192249694274648964132308316289629464199959767,
      15.23262760046669784302041550956226051576480325499,
      16.506110468081989594185016055271767580375606202441,
      17.832991949326387429842546114269676532212047749239,
      19.213641584136066684901496749658987824327097324692,
      20.648447974668349519654447808348566296686549680439,
      22.137819447656704406552716077390543723572214396682,
      23.682184763002376100171887646238319774521954316415,
      25.281993871834041538775185811767894692106599605973,
      26.937718727574264943554420821563356298284635311442,
      28.64985415389129217109679221074678696489104285425,
      30.418918773790942919595713617048104452697898639485,
      32.245456004520665842270490683432751487625800550655,
      34.130035123421516471287278120181406582083089466876,
      36.07325241037997322620358475807515539192546120546,
      38.07573237310709319104533518730924429731326579851,
      40.138129062115545763233678737698828135667518753993,
      42.261127482984794178411494933871743845349357073648,
      44.445445114311806077478838491178111032087024891251,
      46.691833540651539419116010770581151491879821535361,
      49.001080210772436956028200619659191741327940749713,
      51.37401033270399452135984751304564700967634136002,
      53.811488918355660438291791945942420574999135872589,
      56.314422991961708237686384235697436356533205469116,
      58.883763978282090293706081105456788791980697773486,
      61.520510288396142646799262555210088301307405134792,
      64.225710123101560166967699113534070019919296344492,
      67.000464516419311596764254278099751432705630830302,
      69.845930644558374286446832951544745923856156790577,
      72.763325428974586256338515260247046548202678094156,
      75.753929465939936192709187121887367163951952654792,
      78.81909131941147219953449711916410052905582603643,
      81.960232219060124004406034433922871748963999777354,
      85.17885121121890019965819425201152285085863371472,
      88.47653081739461122166173313351549931817562325053,
      91.85494326304930893124588349974424058207792737754,
      95.31585734883172060708188049803719081708348511971,
      98.861146047613527716885852139755277900476209073942,
      102.49279492391656096335151490724171601197400288973,
      106.21291148804681620553193500890842029564387560101,
      110.02373561603091696044095567254651297506815777452,
      113.92765118897162371111095615952688206853431374889,
      117.92719913257322683566930153317598472314768078915,
      122.0250920704416210770071192771802129977882374398,
      126.22423084475038757481282514568521751638696104949,
      130.52772320679941326555235618477155948740904346682,
      134.93890504022740757717591916185365596931353150412,
      139.46136455424015676483735784559273942265772179158,
      144.0989699772127241580660709688897260659410534834,
      148.85590139775824946113745249503385376533217593335,
      153.73668754797303061104508345523147446924144789121,
      158.74624851171310443390313484523534639226550232703,
      163.88994558258723283156168509187096508290147957381,
      169.17363981000302458051369125544383162038737281778,
      174.60376118237662671452586450128250401592779770557,
      180.18739094024569619468544567349296547541064513326,
      185.93236023966697143161396472939190679919308665195,
      191.84736937224832912467163514693758170098662143982,
      197.94213310214325740605535167367820592237967945187,
      204.22755956703050772080095334034491093971825741861,
      210.71597286157694337066830974235388351439277499162,
      217.42139327200148109611632514213232315501173179011,
      224.35989478887460814536094305461044256748650339089,
      231.550068025172484218832989049761250273162951332,
      239.01362975131492446798893533792714879336168509609,
      246.77624096724849045732253704645704530192569180271,
      254.86862925704743027863842226837592454026841223628,
      263.32816846915789310981244461061198767500418420254,
      272.20117002409253682587551568880510333756002327315,
      281.54632828389738879914802558930339720242714802028,
      291.44013361637710726069724339449220378847267906566,
      301.98585525163915366574517831621556837970610886064,
      313.3295340040755243411836472127284809659746476805,
      325.69126343702652000203534998873955161221810012847,
      339.43510192344961653520496673232150915962334632322,
      355.26131188853413247248270949708161897245257424477,
      374.98411283434267870488403679649642050330116428623;
  _map_points[100] = points_100;
}

void Gauss_Laguerre_Quadrature::FillAdaptedWeights() {
  Eigen::VectorXd AdaptedWeights_8(8);
  AdaptedWeights_8 << 0.4377234104929113732325975801238703103376631775236,
      1.033869347665597642499265855827602461954335024897,
      1.6697097656587757491539220177008427856051063662388,
      2.3769247017585994809591690994750058720662557571753,
      3.2085409133479262842483918457600300070144929506379,
      4.268575510825132198584121630659636092804766871837,
      5.81808336867192192828814196198241067161659726355,
      8.906226215292211406501042881028511446149064456402;
  _map_AdaptedWeights[8] = AdaptedWeights_8;
  Eigen::VectorXd AdaptedWeights_10(10);
  AdaptedWeights_10 << 0.354009738606996308762226891442067608352461375232,
      0.8319023010435807381098296581278495772769414887138,
      1.3302885617493281787527921943939936989529079083161,
      1.8630639031111309897639887354824669365659029551084,
      2.4502555580830101660726937316575225674840723086896,
      3.122764155135182496150818263314554723390177279479,
      3.934152695561521098655812459248230777449846058056,
      4.99241487219302310201148565243315445132156715098,
      6.57220248513080297518766871037611234659532162923,
      9.7846958403746306947700866387185981389150975238;
  _map_AdaptedWeights[10] = AdaptedWeights_10;
  Eigen::VectorXd AdaptedWeights_12(12);
  AdaptedWeights_12 << 0.29720963604441079779198122036754357695062747309614,
      0.6964629804305972306780669558553119367200522247323,
      1.1077813946157521533394673801418981284103516456771,
      1.5384642390428291247940386335053805911722249486239,
      1.9983276062742427651969640965367302175914220369978,
      2.5007457691008668747508706633043160797088609808069,
      3.065321518282386236204603418051038424900531165525,
      3.723289110782771599995609779712930189226527287525,
      4.529814029981735062093311912367881036129552807779,
      5.5972584618353210926905239085094747371049317491765,
      7.2129954609258770081711351665202483272292177775714,
      10.543837461910081111715846770154439584665010094888;
  _map_AdaptedWeights[12] = AdaptedWeights_12;
  Eigen::VectorXd AdaptedWeights_14(14);
  AdaptedWeights_14 << 0.25613115473690945367155604137236094757882153053717,
      0.5991704774951183385157662720719434606317389384044,
      0.9499715024749579869125484270936094947507661292047,
      1.3128078114661639384270884248489802423178192160109,
      1.6932659907519653529745410676462360050266873059999,
      2.098409084271843687773502577270101983723504094644,
      2.5376326549353938448820099657512096366218759469362,
      3.0241599177032399386467951716218970800189870315433,
      3.577804355719859916426068792226390777216598510176,
      4.230565034906432048949948938499946279885083169143,
      5.0394133684635116188297693664760942153547229583944,
      6.120947928329725523704405649801959608037466565982,
      7.7742953670060321174893698342712637506928074474584,
      11.21683421670331968972355415696472732866015480776;
  _map_AdaptedWeights[14] = AdaptedWeights_14;
  Eigen::VectorXd AdaptedWeights_16(16);
  AdaptedWeights_16 << 0.2250363148642472519066007573814144458690185247157,
      0.5258360527623424536145694105195410860858136585704,
      0.831961391687087087665388515060005798365531503267,
      1.1460992409637517046479569302568902959453778405277,
      1.471751316966808588743042045866684543762434226604,
      1.813134687381348164887396108630316034513537481787,
      2.1755175196946074520626708322288638779797078925836,
      2.565762750165029209248616884561986932692202919775,
      2.993215086371375165178025151565561897712713600071,
      3.471234483102090290873868627597548190602231270141,
      4.020044086444668866478284115357455952539428504624,
      4.672516607732854267365709256517417593833911905772,
      5.48742065798615247120752800022638302859933708972,
      6.58536123328921366083470226903840093817534637811,
      8.27635798436423448649507548525324886996687288917,
      11.82427755165843478668777351092777039548497478358;
  _map_AdaptedWeights[16] = AdaptedWeights_16;
  Eigen::VectorXd AdaptedWeights_18(18);
  AdaptedWeights_18 << 0.2006779892089060424567117353858677921357410065508,
      0.4685526868918793123451038404723618531476174159314,
      0.7402656826535084821328848952165180073326729046531,
      1.0175917173039668575733601963884569464681833491062,
      1.3028787020654185274613294165010989084158853049221,
      1.598862139757241971464163626319250748097864369331,
      1.908813906969691449405383185790548603253747095167,
      2.236777877856928862808745488037440092537055724348,
      2.587924166792750465265463240542766432247187473213,
      2.969102377726253026889997545139828219911420194409,
      3.389748873854004693214943133356206203447866755699,
      3.863462276042960583502177219572994264901461070218,
      4.4109368969663167872945574616798809600665149029142,
      5.0659315146113905979769671798325064724279803521,
      5.888946263673389544438677676632267647722417256986,
      7.00435926919015216807565159336225208655434075251,
      8.73234485076647154208563069167393633193242434362,
      12.379906492173747450634250720326202919731298778298;
  _map_AdaptedWeights[18] = AdaptedWeights_18;
  Eigen::VectorXd AdaptedWeights_20(20);
  AdaptedWeights_20 << 0.1810800624189892554516754059131106442274690763912,
      0.4225567678785639745203441725664581975475829520687,
      0.6669095467018481503734821149925159278667309548724,
      0.91535237278307367267060468477186806700815510543294,
      1.169539707195545973801478222395774760596840666293,
      1.4313549859282059863684499489151433158764096086852,
      1.7029811379850227240253326163320672029093050496994,
      1.9870158907927472141092183927512902068826472595247,
      2.2866357812534307854622285468149565116091533479661,
      2.605834727553833332694989509540333237056796189593,
      2.949783734213950866002354168272859510783865111907,
      3.325395782009319552369519374217511185662934568037,
      3.742255470589810921117072932653778117460980980766,
      4.214236710251880419868080637824787464513838141909,
      4.7625184614902092969529219783909637106473444797488,
      5.42172604424557430380308297989981779213794759508,
      6.254012356932421292895184903007075421492954607332,
      7.38731438905443455194030019196464791168876917979,
      9.1513287309874796079434824255295052861521913541,
      12.89338864593999667102628712874852788017020483556;
  _map_AdaptedWeights[20] = AdaptedWeights_20;
  Eigen::VectorXd AdaptedWeights_40(40);
  AdaptedWeights_40 << 0.0916254711574598973115116980801374830365200986836,
      0.213420584905012080007193367121512341186179067974,
      0.3357181166802846738805107016162921911147717694494,
      0.458540935033497560385432380376452497081119061553,
      0.582068165779105168990996365401543283733186743579,
      0.706495216367219392989830015673016682193654834516,
      0.832026903003485238099112947978349523568841199324,
      0.958878198794443111448122679676028906726062837454,
      1.087276162030549715753869333172026615810409829194,
      1.217462327977780978954277850665609480465428924915,
      1.349695491356765307923938594423945197288932007748,
      1.484254929776846711205611786129787199493824011776,
      1.621444162811821978023168843164545274346126922021,
      1.761595374676769611184242204209815983710518506098,
      1.905074665894799676682993205972793710682835087884,
      2.052288347261716717601995822729474548137376825858,
      2.203690553245095889098283443281405707821460447477,
      2.359792538523203323540373753789014974182625221262,
      2.52117414037643299165313690287422820905783991025,
      2.688498055408842264159505447063746594807941918888,
      2.86252781321044881203476395983104311306154633077,
      3.044150665311517100410439679543336703973242206997,
      3.23440709726353194177490239428867111728031920006,
      3.434529398427748092203984818916024646916862068008,
      3.645992824994089072389656466994904343809662531182,
      3.87058459721651656808475320213444338362887384907,
      4.110498680432822655835822472639515778885674143888,
      4.368468723254063474508083382729450258024161759933,
      4.647958984074466882993033998838839914922868269628,
      4.953446112409893262186961507855627211243793964933,
      5.29084840590073657468737365718858968797061461384,
      5.6682046090329767700073052902326379530552220105,
      6.09679641474342030593376010859198806113486222265,
      6.5931088610399995379442966420629489948229766364,
      7.18249599553689315064429801626699574805948127705,
      7.90666631138422877369310742310586595207240931369,
      8.8408924928103465207912559506302679230302350146,
      10.140899265621169483909460030694046881974765591424,
      12.2100212992046038985226485875881108283678273395,
      16.7055206420242974052468774398573553754649199408;
  _map_AdaptedWeights[40] = AdaptedWeights_40;
  Eigen::VectorXd AdaptedWeights_100(100);
  AdaptedWeights_100 << 0.036919939314547993881411785214888485896408070178,
      0.085951345725921354135990924868356400493487728672,
      0.135076347286164061380903423701488222323509920067,
      0.18424069956500730763515611045153438123420901536,
      0.233451446141280421726906433541098297782059647888,
      0.28271984378164452166765828810799230979069262623,
      0.332057878360216896843505523780141522959956311767,
      0.381477785290452047783996464882101347652677523895,
      0.4309919593063252143972900109238281606554216676206,
      0.480612941774710562374542466481313693916004476049,
      0.530353428454059705976212135958878058886203752295,
      0.580226284010330321332297246994356768853677882931,
      0.63024455934702059951914237468401709830071704533,
      0.68042151046961384158215799299580215089372074938,
      0.730770618450149419897166429251690351648882034684,
      0.781305610360941494961702615201237067787428097553,
      0.832040481168061617092076323421497989838424916826,
      0.882989516630006835954003431788219599674293552765,
      0.934167317275462090638034483929486051066217574924,
      0.985588823551736637706762160364386467486652955625,
      1.0372693422487070230494163082479985350150057702521,
      1.089224574314770659472812292635101126468618318508,
      1.141470644192765260846350193420878561006121196887,
      1.194024130815760643630623389727696108291878550321,
      1.246902100415515737648505971195490501063080698034,
      1.300122141310523765763021097644413083208941452559,
      1.353702400856200406404346064734008611910072522262,
      1.407661624757148877662670634449416711756276873725,
      1.462019198960816763259891977082157114019744626717,
      1.516795194373519038111937959022904946132806912385,
      1.57201041466404978255907267231170589495260804105,
      1.6276864474472926795735582160956270956033979368468,
      1.683845719170769181037062706048741254899306968308,
      1.74051155406139488512397405993551058588800738583,
      1.79770823752838185465489271776462776700539093959,
      1.85546108446184368636142438074010649734772712993,
      1.913796512915946137866124553334737389568205110832,
      1.9727421237212305102695270688534115024955631232,
      2.03232678663398894964699721426813759067704816851,
      2.092580733702422741127790667525935681511769901181,
      2.153535660611092763626554412553049029424553589998,
      2.21522483685843270335206736771632828878904007948,
      2.277683225728673326560951980410239299471364901114,
      2.34094761514158333504710567029468641076319619039,
      2.40505676060352910278329872190109014853553100971,
      2.47005154164453003175936905334214490878499684225,
      2.535975133311854335028037539441752220500758674359,
      2.602873194505578443435540234848129523033281189732,
      2.67079407519059121350487787156041193967117731043,
      2.73978904480897194900172018389199775325192879835,
      2.809912544553994824809190226076611155801321069926,
      2.88122246656126652759829186429290041522720167509,
      2.953780463534681133761979169028734526486376056522,
      3.02765229286837076391544591428890651083221240119,
      3.10290819996702722873408871139926032371457466251,
      3.179623346225993050324893810613027585606588759611,
      3.257878288034191592106495855475619784103229735143,
      3.33775951423803577760395212328103289475657186609,
      3.419360050791192654002128918178660903797399824829,
      3.50278014286134288006695937350393743001467680905,
      3.58812802653100352895504815759839456814914074701,
      3.67552080449106105248863502792598863378447655371,
      3.76508544287940603301012089832773991633022777601,
      3.85695990978628010269605292991101785239883526691,
      3.95129448009112296084307036672160806471066926881,
      4.0482532364178323226774084353033824824584795888,
      4.148015802363327800283217965659424505144203627,
      4.25077935211810823679244285911473002867150328221,
      4.35676095061938881015332624766758181161075110746,
      4.4662002910728123140682652081693688026931978903,
      4.5793629128737134860710534049674256082614409809,
      4.69654400377203816014949848028435319129961819588,
      4.818072917085036874367185628110070458006756218799,
      4.9443185699788779059690863394992470599680683382,
      5.07569593525772318594608473360804631585257908599,
      5.2126739008686592812700632612806578879833718487,
      5.3557848543812506505899489634111827300758848891,
      5.50563646260515840395904881800378313745499826371,
      5.66292627184206617136093917590945315654921401784,
      5.8284599707478626267550272499964217588615910285,
      6.0031744637308038046675056588524992684773765788,
      6.1881673418494502515482985241631252441776326098,
      6.38473497877833257922556337937364859708426786636,
      6.59442243137378965949994484175831143637091800474,
      6.8190897678626761187705731803546190954400691021,
      7.0610016850025108248539626653847334668443258116,
      7.3229508340958450093743595039249411445506666067,
      7.6084310939560134731201323844713799936804871328,
      7.9218868481886084532598211126972930825882055048,
      8.26908150662496626475912882963165557215374477667,
      8.6576598589739272079300448307223675419606791724,
      9.0980388945229258193407011282410192762091851171,
      9.6048835568654946122141762477038050760639011679483,
      10.1996888715856386588309545606214683570029238436,
      10.9156175227240176758109193524478890157747729336,
      11.8073985027212477121628818445333081213822488404,
      12.9741341509108123920094390653061654897178622626,
      14.6215810644517865930437346381411571489579913595,
      17.2847396480859001324847059640491782072314462628,
      23.1715523384710306176727561011713184686190876643;
  _map_AdaptedWeights[100] = AdaptedWeights_100;
}
}  // namespace xtp
}  // namespace votca
