from viper import Viper
import numpy

coords2d = numpy.array([[0.0,0.0,0.0],
                        [1.0,0.0,0.0],
                        [0.0,1.0,0.0],
                        [1.0,1.0,0.0],
                        [2.0,0.0,0.0],
                        [0.0,2.0,0.0],
                        [2.0,1.0,0.0],
                        [1.0,2.0,0.0],
                        [2.0,2.0,0.0]])

triangles = numpy.array([[0,1,2],[1,2,3],[1,4,3],[4,3,6],[2,3,5],
                        [3,5,7],[3,6,7],[6,7,8]], dtype='i')


x = numpy.linspace(0,1,len(coords2d))
v = Viper(x=x, coordinates=coords2d, cells=triangles)
v.init_writer(".tmp")
for i in xrange(50):
    v.azimuth(2)
    v.update()
    v.write_png()
v.movie("movie.avi", cleanup=True)



