/***************************************************************************
           publichubsmodel.cpp  -  Public Hubs Model implementation
                             -------------------
    begin                : Mon Nov 5 2007
    copyright            : (C) 2007 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "publichubsmodel.h"

// for byte size strings
#include "dcguiutils.h"

/** Sets values */
PublicHubItem::PublicHubItem( const QString n, const QString addr, const QString desc, const ulonglong u, const QString c, const ulonglong s, const ulonglong ms, const QString e )
{
	name = n;
	server = addr;
	description = desc;
	users = u;
	country = c;
	shared = s;
	minshare = ms;
	extra = e;
}

/** */
PublicHubItem::~PublicHubItem()
{

}

/** */
PublicHubsModel::PublicHubsModel( QObject * parent ) : QAbstractItemModel( parent )
{
	/* nothing */
}

/** delete all items in model */
PublicHubsModel::~PublicHubsModel()
{
	clear();
}

/** */
int PublicHubsModel::rowCount( const QModelIndex & /* index */ ) const
{
	return itemList.size();
}

/** */
int PublicHubsModel::columnCount( const QModelIndex & /* index */ ) const
{
	return 8;
}

/** */
QVariant PublicHubsModel::data( const QModelIndex & index, int role ) const
{
	if ( !index.isValid() )
	{
		return QVariant();
	}
	
	PublicHubItem * item = itemList[index.row()];
	
	if ( item != 0 )
	{
		if ( role == Qt::DisplayRole )
		{
			switch ( index.column() )
			{
				case 0:	return item->name;
				case 1: return item->server;
				case 2: return item->description;
				case 3: return item->users;
				case 4: return item->country;
				case 5: return DCGuiUtils::GetSizeString( item->shared );
				case 6: return DCGuiUtils::GetSizeString( item->minshare );
				case 7: return item->extra;
				default: return QVariant();
			}
		}
		else if ( role == PublicHubsProxyRole )
		{
			switch ( index.column() )
			{
				case 0: return item->name;
				case 1: return item->server;
				case 2: return item->description;
				case 3: return item->users;
				case 4: return item->country;
				case 5: return item->shared;
				case 6: return item->minshare;
				case 7: return item->extra;
				default: return QVariant();
			}
		}
		else if ( role == Qt::ToolTipRole ) // tooltip
		{
			if ( index.column() == 5 )
			{
				return QString().setNum(item->shared);
			}
			else if ( index.column() == 6 )
			{
				return QString().setNum(item->minshare);
			}
			else
			{
				return data( index, Qt::DisplayRole );
			}
		}
		else if ( role == Qt::TextAlignmentRole )
		{
			if ( (index.column() == 3) || (index.column() == 5) || (index.column() == 6) )
			{
				return Qt::AlignRight;
			}
		}
	}
	
	return QVariant();
}

/** */
QVariant PublicHubsModel::headerData( int section, Qt::Orientation orientation, int role ) const
{
	if ( (orientation == Qt::Horizontal) && (role == Qt::DisplayRole) )
	{
		switch ( section )
		{
			case 0:	return tr("Name");
			case 1: return tr("Server");
			case 2: return tr("Description");
			case 3: return tr("Users");
			case 4: return tr("Country");
			case 5: return tr("Shared");
			case 6: return tr("Minimum share");
			case 7: return tr("Extra");
		}
	}
	
	return QVariant();
}

/** */
QModelIndex PublicHubsModel::index( int row, int column, const QModelIndex & parent ) const
{
	if ( !hasIndex( row, column, parent ) )
	{
		return QModelIndex();
	}
	
	return createIndex( row, column );
}

/** */
QModelIndex PublicHubsModel::parent( const QModelIndex & /* parent */ ) const
{
	return QModelIndex();
}

/** add hub */
void PublicHubsModel::addHub( const QString name, const QString address, const QString desc, const ulonglong users, const QString country, const ulonglong shared, const ulonglong minshare, const QString extra )
{
	itemList.append( new PublicHubItem( name, address, desc, users, country, shared, minshare, extra ) );
}

/** delete all hubs */
void PublicHubsModel::clear()
{
	emit layoutAboutToBeChanged();

	QList<PublicHubItem*> tmp = itemList;
	itemList.clear();
	
	for ( QList<PublicHubItem*>::const_iterator it = tmp.constBegin(); it != tmp.constEnd(); ++it )
	{
		delete *it;
	}
	
	emit layoutChanged();
}

/** delete a hub */
bool PublicHubsModel::deleteHub( PublicHubItem * hub )
{
	bool res = false;
	
	emit layoutAboutToBeChanged();
	
	int index = itemList.indexOf(hub);
	if ( index != -1 )
	{
		itemList.removeAt(index);
		delete hub;
		emit layoutChanged();
		res = true;
	}
	
	return res;
}

/** */
QList<PublicHubItem*> PublicHubsModel::getAll()
{
	return itemList;
}

/** */
PublicHubItem * PublicHubsModel::getItem( const QModelIndex & index )
{
	if ( index.isValid() && (index.row() >= 0) && (index.row() < itemList.size()) )
	{
		return itemList.at( index.row() );
	}
	
	return 0;
}
