/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       AMTPPSharedData.h
//
//  Notes:      Definition of Class AMTPPSharedData used to read/write Posture
//              Plugin values from/to the registry (or another shared resource
//              in other OS's).
//
//----------------------------------------------------------------------------

#ifndef _AMT_PP_SHARED_DATA_H_
#define _AMT_PP_SHARED_DATA_H_

#include "registryWrapper.h"

class AMTPPSharedData {
public:
	//*********************************************
	//AMTPPSharedData:
	//Ctor to AMTPPSharedData object
	//params:
	//@name - name of shared data object
	//*********************************************
	AMTPPSharedData(const char * name, bool bOwner = false, bool bPublic = false);

	//*********************************************
	//~AMTPPSharedData:
	//Dtor to AMTPPSharedData object
	//*********************************************
	~AMTPPSharedData();

	//*********************************************
	//Read:
	//will read the PPRegKey to buff, buff must be large enough to receive
	//the PPRegKey if length is smaller than the value to be read the function
	//will fail and length will contain the length needed
	//params:
	//@buff - buffer to read data to
	//@length - length of buffer
	//@decrypt - true to decrypt data, false otherwise
	//*********************************************
	bool Read(unsigned char * buff,unsigned int &length, bool decrypt);

	//*********************************************
	//Write:
	//will write the buff to the PPRegKey
	//params:
	//@buff - buffer to write
	//@length - length of buffer
	//@encrypt - true to encrypt data, false otherwise
	//*********************************************
	bool Write(const unsigned char* buff,unsigned int length, bool encrypt);

	//*********************************************
	//Remove:
	//will remove the key from the registry
	//*********************************************
	bool Remove();

	//*********************************************
	//ReleaseOwnership:
	//Release ownership of the shared data by this instance, causing the data to
	//not be removed automatically upon instance destruction.
	//*********************************************
	void ReleaseOwnership();

	//*********************************************
	//LastError:
	//will return the last error
	//*********************************************
	int LastError();

private:
	const char * _name;		//registry data
	int    _lastError;	//last error
	bool m_bOwner; //Should the data be removed by this instance
	bool m_bPublic; //Public data (give read access to every user)
};

#endif
