/*********************************************************************
 *
 * Written by Nick Gorham
 * (nick@lurcher.org).
 *
 * copyright (c) 1999 Nick Gorham
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 **********************************************************************
 * 
 * 2008-12-10   Code adopted by unixODBC-GUI-Qt project. Heavily altered
 * pharvey      to be Qt4 only code.
 * 
 **********************************************************************/

#include "attr.h"
#include "OdbcTest.h"

static attr_value strlen_options[] = 
{
    { "SQL_NTS",            SQL_NTS,            NULL,   0 },
    { "SQL_IS_POINTER",     SQL_IS_POINTER,     NULL,   0 },
    { "SQL_IS_UINTEGER",    SQL_IS_UINTEGER,    NULL,   0 },
    { "SQL_IS_INTEGER",     SQL_IS_INTEGER,     NULL,   0 },
    { "SQL_IS_USMALLINT",   SQL_IS_USMALLINT,   NULL,   0 },
    { "SQL_IS_SMALLINT",    SQL_IS_SMALLINT,    NULL,   0 },
    { "",                   0,                  NULL,   0 },
    { NULL,                 0,                  NULL,   0 }
};

static attr_options stmt_options[] = 
{
    {   
        "SQL_ATTR_APP_PARAM_DESC", SQL_ATTR_APP_PARAM_DESC, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },

    {   
        "SQL_ATTR_APP_ROW_DESC", SQL_ATTR_APP_ROW_DESC, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_ASYNC_ENABLE", SQL_ATTR_ASYNC_ENABLE, 
        {
            { "SQL_ASYNC_ENABLE_OFF",   SQL_ASYNC_ENABLE_OFF,   NULL, 0 }, 
            { "SQL_ASYNC_ENABLE_ON",    SQL_ASYNC_ENABLE_ON,    NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, 
        "1.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_CONCURRENCY", SQL_ATTR_CONCURRENCY, 
        {
            { "SQL_CONCUR_READ_ONLY",   SQL_CONCUR_READ_ONLY,   NULL, 0 },
            { "SQL_CONCUR_LOCK",        SQL_CONCUR_LOCK,        NULL, 0 }, 
            { "SQL_CONCUR_ROWVER",      SQL_CONCUR_ROWVER,      NULL, 0 }, 
            { "SQL_CONCUR_VALUES",      SQL_CONCUR_VALUES,      NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, 
        "2.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_CURSOR_SCROLLABLE", SQL_ATTR_CURSOR_SCROLLABLE, 
        {
            { "SQL_NONSCROLLABLE",      SQL_NONSCROLLABLE,      NULL, 0 }, 
            { "SQL_SCROLLABLE",         SQL_SCROLLABLE,         NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_CURSOR_SENSITIVITY", SQL_ATTR_CURSOR_SENSITIVITY, 
        {
            { "SQL_UNSPECIFIED",        SQL_UNSPECIFIED,        NULL, 0 }, 
            { "SQL_INSENSITIVE",        SQL_INSENSITIVE,        NULL, 0 },
            { "SQL_SENSITIVE",          SQL_SENSITIVE,          NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_CURSOR_TYPE", SQL_ATTR_CURSOR_TYPE, 
        {
            { "SQL_CURSOR_FORWARD_ONLY",        SQL_CURSOR_FORWARD_ONLY,        NULL, 0 }, 
            { "SQL_CURSOR_STATIC",              SQL_CURSOR_STATIC,              NULL, 0 }, 
            { "SQL_CURSOR_KEYSET_DRIVEN",       SQL_CURSOR_KEYSET_DRIVEN,       NULL, 0 },
            { "SQL_CURSOR_DYNAMIC",             SQL_CURSOR_DYNAMIC,             NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, 
        "2.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_ENABLE_AUTO_IPD", SQL_ATTR_ENABLE_AUTO_IPD, 
        {
            { "SQL_FALSE",      SQL_FALSE,      NULL, 0 }, 
            { "SQL_TRUE",       SQL_TRUE,       NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_FETCH_BOOKMARK_PTR", SQL_ATTR_FETCH_BOOKMARK_PTR, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, FALSE, TRUE
    },
    { 
        "SQL_ATTR_FETCH_IMP_PARAM_DESC", SQL_ATTR_IMP_PARAM_DESC, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_FETCH_IMP_ROW_DESC", SQL_ATTR_IMP_ROW_DESC, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_KEYSET_SIZE", SQL_ATTR_KEYSET_SIZE, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "2.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_MAX_LENGTH", SQL_ATTR_MAX_LENGTH, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "1.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_MAX_ROWS", SQL_ATTR_MAX_ROWS, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "1.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_METADATA_ID", SQL_ATTR_METADATA_ID, 
        {
            { "SQL_FALSE",      SQL_FALSE,      NULL, 0 }, 
            { "SQL_TRUE",       SQL_TRUE,       NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_NOSCAN", SQL_ATTR_NOSCAN, 
        {
            { "SQL_NOSCAN_OFF", SQL_NOSCAN_OFF, NULL, 0 }, 
            { "SQL_NOSCAN_ON",  SQL_NOSCAN_ON,  NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, 
        "1.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_PARAM_BIND_OFFSET_PTR", SQL_ATTR_PARAM_BIND_OFFSET_PTR, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, FALSE, TRUE
    },
    { 
        "SQL_ATTR_PARAM_BIND_TYPE", SQL_ATTR_PARAM_BIND_TYPE, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_PARAM_OPERATION_PTR", SQL_ATTR_PARAM_OPERATION_PTR, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_SMALLINT, FALSE, TRUE
    },
    { 
        "SQL_ATTR_PARAM_STATUS_PTR", SQL_ATTR_PARAM_STATUS_PTR, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_SMALLINT, FALSE, TRUE
    },
    { 
        "SQL_ATTR_PARAMS_PROCESSED_PTR", SQL_ATTR_PARAMS_PROCESSED_PTR, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_SMALLINT, FALSE, TRUE
    },
    { 
        "SQL_ATTR_PARAMSET_SIZE", SQL_ATTR_PARAMSET_SIZE, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_QUERY_TIMEOUT", SQL_ATTR_QUERY_TIMEOUT, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_RETRIEVE_DATA", SQL_ATTR_RETRIEVE_DATA, 
        {
            { "SQL_RD_ON",      SQL_RD_ON,      NULL, 0 }, 
            { "SQL_RD_OFF",     SQL_RD_OFF,     NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, 
        "2.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_ROW_ARRAY_SIZE", SQL_ATTR_ROW_ARRAY_SIZE, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_ROW_BIND_OFFSET_PTR", SQL_ATTR_ROW_BIND_OFFSET_PTR, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, FALSE, TRUE
    },
    { 
        "SQL_ATTR_ROW_BIND_TYPE", SQL_ATTR_ROW_BIND_TYPE, 
        {
            { "SQL_BIND_BY_COLUMN", SQL_BIND_BY_COLUMN, NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, 
        "1.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_ROW_NUMBER", SQL_ATTR_ROW_NUMBER, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "2.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_ROW_OPERATION_PTR", SQL_ATTR_ROW_OPERATION_PTR, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_SMALLINT, FALSE, TRUE
    },
    { 
        "SQL_ATTR_ROW_STATUS_PTR", SQL_ATTR_ROW_STATUS_PTR,
        {
            { NULL, 0, NULL, 0 }
        }, "3.0", SQL_SMALLINT, FALSE, TRUE
    },
    { 
        "SQL_ATTR_ROWS_FETCHED_PTR", SQL_ATTR_ROWS_FETCHED_PTR, 
        {
            { NULL, 0, NULL, 0 }
        }, 
        "3.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_SIMULATE_CURSOR", SQL_ATTR_SIMULATE_CURSOR, 
        {
            { "SQL_SC_NON_UNIQUE",      SQL_SC_NON_UNIQUE,      NULL, 0 },
            { "SQL_SC_TRY_UNIQUE",      SQL_SC_TRY_UNIQUE,      NULL, 0 },
            { "SQL_SC_UNIQUE",          SQL_SC_UNIQUE,          NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, 
        "2.0", SQL_INTEGER, 0, 0
    },
    { 
        "SQL_ATTR_USE_BOOKMARKS", SQL_ATTR_USE_BOOKMARKS,
        {
            { "SQL_UB_ON",              SQL_UB_ON,      NULL, 0 }, 
            { "SQL_UB_OFF",             SQL_UB_OFF,     NULL, 0 }, 
            { "SQL_UB_VARIABLE",        SQL_UB_VARIABLE,NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, 
        "2.0", SQL_INTEGER, 0, 0
    },
    { NULL, 0, { { NULL, 0, NULL, 0 } }, NULL, 0, 0, 0 }
};

static attr_options stmt_opt_options[] = 
{
    { "SQL_ASYNC_ENABLE", SQL_ASYNC_ENABLE, 
        {
            { "SQL_ASYNC_ENABLE_OFF",   SQL_ASYNC_ENABLE_OFF,   NULL, 0 },
            { "SQL_ASYNC_ENABLE_ON",    SQL_ASYNC_ENABLE_ON,    NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_BIND_TYPE", SQL_BIND_TYPE, 
        {
            { "SQL_BIND_BY_COLUMN",     SQL_BIND_BY_COLUMN,     NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_CONCURRENCY", SQL_CONCURRENCY, 
        {
            { "SQL_CONCUR_READ_ONLY",   SQL_CONCUR_READ_ONLY,   NULL, 0 },
            { "SQL_CONCUR_LOCK",        SQL_CONCUR_LOCK,        NULL, 0 },
            { "SQL_CONCUR_ROWVER",      SQL_CONCUR_ROWVER,      NULL, 0 },
            { "SQL_CONCUR_VALUES",      SQL_CONCUR_VALUES,      NULL, 0 }, 
            { "SQL_CONCUR_READ_ONLY",   SQL_CONCUR_READ_ONLY,   NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_CURSOR_TYPE", SQL_CURSOR_TYPE, 
        {
            { "SQL_CURSOR_FORWARD_ONLY",        SQL_CURSOR_FORWARD_ONLY,        NULL, 0 },
            { "SQL_CURSOR_STATIC",              SQL_CURSOR_STATIC,              NULL, 0 },
            { "SQL_CURSOR_KEYSET_DRIVEN",       SQL_CURSOR_KEYSET_DRIVEN,       NULL, 0 }, 
            { "SQL_CURSOR_DYNAMIC",             SQL_CURSOR_DYNAMIC,             NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_KEYSET_SIZE", SQL_KEYSET_SIZE, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_MAX_LENGTH", SQL_MAX_LENGTH, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_MAX_ROWS", SQL_MAX_ROWS, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_NOSCAN", SQL_NOSCAN, 
        {
            { "SQL_NOSCAN_OFF",         SQL_NOSCAN_OFF, NULL, 0 }, 
            { "SQL_NOSCAN_ON",          SQL_NOSCAN_ON,  NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_QUERY_TIMEOUT", SQL_QUERY_TIMEOUT, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_RETRIEVE_DATA", SQL_RETRIEVE_DATA, 
        {
            { "SQL_RD_ON",      SQL_RD_ON,      NULL, 0 }, 
            { "SQL_RD_OFF",     SQL_RD_OFF,     NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ROWSET_SIZE", SQL_ROWSET_SIZE, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_SIMULATE_CURSOR", SQL_SIMULATE_CURSOR, 
        {
            { "SQL_SC_NON_UNIQUE",      SQL_SC_NON_UNIQUE,      NULL, 0 }, 
            { "SQL_SC_TRY_UNIQUE",      SQL_SC_TRY_UNIQUE,      NULL, 0 }, 
            { "SQL_SC_UNIQUE",          SQL_SC_UNIQUE,          NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_USE_BOOKMARKS", SQL_USE_BOOKMARKS, 
        {
            { "SQL_UB_ON",              SQL_UB_ON,              NULL, 0 }, 
            { "SQL_UB_OFF",             SQL_UB_OFF,             NULL, 0 }, 
            { "SQL_UB_VARIABLE",        SQL_UB_VARIABLE,        NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { NULL, 0, { { NULL, 0, NULL, 0 } }, NULL, 0, 0, 0 }
};

static attr_options conn_options[] = 
{
    { "SQL_ATTR_ACCESS_MODE", SQL_ATTR_ACCESS_MODE, 
        {
            { "SQL_MODE_READ_WRITE",    SQL_MODE_READ_WRITE,    NULL, 0 }, 
            { "SQL_MODE_READ_ONLY",     SQL_MODE_READ_ONLY,     NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_ASYNC_ENABLE", SQL_ATTR_ASYNC_ENABLE, 
        {
            { "SQL_ASYNC_ENABLE_OFF",   SQL_ASYNC_ENABLE_OFF,   NULL, 0 }, 
            { "SQL_ASYNC_ENABLE_ON",    SQL_ASYNC_ENABLE_ON,    NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "3.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_AUTO_IPD", SQL_ATTR_AUTO_IPD, 
        {
            { "SQL_TRUE",       SQL_TRUE,       NULL, 0 }, 
            { "SQL_FALSE",      SQL_FALSE,      NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "3.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_AUTOCOMMIT", SQL_ATTR_AUTOCOMMIT, 
        {
            { "SQL_AUTOCOMMIT_ON",      SQL_AUTOCOMMIT_ON,      NULL, 0 }, 
            { "SQL_AUTOCOMMIT_OFF",     SQL_AUTOCOMMIT_OFF,     NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_CONNECTION_TIMEOUT", SQL_ATTR_CONNECTION_TIMEOUT, 
        {
            { NULL, 0, NULL, 0 }
        }, "3.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_CURRENT_CATALOG", SQL_ATTR_CURRENT_CATALOG, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_CHAR, 0, 0
    },
    { "SQL_ATTR_LOGIN_TIMEOUT", SQL_ATTR_LOGIN_TIMEOUT, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_METADATA_ID", SQL_ATTR_METADATA_ID, 
        {
            { "SQL_TRUE",       SQL_TRUE,       NULL, 0 }, 
            { "SQL_FALSE",      SQL_FALSE,      NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "3.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_ODBC_CURSORS", SQL_ATTR_ODBC_CURSORS, 
        {
            { "SQL_CUR_USE_IF_NEEDED",  SQL_CUR_USE_IF_NEEDED,  NULL, 0 }, 
            { "SQL_CUR_USE_ODBC",       SQL_CUR_USE_ODBC,       NULL, 0 }, 
            { "SQL_CUR_USE_DRIVER",     SQL_CUR_USE_DRIVER,     NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_PACKET_SIZE", SQL_ATTR_PACKET_SIZE, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_QUIET_MODE", SQL_ATTR_QUIET_MODE, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_TRACE", SQL_ATTR_TRACE, 
        {
            { "SQL_OPT_TRACE_OFF",      SQL_OPT_TRACE_OFF,      NULL, 0 }, 
            { "SQL_OPT_TRACE_ON",       SQL_OPT_TRACE_ON,       NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_TRACEFILE", SQL_ATTR_TRACEFILE, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_CHAR, 0, 0
    },
    { "SQL_ATTR_TRANSLATE_LIB", SQL_ATTR_TRANSLATE_LIB, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_CHAR, 0, 0
    },
    { "SQL_ATTR_TRANSLATE_OPTION", SQL_ATTR_TRANSLATE_OPTION, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_TXN_ISOLATION", SQL_ATTR_TXN_ISOLATION, 
        {
            { "SQL_TXN_READ_UNCOMMITTED",       SQL_TXN_READ_UNCOMMITTED,       NULL, 0 },
            { "SQL_TXN_READ_COMMITTED",         SQL_TXN_READ_COMMITTED,         NULL, 0 },
            { "SQL_TXN_REPEATABLE_READ",        SQL_TXN_REPEATABLE_READ,        NULL, 0 },
            { "SQL_TXN_SERIALIZABLE",           SQL_TXN_SERIALIZABLE,           NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { NULL, 0, { { NULL, 0, NULL, 0 } }, NULL, 0, 0, 0 }
};

static attr_options conn_opt_options[] = 
{
    { "conn: SQL_ACCESS_MODE", SQL_ACCESS_MODE, 
        {
            { "SQL_MODE_READ_ONLY",     SQL_MODE_READ_ONLY,     NULL, 0 }, 
            { "SQL_MODE_READ_WRITE",    SQL_MODE_READ_WRITE,    NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "conn: SQL_AUTOCOMMIT", SQL_AUTOCOMMIT, 
        {
            { "SQL_AUTOCOMMIT_ON",      SQL_AUTOCOMMIT_ON,      NULL, 0 }, 
            { "SQL_AUTOCOMMIT_OFF",     SQL_AUTOCOMMIT_OFF,     NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "conn: SQL_CURRENT_QUALIFIER", SQL_CURRENT_QUALIFIER, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_CHAR, 0, 0
    },
    { "conn: SQL_LOGIN_TIMEOUT", SQL_LOGIN_TIMEOUT, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "conn: SQL_ODBC_CURSORS", SQL_ODBC_CURSORS, 
        {
            { "SQL_CUR_USE_IF_NEEDED",  SQL_CUR_USE_IF_NEEDED,  NULL, 0 }, 
            { "SQL_CUR_USE_ODBC",       SQL_CUR_USE_ODBC,       NULL, 0 },
            { "SQL_CUR_USE_DRIVER",     SQL_CUR_USE_DRIVER,     NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "conn: SQL_OPT_TRACE", SQL_OPT_TRACE, 
        {
            { "SQL_OPT_TRACE_ON",       SQL_OPT_TRACE_ON,       NULL, 0 }, 
            { "SQL_OPT_TRACE_OFF",      SQL_OPT_TRACE_OFF,      NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "conn: SQL_OPT_TRACEFILE", SQL_OPT_TRACEFILE, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_CHAR, 0, 0
    },
    { "conn: SQL_PACKET_SIZE", SQL_PACKET_SIZE, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "conn: SQL_QUIET_MODE", SQL_QUIET_MODE, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "conn: SQL_TRANSLATE_DLL", SQL_TRANSLATE_DLL, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_CHAR, 0, 0
    },
    { "conn: SQL_TRANSLATE_OPTION", SQL_TRANSLATE_OPTION, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "conn: SQL_TXN_ISOLATION", SQL_TXN_ISOLATION, 
        {
            { "SQL_TXN_READ_UNCOMMITED",        SQL_TXN_READ_UNCOMMITTED,       NULL, 0 }, 
            { "SQL_TXN_READ_COMMITED",          SQL_TXN_READ_COMMITTED,         NULL, 0 }, 
            { "SQL_TXN_REPEATABLE_READ",        SQL_TXN_REPEATABLE_READ,        NULL, 0 }, 
            { "SQL_TXN_SERIALIZABLE",           SQL_TXN_SERIALIZABLE,           NULL, 0 }, 
            { "SQL_TXN_VERSIONING",             0x00000010L,                    NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_ASYNC_ENABLE", SQL_ASYNC_ENABLE, 
        {
            { "SQL_ASYNC_ENABLE_OFF",   SQL_ASYNC_ENABLE_OFF,   NULL, 0 }, 
            { "SQL_ASYNC_ENABLE_ON",    SQL_ASYNC_ENABLE_ON,    NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_BIND_TYPE", SQL_BIND_TYPE, 
        {
            { "SQL_BIND_BY_COLUMN", SQL_BIND_BY_COLUMN, NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_CONCURRENCY", SQL_CONCURRENCY, 
        {
            { "SQL_CONCUR_READ_ONLY",   SQL_CONCUR_READ_ONLY,   NULL, 0 },
            { "SQL_CONCUR_LOCK",        SQL_CONCUR_LOCK,        NULL, 0 }, 
            { "SQL_CONCUR_ROWVER",      SQL_CONCUR_ROWVER,      NULL, 0 }, 
            { "SQL_CONCUR_VALUES",      SQL_CONCUR_VALUES,      NULL, 0 }, 
            { "SQL_CONCUR_READ_ONLY",   SQL_CONCUR_READ_ONLY,   NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_CURSOR_TYPE", SQL_CURSOR_TYPE, 
        {
            { "SQL_CURSOR_FORWARD_ONLY",        SQL_CURSOR_FORWARD_ONLY,        NULL, 0 }, 
            { "SQL_CURSOR_STATIC",              SQL_CURSOR_STATIC,              NULL, 0 }, 
            { "SQL_CURSOR_KEYSET_DRIVEN",       SQL_CURSOR_KEYSET_DRIVEN,       NULL, 0 }, 
            { "SQL_CURSOR_DYNAMIC",             SQL_CURSOR_DYNAMIC,             NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_KEYSET_SIZE", SQL_KEYSET_SIZE, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_MAX_LENGTH", SQL_MAX_LENGTH, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_MAX_ROWS", SQL_MAX_ROWS, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_NOSCAN", SQL_NOSCAN, 
        {
            { "SQL_NOSCAN_OFF", SQL_NOSCAN_OFF, NULL, 0 }, 
            { "SQL_NOSCAN_ON",  SQL_NOSCAN_ON,  NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_QUERY_TIMEOUT", SQL_QUERY_TIMEOUT, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_RETRIEVE_DATA", SQL_RETRIEVE_DATA, 
        {
            { "SQL_RD_ON",      SQL_RD_ON,      NULL, 0 }, 
            { "SQL_RD_OFF",     SQL_RD_OFF,     NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_ROWSET_SIZE", SQL_ROWSET_SIZE, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_SIMULATE_CURSOR", SQL_SIMULATE_CURSOR, 
        {
            { "SQL_SC_NON_UNIQUE",      SQL_SC_NON_UNIQUE,      NULL, 0 }, 
            { "SQL_SC_TRY_UNIQUE",      SQL_SC_TRY_UNIQUE,      NULL, 0 }, 
            { "SQL_SC_UNIQUE",          SQL_SC_UNIQUE,          NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "stmt: SQL_USE_BOOKMARKS", SQL_USE_BOOKMARKS, 
        {
            { "SQL_UB_ON",      SQL_UB_ON,      NULL, 0 }, 
            { "SQL_UB_OFF",     SQL_UB_OFF,     NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { NULL, 0, { { NULL, 0, NULL, 0 } }, NULL, 0, 0, 0 }
};

static attr_options conn_gopt_options[] = 
{
    { "SQL_ACCESS_MODE", SQL_ACCESS_MODE, 
        {
            { "SQL_MODE_READ_ONLY",     SQL_MODE_READ_ONLY,     NULL, 0 }, 
            { "SQL_MODE_READ_WRITE",    SQL_MODE_READ_WRITE,    NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_AUTOCOMMIT", SQL_AUTOCOMMIT, 
        {
            { "SQL_AUTOCOMMIT_ON",      SQL_AUTOCOMMIT_ON,      NULL, 0 }, 
            { "SQL_AUTOCOMMIT_OFF",     SQL_AUTOCOMMIT_OFF,     NULL, 0 }, 
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_CURRENT_QUALIFIER", SQL_CURRENT_QUALIFIER, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_CHAR, 0, 0
    },
    { "SQL_LOGIN_TIMEOUT", SQL_LOGIN_TIMEOUT, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ODBC_CURSORS", SQL_ODBC_CURSORS, 
        {
            { "SQL_CUR_USE_IF_NEEDED",  SQL_CUR_USE_IF_NEEDED,  NULL, 0 }, 
            { "SQL_CUR_USE_ODBC",       SQL_CUR_USE_ODBC,       NULL, 0 }, 
            { "SQL_CUR_USE_DRIVER",     SQL_CUR_USE_DRIVER,     NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_OPT_TRACE", SQL_OPT_TRACE, 
        {
            { "SQL_OPT_TRACE_ON",       SQL_OPT_TRACE_ON,       NULL, 0 }, 
            { "SQL_OPT_TRACE_OFF",      SQL_OPT_TRACE_OFF,      NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_OPT_TRACEFILE", SQL_OPT_TRACEFILE, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_CHAR, 0, 0
    },
    { "SQL_PACKET_SIZE", SQL_PACKET_SIZE, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_QUIET_MODE", SQL_QUIET_MODE, 
        {
            { NULL, 0, NULL, 0 }
        }, "2.0", SQL_INTEGER, 0, 0
    },
    { "SQL_TRANSLATE_DLL", SQL_TRANSLATE_DLL, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_CHAR, 0, 0
    },
    { "SQL_TRANSLATE_OPTION", SQL_TRANSLATE_OPTION, 
        {
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { "SQL_TXN_ISOLATION", SQL_TXN_ISOLATION, 
        {
            { "SQL_TXN_READ_UNCOMMITED",        SQL_TXN_READ_UNCOMMITTED,       NULL, 0 }, 
            { "SQL_TXN_READ_COMMITED",          SQL_TXN_READ_COMMITTED,         NULL, 0 },
            { "SQL_TXN_REPEATABLE_READ",        SQL_TXN_REPEATABLE_READ,        NULL, 0 },
            { "SQL_TXN_SERIALIZABLE",           SQL_TXN_SERIALIZABLE,           NULL, 0 },
            { "SQL_TXN_VERSIONING",             0x00000010L,                    NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "1.0", SQL_INTEGER, 0, 0
    },
    { NULL, 0, { { NULL, 0, NULL, 0 } }, NULL, 0, 0, 0 }
};

static attr_options env_options[] = 
{
    { "SQL_ATTR_ODBC_VERSION", SQL_ATTR_ODBC_VERSION, 
        {
            { "SQL_OV_ODBC2", SQL_OV_ODBC2,     NULL, 0 }, 
            { "SQL_OV_ODBC3", SQL_OV_ODBC3,     NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "3.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_CP_MATCH", SQL_ATTR_CP_MATCH,
        {
            { "SQL_CP_STRICT_MATCH",    SQL_CP_STRICT_MATCH,    NULL, 0 },
            { "SQL_CP_RELAXED_MATCH",   SQL_CP_RELAXED_MATCH,   NULL, 0 },
            { "SQL_CP_MATCH_DEFAULT",   SQL_CP_MATCH_DEFAULT,   NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "3.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_CONNECTION_POOLING", SQL_ATTR_CONNECTION_POOLING, 
        {
            { "SQL_CP_OFF",             SQL_OV_ODBC2,           NULL, 0 },
            { "SQL_CP_ONE_PER_DRIVER",  SQL_CP_ONE_PER_DRIVER,  NULL, 0 },
            { "SQL_CP_ONE_PER_HENV",    SQL_CP_ONE_PER_HENV,    NULL, 0 },
            { "SQL_CP_DEFAULT",         SQL_CP_DEFAULT,         NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "3.0", SQL_INTEGER, 0, 0
    },
    { "SQL_ATTR_OUTPUT_NTS", SQL_ATTR_OUTPUT_NTS, 
        {
            { "SQL_TRUE",       SQL_TRUE,       NULL, 0 },
            { "SQL_FALSE",      SQL_FALSE,      NULL, 0 },
            { NULL, 0, NULL, 0 }
        }, "3.0", SQL_INTEGER, 0, 0
    },
    { NULL, 0, { { NULL, 0, NULL, 0 } }, NULL, 0, 0, 0 }
};

void dSetEnvAttr::Activated( int index )
{
    value->clear();

    pOdbcTest->fill_list_box( env_options[ index ].values, value );
}

void dSetEnvAttr::Ok()
{
    SQLHANDLE in_handle = SQL_NULL_HENV;
    SQLINTEGER attribute;
    SQLPOINTER vptr;
    SQLINTEGER string_length;
    OdbcHandle *hand = pOdbcTest->extract_handle_list( SQL_HANDLE_ENV, handles );

    if ( hand )
        in_handle = hand->getHandle();

    pOdbcTest->out_win->append( "SQLSetEnvAttr():" );
    pOdbcTest->out_win->append( "  In:" );
    if ( in_handle )
        txt.sprintf( "    Environment Handle: %p", in_handle );
    else
        txt.sprintf( "    Environment Handle: SQL_NULL_HENV" );
    pOdbcTest->out_win->append( txt );

    attribute = env_options[ types->currentIndex() ].attr;
    txt.sprintf( "    Attribute: %s=%d", 
                 env_options[ types->currentIndex() ].text,
                 env_options[ types->currentIndex() ].attr );
    pOdbcTest->out_win->append( txt );

    vptr = (SQLPOINTER) env_options[ types->currentIndex() ].values[ value->currentIndex() ].value;
    txt.sprintf( "    Value: %s=%d", 
                 env_options[ types->currentIndex() ].values[ value->currentIndex() ].text,
                 env_options[ types->currentIndex() ].values[ value->currentIndex() ].value );
    pOdbcTest->out_win->append( txt );

    string_length = strlen_options[ stringlen->currentIndex() ].value;
    txt.sprintf( "    String Length: %s=%d", 
                 strlen_options[ stringlen->currentIndex() ].text,
                 strlen_options[ stringlen->currentIndex() ].value );
    pOdbcTest->out_win->append( txt );

    SQLRETURN ret = SQLSetEnvAttr( in_handle, attribute, vptr, string_length );

    pOdbcTest->out_win->append( "  Return:" );
    txt.sprintf( "    %s=%d", pOdbcTest->return_as_text( ret ), ret );
    pOdbcTest->out_win->append( txt );
    pOdbcTest->out_win->append( "" );
}

dSetEnvAttr::dSetEnvAttr( OdbcTest *pOdbcTest, QString name )
    : QDialog( pOdbcTest )
{
    setWindowTitle( name );
    setModal( true );

    this->pOdbcTest = pOdbcTest;

    ok = new QPushButton( "OK", this );
    ok->setGeometry( 240,10, 70,25 );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry( 320,10, 70,25 );

    help = new QPushButton( "Help", this );
    help->setGeometry( 400,10, 70,25 );

    handles = new QComboBox( this ); // "Environment Handle"
    handles->setGeometry( 170, 50, 300, 20 );

    pOdbcTest->fill_handle_list( SQL_HANDLE_ENV, handles );

    types = new QComboBox( this ); // "Attribute"
    types->setGeometry( 170, 80, 300, 20 );

    pOdbcTest->fill_list_box( env_options, types );

    value = new QComboBox( this ); // "Value"
    value->setGeometry( 170, 110, 300, 20 );
    pOdbcTest->fill_list_box( env_options[ 0 ].values, value );

    stringlen = new QComboBox( this ); // "String Length"
    stringlen->setGeometry( 170, 140, 300, 20 );
    pOdbcTest->fill_list_box( strlen_options, stringlen );

    l_handle = new QLabel( "Environment Handle:", this );
    l_handle->setGeometry( 10, 50, 130, 20 );

    l_types = new QLabel( "Attribute:", this );
    l_types->setGeometry( 10, 80, 130, 20 );

    l_value = new QLabel( "Value:", this );
    l_value->setGeometry( 10, 110, 130, 20 );

    l_slen = new QLabel( "String Length:", this );
    l_slen->setGeometry( 10, 140, 130, 20 );

    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
    connect( ok, SIGNAL(clicked()), SLOT(Ok()) );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );
    connect( types, SIGNAL(activated(int)), this, SLOT( Activated(int)));
}

dSetEnvAttr::~dSetEnvAttr()
{
    delete ok;
    delete cancel;
    delete help;
    delete types;
    delete handles;
    delete value;
    delete stringlen;
    delete l_handle;
    delete l_types;
    delete l_value;
    delete l_slen;
}

void dGetEnvAttr::Ok()
{
    SQLHANDLE in_handle = SQL_NULL_HENV;
    SQLINTEGER attribute;
    OdbcHandle *hand = pOdbcTest->extract_handle_list( SQL_HANDLE_ENV, handles );
    SQLINTEGER b_len, strlen_or_ind;
    SQLINTEGER *strlen_ptr;
    char *buf = NULL;

    if ( hand )
        in_handle = hand->getHandle();

    pOdbcTest->out_win->append( "SQLGetEnvAttr():" );
    pOdbcTest->out_win->append( "  In:" );
    if ( in_handle )
        txt.sprintf( "    Environment Handle: %p", in_handle );
    else
        txt.sprintf( "    Environment Handle: SQL_NULL_HENV" );
    pOdbcTest->out_win->append( txt );

    attribute = env_options[ types->currentIndex() ].attr;
    txt.sprintf( "    Attribute: %s=%d", 
                 env_options[ types->currentIndex() ].text,
                 env_options[ types->currentIndex() ].attr );
    pOdbcTest->out_win->append( txt );

    b_len = buffer_len->text().toInt();
    if ( b_len < 1 )
    {
        b_len = 0;
    }

    if ( target_valid->isChecked() )
    {
        buf = NULL;
    }
    else if ( b_len < 300 )
    {
        buf = new char[ 300 ];  
    }
    else
    {
        buf = new char[ b_len ];    
    }

    if ( buf )
    {
        txt.sprintf( "    Value Ptr: %p", buf );
        pOdbcTest->out_win->append( txt );
    }
    else
    {
        txt.sprintf( "    Value Ptr: SQL_NULL_POINTER" );
        pOdbcTest->out_win->append( txt );
    }

    txt.sprintf( "    Buffer Length: %d", b_len );
    pOdbcTest->out_win->append( txt );

    strlen_or_ind = -999999;

    if ( strlen_valid->isChecked() )
    {
        strlen_ptr = NULL;
    }
    else
    {
        strlen_ptr = &strlen_or_ind;
    }

    if ( strlen_ptr )
    {
        txt.sprintf( "    Strlen Ptr: %p", strlen_ptr );
        pOdbcTest->out_win->append( txt );
    }
    else
    {
        txt.sprintf( "    Strlen Ptr: SQL_NULL_POINTER" );
        pOdbcTest->out_win->append( txt );
    }

    SQLRETURN ret = SQLGetEnvAttr( in_handle, attribute, 
                                   buf, b_len, strlen_ptr );

    pOdbcTest->out_win->append( "  Return:" );
    txt.sprintf( "    %s=%d", pOdbcTest->return_as_text( ret ), ret );
    pOdbcTest->out_win->append( txt );

    pOdbcTest->out_win->append( "  Out:" );
    if ( strlen_ptr )
    {
        if ( strlen_or_ind == -999999 )
        {
            txt.sprintf( "    *Strlen Ptr: <unchanged>" );
        }
        else
        {
            txt.sprintf( "    *Strlen Ptr: %d", strlen_or_ind );
        }
        pOdbcTest->out_win->append( txt );
    }

    if ( SQL_SUCCEEDED( ret ))
    {
        int index = types->currentIndex();
        switch ( env_options[ index ].data_type )
        {
            case SQL_INTEGER:
                SQLUINTEGER ival;
                memcpy( &ival, buf, sizeof( ival ));
                txt.sprintf( "    *ValuePtr = %d (0x%08X)", ival, ival );
                pOdbcTest->out_win->append( txt );

                if ( env_options[ index ].values[ 0 ].text )
                {
                    if ( env_options[ index ].is_bitmap )
                    {
                        int i;

                        for ( i = 0; env_options[ index ].values[ i ].text; i ++ )
                        {
                            if ( env_options[ index ].values[ i ].value & ival )
                            {
                                txt.sprintf( "        %s", 
                                             env_options[ index ].values[ i ].text );
                                pOdbcTest->out_win->append( txt );
                            }
                        }
                    }
                    else
                    {
                        int i;

                        for ( i = 0; env_options[ index ].values[ i ].text; i ++ )
                        {
                            if ( (SQLUINTEGER)(env_options[ index ].values[ i ].value) == ival )
                            {
                                txt.sprintf( "        %s", 
                                             env_options[ index ].values[ i ].text );
                                pOdbcTest->out_win->append( txt );
                            }
                        }
                    }
                }
                break;

            case SQL_SMALLINT:
                SQLSMALLINT sval;
                memcpy( &sval, buf, sizeof( sval ));
                txt.sprintf( "    *ValuePtr = %d (0x%04X)", sval, sval );
                pOdbcTest->out_win->append( txt );

                if ( env_options[ index ].values[ 0 ].text )
                {
                    if ( env_options[ index ].is_bitmap )
                    {
                        int i;

                        for ( i = 0; env_options[ index ].values[ i ].text; i ++ )
                        {
                            if ( env_options[ index ].values[ i ].value & sval )
                            {
                                txt.sprintf( "        %s", 
                                             env_options[ index ].values[ i ].text );
                                pOdbcTest->out_win->append( txt );
                            }
                        }
                    }
                    else
                    {
                        int i;

                        for ( i = 0; env_options[ index ].values[ i ].text; i ++ )
                        {
                            if ( env_options[ index ].values[ i ].value == sval )
                            {
                                txt.sprintf( "        %s", 
                                             env_options[ index ].values[ i ].text );
                                pOdbcTest->out_win->append( txt );
                            }
                        }
                    }
                }
                break;
        }       
    }

    if ( buf )
        delete buf;

    pOdbcTest->out_win->append( "" );
}

void dGetEnvAttr::target_clkd()
{
    if ( target_valid->isChecked() )
        target_valid->setText( "ValuePtr: SQL_NULL_POINTER" );
    else
        target_valid->setText( "ValuePtr: VALID" );
}

void dGetEnvAttr::strlen_clkd()
{
    if ( strlen_valid->isChecked() )
        strlen_valid->setText( "StrLen_Ptr: SQL_NULL_POINTER" );
    else
        strlen_valid->setText( "StrLen_Ptr: VALID" );
}

dGetEnvAttr::dGetEnvAttr( OdbcTest *pOdbcTest, QString name )
: QDialog( pOdbcTest )
{
    setWindowTitle( name );
    setModal( true );

    this->pOdbcTest = pOdbcTest;

    ok = new QPushButton( "OK", this );
    ok->setGeometry( 240,10, 70,25 );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry( 320,10, 70,25 );

    help = new QPushButton( "Help", this );
    help->setGeometry( 400,10, 70,25 );

    handles = new QComboBox( this ); // "Environment Handle"
    handles->setGeometry( 170, 50, 300, 20 );

    pOdbcTest->fill_handle_list( SQL_HANDLE_ENV, handles );

    types = new QComboBox( this ); // "Attribute"
    types->setGeometry( 170, 80, 300, 20 );

    pOdbcTest->fill_list_box( env_options, types );

    l_handle = new QLabel( "Environment Handle:", this );
    l_handle->setGeometry( 10, 50, 130, 20 );

    l_types = new QLabel( "Attribute:", this );
    l_types->setGeometry( 10, 80, 130, 20 );

    target_valid = new QCheckBox( "ValuePtr: VALID", this );
    target_valid->setGeometry( 10, 110, 300, 15 );

    strlen_valid = new QCheckBox( "StrLen_Ptr: VALID", this );
    strlen_valid->setGeometry( 10, 140, 300, 15 );

    buffer_len = new QLineEdit( this ); // "Buffer Len"
    buffer_len->setGeometry( 400, 110, 70, 20 );
    buffer_len->setMaxLength( 7 );
    buffer_len->setText( "300" );

    l_buffer_len = new QLabel( "Buffer Len:", this );
    l_buffer_len->setGeometry( 320, 110, 60, 20 );

    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
    connect( ok, SIGNAL(clicked()), SLOT(Ok()) );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );
    connect( target_valid, SIGNAL( clicked()), this, SLOT( target_clkd()));
    connect( strlen_valid, SIGNAL( clicked()), this, SLOT( strlen_clkd()));
}

dGetEnvAttr::~dGetEnvAttr()
{
    delete ok;
    delete cancel;
    delete help;
    delete types;
    delete handles;
    delete l_handle;
    delete l_types;
    delete target_valid;
    delete strlen_valid;
    delete buffer_len;
    delete l_buffer_len;
}

void dSetStmtAttr::Activated( int index )
{
    value->clear();

    if ( !stmt_options[ index ].values[ 0 ].text )
    {
        switch ( stmt_options[ index ].attr )
        {
            case SQL_ATTR_FETCH_BOOKMARK_PTR:
            case SQL_ATTR_PARAM_BIND_OFFSET_PTR:
            case SQL_ATTR_PARAM_OPERATION_PTR:
            case SQL_ATTR_PARAM_STATUS_PTR:
            case SQL_ATTR_PARAMS_PROCESSED_PTR:
            case SQL_ATTR_ROW_BIND_OFFSET_PTR:
            case SQL_ATTR_ROW_OPERATION_PTR:
            case SQL_ATTR_ROW_STATUS_PTR:
            case SQL_ATTR_ROWS_FETCHED_PTR:
                value->insertItem( 0, "<valid ptr>" );
                break;

            default:
                value->insertItem( 0, "0" );
                break;
        }
    }
    else
    {
        pOdbcTest->fill_list_box( stmt_options[ index ].values, value );
    }
}

void dSetStmtAttr::Ok()
{
    SQLHANDLE in_handle = SQL_NULL_HSTMT;
    SQLINTEGER attribute;
    SQLPOINTER vptr;
    SQLUINTEGER ival = 0;
    const char *tptr;
    attr_value *ptr;
    SQLINTEGER string_length;
    OdbcHandle *hand = pOdbcTest->extract_handle_list( SQL_HANDLE_STMT, handles );

    QString qtptr;

    if ( hand )
        in_handle = hand->getHandle();

    pOdbcTest->out_win->append( "SQLSetStmtAttr():" );
    pOdbcTest->out_win->append( "  In:" );
    if ( in_handle )
        txt.sprintf( "    Statment Handle: %p", in_handle );
    else
        txt.sprintf( "    Statment Handle: SQL_NULL_HSTMT" );
    pOdbcTest->out_win->append( txt );

    attribute = stmt_options[ types->currentIndex() ].attr;
    txt.sprintf( "    Attribute: %s=%d", 
                 stmt_options[ types->currentIndex() ].text,
                 stmt_options[ types->currentIndex() ].attr );
    pOdbcTest->out_win->append( txt );

    qtptr = value->currentText();
    tptr = qtptr.toAscii().constData();

    /*
     * try and match the text
     */

    for ( ptr = stmt_options[ types->currentIndex() ].values; 
        ptr->text; ptr ++ )
    {
        if ( strncmp( ptr->text, tptr, strlen( ptr->text )) == 0 )
        {
            break;
        }
    }

    if ( !ptr->text )
    {
        if ( attribute == SQL_ATTR_ROW_ARRAY_SIZE ||
             attribute == SQL_ATTR_PARAMSET_SIZE )
        {
            ival = atoi( tptr );
        }

        vptr = (SQLPOINTER) atoi( tptr );
        txt.sprintf( "    Value: %d", atoi( tptr ));
    }
    else
    {
        if ( attribute == SQL_ATTR_ROW_ARRAY_SIZE ||
             attribute == SQL_ATTR_PARAMSET_SIZE )
        {
            ival = ptr->value;
        }

        vptr = (SQLPOINTER) ptr->value;
        txt.sprintf( "    Value: %s=%d", ptr->text, ptr->value );
    }

    if ( strcmp( tptr, "<valid ptr>" ) == 0 )
    {
        switch ( stmt_options[ types->currentIndex() ].attr )
        {
            case SQL_ATTR_FETCH_BOOKMARK_PTR:
                vptr = hand->bookmark_ptr;
                txt.sprintf( "    Value: %p", vptr );
                break;

            case SQL_ATTR_PARAM_BIND_OFFSET_PTR:
                vptr = hand->param_bind_offset_ptr;
                txt.sprintf( "    Value: %p", vptr );
                break;

            case SQL_ATTR_PARAM_OPERATION_PTR:
                vptr = hand->param_opt_ptr;
                txt.sprintf( "    Value: %p", vptr );
                break;

            case SQL_ATTR_PARAM_STATUS_PTR:
                vptr = hand->param_status_ptr;
                txt.sprintf( "    Value: %p", vptr );
                break;

            case SQL_ATTR_PARAMS_PROCESSED_PTR:
                vptr = hand->params_processed_ptr;
                txt.sprintf( "    Value: %p", vptr );
                break;

            case SQL_ATTR_ROW_BIND_OFFSET_PTR:
                vptr = hand->row_bind_offset_ptr;
                txt.sprintf( "    Value: %p", vptr );
                break;

            case SQL_ATTR_ROW_OPERATION_PTR:
                vptr = hand->row_operation_ptr;
                txt.sprintf( "    Value: %p", vptr );
                break;

            case SQL_ATTR_ROW_STATUS_PTR:
                vptr = hand->row_status_ptr;
                txt.sprintf( "    Value: %p", vptr );
                break;

            case SQL_ATTR_ROWS_FETCHED_PTR:
                vptr = hand->rows_fetched_ptr;
                txt.sprintf( "    Value: %p", vptr );
                break;
        }
    }

    pOdbcTest->out_win->append( txt );

    string_length = strlen_options[ stringlen->currentIndex() ].value;
    txt.sprintf( "    String Length: %s=%d", 
                 strlen_options[ stringlen->currentIndex() ].text,
                 strlen_options[ stringlen->currentIndex() ].value );
    pOdbcTest->out_win->append( txt );

    SQLRETURN ret = SQLSetStmtAttr( in_handle, attribute, vptr, string_length );

    pOdbcTest->out_win->append( "  Return:" );
    txt.sprintf( "    %s=%d", pOdbcTest->return_as_text( ret ), ret );
    pOdbcTest->out_win->append( txt );
    pOdbcTest->out_win->append( "" );

    /*
     * save the row or param array size
     */

    if ( SQL_SUCCEEDED( ret ))
    {
        if ( attribute == SQL_ATTR_ROW_ARRAY_SIZE )
        {
            hand->row_array_size = ival;
        }
        else if ( attribute == SQL_ATTR_PARAMSET_SIZE )
        {
            hand->param_array_size = ival;
        }
    }
}

dSetStmtAttr::dSetStmtAttr( OdbcTest *pOdbcTest, QString name )
    : QDialog( pOdbcTest )
{
    setWindowTitle( name );
    setModal( true );
    this->pOdbcTest = pOdbcTest;

    ok = new QPushButton( "OK", this );
    ok->setGeometry( 240,10, 70,25 );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry( 320,10, 70,25 );

    help = new QPushButton( "Help", this );
    help->setGeometry( 400,10, 70,25 );

    handles = new QComboBox( this ); // "Statement Handle"
    handles->setGeometry( 170, 50, 300, 20 );

    pOdbcTest->fill_handle_list( SQL_HANDLE_STMT, handles );

    types = new QComboBox( this ); // "Attribute"
    types->setGeometry( 170, 80, 300, 20 );

    pOdbcTest->fill_list_box( stmt_options, types );

    value = new QComboBox( this ); // "Value"
    value->setGeometry( 170, 110, 300, 20 );
    pOdbcTest->fill_list_box( stmt_options[ 0 ].values, value );

    stringlen = new QComboBox( this ); // "String Length"
    stringlen->setGeometry( 170, 140, 300, 20 );
    pOdbcTest->fill_list_box( strlen_options, stringlen );

    l_handle = new QLabel( "Statement Handle:", this );
    l_handle->setGeometry( 10, 50, 130, 20 );

    l_types = new QLabel( "Attribute:", this );
    l_types->setGeometry( 10, 80, 130, 20 );

    l_value = new QLabel( "Value:", this );
    l_value->setGeometry( 10, 110, 130, 20 );

    l_slen = new QLabel( "String Length:", this );
    l_slen->setGeometry( 10, 140, 130, 20 );

    Activated( 0 );

    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
    connect( ok, SIGNAL(clicked()), SLOT(Ok()) );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );
    connect( types, SIGNAL(activated(int)), this, SLOT( Activated(int)));
}

dSetStmtAttr::~dSetStmtAttr()
{
    delete ok;
    delete cancel;
    delete help;
    delete types;
    delete handles;
    delete value;
    delete stringlen;
    delete l_handle;
    delete l_types;
    delete l_value;
    delete l_slen;
}

void dSetStmtOption::Activated( int index )
{
    value->clear();

    if ( !stmt_opt_options[ index ].values[ 0 ].text )
    {
        value->insertItem( 0, "0" );
    }
    else
    {
        pOdbcTest->fill_list_box( stmt_opt_options[ index ].values, value );
    }
}

void dSetStmtOption::Ok()
{
    SQLHANDLE in_handle = SQL_NULL_HSTMT;
    SQLINTEGER attribute;
    SQLINTEGER ival = 0;
    SQLULEN vptr;
    const char *tptr;
    attr_value *ptr;
    OdbcHandle *hand = pOdbcTest->extract_handle_list( SQL_HANDLE_STMT, handles );
    QString qtptr;

    if ( hand )
        in_handle = hand->getHandle();

    pOdbcTest->out_win->append( "SQLSetStmtOption():" );
    pOdbcTest->out_win->append( "  In:" );
    if ( in_handle )
        txt.sprintf( "    hstmt: %p", in_handle );
    else
        txt.sprintf( "    hstmt: SQL_NULL_HSTMT" );
    pOdbcTest->out_win->append( txt );

    attribute = stmt_opt_options[ types->currentIndex() ].attr;
    txt.sprintf( "    fOption: %s=%d", 
                 stmt_opt_options[ types->currentIndex() ].text,
                 stmt_opt_options[ types->currentIndex() ].attr );
    pOdbcTest->out_win->append( txt );

    qtptr = value->currentText();
    tptr = qtptr.toAscii().constData();

    /*
     * try and match the text
     */

    for ( ptr = stmt_opt_options[ types->currentIndex() ].values; 
        ptr->text; ptr ++ )
    {
        if ( strncmp( ptr->text, tptr, strlen( ptr->text )) == 0 )
        {
            break;
        }
    }

    if ( !ptr->text )
    {
        vptr = (SQLULEN) atoi( tptr );
        txt.sprintf( "    vParam: %d", atoi( tptr ));
        if ( attribute == SQL_ROWSET_SIZE )
        {
            ival = atoi( tptr );
        }
    }
    else
    {
        vptr = (SQLULEN) ptr->value;
        txt.sprintf( "    vParam: %s=%d", ptr->text, ptr->value );
        if ( attribute == SQL_ROWSET_SIZE )
        {
            ival = ptr->value;
        }
    }

    pOdbcTest->out_win->append( txt );

    SQLRETURN ret = SQLSetStmtOption( in_handle, attribute, vptr );

    pOdbcTest->out_win->append( "  Return:" );
    txt.sprintf( "    %s=%d", pOdbcTest->return_as_text( ret ), ret );
    pOdbcTest->out_win->append( txt );
    pOdbcTest->out_win->append( "" );

    /*
     * save the row or param array size
     */

    if ( SQL_SUCCEEDED( ret ))
    {
        if ( attribute == SQL_ROWSET_SIZE )
        {
            hand->row_array_size = ival;
        }
    }
}

dSetStmtOption::dSetStmtOption( OdbcTest *pOdbcTest, QString name )
: QDialog( pOdbcTest )
{
    setWindowTitle( name );
    setModal( true );
    this->pOdbcTest = pOdbcTest;

    ok = new QPushButton( "OK", this );
    ok->setGeometry( 240,10, 70,25 );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry( 320,10, 70,25 );

    help = new QPushButton( "Help", this );
    help->setGeometry( 400,10, 70,25 );

    handles = new QComboBox( this ); // "Statement Handle"
    handles->setGeometry( 170, 50, 300, 20 );

    pOdbcTest->fill_handle_list( SQL_HANDLE_STMT, handles );

    types = new QComboBox( this ); // "Attribute"
    types->setGeometry( 170, 80, 300, 20 );

    pOdbcTest->fill_list_box( stmt_opt_options, types );

    value = new QComboBox( this ); // "Value"
    value->setGeometry( 170, 110, 300, 20 );
    pOdbcTest->fill_list_box( stmt_opt_options[ 0 ].values, value );

    l_handle = new QLabel( "Statement Handle:", this );
    l_handle->setGeometry( 10, 50, 130, 20 );

    l_types = new QLabel( "fOption:", this );
    l_types->setGeometry( 10, 80, 130, 20 );

    l_value = new QLabel( "vParam:", this );
    l_value->setGeometry( 10, 110, 130, 20 );

    Activated( 0 );

    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
    connect( ok, SIGNAL(clicked()), SLOT(Ok()) );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );
    connect( types, SIGNAL(activated(int)), this, SLOT( Activated(int)));
}

dSetStmtOption::~dSetStmtOption()
{
    delete ok;
    delete cancel;
    delete help;
    delete types;
    delete handles;
    delete value;
    delete l_handle;
    delete l_types;
    delete l_value;
}

void dGetStmtAttr::Ok()
{
    SQLHANDLE in_handle = SQL_NULL_HENV;
    SQLINTEGER attribute;
    OdbcHandle *hand = pOdbcTest->extract_handle_list( SQL_HANDLE_STMT, handles );
    SQLINTEGER b_len, strlen_or_ind;
    SQLINTEGER *strlen_ptr;
    char *buf = NULL; 

    if ( hand )
        in_handle = hand->getHandle();

    pOdbcTest->out_win->append( "SQLGetStmtAttr():" );
    pOdbcTest->out_win->append( "  In:" );
    if ( in_handle )
        txt.sprintf( "    Statement Handle: %p", in_handle );
    else
        txt.sprintf( "    Statement Handle: SQL_NULL_HSTMT" );
    pOdbcTest->out_win->append( txt );

    attribute = stmt_options[ types->currentIndex() ].attr;
    txt.sprintf( "    Attribute: %s=%d", 
                 stmt_options[ types->currentIndex() ].text,
                 stmt_options[ types->currentIndex() ].attr );
    pOdbcTest->out_win->append( txt );

    b_len = buffer_len->text().toInt();
    if ( b_len < 1 )
    {
        b_len = 0;
    }

    if ( target_valid->isChecked())
    {
        buf = NULL;
    }
    else if ( b_len < 300 )
    {
        buf = new char[ 300 ];  
    }
    else
    {
        buf = new char[ b_len ];    
    }

    if ( buf )
    {
        txt.sprintf( "    Value Ptr: %p", buf );
        pOdbcTest->out_win->append( txt );
    }
    else
    {
        txt.sprintf( "    Value Ptr: SQL_NULL_POINTER" );
        pOdbcTest->out_win->append( txt );
    }

    txt.sprintf( "    Buffer Length: %d", b_len );
    pOdbcTest->out_win->append( txt );

    strlen_or_ind = -999999;

    if ( strlen_valid->isChecked())
    {
        strlen_ptr = NULL;
    }
    else
    {
        strlen_ptr = &strlen_or_ind;
    }

    if ( strlen_ptr )
    {
        txt.sprintf( "    Strlen Ptr: %p", strlen_ptr );
        pOdbcTest->out_win->append( txt );
    }
    else
    {
        txt.sprintf( "    Strlen Ptr: SQL_NULL_POINTER" );
        pOdbcTest->out_win->append( txt );
    }

    SQLRETURN ret = SQLGetStmtAttr( in_handle, attribute, 
                                    buf, b_len, strlen_ptr );

    pOdbcTest->out_win->append( "  Return:" );
    txt.sprintf( "    %s=%d", pOdbcTest->return_as_text( ret ), ret );
    pOdbcTest->out_win->append( txt );

    pOdbcTest->out_win->append( "  Out:" );
    if ( strlen_ptr )
    {
        if ( strlen_or_ind == -999999 )
        {
            txt.sprintf( "    *Strlen Ptr: <unchanged>" );
        }
        else
        {
            txt.sprintf( "    *Strlen Ptr: %d", strlen_or_ind );
        }
        pOdbcTest->out_win->append( txt );
    }

    if ( SQL_SUCCEEDED( ret ))
    {
        int index = types->currentIndex();

        if ( stmt_options[ index ].is_pointer )
        {
            void *ival;
            memcpy( &ival, buf, sizeof( ival ));
            txt.sprintf( "    ValuePtr = 0x%08X", ival );
            pOdbcTest->out_win->append( txt );
        }
        else
        {
            switch ( stmt_options[ index ].data_type )
            {
                case SQL_INTEGER:
                    SQLUINTEGER ival;
                    memcpy( &ival, buf, sizeof( ival ));
                    txt.sprintf( "    *ValuePtr = %d (0x%08X)", ival, ival );
                    pOdbcTest->out_win->append( txt );

                    if ( stmt_options[ index ].values[ 0 ].text )
                    {
                        if ( stmt_options[ index ].is_bitmap )
                        {
                            int i;

                            for ( i = 0; stmt_options[ index ].values[ i ].text; i ++ )
                            {
                                if ( stmt_options[ index ].values[ i ].value & ival )
                                {
                                    txt.sprintf( "        %s", 
                                                 stmt_options[ index ].values[ i ].text );
                                    pOdbcTest->out_win->append( txt );
                                }
                            }
                        }
                        else
                        {
                            int i;

                            for ( i = 0; stmt_options[ index ].values[ i ].text; i ++ )
                            {
                                if ( (SQLUINTEGER)(stmt_options[ index ].values[ i ].value) == ival )
                                {
                                    txt.sprintf( "        %s", 
                                                 stmt_options[ index ].values[ i ].text );
                                    pOdbcTest->out_win->append( txt );
                                }
                            }
                        }
                    }
                    break;

                case SQL_SMALLINT:
                    SQLSMALLINT sval;
                    memcpy( &sval, buf, sizeof( sval ));
                    txt.sprintf( "    *ValuePtr = %d (0x%04X)", sval, sval );
                    pOdbcTest->out_win->append( txt );

                    if ( stmt_options[ index ].values[ 0 ].text )
                    {
                        if ( stmt_options[ index ].is_bitmap )
                        {
                            int i;

                            for ( i = 0; stmt_options[ index ].values[ i ].text; i ++ )
                            {
                                if ( stmt_options[ index ].values[ i ].value & sval )
                                {
                                    txt.sprintf( "        %s", 
                                                 stmt_options[ index ].values[ i ].text );
                                    pOdbcTest->out_win->append( txt );
                                }
                            }
                        }
                        else
                        {
                            int i;

                            for ( i = 0; stmt_options[ index ].values[ i ].text; i ++ )
                            {
                                if ( stmt_options[ index ].values[ i ].value == sval )
                                {
                                    txt.sprintf( "        %s", 
                                                 stmt_options[ index ].values[ i ].text );
                                    pOdbcTest->out_win->append( txt );
                                }
                            }
                        }
                    }
                    break;
            }       
        }
    }

    if ( buf )
        delete buf;

    pOdbcTest->out_win->append( "" );
}

void dGetStmtAttr::target_clkd()
{
    if ( target_valid->isChecked() )
        target_valid->setText( "ValuePtr: SQL_NULL_POINTER" );
    else
        target_valid->setText( "ValuePtr: VALID" );
}

void dGetStmtAttr::strlen_clkd()
{
    if ( strlen_valid->isChecked() )
        strlen_valid->setText( "StrLen_Ptr: SQL_NULL_POINTER" );
    else
        strlen_valid->setText( "StrLen_Ptr: VALID" );
}

dGetStmtAttr::dGetStmtAttr( OdbcTest *pOdbcTest, QString name )
: QDialog( pOdbcTest )
{
    setWindowTitle( name );
    setModal( true );

    this->pOdbcTest = pOdbcTest;

    ok = new QPushButton( "OK", this );
    ok->setGeometry( 240,10, 70,25 );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry( 320,10, 70,25 );

    help = new QPushButton( "Help", this );
    help->setGeometry( 400,10, 70,25 );

    handles = new QComboBox( this ); // "Statement Handle"
    handles->setGeometry( 170, 50, 300, 20 );

    pOdbcTest->fill_handle_list( SQL_HANDLE_STMT, handles );

    types = new QComboBox( this ); // "Attribute"
    types->setGeometry( 170, 80, 300, 20 );

    pOdbcTest->fill_list_box( stmt_options, types );

    l_handle = new QLabel( "Statement Handle:", this );
    l_handle->setGeometry( 10, 50, 130, 20 );

    l_types = new QLabel( "Attribute:", this );
    l_types->setGeometry( 10, 80, 130, 20 );

    target_valid = new QCheckBox( "ValuePtr: VALID", this );
    target_valid->setGeometry( 10, 110, 300, 15 );

    strlen_valid = new QCheckBox( "StrLen_Ptr: VALID", this );
    strlen_valid->setGeometry( 10, 140, 300, 15 );

    buffer_len = new QLineEdit( this ); // "Buffer Len"
    buffer_len->setGeometry( 400, 110, 70, 20 );
    buffer_len->setMaxLength( 6 );
    buffer_len->setText( "300" );

    l_buffer_len = new QLabel( "Buffer Len:", this );
    l_buffer_len->setGeometry( 320, 110, 60, 20 );

    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
    connect( ok, SIGNAL(clicked()), SLOT(Ok()) );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );
    connect( target_valid, SIGNAL( clicked()), this, SLOT( target_clkd()));
    connect( strlen_valid, SIGNAL( clicked()), this, SLOT( strlen_clkd()));
}

dGetStmtAttr::~dGetStmtAttr()
{
    delete ok;
    delete cancel;
    delete help;
    delete types;
    delete handles;
    delete l_handle;
    delete l_types;
    delete target_valid;
    delete strlen_valid;
    delete buffer_len;
    delete l_buffer_len;
}

void dGetStmtOption::Ok()
{
    SQLHANDLE in_handle = SQL_NULL_HENV;
    SQLINTEGER attribute, value;
    SQLPOINTER vptr;
    OdbcHandle *hand = pOdbcTest->extract_handle_list( SQL_HANDLE_STMT, handles );
    int index = types->currentIndex();
    char *buf = NULL;

    if ( hand )
        in_handle = hand->getHandle();

    pOdbcTest->out_win->append( "SQLGetStmtOption():" );
    pOdbcTest->out_win->append( "  In:" );
    if ( in_handle )
        txt.sprintf( "    hstmt: %p", in_handle );
    else
        txt.sprintf( "    hstmt: SQL_NULL_HSTMT" );
    pOdbcTest->out_win->append( txt );

    attribute = stmt_opt_options[ types->currentIndex() ].attr;
    txt.sprintf( "    fOption: %s=%d", 
                 stmt_opt_options[ types->currentIndex() ].text,
                 stmt_opt_options[ types->currentIndex() ].attr );
    pOdbcTest->out_win->append( txt );

    if ( target_valid->isChecked())
    {
        buf = NULL;
        vptr = NULL;
    }
    else
    {
        if ( stmt_opt_options[ index ].data_type == SQL_INTEGER )
        {
            vptr = &value;
        }
        else
        {
            buf = new char[ 300 ];  
            vptr = buf;
        }
    }

    if ( vptr )
    {
        txt.sprintf( "    vParam: %p", vptr );
        pOdbcTest->out_win->append( txt );
    }
    else
    {
        txt.sprintf( "    vParam: SQL_NULL_POINTER" );
        pOdbcTest->out_win->append( txt );
    }

    SQLRETURN ret = SQLGetStmtOption( in_handle, attribute, 
                                      vptr );

    pOdbcTest->out_win->append( "  Return:" );
    txt.sprintf( "    %s=%d", pOdbcTest->return_as_text( ret ), ret );
    pOdbcTest->out_win->append( txt );

    pOdbcTest->out_win->append( "  Out:" );

    if ( SQL_SUCCEEDED( ret ))
    {
        if ( vptr )
        {
            switch ( stmt_opt_options[ index ].data_type )
            {
                case SQL_INTEGER:
                    {
                        int i;

                        txt.sprintf( "    *vptr = 0x%08X", value );
                        pOdbcTest->out_win->append( txt );

                        for ( i = 0; stmt_opt_options[ index ].values[ i ].text; i ++ )
                        {
                            if ( stmt_opt_options[ index ].values[ i ].value == value )
                            {
                                txt.sprintf( "        %s", 
                                             stmt_opt_options[ index ].values[ i ].text );
                                pOdbcTest->out_win->append( txt );
                            }
                        }
                        break;
                    }

                default:
                    txt.sprintf( "    *vptr = %s", buf );
                    break;
            }
        }
    }

    if ( buf )
        delete buf;

    pOdbcTest->out_win->append( "" );
}

void dGetStmtOption::target_clkd()
{
    if ( target_valid->isChecked() )
        target_valid->setText( "vParam: SQL_NULL_POINTER" );
    else
        target_valid->setText( "vParam: VALID" );
}

dGetStmtOption::dGetStmtOption( OdbcTest *pOdbcTest, QString name )
: QDialog( pOdbcTest )
{
    setWindowTitle( name );
    setModal( true );
    this->pOdbcTest = pOdbcTest;

    ok = new QPushButton( "OK", this );
    ok->setGeometry( 240,10, 70,25 );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry( 320,10, 70,25 );

    help = new QPushButton( "Help", this );
    help->setGeometry( 400,10, 70,25 );

    handles = new QComboBox( this ); // "hstmt"
    handles->setGeometry( 170, 50, 300, 20 );

    pOdbcTest->fill_handle_list( SQL_HANDLE_STMT, handles );

    types = new QComboBox( this ); // "fOption"
    types->setGeometry( 170, 80, 300, 20 );

    pOdbcTest->fill_list_box( stmt_opt_options, types );

    l_handle = new QLabel( "hstmt:", this );
    l_handle->setGeometry( 10, 50, 130, 20 );

    l_types = new QLabel( "fOption:", this );
    l_types->setGeometry( 10, 80, 130, 20 );

    target_valid = new QCheckBox( "vParam: VALID", this );
    target_valid->setGeometry( 10, 110, 300, 15 );

    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
    connect( ok, SIGNAL(clicked()), SLOT(Ok()) );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );
    connect( target_valid, SIGNAL( clicked()), this, SLOT( target_clkd()));
}

dGetStmtOption::~dGetStmtOption()
{
    delete ok;
    delete cancel;
    delete help;
    delete types;
    delete handles;
    delete l_handle;
    delete l_types;
    delete target_valid;
}

void dSetConnAttr::Activated( int index )
{
    value->clear();

    if ( !conn_options[ index ].values[ 0 ].text )
    {
        if ( conn_options[ index ].data_type == SQL_CHAR )
        {
            value->insertItem( 0, "<null pointer>" );
            value->insertItem( 1, "" );
        }
        else
        {
            value->insertItem( 0, "0" );
        }
    }
    else
    {
        pOdbcTest->fill_list_box( conn_options[ index ].values, value );
    }
}

void dSetConnAttr::Ok()
{
    SQLHANDLE in_handle = SQL_NULL_HDBC;
    SQLINTEGER attribute;
    SQLPOINTER vptr;
    SQLINTEGER string_length;
    OdbcHandle *hand = pOdbcTest->extract_handle_list( SQL_HANDLE_DBC, handles );
    attr_value *ptr;
    const char *tptr;
    QString qtptr;

    if ( hand )
        in_handle = hand->getHandle();

    pOdbcTest->out_win->append( "SQLSetConnectAttr():" );
    pOdbcTest->out_win->append( "  In:" );
    if ( in_handle )
        txt.sprintf( "    Connection Handle: %p", in_handle );
    else
        txt.sprintf( "    Connection Handle: SQL_NULL_HDBC" );
    pOdbcTest->out_win->append( txt );

    attribute = conn_options[ types->currentIndex() ].attr;
    txt.sprintf( "    Attribute: %s=%d", 
                 conn_options[ types->currentIndex() ].text,
                 conn_options[ types->currentIndex() ].attr );
    pOdbcTest->out_win->append( txt );

    qtptr = value->currentText();
    tptr = qtptr.toAscii().constData();

    /*
     * try and match the text
     */

    for ( ptr = conn_options[ types->currentIndex() ].values; 
        ptr->text; ptr ++ )
    {
        if ( strncmp( ptr->text, tptr, strlen( ptr->text )) == 0 )
        {
            break;
        }
    }

    if ( !ptr->text )
    {
        if ( conn_options[ types->currentIndex() ].data_type == SQL_CHAR )
        {
            vptr = (SQLPOINTER) tptr;
            if ( strncmp( "<null pointer>", tptr, 14 ) == 0 )
            {
                vptr = NULL;
                txt.sprintf( "    Value: SQL_NULL_POINTER" );
            }
            else
            {
                vptr = (SQLPOINTER) tptr;
                txt.sprintf( "    Value: %s", tptr );
            }
        }
        else
        {
            vptr = (SQLPOINTER) atoi( tptr );
            txt.sprintf( "    Value: %d", atoi( tptr ));
        }
    }
    else
    {
        vptr = (SQLPOINTER) ptr->value;
        txt.sprintf( "    Value: %s=%d", ptr->text, ptr->value );
    }

    pOdbcTest->out_win->append( txt );

    string_length = strlen_options[ stringlen->currentIndex() ].value;
    txt.sprintf( "    String Length: %s=%d", 
                 strlen_options[ stringlen->currentIndex() ].text,
                 strlen_options[ stringlen->currentIndex() ].value );
    pOdbcTest->out_win->append( txt );

    SQLRETURN ret = SQLSetConnectAttr( in_handle, attribute, vptr, string_length );

    pOdbcTest->out_win->append( "  Return:" );
    txt.sprintf( "    %s=%d", pOdbcTest->return_as_text( ret ), ret );
    pOdbcTest->out_win->append( txt );
    pOdbcTest->out_win->append( "" );
}

dSetConnAttr::dSetConnAttr( OdbcTest *pOdbcTest, QString name )
: QDialog( pOdbcTest )
{
    setWindowTitle( name );
    setModal( true );
    this->pOdbcTest = pOdbcTest;

    ok = new QPushButton( "OK", this );
    ok->setGeometry( 240,10, 70,25 );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry( 320,10, 70,25 );

    help = new QPushButton( "Help", this );
    help->setGeometry( 400,10, 70,25 );

    handles = new QComboBox( this ); // "Connection Handle"
    handles->setGeometry( 170, 50, 300, 20 );

    pOdbcTest->fill_handle_list( SQL_HANDLE_DBC, handles );

    types = new QComboBox( this ); // "Attribute"
    types->setGeometry( 170, 80, 300, 20 );

    pOdbcTest->fill_list_box( conn_options, types );

    value = new QComboBox( this ); // "Value"
    value->setGeometry( 170, 110, 300, 20 );
    pOdbcTest->fill_list_box( conn_options[ 0 ].values, value );

    stringlen = new QComboBox( this ); // "String Length"
    stringlen->setGeometry( 170, 140, 300, 20 );
    pOdbcTest->fill_list_box( strlen_options, stringlen );

    l_handle = new QLabel( "Connection Handle:", this );
    l_handle->setGeometry( 10, 50, 130, 20 );

    l_types = new QLabel( "Attribute:", this );
    l_types->setGeometry( 10, 80, 130, 20 );

    l_value = new QLabel( "Value:", this );
    l_value->setGeometry( 10, 110, 130, 20 );

    l_slen = new QLabel( "String Length:", this );
    l_slen->setGeometry( 10, 140, 130, 20 );

    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
    connect( ok, SIGNAL(clicked()), SLOT(Ok()) );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );
    connect( types, SIGNAL(activated(int)), this, SLOT( Activated(int)));
}

dSetConnAttr::~dSetConnAttr()
{
    delete ok;
    delete cancel;
    delete help;
    delete types;
    delete handles;
    delete value;
    delete stringlen;
    delete l_handle;
    delete l_types;
    delete l_value;
    delete l_slen;
}

void dGetConnAttr::Ok()
{
    SQLHANDLE in_handle = SQL_NULL_HDBC;
    SQLINTEGER attribute;
    OdbcHandle *hand = pOdbcTest->extract_handle_list( SQL_HANDLE_DBC, handles );
    SQLINTEGER b_len, strlen_or_ind;
    SQLINTEGER *strlen_ptr;
    char *buf = NULL;

    if ( hand )
        in_handle = hand->getHandle();

    pOdbcTest->out_win->append( "SQLGetConnectAttr():" );
    pOdbcTest->out_win->append( "  In:" );
    if ( in_handle )
        txt.sprintf( "    Connection Handle: %p", in_handle );
    else
        txt.sprintf( "    Connection Handle: SQL_NULL_HDBC" );
    pOdbcTest->out_win->append( txt );

    attribute = conn_options[ types->currentIndex() ].attr;
    txt.sprintf( "    Attribute: %s=%d", 
                 conn_options[ types->currentIndex() ].text,
                 conn_options[ types->currentIndex() ].attr );
    pOdbcTest->out_win->append( txt );

    b_len = atoi( buffer_len->text().toAscii().constData() );
    if ( b_len < 1 )
    {
        b_len = 0;
    }

    if ( target_valid->isChecked())
    {
        buf = NULL;
    }
    else if ( b_len < 300 )
    {
        buf = new char[ 300 ];  
    }
    else
    {
        buf = new char[ b_len ];    
    }

    if ( buf )
    {
        txt.sprintf( "    Value Ptr: %p", buf );
        pOdbcTest->out_win->append( txt );
    }
    else
    {
        txt.sprintf( "    Value Ptr: SQL_NULL_POINTER" );
        pOdbcTest->out_win->append( txt );
    }

    txt.sprintf( "    Buffer Length: %d", b_len );
    pOdbcTest->out_win->append( txt );

    strlen_or_ind = -999999;

    if ( strlen_valid->isChecked())
    {
        strlen_ptr = NULL;
    }
    else
    {
        strlen_ptr = &strlen_or_ind;
    }

    if ( strlen_ptr )
    {
        txt.sprintf( "    Strlen Ptr: %p", strlen_ptr );
        pOdbcTest->out_win->append( txt );
    }
    else
    {
        txt.sprintf( "    Strlen Ptr: SQL_NULL_POINTER" );
        pOdbcTest->out_win->append( txt );
    }

    SQLRETURN ret = SQLGetConnectAttr( in_handle, attribute, 
                                       buf, b_len, strlen_ptr );

    pOdbcTest->out_win->append( "  Return:" );
    txt.sprintf( "    %s=%d", pOdbcTest->return_as_text( ret ), ret );
    pOdbcTest->out_win->append( txt );

    pOdbcTest->out_win->append( "  Out:" );
    if ( strlen_ptr )
    {
        if ( strlen_or_ind == -999999 )
        {
            txt.sprintf( "    *Strlen Ptr: <unchanged>" );
        }
        else
        {
            txt.sprintf( "    *Strlen Ptr: %d", strlen_or_ind );
        }
        pOdbcTest->out_win->append( txt );
    }

    if ( SQL_SUCCEEDED( ret ))
    {
        int index = types->currentIndex();
        switch ( conn_options[ index ].data_type )
        {
            case SQL_CHAR:
                txt.sprintf( "    *InfoValuePtr = \"%s\"", buf );
                pOdbcTest->out_win->append( txt );
                break;

            case SQL_INTEGER:
                SQLUINTEGER ival;
                memcpy( &ival, buf, sizeof( ival ));
                txt.sprintf( "    *ValuePtr = %d (0x%08X)", ival, ival );
                pOdbcTest->out_win->append( txt );

                if ( conn_options[ index ].values[ 0 ].text )
                {
                    if ( conn_options[ index ].is_bitmap )
                    {
                        int i;

                        for ( i = 0; conn_options[ index ].values[ i ].text; i ++ )
                        {
                            if ( conn_options[ index ].values[ i ].value & ival )
                            {
                                txt.sprintf( "        %s", 
                                             conn_options[ index ].values[ i ].text );
                                pOdbcTest->out_win->append( txt );
                            }
                        }
                    }
                    else
                    {
                        int i;

                        for ( i = 0; conn_options[ index ].values[ i ].text; i ++ )
                        {
                            if ( (SQLUINTEGER)(conn_options[ index ].values[ i ].value) == ival )
                            {
                                txt.sprintf( "        %s", 
                                             conn_options[ index ].values[ i ].text );
                                pOdbcTest->out_win->append( txt );
                            }
                        }
                    }
                }
                break;

            case SQL_SMALLINT:
                SQLSMALLINT sval;
                memcpy( &sval, buf, sizeof( sval ));
                txt.sprintf( "    *ValuePtr = %d (0x%04X)", sval, sval );
                pOdbcTest->out_win->append( txt );

                if ( conn_options[ index ].values[ 0 ].text )
                {
                    if ( conn_options[ index ].is_bitmap )
                    {
                        int i;

                        for ( i = 0; conn_options[ index ].values[ i ].text; i ++ )
                        {
                            if ( conn_options[ index ].values[ i ].value & sval )
                            {
                                txt.sprintf( "        %s", 
                                             conn_options[ index ].values[ i ].text );
                                pOdbcTest->out_win->append( txt );
                            }
                        }
                    }
                    else
                    {
                        int i;

                        for ( i = 0; conn_options[ index ].values[ i ].text; i ++ )
                        {
                            if ( conn_options[ index ].values[ i ].value == sval )
                            {
                                txt.sprintf( "        %s", 
                                             conn_options[ index ].values[ i ].text );
                                pOdbcTest->out_win->append( txt );
                            }
                        }
                    }
                }
                break;
        }       
    }

    if ( buf )
        delete buf;

    pOdbcTest->out_win->append( "" );
}

void dGetConnAttr::target_clkd()
{
    if ( target_valid->isChecked() )
        target_valid->setText( "ValuePtr: SQL_NULL_POINTER" );
    else
        target_valid->setText( "ValuePtr: VALID" );
}

void dGetConnAttr::strlen_clkd()
{
    if ( strlen_valid->isChecked() )
        strlen_valid->setText( "StrLen_Ptr: SQL_NULL_POINTER" );
    else
        strlen_valid->setText( "StrLen_Ptr: VALID" );
}

dGetConnAttr::dGetConnAttr( OdbcTest *pOdbcTest, QString name )
: QDialog( pOdbcTest )
{
    setWindowTitle( name );
    setModal( true );

    this->pOdbcTest = pOdbcTest;

    ok = new QPushButton( "OK", this );
    ok->setGeometry( 240,10, 70,25 );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry( 320,10, 70,25 );

    help = new QPushButton( "Help", this );
    help->setGeometry( 400,10, 70,25 );

    handles = new QComboBox( this ); // "Connection Handle"
    handles->setGeometry( 170, 50, 300, 20 );

    pOdbcTest->fill_handle_list( SQL_HANDLE_DBC, handles );

    types = new QComboBox( this ); // "Attribute"
    types->setGeometry( 170, 80, 300, 20 );

    pOdbcTest->fill_list_box( conn_options, types );

    l_handle = new QLabel( "Connection Handle:", this );
    l_handle->setGeometry( 10, 50, 130, 20 );

    l_types = new QLabel( "Attribute:", this );
    l_types->setGeometry( 10, 80, 130, 20 );

    target_valid = new QCheckBox( "ValuePtr: VALID", this );
    target_valid->setGeometry( 10, 110, 300, 15 );

    strlen_valid = new QCheckBox( "StrLen_Ptr: VALID", this );
    strlen_valid->setGeometry( 10, 140, 300, 15 );

    buffer_len = new QLineEdit( this ); // "Buffer Len"
    buffer_len->setGeometry( 400, 110, 70, 20 );
    buffer_len->setMaxLength( 6 );
    buffer_len->setText( "300" );

    l_buffer_len = new QLabel( "Buffer Len:", this );
    l_buffer_len->setGeometry( 320, 110, 60, 20 );

    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
    connect( ok, SIGNAL(clicked()), SLOT(Ok()) );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );
    connect( target_valid, SIGNAL( clicked()), this, SLOT( target_clkd()));
    connect( strlen_valid, SIGNAL( clicked()), this, SLOT( strlen_clkd()));
}

dGetConnAttr::~dGetConnAttr()
{
    delete ok;
    delete cancel;
    delete help;
    delete types;
    delete handles;
    delete l_handle;
    delete l_types;
    delete target_valid;
    delete strlen_valid;
    delete buffer_len;
    delete l_buffer_len;
}

void dSetConnectOption::Activated( int index )
{
    value->clear();

    if ( !conn_opt_options[ index ].values[ 0 ].text )
    {
        if ( conn_opt_options[ index ].data_type == SQL_CHAR )
        {
            value->insertItem( 0, "<null pointer>" );
            value->insertItem( 1, "" );
        }
        else
        {
            value->insertItem( 0, "0" );
        }
    }
    else
    {
        pOdbcTest->fill_list_box( conn_opt_options[ index ].values, value );
    }
}

void dSetConnectOption::Ok()
{
    SQLHANDLE in_handle = SQL_NULL_HDBC;
    SQLINTEGER attribute;
    SQLULEN vptr = 0;
    const char *tptr;
    attr_value *ptr;
    OdbcHandle *hand = pOdbcTest->extract_handle_list( SQL_HANDLE_DBC, handles );
    QString qtptr;

    if ( hand )
        in_handle = hand->getHandle();

    pOdbcTest->out_win->append( "SQLSetConnectOption():" );
    pOdbcTest->out_win->append( "  In:" );
    if ( in_handle )
        txt.sprintf( "    hdbc: %p", in_handle );
    else
        txt.sprintf( "    hdbc: SQL_NULL_HDBC" );
    pOdbcTest->out_win->append( txt );

    attribute = conn_opt_options[ types->currentIndex() ].attr;
    txt.sprintf( "    fOption: %s=%d", 
                 conn_opt_options[ types->currentIndex() ].text,
                 conn_opt_options[ types->currentIndex() ].attr );
    pOdbcTest->out_win->append( txt );

    qtptr = value->currentText();
    tptr = qtptr.toAscii().constData();

    /*
     * try and match the text
     */

    for ( ptr = conn_opt_options[ types->currentIndex() ].values; 
        ptr->text; ptr ++ )
    {
        if ( strncmp( ptr->text, tptr, strlen( ptr->text )) == 0 )
        {
            break;
        }
    }
    if ( !ptr->text )
    {
        // This can't be done on 64 bit with old definitions...
        if ( conn_opt_options[ types->currentIndex() ].data_type == SQL_CHAR )
        {
#if (SIZEOF_LONG_INT == 8)
#ifndef DO_YOU_KNOW_WHAT_YOUR_ARE_DOING
            fprintf( stderr, "unable to do this on this processor with 32 bit build options...\n" );
#else
            vptr = (SQLULEN) tptr;
#endif
#else
            vptr = (SQLULEN) tptr;
#endif
            if ( strncmp( "<null pointer>", tptr, 14 ) == 0 )
            {
                vptr = 0;
                txt.sprintf( "    vParam: SQL_NULL_POINTER" );
            }
            else
            {
#if (SIZEOF_LONG_INT == 8)
#ifndef DO_YOU_KNOW_WHAT_YOUR_ARE_DOING
                fprintf( stderr, "unable to do this on this processor with 32 bit build options...\n" );
#else
                vptr = (SQLULEN) tptr;
#endif
#else
                vptr = (SQLULEN) tptr;
#endif
                txt.sprintf( "    vParam: %s", tptr );
            }
        }
        else
        {
            vptr = (SQLULEN) atoi( tptr );
            txt.sprintf( "    vParam: %d", atoi( tptr ));
        }
    }
    else
    {
        vptr = (SQLULEN) ptr->value;
        txt.sprintf( "    vParam: %s=%d", ptr->text, ptr->value );
    }

    pOdbcTest->out_win->append( txt );

    SQLRETURN ret = SQLSetConnectOption( in_handle, attribute, vptr );

    pOdbcTest->out_win->append( "  Return:" );
    txt.sprintf( "    %s=%d", pOdbcTest->return_as_text( ret ), ret );
    pOdbcTest->out_win->append( txt );
    pOdbcTest->out_win->append( "" );
}

dSetConnectOption::dSetConnectOption( OdbcTest *pOdbcTest, QString name )
: QDialog( pOdbcTest )
{
    setWindowTitle( name );
    setModal( true );

    this->pOdbcTest = pOdbcTest;

    ok = new QPushButton( "OK", this );
    ok->setGeometry( 240,10, 70,25 );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry( 320,10, 70,25 );

    help = new QPushButton( "Help", this );
    help->setGeometry( 400,10, 70,25 );

    handles = new QComboBox( this ); // "Statement Handle"
    handles->setGeometry( 170, 50, 300, 20 );

    pOdbcTest->fill_handle_list( SQL_HANDLE_STMT, handles );

    types = new QComboBox( this ); // "Attribute"
    types->setGeometry( 170, 80, 300, 20 );

    pOdbcTest->fill_list_box( conn_opt_options, types );

    value = new QComboBox( this ); // "Value"
    value->setGeometry( 170, 110, 300, 20 );
    pOdbcTest->fill_list_box( conn_opt_options[ 0 ].values, value );

    l_handle = new QLabel( "hdbc:", this );
    l_handle->setGeometry( 10, 50, 130, 20 );

    l_types = new QLabel( "fOption:", this );
    l_types->setGeometry( 10, 80, 130, 20 );

    l_value = new QLabel( "vParam:", this );
    l_value->setGeometry( 10, 110, 130, 20 );

    Activated( 0 );

    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
    connect( ok, SIGNAL(clicked()), SLOT(Ok()) );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );
    connect( types, SIGNAL(activated(int)), this, SLOT( Activated(int)));
}

dSetConnectOption::~dSetConnectOption()
{
    delete ok;
    delete cancel;
    delete help;
    delete types;
    delete handles;
    delete value;
    delete l_handle;
    delete l_types;
    delete l_value;
}

void dGetConnectOption::Ok()
{
    SQLHANDLE in_handle = SQL_NULL_HENV;
    SQLINTEGER attribute, value;
    SQLPOINTER vptr;
    OdbcHandle *hand = pOdbcTest->extract_handle_list( SQL_HANDLE_DBC, handles );
    int index = types->currentIndex();
    char *buf = NULL;

    if ( hand )
        in_handle = hand->getHandle();

    pOdbcTest->out_win->append( "SQLGetConnectOption():" );
    pOdbcTest->out_win->append( "  In:" );
    if ( in_handle )
        txt.sprintf( "    hdbc: %p", in_handle );
    else
        txt.sprintf( "    hdbc: SQL_NULL_HDBC" );
    pOdbcTest->out_win->append( txt );

    attribute = conn_gopt_options[ types->currentIndex() ].attr;
    txt.sprintf( "    fOption: %s=%d", 
                 conn_gopt_options[ types->currentIndex() ].text,
                 conn_gopt_options[ types->currentIndex() ].attr );
    pOdbcTest->out_win->append( txt );

    if ( target_valid->isChecked())
    {
        buf = NULL;
        vptr = NULL;
    }
    else
    {
        if ( conn_gopt_options[ index ].data_type == SQL_INTEGER )
        {
            vptr = &value;
        }
        else
        {
            buf = new char[ 300 ];  
            vptr = buf;
        }
    }

    if ( vptr )
    {
        txt.sprintf( "    vParam: %p", vptr );
        pOdbcTest->out_win->append( txt );
    }
    else
    {
        txt.sprintf( "    vParam: SQL_NULL_POINTER" );
        pOdbcTest->out_win->append( txt );
    }

    SQLRETURN ret = SQLGetConnectOption( in_handle, attribute, 
                                         vptr );

    pOdbcTest->out_win->append( "  Return:" );
    txt.sprintf( "    %s=%d", pOdbcTest->return_as_text( ret ), ret );
    pOdbcTest->out_win->append( txt );

    pOdbcTest->out_win->append( "  Out:" );

    if ( SQL_SUCCEEDED( ret ))
    {
        if ( vptr )
        {
            switch ( conn_gopt_options[ index ].data_type )
            {
                case SQL_INTEGER:
                    {
                        int i;

                        txt.sprintf( "    *vptr = 0x%08X", value );
                        pOdbcTest->out_win->append( txt );

                        for ( i = 0; conn_gopt_options[ index ].values[ i ].text; i ++ )
                        {
                            if ( conn_gopt_options[ index ].values[ i ].value == value )
                            {
                                txt.sprintf( "        %s", 
                                             conn_gopt_options[ index ].values[ i ].text );
                                pOdbcTest->out_win->append( txt );
                            }
                        }
                        break;
                    }

                default:
                    txt.sprintf( "    *vptr = %s", buf );
                    break;
            }
        }
    }

    if ( buf )
        delete buf;

    pOdbcTest->out_win->append( "" );
}

void dGetConnectOption::target_clkd()
{
    if ( target_valid->isChecked() )
        target_valid->setText( "vParam: SQL_NULL_POINTER" );
    else
        target_valid->setText( "vParam: VALID" );
}

dGetConnectOption::dGetConnectOption( OdbcTest *pOdbcTest, QString name )
: QDialog( pOdbcTest )
{
    setWindowTitle( name );
    setModal( true );

    this->pOdbcTest = pOdbcTest;

    ok = new QPushButton( "OK", this );
    ok->setGeometry( 240,10, 70,25 );

    cancel = new QPushButton( "Cancel", this );
    cancel->setGeometry( 320,10, 70,25 );

    help = new QPushButton( "Help", this );
    help->setGeometry( 400,10, 70,25 );

    handles = new QComboBox( this ); // "hdbc"
    handles->setGeometry( 170, 50, 300, 20 );

    pOdbcTest->fill_handle_list( SQL_HANDLE_DBC, handles );

    types = new QComboBox( this ); // "fOption"
    types->setGeometry( 170, 80, 300, 20 );

    pOdbcTest->fill_list_box( conn_gopt_options, types );

    l_handle = new QLabel( "hstmt:", this );
    l_handle->setGeometry( 10, 50, 130, 20 );

    l_types = new QLabel( "fOption:", this );
    l_types->setGeometry( 10, 80, 130, 20 );

    target_valid = new QCheckBox( "vParam: VALID", this );
    target_valid->setGeometry( 10, 110, 300, 15 );

    connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
    connect( ok, SIGNAL(clicked()), SLOT(Ok()) );
    connect( ok, SIGNAL(clicked()), SLOT(accept()) );
    connect( target_valid, SIGNAL( clicked()), this, SLOT( target_clkd()));
}

dGetConnectOption::~dGetConnectOption()
{
    delete ok;
    delete cancel;
    delete help;
    delete types;
    delete handles;
    delete l_handle;
    delete l_types;
    delete target_valid;
}

void OdbcTest::slotSetStmtAttr()
{
    dSetStmtAttr *dlg = new dSetStmtAttr( this, "SQLSetStmtAttr" );

    dlg->exec();

    delete dlg;
}

void OdbcTest::slotGetStmtAttr()
{
    dGetStmtAttr *dlg = new dGetStmtAttr( this, "SQLGetStmtAttr" );

    dlg->exec();

    delete dlg;
}

void OdbcTest::slotSetConnectAttr()
{
    dSetConnAttr *dlg = new dSetConnAttr( this, "SQLSetConnectAttr" );

    dlg->exec();

    delete dlg;
}

void OdbcTest::slotGetConnectAttr()
{
    dGetConnAttr *dlg = new dGetConnAttr( this, "SQLGetConnectAttr" );

    dlg->exec();

    delete dlg;
}

void OdbcTest::slotSetEnvAttr()
{
    dSetEnvAttr *dlg = new dSetEnvAttr( this, "SQLSetEnvAttr" );

    dlg->exec();

    delete dlg;
}

void OdbcTest::slotGetEnvAttr()
{
    dGetEnvAttr *dlg = new dGetEnvAttr( this, "SQLGetEnvAttr" );

    dlg->exec();

    delete dlg;
}

void OdbcTest::slotSetStmtOption()
{
    dSetStmtOption *dlg = new dSetStmtOption( this, "SQLSetStmtOption" );

    dlg->exec();

    delete dlg;
}

void OdbcTest::slotGetStmtOption()
{
    dGetStmtOption *dlg = new dGetStmtOption( this, "SQLGetStmtOption" );

    dlg->exec();

    delete dlg;
}

void OdbcTest::slotSetConnectOption()
{
    dSetConnectOption *dlg = new dSetConnectOption( this, "SQLSetConnectOption" );

    dlg->exec();

    delete dlg;
}

void OdbcTest::slotGetConnectOption()
{
    dGetConnectOption *dlg = new dGetConnectOption( this, "SQLGetConnectOption" );

    dlg->exec();

    delete dlg;
}

void OdbcTest::slotSetCursorAttributes()
{
    QMessageBox::about( this, "ODBC Test",
                        "Not yet implemented" );
}

