import QtQuick 2.12
import QtQuick.Layouts 1.12
import QtQuick.Controls 2.12
import org.ukui.panel.items 1.0
import org.ukui.windowThumbnail 1.0

ListView {
    id: mprisView
    interactive: false
    model: mprisModel
    delegate: Loader {
        property var artUrl: model.MetaData["mpris:artUrl"]
        property var title: model.MetaData["xesam:title"]
        property var artist: model.MetaData["xesam:artist"]
        property var playbackStatus: model.PlaybackStatus

        anchors.horizontalCenter: parent.horizontalCenter

        sourceComponent: {
            return thumbanilComponent;
//            if (artUrl) {
//                return artUrlComponent;
//            } else {
//                return thumbanilComponent;
//            }
        }
    }

    Component {
        id: artUrlComponent
        Item {
            width: 304
            height: 96

            RowLayout {
                height: parent.height
                width: height * 3
                Image {
                    id: artUrlImage
                    Layout.fillHeight: true
                    Layout.preferredWidth: artUrlImage.height
                    source: artUrl
                }

                BlurItem {
                    Layout.fillHeight: true
                    Layout.fillWidth: true
                    ColumnLayout {
                        anchors.fill: parent
                        anchors.leftMargin: 24
                        anchors.rightMargin: 24
                        anchors.bottomMargin: 10
                        Text {
                            Layout.fillWidth: true
                            text: title
                            elide: Text.ElideRight
                            verticalAlignment: Text.AlignVCenter
                        }
                        Text {
                            Layout.fillWidth: true
                            text: artist
                            elide: Text.ElideRight
                            verticalAlignment: Text.AlignVCenter
                        }
                        Loader {
                            Layout.fillWidth: true
                            Layout.preferredHeight: 28
                            property var playStatus: playbackStatus
                            sourceComponent: buttonArea
                        }
                    }
                }
            }
        }
    }

    Component {
        id: thumbanilComponent
        Item {
            width: 256
            height: 144
            Loader {
                id: thumbnailLoader
                anchors.fill: parent
                sourceComponent: {
                    if (windowThumbnailConfig.pipewireThumbnailEnable) {
                        return piperWireThumbnailComponent;
                    } else {
                        return x11ThumbnailComponent;
                    }
                }
            }
            BlurItem {
                x: buttonBase.x
                y: buttonBase.y
                width: buttonBase.width
                height: buttonBase.height
                radius: 4
                blurRadius: 40
                samples: 81
                source: thumbnailLoader
            }

            Loader {
                id: buttonBase
                height: 28
                width: 128
                z: 10
                anchors.bottom: parent.bottom
                anchors.bottomMargin: 16
                anchors.horizontalCenter: parent.horizontalCenter
                property var playStatus: playbackStatus
                sourceComponent: buttonArea
            }
        }

    }

    Component {
        id: buttonArea
        StyleBackground {
            useStyleTransparency: false
            paletteRole: PaletteRole.Base
            alpha: 0.65
            radius: 4

            RowLayout {
                anchors.fill: parent
                MouseArea {
                    Layout.preferredHeight: 28
                    Layout.fillWidth: true
                    onClicked: {
                        mprisModel.operation(mprisView.model.index(index, 0), MprisProperties.Previous, [])
                    }

                    ThemeIcon {
                        height: 16
                        width: 16
                        anchors.centerIn: parent
                        source: "media-skip-backward-symbolic"
                    }
                }

                MouseArea {
                    Layout.preferredHeight: 28
                    Layout.fillWidth: true
                    onClicked: {
                        mprisModel.operation(mprisView.model.index(index, 0), MprisProperties.PlayPause, [])
                    }
                    ThemeIcon {
                        id: playStatusIcon
                        height: 16
                        width: 16
                        anchors.centerIn: parent
                        source: playStatus === "Playing" ? "media-playback-pause-symbolic" : "ukui-play-full-symbolic"
                    }
                }

                MouseArea {
                    Layout.preferredHeight: 28
                    Layout.fillWidth: true
                    onClicked: {
                        mprisModel.operation(mprisView.model.index(index, 0), MprisProperties.Next, [])
                    }
                    ThemeIcon {
                        height: 16
                        width: 16
                        anchors.centerIn: parent
                        source: "media-skip-forward-symbolic"
                    }
                }
            }
        }
    }
}
