//: version "2.0"
//: property title = "welcome_tut.v"
//: property useExtBars = 0

module ALU(F, A, B, Z);
//: interface  /sz:(89, 65) /bd:[ Ti0>B[7:0](67/89) Ti1>A[7:0](20/89) Li0>F[1:0](28/65) Bo0<Z[7:0](44/89) ]
input [7:0] B;    //: /sn:0 {0}(342,147)(342,184){1}
//: {2}(344,186)(367,186){3}
//: {4}(371,186)(425,186)(425,258){5}
//: {6}(369,188)(369,261){7}
//: {8}(342,188)(342,258){9}
input [1:0] F;    //: /sn:0 /dp:1 {0}(343,353)(214,353){1}
supply0 w0;    //: /sn:0 {0}(491,295)(491,272)(465,272){1}
input [7:0] A;    //: /sn:0 {0}(265,147)(265,215){1}
//: {2}(267,217)(345,217){3}
//: {4}(349,217)(372,217){5}
//: {6}(376,217)(457,217)(457,258){7}
//: {8}(374,219)(374,261){9}
//: {10}(347,219)(347,258){11}
//: {12}(265,219)(265,322)(348,322)(348,337){13}
output [7:0] Z;    //: /sn:0 {0}(366,404)(366,366){1}
wire [7:0] w14;    //: /sn:0 {0}(345,279)(345,310)(360,310)(360,337){1}
wire w4;    //: /sn:0 {0}(417,272)(407,272){1}
wire [7:0] w11;    //: /sn:0 {0}(372,282)(372,337){1}
wire [7:0] w10;    //: /sn:0 /dp:1 {0}(384,337)(384,307)(441,307)(441,287){1}
//: enddecls

  add g4 (.A(B), .B(A), .S(w10), .CI(w0), .CO(w4));   //: @(441,274) /sn:0 /w:[ 5 7 1 1 0 ]
  //: joint g8 (A) @(347, 217) /w:[ 4 -1 3 10 ]
  //: input g3 (F) @(212,353) /sn:0 /w:[ 1 ]
  //: supply0 g13 (w0) @(491,301) /sn:0 /w:[ 0 ]
  //: input g2 (A) @(265,145) /sn:0 /R:3 /w:[ 0 ]
  //: input g1 (B) @(342,145) /sn:0 /R:3 /w:[ 0 ]
  //: joint g11 (B) @(369, 186) /w:[ 4 -1 3 6 ]
  //: joint g10 (A) @(374, 217) /w:[ 6 -1 5 8 ]
  and g6 (.I0(B), .I1(A), .Z(w11));   //: @(372,272) /sn:0 /R:3 /w:[ 7 9 0 ]
  or g7 (.I0(B), .I1(A), .Z(w14));   //: @(345,269) /sn:0 /R:3 /w:[ 9 11 0 ]
  //: joint g9 (A) @(265, 217) /w:[ 2 1 -1 12 ]
  //: output g5 (Z) @(366,401) /sn:0 /R:3 /w:[ 0 ]
  mux g0 (.I0(A), .I1(w14), .I2(w11), .I3(w10), .S(F), .Z(Z));   //: @(366,353) /sn:0 /w:[ 13 1 1 0 0 1 ] /ss:0 /do:0
  //: joint g12 (B) @(342, 186) /w:[ 2 1 -1 8 ]

endmodule

module REGS(SB, SA, BOUT, AOUT, ck, AIN);
//: interface  /sz:(94, 80) /bd:[ Ti0>AIN[7:0](46/94) Li0>ck(56/80) Li1>SB[1:0](34/80) Li2>SA[1:0](14/80) Bo0<BOUT[7:0](79/94) Bo1<AOUT[7:0](16/94) ]
supply1 w0;    //: /sn:0 /dp:1 {0}(361,358)(373,358)(373,339){1}
supply1 w21;    //: /sn:0 /dp:1 {0}(260,211)(181,211)(181,173){1}
input [1:0] SB;    //: /sn:0 {0}(507,507)(570,507){1}
supply1 w1;    //: /sn:0 /dp:1 {0}(506,358)(519,358)(519,339){1}
output [7:0] BOUT;    //: /sn:0 {0}(593,549)(593,520){1}
input [1:0] SA;    //: /sn:0 {0}(382,507)(92,507)(92,138){1}
//: {2}(94,136)(284,136)(284,198){3}
//: {4}(90,136)(47,136){5}
supply1 w2;    //: /sn:0 /dp:1 {0}(219,357)(231,357)(231,340){1}
input [7:0] AIN;    //: /sn:0 {0}(467,144)(467,285){1}
//: {2}(469,287)(626,287)(626,353){3}
//: {4}(465,287)(324,287){5}
//: {6}(320,287)(180,287)(180,352){7}
//: {8}(322,289)(322,353){9}
//: {10}(467,289)(467,353){11}
output [7:0] AOUT;    //: /sn:0 /dp:1 {0}(405,520)(405,549){1}
input ck;    //: /sn:0 {0}(51,392)(124,392){1}
//: {2}(128,392)(273,392){3}
//: {4}(277,392)(412,392){5}
//: {6}(416,392)(574,392)(574,363)(589,363){7}
//: {8}(414,390)(414,363)(430,363){9}
//: {10}(275,390)(275,363)(285,363){11}
//: {12}(126,390)(126,362)(143,362){13}
supply1 w5;    //: /sn:0 /dp:1 {0}(665,358)(680,358)(680,340){1}
wire w4;    //: /sn:0 {0}(290,227)(290,266)(555,266)(555,368)(506,368){1}
wire w3;    //: /sn:0 {0}(278,227)(278,281)(404,281)(404,368)(361,368){1}
wire [7:0] R2;    //: /dp:4 {0}(411,491)(411,432)(465,432){1}
//: {2}(469,432)(599,432)(599,491){3}
//: {4}(467,430)(467,374){5}
wire w20;    //: /sn:0 {0}(302,227)(302,248)(712,248)(712,368)(665,368){1}
wire [7:0] R1;    //: /dp:5 {0}(399,491)(399,422){1}
//: {2}(401,420)(587,420)(587,491){3}
//: {4}(397,420)(322,420)(322,374){5}
wire [7:0] R3;    //: /dp:3 {0}(423,491)(423,447)(609,447){1}
//: {2}(613,447)(626,447)(626,374){3}
//: {4}(611,449)(611,491){5}
wire w8;    //: /sn:0 /dp:1 {0}(219,367)(266,367)(266,227){1}
wire [7:0] R0;    //: /dp:3 {0}(575,491)(575,460)(389,460){1}
//: {2}(385,460)(180,460)(180,373){3}
//: {4}(387,462)(387,491){5}
//: enddecls

  //: input g4 (SB) @(505,507) /sn:0 /w:[ 0 ]
  register g8 (.Q(R3), .D(AIN), .EN(w20), .CLR(w5), .CK(ck));   //: @(626,363) /sn:0 /w:[ 3 3 1 0 7 ]
  //: input g3 (SA) @(45,136) /sn:0 /w:[ 5 ]
  mux g13 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SB), .Z(BOUT));   //: @(593,507) /sn:0 /w:[ 0 3 3 5 1 1 ] /ss:0 /do:0
  //: output g2 (BOUT) @(593,546) /sn:0 /R:3 /w:[ 0 ]
  //: output g1 (AOUT) @(405,546) /sn:0 /R:3 /w:[ 1 ]
  //: joint g11 (ck) @(275, 392) /w:[ 4 10 3 -1 ]
  //: joint g16 (R0) @(387, 460) /w:[ 1 -1 2 4 ]
  //: supply1 g10 (w21) @(192,173) /sn:0 /w:[ 1 ]
  //: joint g19 (R1) @(399, 420) /w:[ 2 -1 4 1 ]
  //: joint g27 (ck) @(126, 392) /w:[ 2 12 1 -1 ]
  register g6 (.Q(R1), .D(AIN), .EN(w3), .CLR(w0), .CK(ck));   //: @(322,363) /sn:0 /w:[ 5 9 1 0 11 ]
  register g7 (.Q(R2), .D(AIN), .EN(w4), .CLR(w1), .CK(ck));   //: @(467,363) /sn:0 /w:[ 5 11 1 0 9 ]
  demux g9 (.I(SA), .E(w21), .Z0(!w8), .Z1(!w3), .Z2(!w4), .Z3(!w20));   //: @(284,211) /sn:0 /w:[ 3 0 1 0 0 0 ] /ss:0 /do:0
  //: joint g20 (SA) @(92, 136) /w:[ 2 -1 4 1 ]
  register g15 (.Q(R0), .D(AIN), .EN(w8), .CLR(w2), .CK(ck));   //: @(180,362) /sn:0 /w:[ 3 7 0 0 13 ]
  //: joint g17 (R3) @(611, 447) /w:[ 2 -1 1 4 ]
  //: supply1 g25 (w2) @(242,340) /sn:0 /w:[ 1 ]
  //: input g5 (ck) @(49,392) /sn:0 /w:[ 0 ]
  mux g14 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SA), .Z(AOUT));   //: @(405,507) /sn:0 /w:[ 5 0 0 0 0 0 ] /ss:0 /do:0
  //: supply1 g21 (w0) @(384,339) /sn:0 /w:[ 1 ]
  //: joint g24 (AIN) @(467, 287) /w:[ 2 1 4 10 ]
  //: supply1 g23 (w5) @(691,340) /sn:0 /w:[ 1 ]
  //: input g0 (AIN) @(467,142) /sn:0 /R:3 /w:[ 0 ]
  //: supply1 g22 (w1) @(530,339) /sn:0 /w:[ 1 ]
  //: joint g26 (AIN) @(322, 287) /w:[ 5 -1 6 8 ]
  //: joint g12 (ck) @(414, 392) /w:[ 6 8 5 -1 ]
  //: joint g18 (R2) @(467, 432) /w:[ 2 4 1 -1 ]

endmodule

module main;    //: root_module
supply1 w7;    //: /sn:0 {0}(462,80)(462,67){1}
supply0 w2;    //: /sn:0 {0}(501,185)(501,200)(464,200){1}
//: {2}(460,200)(429,200)(429,184){3}
//: {4}(462,202)(462,212){5}
wire [7:0] w6;    //: /sn:0 /dp:1 {0}(160,269)(160,257)(220,257){1}
//: {2}(224,257)(266,257)(266,553)(144,553)(144,530){3}
//: {4}(222,255)(222,244){5}
wire b;    //: /dp:1 {0}(70,101)(106,101){1}
//: {2}(108,99)(108,71)(124,71){3}
//: {4}(108,103)(108,147)(136,147){5}
wire s0;    //: {0}(755,89)(773,89)(773,106){1}
wire w4;    //: /sn:0 /dp:1 {0}(202,145)(157,145){1}
wire [7:0] w15;    //: /sn:0 /dp:1 {0}(197,356)(197,327)(220,327){1}
//: {2}(224,327)(247,327)(247,544)(207,544)(207,530){3}
//: {4}(222,325)(222,312){5}
wire co0;    //: {0}(758,160)(771,160)(771,149){1}
wire w3;    //: /sn:0 /dp:1 {0}(202,140)(172,140)(172,124){1}
wire w0;    //: /sn:0 {0}(363,88)(435,88){1}
//: {2}(439,88)(448,88){3}
//: {4}(437,86)(437,78){5}
//: {6}(437,90)(437,176)(487,176){7}
wire [1:0] w21;    //: /sn:0 {0}(84,445)(101,445)(101,463)(127,463){1}
wire ci0;    //: {0}(605,47)(709,47)(709,89){1}
//: {2}(711,91)(734,91){3}
//: {4}(709,93)(709,120){5}
wire w28;    //: /sn:0 {0}(86,285)(127,285){1}
wire [1:0] w23;    //: /sn:0 /dp:1 {0}(127,483)(100,483)(100,495)(86,495){1}
wire w1;    //: /sn:0 {0}(362,122)(398,122){1}
//: {2}(402,122)(448,122){3}
//: {4}(400,120)(400,113){5}
//: {6}(400,124)(400,175)(415,175){7}
wire co;    //: /dp:1 {0}(223,143)(236,143)(236,132){1}
wire [7:0] w25;    //: /sn:0 {0}(107,225)(140,225)(140,269){1}
wire w8;    //: /sn:0 /dp:1 {0}(199,69)(171,69){1}
//: {2}(167,69)(145,69){3}
//: {4}(169,71)(169,103){5}
wire a0;    //: {0}(605,83)(647,83){1}
//: {2}(651,83)(659,83){3}
//: {4}(649,85)(649,159)(671,159){5}
wire [7:0] w17;    //: /sn:0 {0}(174,448)(174,423){1}
wire b0;    //: {0}(605,118)(641,118){1}
//: {2}(643,116)(643,88)(659,88){3}
//: {4}(643,120)(643,164)(671,164){5}
wire w11;    //: /sn:0 {0}(734,86)(706,86){1}
//: {2}(702,86)(680,86){3}
//: {4}(704,88)(704,120){5}
wire ci;    //: {0}(70,30)(174,30)(174,72){1}
//: {2}(176,74)(199,74){3}
//: {4}(174,76)(174,103){5}
wire w10;    //: /sn:0 {0}(737,162)(692,162){1}
wire ck;    //: /sn:0 {0}(60,551)(114,551)(114,505)(127,505){1}
wire s;    //: /dp:1 {0}(220,72)(238,72)(238,89){1}
wire w13;    //: /sn:0 {0}(429,167)(429,148)(460,148){1}
//: {2}(464,148)(499,148){3}
//: {4}(501,146)(501,136){5}
//: {6}(501,150)(501,168){7}
//: {8}(462,146)(462,131){9}
wire a;    //: {0}(70,66)(112,66){1}
//: {2}(116,66)(124,66){3}
//: {4}(114,68)(114,142)(136,142){5}
wire w5;    //: /sn:0 /dp:1 {0}(462,97)(462,114){1}
wire [7:0] w29;    //: /sn:0 /dp:1 {0}(150,356)(150,298){1}
wire w9;    //: /sn:0 {0}(737,157)(707,157)(707,141){1}
wire [1:0] w26;    //: /sn:0 /dp:1 {0}(86,348)(107,348)(107,385)(129,385){1}
//: enddecls

  //: supply1 g8 (w7) @(473,67) /sn:0 /w:[ 1 ]
  nmos g4 (.Z(w2), .S0(w13), .G0(w0));   //: @(495,176) /sn:0 /w:[ 0 7 7 ]
  //: joint g37 (b0) @(643, 118) /w:[ -1 2 1 4 ]
  //: joint g58 (w6) @(222, 257) /w:[ 2 4 1 -1 ]
  led g55 (.I(w0));   //: @(437,71) /sn:0 /w:[ 5 ] /type:0
  or g34 (.I0(w3), .I1(w4), .Z(co));   //: @(213,143) /sn:0 /w:[ 0 0 0 ]
  //: joint g13 (w1) @(400, 122) /w:[ 2 4 1 6 ]
  //: switch g3 (w0) @(346,88) /sn:0 /w:[ 0 ] /st:0
  clock g51 (.Z(ck));   //: @(47,551) /sn:0 /w:[ 0 ] /omega:200 /phi:0 /duty:50
  led g2 (.I(co0));   //: @(771,142) /sn:0 /w:[ 1 ] /type:0
  led g59 (.I(w15));   //: @(222,305) /sn:0 /w:[ 5 ] /type:2
  or g1 (.I0(w9), .I1(w10), .Z(co0));   //: @(748,160) /sn:0 /w:[ 0 0 0 ]
  //: joint g16 (w11) @(704, 86) /w:[ 1 -1 2 4 ]
  //: joint g11 (w2) @(462, 200) /w:[ 1 -1 2 4 ]
  and g28 (.I0(a), .I1(b), .Z(w4));   //: @(147,145) /sn:0 /w:[ 5 5 1 ]
  //: supply0 g10 (w2) @(462,218) /sn:0 /w:[ 5 ]
  led g50 (.I(co));   //: @(236,125) /sn:0 /w:[ 1 ] /type:0
  //: joint g32 (w8) @(169, 69) /w:[ 1 -1 2 4 ]
  //: switch g27 (ci) @(53,30) /sn:0 /w:[ 0 ] /st:0
  //: joint g19 (w0) @(437, 88) /w:[ 2 4 1 6 ]
  //: joint g38 (ci0) @(709, 91) /w:[ 2 1 -1 4 ]
  nmos g6 (.Z(w2), .S0(w13), .G0(w1));   //: @(423,175) /sn:0 /w:[ 3 0 7 ]
  //: dip sa (w21) @(46,445) /R:1 /w:[ 0 ] /st:0
  //: joint g57 (w13) @(501, 148) /w:[ -1 4 3 6 ]
  //: joint g9 (w13) @(462, 148) /w:[ 2 8 1 -1 ]
  pmos g7 (.Z(w7), .S0(w5), .G0(w0));   //: @(456,88) /sn:0 /w:[ 0 0 3 ]
  mux g53 (.I0(w25), .I1(w6), .S(w28), .Z(w29));   //: @(150,285) /sn:0 /w:[ 1 0 1 1 ] /ss:0 /do:0
  //: joint g20 (a0) @(649, 83) /w:[ 2 -1 1 4 ]
  //: switch g15 (ci0) @(588,47) /sn:0 /w:[ 0 ] /st:0
  and g31 (.I0(w8), .I1(ci), .Z(w3));   //: @(172,114) /sn:0 /R:3 /tech:unit /w:[ 5 5 1 ]
  //: dip sb (w23) @(48,495) /R:1 /w:[ 1 ] /st:1
  ALU alu (.B(w15), .A(w29), .F(w26), .Z(w17));   //: @(130, 357) /sz:(89, 65) /p:[ Ti0>0 Ti1>0 Li0>1 Bo0<1 ]
  REGS regs (.AIN(w17), .ck(ck), .SB(w23), .SA(w21), .BOUT(w15), .AOUT(w6));   //: @(128, 449) /sz:(94, 80) /p:[ Ti0>0 Li0>1 Li1>0 Li2>1 Bo0<3 Bo1<3 ]
  //: dip func (w26) @(48,348) /R:1 /w:[ 0 ] /st:0
  and g17 (.I0(w11), .I1(ci0), .Z(w9));   //: @(707,131) /sn:0 /R:3 /tech:unit /w:[ 5 5 1 ]
  led g62 (.I(w6));   //: @(222,237) /sn:0 /w:[ 5 ] /type:2
  //: joint g29 (a) @(114, 66) /w:[ 2 -1 1 4 ]
  //: switch g25 (a) @(53,66) /sn:0 /w:[ 0 ] /st:0
  led g52 (.I(s));   //: @(238,96) /sn:0 /R:2 /w:[ 1 ] /type:0
  //: dip data_in (w25) @(69,225) /R:1 /w:[ 0 ] /st:11
  and g14 (.I0(a0), .I1(b0), .Z(w10));   //: @(682,162) /sn:0 /w:[ 5 5 1 ]
  led g56 (.I(w13));   //: @(501,129) /sn:0 /w:[ 5 ] /type:0
  pmos g5 (.Z(w5), .S0(w13), .G0(w1));   //: @(456,122) /sn:0 /w:[ 1 9 3 ]
  //: switch g36 (b0) @(588,118) /sn:0 /w:[ 0 ] /st:1
  led g21 (.I(s0));   //: @(773,113) /sn:0 /R:2 /w:[ 1 ] /type:0
  xor g24 (.I0(w8), .I1(ci), .Z(s));   //: @(210,72) /sn:0 /w:[ 0 3 0 ]
  xor g23 (.I0(a), .I1(b), .Z(w8));   //: @(135,69) /sn:0 /w:[ 3 3 3 ]
  //: joint g60 (w15) @(222, 327) /w:[ 2 4 1 -1 ]
  led g54 (.I(w1));   //: @(400,106) /sn:0 /w:[ 5 ] /type:0
  xor g35 (.I0(a0), .I1(b0), .Z(w11));   //: @(670,86) /sn:0 /w:[ 3 3 3 ]
  xor g22 (.I0(w11), .I1(ci0), .Z(s0));   //: @(745,89) /sn:0 /w:[ 0 3 0 ]
  //: switch g26 (b) @(53,101) /sn:0 /w:[ 0 ] /st:1
  //: comment g0 @(328,285)
  //: /line:"<h1 color=blue>TkGate <value-of name=\"tkgate-version\">ؤ褦!</h1>"
  //: /line:""
  //: /line:"<value-of name=\"tkgate-copyright\">"
  //: /line:"  TKGate comes with ABSOLUTELY NO WARRANTY; see 'Help...License' menu"
  //: /line:"  for license and warranty details.  Report problems to <value-of name=\"tkgate-mailcontact\">"
  //: /line:""
  //: /line:"ʲΥ󥯤ˤ줫åƲ"
  //: /line:""
  //: /line:"   <a href=\"create_tut.v\">塼ȥꥢԤ</a>"
  //: /line:""
  //: /line:"   <a href=\"action:new\">ϩԽ롣</a>"
  //: /line:""
  //: /line:"   <a href=\"http://www.tkgate.org/1.8\"><value-of name=\"tkgate-homepage\">ˤɥȤ򸫤롣</a>"
  //: /end
  //: switch data_select (w28) @(69,285) /w:[ 0 ] /st:0
  //: switch g18 (a0) @(588,83) /sn:0 /w:[ 0 ] /st:0
  //: switch g12 (w1) @(345,122) /sn:0 /w:[ 0 ] /st:0
  //: joint g33 (ci) @(174, 74) /w:[ 2 1 -1 4 ]
  //: joint g30 (b) @(108, 101) /w:[ -1 2 1 4 ]

endmodule
