# pst-eucl package
# Matthew Bertucci 2/23/2022 for v4.34a

#include:pstricks
#include:pst-node
#include:pst-tools
#include:pst-calculate
#include:pst-arrow
#include:pst-plot
#include:multido

#keyvals:\usepackage/pst-eucl#c
old
#endkeyvals

\pstGeonode(%<x1,y1%>){%<A1%>}%<...(xn,yn){An}%>
\pstGeonode[%<options%>](%<x1,y1%>){%<A1%>}%<...(xn,yn){An}%>
\pstAbscissa{A}
\pstOrdinate{A}
\pstMoveNode(dx,dy){A}{B}
\pstMoveNode[options%keyvals](dx,dy){A}{B}
\pstOIJGeonode(%<x1,y1%>){%<A1%>}{%<O%>}{%<I%>}{%<J%>}(%<x2,y2%>){%<A2%>}%<...(xn,yn){An}%>
\pstOIJGeonode[%<options%>](%<x1,y1%>){%<A1%>}{%<O%>}{%<I%>}{%<J%>}(%<x2,y2%>){%<A2%>}%<...(xn,yn){An}%>
\pstSegmentMark{A}{B}
\pstSegmentMark[options%keyvals]{A}{B}
\pstLabelAB{A}{B}{label}
\pstLabelAB[options%keyvals]{A}{B}{label}
\pstLabelAB*{A}{B}{label}
\pstLabelAB*[options%keyvals]{A}{B}{label}
\pstTriangle(x1,y1){A}(x2,y2){B}(x3,y3){C}
\pstTriangle[options%keyvals](x1,y1){A}(x2,y2){B}(x3,y3){C}
\pstTriangleSSS(pos){A}(a,b,c){B}{C}
\pstTriangleSSS[options%keyvals](pos){A}(a,b,c){B}{C}
\pstTriangleSAS(pos){A}(b,∠A,c){B}{C}
\pstTriangleSAS[options%keyvals](pos){A}(b,∠A,c){B}{C}
\pstTriangleAAS(pos){A}(∠C,∠A,c){B}{C}
\pstTriangleAAS[options%keyvals](pos){A}(∠C,∠A,c){B}{C}
\pstTriangleASA(pos){A}(∠A,c,∠B){B}{C}
\pstTriangleASA[options%keyvals](pos){A}(∠A,c,∠B){B}{C}
\pstTriangleIC{A}{B}{C}
\pstTriangleIC{A}{B}{C}[I][H]
\pstTriangleIC[options%keyvals]{A}{B}{C}
\pstTriangleIC[options%keyvals]{A}{B}{C}[I][H]
\pstTriangleOC{A}{B}{C}
\pstTriangleOC{A}{B}{C}[O]
\pstTriangleOC[options%keyvals]{A}{B}{C}
\pstTriangleOC[options%keyvals]{A}{B}{C}[O]
\pstTriangleGC{A}{B}{C}{G}
\pstTriangleGC{A}{B}{C}{G}[M1][M2]
\pstTriangleGC[options%keyvals]{A}{B}{C}{G}
\pstTriangleGC[options%keyvals]{A}{B}{C}{G}[M1][M2]
\pstTriangleHC{A}{B}{C}{H}
\pstTriangleHC{A}{B}{C}{H}[H1][H2]
\pstTriangleHC[options%keyvals]{A}{B}{C}{H}
\pstTriangleHC[options%keyvals]{A}{B}{C}{H}[H1][H2]
\pstTriangleEC{A}{B}{C}{E}
\pstTriangleEC{A}{B}{C}{E}[T1]
\pstTriangleEC[options%keyvals]{A}{B}{C}{E}
\pstTriangleEC[options%keyvals]{A}{B}{C}{E}[T1]
\pstTriangleNC{A}{B}{C}{N}
\pstTriangleNC{A}{B}{C}{N}[M1][M2][M3]
\pstTriangleNC[options%keyvals]{A}{B}{C}{N}
\pstTriangleNC[options%keyvals]{A}{B}{C}{N}[M1][M2][M3]
\pstTriangleLC{A}{B}{C}{L}
\pstTriangleLC{A}{B}{C}{L}[S1][S2][S3]
\pstTriangleLC[options%keyvals]{A}{B}{C}{L}
\pstTriangleLC[options%keyvals]{A}{B}{C}{L}[S1][S2][S3]
\pstRightAngle{A}{B}{C}
\pstRightAngle[options%keyvals]{A}{B}{C}
\pstMarkAngle{A}{B}{C}{label}
\pstMarkAngle[options%keyvals]{A}{B}{C}{label}
\pstLineAB{A}{B}
\pstLineAB[options%keyvals]{A}{B}
\pstLine{A}{B}
\pstLine[options%keyvals]{A}{B}
\pstLine{A}(x,y)
\pstLine[options%keyvals]{A}(x,y)
\pstLine(x,y){B}
\pstLine[options%keyvals](x,y){B}
\pstLine(x1,y1)(x2,y2)
\pstLine[options%keyvals](x1,y1)(x2,y2)
\pstLineAA{A}{angle}{B}
\pstLineAA[options%keyvals]{A}{angle}{B}
\pstLineAA(x,y){angle}{B}
\pstLineAA[options%keyvals](x,y){angle}{B}
\pstLineAS{A}{gradient}{B}
\pstLineAS[options%keyvals]{A}{gradient}{B}
\pstLineAS(x,y){gradient}{B}
\pstLineAS[options%keyvals](x,y){gradient}{B}
\pstLineCoef{a,b,c}{A}{B}
\pstLineCoef[options%keyvals]{a,b,c}{A}{B}
\pstLineAbsNode{A}{B}{x}{C}
\pstLineAbsNode[options%keyvals]{A}{B}{x}{C}
\pstLineOrdNode{A}{B}{y}{C}
\pstLineOrdNode[options%keyvals]{A}{B}{y}{C}
\pstProportionNode{A}{B}{λ}{C}{C'}
\pstProportionNode[options%keyvals]{A}{B}{λ}{C}{C'}
\pstBisectorAOB{A}{O}{B}{T1}{T2}
\pstBisectorAOB[options%keyvals]{A}{O}{B}{T1}{T2}
\pstFourthHarmonicNode{A}{B}{C}{X}
\pstFourthHarmonicNode[options%keyvals]{A}{B}{C}{X}
\pstLocateAB{A}{B}{L}{C}
\pstLocateAB[options%keyvals]{A}{B}{L}{C}
\pstExtendAB{A}{B}{L}{C}
\pstExtendAB[options%keyvals]{A}{B}{L}{C}
\pstInversion{O}{A}{C}{C'}
\pstInversion[options%keyvals]{O}{A}{C}{C'}
\pstGoldenMean{A}{B}{C}
\pstGoldenMean[options%keyvals]{A}{B}{C}
\pstGeometricMean{A}{B}{L1}{L2}{C}
\pstGeometricMean[options%keyvals]{A}{B}{L1}{L2}{C}
\pstHarmonicMean{A}{B}{L1}{L2}{C}
\pstHarmonicMean[options%keyvals]{A}{B}{L1}{L2}{C}
\pstDistAB{A}{B}
\pstDistVal{l}
\pstDistCalc{expr%definition}
\pstDist{A}{B}
\pstDistConst{l}
\pstDistExpr{expr%definition}
\pstDistCoef{distance}
\pstUserDist{distance}
\pstScreenDist{distance}
\pstDistMul{A}{B}{λ}
\pstDistAdd{A}{B}{C}{D}
\pstDistAddVal{A}{B}{λ}{L}
\pstDistAddCoef{A}{B}{λ1}{C}{D}{λ2}
\pstDistSub{A}{B}{C}{D}
\pstDistSubVal{A}{B}{λ}{L}
\pstDistSubCoef{A}{B}{λ1}{C}{D}{λ2}
\pstDistDiv{A}{B}{C}{D}
\pstDistABC{A}{B}{C}
\pstCircleOA{O}{A}
\pstCircleOA{O}{A}[angleA][angleB]
\pstCircleOA[options%keyvals]{O}{A}
\pstCircleOA[options%keyvals]{O}{A}[angleA][angleB]
\pstCircleAB{A}{B}
\pstCircleAB{A}{B}[angleA][angleB]
\pstCircleAB[options%keyvals]{A}{B}
\pstCircleAB[options%keyvals]{A}{B}[angleA][angleB]
\pstCircleABR{A}{B}{R}{O}
\pstCircleABR[options%keyvals]{A}{B}{R}{O}
\pstArcOAB{O}{A}{B}
\pstArcOAB[options%keyvals]{O}{A}{B}
\pstArcnOAB{O}{A}{B}
\pstArcnOAB[options%keyvals]{O}{A}{B}
\pstCircleNode{O}{A}{θ}{X}
\pstCircleNode[options%keyvals]{O}{A}{θ}{X}
\pstCircleRotNode{O}{A}{X}
\pstCircleRotNode[options%keyvals]{O}{A}{X}
\pstCircleChordNode{O}{A}{L}{X}
\pstCircleChordNode[options%keyvals]{O}{A}{L}{X}
\pstCircleAbsNode{O}{A}{x}{C}{D}
\pstCircleAbsNode[options%keyvals]{O}{A}{x}{C}{D}
\pstCircleOrdNode{O}{A}{y}{C}{D}
\pstCircleOrdNode[options%keyvals]{O}{A}{y}{C}{D}
\pstCurvAbsNode{O}{A}{B}{abscissa}
\pstCurvAbsNode[options%keyvals]{O}{A}{B}{abscissa}
\pstCircleTangentLine{O}{A}{T}
\pstCircleTangentLine[options%keyvals]{O}{A}{T}
\pstCircleTangentNode{O}{A}{P}{T1}{T2}
\pstCircleTangentNode[options%keyvals]{O}{A}{P}{T1}{T2}
\pstCircleExternalCommonTangent{O1}{A}{O2}{B}{T1}{T2}{T3}{T4}
\pstCircleExternalCommonTangent[options%keyvals]{O1}{A}{O2}{B}{T1}{T2}{T3}{T4}
\pstCircleInternalCommonTangent{O1}{A}{O2}{B}{T1}{T2}{T3}{T4}
\pstCircleInternalCommonTangent[options%keyvals]{O1}{A}{O2}{B}{T1}{T2}{T3}{T4}
\pstCircleRadicalAxis{O1}{A}{O2}{B}{C}{D}
\pstCircleRadicalAxis[options%keyvals]{O1}{A}{O2}{B}{C}{D}
\pstETriangleAB{A}{B}{C}
\pstETriangleAB[options%keyvals]{A}{B}{C}
\pstSquareAB{A}{B}{C}{D}
\pstSquareAB[options%keyvals]{A}{B}{C}{D}
\pstRegularPolygonAB{A0}{A1}{n}{A2,A3,...}
\pstRegularPolygonAB[options%keyvals]{A0}{A1}{n}{A2,A3,...}
\pstRegularPolygonOA{O}{A0}{n}{A1,A2,...}
\pstRegularPolygonOA[options%keyvals]{O}{A0}{n}{A1,A2,...}
\pstGenericCurve{radical}{n1}{n2}
\pstGenericCurve[options%keyvals]{radical}{n1}{n2}
\pstEllipse(O)(a,b)
\pstEllipse(O)(a,b)[angleA][angleB]
\pstEllipse[options%keyvals](O)(a,b)
\pstEllipse[options%keyvals](O)(a,b)[angleA][angleB]
\pstEllipseNode(O)(a,b){t}{P}
\pstEllipseNode[options%keyvals](O)(a,b){t}{P}
\pstEllipseRotNode(O)(a,b){P}
\pstEllipseRotNode[options%keyvals](O)(a,b){P}
\pstEllipseAbsNode(O)(a,b){x}{A}{B}
\pstEllipseAbsNode[options%keyvals](O)(a,b){x}{A}{B}
\pstEllipseOrdNode(O)(a,b){y}{A}{B}
\pstEllipseOrdNode[options%keyvals](O)(a,b){y}{A}{B}
\pstEllipseFocusNode(O)(a,b){A}{B}
\pstEllipseFocusNode[options%keyvals](O)(a,b){A}{B}
\pstEllipseDirectrixLine(O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstEllipseDirectrixLine[options%keyvals](O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstEllipseLineInter(O)(a,b){A}{B}{C}{D}
\pstEllipseLineInter[options%keyvals](O)(a,b){A}{B}{C}{D}
\pstEllipsePolarNode(O)(a,b){A}{B}{T}
\pstEllipsePolarNode[options%keyvals](O)(a,b){A}{B}{T}
\pstEllipseTangentNode(O)(a,b){T}{A}{B}
\pstEllipseTangentNode[options%keyvals](O)(a,b){T}{A}{B}
\pstGeneralEllipse(O)(a,b)
\pstGeneralEllipse(O)(a,b)[θ]
\pstGeneralEllipse(O)(a,b)[θ][angleA][angleB]
\pstGeneralEllipse[options%keyvals](O)(a,b)
\pstGeneralEllipse[options%keyvals](O)(a,b)[θ]
\pstGeneralEllipse[options%keyvals](O)(a,b)[θ][angleA][angleB]
\pstGeneralEllipseFle{F}{A}{B}{e}{O}{Rab}{θ}
\pstGeneralEllipseFle[options%keyvals]{F}{A}{B}{e}{O}{Rab}{θ}
\pstGeneralEllipseFFN{F1}{F2}{O}{Rab}{θ}
\pstGeneralEllipseFFN[options%keyvals]{F1}{F2}{O}{Rab}{θ}
\pstGeneralEllipseCoef{a,b,c,d,e,f}{O}{Rab}{θ}
\pstGeneralEllipseCoef[options%keyvals]{a,b,c,d,e,f}{O}{Rab}{θ}
\pstGeneralEllipseABCDE{A}{B}{C}{D}{E}{O}{Rab}{θ}
\pstGeneralEllipseABCDE[options%keyvals]{A}{B}{C}{D}{E}{O}{Rab}{θ}
\pstGeneralEllipseNode(O)(a,b){t}{A}
\pstGeneralEllipseNode(O)(a,b)[θ]{t}{A}
\pstGeneralEllipseNode[options%keyvals](O)(a,b){t}{A}
\pstGeneralEllipseNode[options%keyvals](O)(a,b)[θ]{t}{A}
\pstGeneralEllipseRotNode(O)(a,b){A}
\pstGeneralEllipseRotNode(O)(a,b)[θ]{A}
\pstGeneralEllipseRotNode[options%keyvals](O)(a,b){A}
\pstGeneralEllipseRotNode[options%keyvals](O)(a,b)[θ]{A}
\pstGeneralEllipseAbsNode(O)(a,b){x}{A}{B}
\pstGeneralEllipseAbsNode(O)(a,b)[θ]{x}{A}{B}
\pstGeneralEllipseAbsNode[options%keyvals](O)(a,b){x}{A}{B}
\pstGeneralEllipseAbsNode[options%keyvals](O)(a,b)[θ]{x}{A}{B}
\pstGeneralEllipseOrdNode(O)(a,b){y}{A}{B}
\pstGeneralEllipseOrdNode(O)(a,b)[θ]{y}{A}{B}
\pstGeneralEllipseOrdNode[options%keyvals](O)(a,b){y}{A}{B}
\pstGeneralEllipseOrdNode[options%keyvals](O)(a,b)[θ]{y}{A}{B}
\pstGeneralEllipseFocusNode(O)(a,b){t}{F1}{F2}
\pstGeneralEllipseFocusNode(O)(a,b)[θ]{t}{F1}{F2}
\pstGeneralEllipseFocusNode[options%keyvals](O)(a,b){t}{F1}{F2}
\pstGeneralEllipseFocusNode[options%keyvals](O)(a,b)[θ]{t}{F1}{F2}
\pstGeneralEllipseDirectrixLine(O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstGeneralEllipseDirectrixLine(O)(a,b)[θ]{Lx}{Ly}{Rx}{Ry}
\pstGeneralEllipseDirectrixLine[options%keyvals](O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstGeneralEllipseDirectrixLine[options%keyvals](O)(a,b)[θ]{Lx}{Ly}{Rx}{Ry}
\pstGeneralEllipseLineInter(O)(a,b){A}{B}{C}{D}
\pstGeneralEllipseLineInter(O)(a,b)[θ]{A}{B}{C}{D}
\pstGeneralEllipseLineInter[options%keyvals](O)(a,b){A}{B}{C}{D}
\pstGeneralEllipseLineInter[options%keyvals](O)(a,b)[θ]{A}{B}{C}{D}
\pstGeneralEllipsePolarNode(O)(a,b){A}{B}{T}
\pstGeneralEllipsePolarNode(O)(a,b)[θ]{A}{B}{T}
\pstGeneralEllipsePolarNode[options%keyvals](O)(a,b){A}{B}{T}
\pstGeneralEllipsePolarNode[options%keyvals](O)(a,b)[θ]{A}{B}{T}
\pstGeneralEllipseTangentNode(O)(a,b){T}{A}{B}
\pstGeneralEllipseTangentNode(O)(a,b)[θ]{T}{A}{B}
\pstGeneralEllipseTangentNode[options%keyvals](O)(a,b){T}{A}{B}
\pstGeneralEllipseTangentNode[options%keyvals](O)(a,b)[θ]{T}{A}{B}
\pstParabola(O){p}{x1}{x2}
\pstParabola[options%keyvals](O){p}{x1}{x2}
\pstParabolaNode(O){p}{t}{A}
\pstParabolaNode[options%keyvals](O){p}{t}{A}
\pstParabolaAbsNode(O){p}{x}{A}
\pstParabolaAbsNode[options%keyvals](O){p}{x}{A}
\pstParabolaOrdNode(O){p}{y}{A}{B}
\pstParabolaOrdNode[options%keyvals](O){p}{y}{A}{B}
\pstParabolaFocusNode(O){p}{F}
\pstParabolaFocusNode[options%keyvals](O){p}{F}
\pstParabolaDirectrixLine(O){p}{Lx}{Ly}
\pstParabolaDirectrixLine[options%keyvals](O){p}{Lx}{Ly}
\pstParabolaLineInter(O){p}{A}{B}{C}{D}
\pstParabolaPolarNode(O){p}{A}{B}{T}
\pstParabolaPolarNode(O){p}(F){A}{B}{T}
\pstParabolaPolarNode(O){p}(F)[Lx][Ly]{A}{B}{T}
\pstParabolaPolarNode[options%keyvals](O){p}{A}{B}{T}
\pstParabolaPolarNode[options%keyvals](O){p}(F){A}{B}{T}
\pstParabolaPolarNode[options%keyvals](O){p}(F)[Lx][Ly]{A}{B}{T}
\pstParabolaTangentNode(O){p}{T}{A}{B}
\pstParabolaTangentNode[options%keyvals](O){p}{T}{A}{B}
\pstIParabola(O){p}{y1}{y2}
\pstIParabola[options%keyvals](O){p}{y1}{y2}
\pstIParabolaNode(O){p}{t}{A}
\pstIParabolaNode[options%keyvals](O){p}{t}{A}
\pstIParabolaAbsNode(O){p}{x}{A}{B}
\pstIParabolaAbsNode[options%keyvals](O){p}{x}{A}{B}
\pstIParabolaOrdNode(O){p}{y}{A}
\pstIParabolaOrdNode[options%keyvals](O){p}{y}{A}
\pstIParabolaFocusNode(O){p}{F}
\pstIParabolaFocusNode[options%keyvals](O){p}{F}
\pstIParabolaDirectrixLine(O){p}{Lx}{Ly}
\pstIParabolaDirectrixLine[options%keyvals](O){p}{Lx}{Ly}
\pstIParabolaLineInter(O){p}{A}{B}{C}{D}
\pstIParabolaLineInter[options%keyvals](O){p}{A}{B}{C}{D}
\pstIParabolaPolarNode(O){p}{A}{B}{T}
\pstIParabolaPolarNode(O){p}(F){A}{B}{T}
\pstIParabolaPolarNode(O){p}(F)[Lx][Ly]{A}{B}{T}
\pstIParabolaPolarNode[options%keyvals](O){p}{A}{B}{T}
\pstIParabolaPolarNode[options%keyvals](O){p}(F){A}{B}{T}
\pstIParabolaPolarNode[options%keyvals](O){p}(F)[Lx][Ly]{A}{B}{T}
\pstIParabolaTangentNode(O){p}{T}{A}{B}
\pstIParabolaTangentNode[options%keyvals](O){p}{T}{A}{B}
\pstGeneralParabola(O){p}{x1}{x2}
\pstGeneralParabola(O){p}[θ]{x1}{x2}
\pstGeneralParabola[options%keyvals](O){p}{x1}{x2}
\pstGeneralParabola[options%keyvals](O){p}[θ]{x1}{x2}
\pstGeneralParabolaNode(O){p}{t}{A}
\pstGeneralParabolaNode(O){p}[θ]{t}{A}
\pstGeneralParabolaNode[options%keyvals](O){p}{t}{A}
\pstGeneralParabolaNode[options%keyvals](O){p}[θ]{t}{A}
\pstGeneralParabolaAbsNode(O){p}{x}{A}{B}
\pstGeneralParabolaAbsNode(O){p}[θ]{x}{A}{B}
\pstGeneralParabolaAbsNode[options%keyvals](O){p}{x}{A}{B}
\pstGeneralParabolaAbsNode[options%keyvals](O){p}[θ]{x}{A}{B}
\pstGeneralParabolaOrdNode(O){p}{y}{A}{B}
\pstGeneralParabolaOrdNode(O){p}[θ]{y}{A}{B}
\pstGeneralParabolaOrdNode[options%keyvals](O){p}{y}{A}{B}
\pstGeneralParabolaOrdNode[options%keyvals](O){p}[θ]{y}{A}{B}
\pstGeneralParabolaFl{F}{A}{B}{O}{p}{θ}
\pstGeneralParabolaFl[options%keyvals]{F}{A}{B}{O}{p}{θ}
\pstGeneralParabolaCoef{a,b,c,d,e,f}{O}{p}{θ}
\pstGeneralParabolaCoef[options%keyvals]{a,b,c,d,e,f}{O}{p}{θ}
\pstGeneralParabolaABCDE{A}{B}{C}{D}{E}{O}{p}{θ}
\pstGeneralParabolaABCDE[options%keyvals]{A}{B}{C}{D}{E}{O}{p}{θ}
\pstGeneralParabolaFocusNode(O){p}{F}
\pstGeneralParabolaFocusNode(O){p}[θ]{F}
\pstGeneralParabolaFocusNode[options%keyvals](O){p}{F}
\pstGeneralParabolaFocusNode[options%keyvals](O){p}[θ]{F}
\pstGeneralParabolaDirectrixLine(O){p}{Lx}{Ly}
\pstGeneralParabolaDirectrixLine(O){p}[θ]{Lx}{Ly}
\pstGeneralParabolaDirectrixLine[options%keyvals](O){p}{Lx}{Ly}
\pstGeneralParabolaDirectrixLine[options%keyvals](O){p}[θ]{Lx}{Ly}
\pstGeneralParabolaLineInter(O){p}{A}{B}{C}{D}
\pstGeneralParabolaLineInter(O){p}[θ]{A}{B}{C}{D}
\pstGeneralParabolaLineInter[options%keyvals](O){p}{A}{B}{C}{D}
\pstGeneralParabolaLineInter[options%keyvals](O){p}[θ]{A}{B}{C}{D}
\pstGeneralParabolaPolarNode(O){p}{A}{B}{T}
\pstGeneralParabolaPolarNode(O){p}[θ]{A}{B}{T}
\pstGeneralParabolaPolarNode(O){p}(F){A}{B}{T}
\pstGeneralParabolaPolarNode(O){p}[θ](F){A}{B}{T}
\pstGeneralParabolaPolarNode(O){p}(F)[Lx][Ly]{A}{B}{T}
\pstGeneralParabolaPolarNode(O){p}[θ](F)[Lx][Ly]{A}{B}{T}
\pstGeneralParabolaPolarNode[options%keyvals](O){p}{A}{B}{T}
\pstGeneralParabolaPolarNode[options%keyvals](O){p}[θ]{A}{B}{T}
\pstGeneralParabolaPolarNode[options%keyvals](O){p}(F){A}{B}{T}
\pstGeneralParabolaPolarNode[options%keyvals](O){p}[θ](F){A}{B}{T}
\pstGeneralParabolaPolarNode[options%keyvals](O){p}(F)[Lx][Ly]{A}{B}{T}
\pstGeneralParabolaPolarNode[options%keyvals](O){p}[θ](F)[Lx][Ly]{A}{B}{T}
\pstGeneralParabolaTangentNode(O){p}{T}{A}{B}
\pstGeneralParabolaTangentNode(O){p}[θ]{T}{A}{B}
\pstGeneralParabolaTangentNode[options%keyvals](O){p}{T}{A}{B}
\pstGeneralParabolaTangentNode[options%keyvals](O){p}[θ]{T}{A}{B}
\pstGeneralIParabola(O){p}{y1}{y2}
\pstGeneralIParabola[options%keyvals](O){p}{y1}{y2}
\pstGeneralIParabola(O){p}[θ]{y1}{y2}
\pstGeneralIParabola[options%keyvals](O){p}[θ]{y1}{y2}
\pstGeneralIParabolaNode(O){p}{t}{A}
\pstGeneralIParabolaNode[options%keyvals](O){p}{t}{A}
\pstGeneralIParabolaNode(O){p}[θ]{t}{A}
\pstGeneralIParabolaNode[options%keyvals](O){p}[θ]{t}{A}
\pstGeneralIParabolaAbsNode(O){p}{x}{A}{B}
\pstGeneralIParabolaAbsNode[options%keyvals](O){p}{x}{A}{B}
\pstGeneralIParabolaAbsNode(O){p}[θ]{x}{A}{B}
\pstGeneralIParabolaAbsNode[options%keyvals](O){p}[θ]{x}{A}{B}
\pstGeneralIParabolaOrdNode(O){p}{y}{A}{B}
\pstGeneralIParabolaOrdNode[options%keyvals](O){p}{y}{A}{B}
\pstGeneralIParabolaOrdNode(O){p}[θ]{y}{A}{B}
\pstGeneralIParabolaOrdNode[options%keyvals](O){p}[θ]{y}{A}{B}
\pstGeneralIParabolaFocusNode(O){p}{F}
\pstGeneralIParabolaFocusNode[options%keyvals](O){p}{F}
\pstGeneralIParabolaFocusNode(O){p}[θ]{F}
\pstGeneralIParabolaFocusNode[options%keyvals](O){p}[θ]{F}
\pstGeneralIParabolaDirectrixLine(O){p}{Lx}{Ly}
\pstGeneralIParabolaDirectrixLine[options%keyvals](O){p}{Lx}{Ly}
\pstGeneralIParabolaDirectrixLine(O){p}[θ]{Lx}{Ly}
\pstGeneralIParabolaDirectrixLine[options%keyvals](O){p}[θ]{Lx}{Ly}
\pstGeneralIParabolaLineInter(O){p}{A}{B}{C}{D}
\pstGeneralIParabolaLineInter[options%keyvals](O){p}{A}{B}{C}{D}
\pstGeneralIParabolaLineInter(O){p}[θ]{A}{B}{C}{D}
\pstGeneralIParabolaLineInter[options%keyvals](O){p}[θ]{A}{B}{C}{D}
\pstGeneralIParabolaPolarNode(O){p}{A}{B}{T}
\pstGeneralIParabolaPolarNode[options%keyvals](O){p}{A}{B}{T}
\pstGeneralIParabolaPolarNode(O){p}[θ]{A}{B}{T}
\pstGeneralIParabolaPolarNode[options%keyvals](O){p}[θ]{A}{B}{T}
\pstGeneralIParabolaPolarNode(O){p}(F){A}{B}{T}
\pstGeneralIParabolaPolarNode[options%keyvals](O){p}(F){A}{B}{T}
\pstGeneralIParabolaPolarNode(O){p}[θ](F){A}{B}{T}
\pstGeneralIParabolaPolarNode[options%keyvals](O){p}[θ](F){A}{B}{T}
\pstGeneralIParabolaPolarNode(O){p}(F)[Lx][Ly]{A}{B}{T}
\pstGeneralIParabolaPolarNode[options%keyvals](O){p}(F)[Lx][Ly]{A}{B}{T}
\pstGeneralIParabolaPolarNode(O){p}[θ](F)[Lx][Ly]{A}{B}{T}
\pstGeneralIParabolaPolarNode[options%keyvals](O){p}[θ](F)[Lx][Ly]{A}{B}{T}
\pstGeneralIParabolaTangentNode(O){p}{T}{A}{B}
\pstGeneralIParabolaTangentNode[options%keyvals](O){p}{T}{A}{B}
\pstGeneralIParabolaTangentNode(O){p}[θ]{T}{A}{B}
\pstGeneralIParabolaTangentNode[options%keyvals](O){p}[θ]{T}{A}{B}
\pstHyperbola(O)(a,b)
\pstHyperbola(O)(a,b)[angleX]
\pstHyperbola[options%keyvals](O)(a,b)
\pstHyperbola[options%keyvals](O)(a,b)[angleX]
\pstHyperbolaNode(O)(a,b){t}{A}
\pstHyperbolaNode[options%keyvals](O)(a,b){t}{A}
\pstHyperbolaAbsNode(O)(a,b){x}{A}{B}
\pstHyperbolaAbsNode[options%keyvals](O)(a,b){x}{A}{B}
\pstHyperbolaOrdNode(O)(a,b){y}{A}{B}
\pstHyperbolaOrdNode[options%keyvals](O)(a,b){y}{A}{B}
\pstHyperbolaFocusNode(O)(a,b){F1}{F2}
\pstHyperbolaFocusNode[options%keyvals](O)(a,b){F1}{F2}
\pstHyperbolaDirectrixLine(O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstHyperbolaDirectrixLine[options%keyvals](O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstHyperbolaAsymptoteLine(O)(a,b){L1}{L2}
\pstHyperbolaAsymptoteLine[options%keyvals](O)(a,b){L1}{L2}
\pstHyperbolaLineInter(O)(a,b){A}{B}{C}{D}
\pstHyperbolaLineInter[options%keyvals](O)(a,b){A}{B}{C}{D}
\pstHyperbolaPolarNode(O)(a,b){A}{B}{T}
\pstHyperbolaPolarNode[options%keyvals](O)(a,b){A}{B}{T}
\pstHyperbolaTangentNode(O)(a,b){T}{A}{B}
\pstHyperbolaTangentNode[options%keyvals](O)(a,b){T}{A}{B}
\pstIHyperbola(O)(a,b)
\pstIHyperbola(O)(a,b)[angleY]
\pstIHyperbola[options%keyvals](O)(a,b)
\pstIHyperbola[options%keyvals](O)(a,b)[angleY]
\pstIHyperbolaNode(O)(a,b){t}{A}
\pstIHyperbolaNode[options%keyvals](O)(a,b){t}{A}
\pstIHyperbolaAbsNode(O)(a,b){x}{A}{B}
\pstIHyperbolaAbsNode[options%keyvals](O)(a,b){x}{A}{B}
\pstIHyperbolaOrdNode(O)(a,b){y}{A}{B}
\pstIHyperbolaOrdNode[options%keyvals](O)(a,b){y}{A}{B}
\pstIHyperbolaFocusNode(O)(a,b){F1}{F2}
\pstIHyperbolaFocusNode[options%keyvals](O)(a,b){F1}{F2}
\pstIHyperbolaDirectrixLine(O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstIHyperbolaDirectrixLine[options%keyvals](O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstIHyperbolaAsymptoteLine(O)(a,b){L1}{L2}
\pstIHyperbolaAsymptoteLine[options%keyvals](O)(a,b){L1}{L2}
\pstIHyperbolaLineInter(O)(a,b){A}{B}{C}{D}
\pstIHyperbolaLineInter[options%keyvals](O)(a,b){A}{B}{C}{D}
\pstIHyperbolaPolarNode(O)(a,b){A}{B}{T}
\pstIHyperbolaPolarNode[options%keyvals](O)(a,b){A}{B}{T}
\pstIHyperbolaTangentNode(O)(a,b){T}{A}{B}
\pstIHyperbolaTangentNode[options%keyvals](O)(a,b){T}{A}{B}
\pstGeneralHyperbola(O)(a,b)
\pstGeneralHyperbola(O)(a,b)[θ]
\pstGeneralHyperbola(O)(a,b)[θ][angleX]
\pstGeneralHyperbola[options%keyvals](O)(a,b)
\pstGeneralHyperbola[options%keyvals](O)(a,b)[θ]
\pstGeneralHyperbola[options%keyvals](O)(a,b)[θ][angleX]
\pstGeneralHyperbolaFle{F}{A}{B}{e}{O}{Rab}{θ}
\pstGeneralHyperbolaFle[options%keyvals]{F}{A}{B}{e}{O}{Rab}{θ}
\pstGeneralHyperbolaFFN{F1}{F2}{O}{Rab}{θ}
\pstGeneralHyperbolaFFN[options%keyvals]{F1}{F2}{O}{Rab}{θ}
\pstGeneralHyperbolaCoef{a,b,c,d,e,f}{O}{Rab}{θ}
\pstGeneralHyperbolaCoef[options%keyvals]{a,b,c,d,e,f}{O}{Rab}{θ}
\pstGeneralHyperbolaABCDE{A}{B}{C}{D}{E}{O}{Rab}{θ}
\pstGeneralHyperbolaABCDE[options%keyvals]{A}{B}{C}{D}{E}{O}{Rab}{θ}
\pstGeneralHyperbolaNode(O)(a,b){t}{A}
\pstGeneralHyperbolaNode(O)(a,b)[θ]{t}{A}
\pstGeneralHyperbolaNode[options%keyvals](O)(a,b){t}{A}
\pstGeneralHyperbolaNode[options%keyvals](O)(a,b)[θ]{t}{A}
\pstGeneralHyperbolaAbsNode(O)(a,b){x}{A}{B}
\pstGeneralHyperbolaAbsNode(O)(a,b)[θ]{x}{A}{B}
\pstGeneralHyperbolaAbsNode[options%keyvals](O)(a,b){x}{A}{B}
\pstGeneralHyperbolaAbsNode[options%keyvals](O)(a,b)[θ]{x}{A}{B}
\pstGeneralHyperbolaOrdNode(O)(a,b){y}{A}{B}
\pstGeneralHyperbolaOrdNode(O)(a,b)[θ]{y}{A}{B}
\pstGeneralHyperbolaOrdNode[options%keyvals](O)(a,b){y}{A}{B}
\pstGeneralHyperbolaOrdNode[options%keyvals](O)(a,b)[θ]{y}{A}{B}
\pstGeneralHyperbolaFocusNode(O)(a,b){F1}{F2}
\pstGeneralHyperbolaFocusNode(O)(a,b)[θ]{F1}{F2}
\pstGeneralHyperbolaFocusNode[options%keyvals](O)(a,b){F1}{F2}
\pstGeneralHyperbolaFocusNode[options%keyvals](O)(a,b)[θ]{F1}{F2}
\pstGeneralHyperbolaVertexNode(O)(a,b){V1}{V2}
\pstGeneralHyperbolaVertexNode(O)(a,b)[θ]{V1}{V2}
\pstGeneralHyperbolaVertexNode[options%keyvals](O)(a,b){V1}{V2}
\pstGeneralHyperbolaVertexNode[options%keyvals](O)(a,b)[θ]{V1}{V2}
\pstGeneralHyperbolaDirectrixLine(O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstGeneralHyperbolaDirectrixLine(O)(a,b)[θ]{Lx}{Ly}{Rx}{Ry}
\pstGeneralHyperbolaDirectrixLine[options%keyvals](O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstGeneralHyperbolaDirectrixLine[options%keyvals](O)(a,b)[θ]{Lx}{Ly}{Rx}{Ry}
\pstGeneralHyperbolaLineInter(O)(a,b){A}{B}{C}{D}
\pstGeneralHyperbolaLineInter(O)(a,b)[θ]{A}{B}{C}{D}
\pstGeneralHyperbolaLineInter[options%keyvals](O)(a,b){A}{B}{C}{D}
\pstGeneralHyperbolaLineInter[options%keyvals](O)(a,b)[θ]{A}{B}{C}{D}
\pstGeneralHyperbolaPolarNode(O)(a,b){A}{B}{T}
\pstGeneralHyperbolaPolarNode(O)(a,b)[θ]{A}{B}{T}
\pstGeneralHyperbolaPolarNode[options%keyvals](O)(a,b){A}{B}{T}
\pstGeneralHyperbolaPolarNode[options%keyvals](O)(a,b)[θ]{A}{B}{T}
\pstGeneralHyperbolaTangentNode(O)(a,b){T}{A}{B}
\pstGeneralHyperbolaTangentNode(O)(a,b)[θ]{T}{A}{B}
\pstGeneralHyperbolaTangentNode[options%keyvals](O)(a,b){T}{A}{B}
\pstGeneralHyperbolaTangentNode[options%keyvals](O)(a,b)[θ]{T}{A}{B}
\pstGeneralIHyperbola(O)(a,b)
\pstGeneralIHyperbola(O)(a,b)[θ]
\pstGeneralIHyperbola(O)(a,b)[θ][angleY]
\pstGeneralIHyperbola[options%keyvals](O)(a,b)
\pstGeneralIHyperbola[options%keyvals](O)(a,b)[θ]
\pstGeneralIHyperbola[options%keyvals](O)(a,b)[θ][angleY]
\pstGeneralIHyperbolaNode(O)(a,b){t}{A}
\pstGeneralIHyperbolaNode(O)(a,b)[θ]{t}{A}
\pstGeneralIHyperbolaNode[options%keyvals](O)(a,b){t}{A}
\pstGeneralIHyperbolaNode[options%keyvals](O)(a,b)[θ]{t}{A}
\pstGeneralIHyperbolaAbsNode(O)(a,b){x}{A}{B}
\pstGeneralIHyperbolaAbsNode(O)(a,b)[θ]{x}{A}{B}
\pstGeneralIHyperbolaAbsNode[options%keyvals](O)(a,b){x}{A}{B}
\pstGeneralIHyperbolaAbsNode[options%keyvals](O)(a,b)[θ]{x}{A}{B}
\pstGeneralIHyperbolaOrdNode(O)(a,b){y}{A}{B}
\pstGeneralIHyperbolaOrdNode(O)(a,b)[θ]{y}{A}{B}
\pstGeneralIHyperbolaOrdNode[options%keyvals](O)(a,b){y}{A}{B}
\pstGeneralIHyperbolaOrdNode[options%keyvals](O)(a,b)[θ]{y}{A}{B}
\pstGeneralIHyperbolaFocusNode(O)(a,b){F1}{F2}
\pstGeneralIHyperbolaFocusNode(O)(a,b)[θ]{F1}{F2}
\pstGeneralIHyperbolaFocusNode[options%keyvals](O)(a,b){F1}{F2}
\pstGeneralIHyperbolaFocusNode[options%keyvals](O)(a,b)[θ]{F1}{F2}
\pstGeneralIHyperbolaVertexNode(O)(a,b){V1}{V2}
\pstGeneralIHyperbolaVertexNode(O)(a,b)[θ]{V1}{V2}
\pstGeneralIHyperbolaVertexNode[options%keyvals](O)(a,b){V1}{V2}
\pstGeneralIHyperbolaVertexNode[options%keyvals](O)(a,b)[θ]{V1}{V2}
\pstGeneralIHyperbolaDirectrixLine(O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstGeneralIHyperbolaDirectrixLine(O)(a,b)[θ]{Lx}{Ly}{Rx}{Ry}
\pstGeneralIHyperbolaDirectrixLine[options%keyvals](O)(a,b){Lx}{Ly}{Rx}{Ry}
\pstGeneralIHyperbolaDirectrixLine[options%keyvals](O)(a,b)[θ]{Lx}{Ly}{Rx}{Ry}
\pstGeneralIHyperbolaAsymptoteLine(O)(a,b){L1}{L2}
\pstGeneralIHyperbolaAsymptoteLine(O)(a,b)[θ]{L1}{L2}
\pstGeneralIHyperbolaAsymptoteLine[options%keyvals](O)(a,b){L1}{L2}
\pstGeneralIHyperbolaAsymptoteLine[options%keyvals](O)(a,b)[θ]{L1}{L2}
\pstGeneralIHyperbolaLineInter(O)(a,b){A}{B}{C}{D}
\pstGeneralIHyperbolaLineInter(O)(a,b)[θ]{A}{B}{C}{D}
\pstGeneralIHyperbolaLineInter[options%keyvals](O)(a,b){A}{B}{C}{D}
\pstGeneralIHyperbolaLineInter[options%keyvals](O)(a,b)[θ]{A}{B}{C}{D}
\pstGeneralIHyperbolaPolarNode(O)(a,b){A}{B}{T}
\pstGeneralIHyperbolaPolarNode(O)(a,b)[θ]{A}{B}{T}
\pstGeneralIHyperbolaPolarNode[options%keyvals](O)(a,b){A}{B}{T}
\pstGeneralIHyperbolaPolarNode[options%keyvals](O)(a,b)[θ]{A}{B}{T}
\pstGeneralIHyperbolaTangentNode(O)(a,b){T}{A}{B}
\pstGeneralIHyperbolaTangentNode(O)(a,b)[θ]{T}{A}{B}
\pstGeneralIHyperbolaTangentNode[options%keyvals](O)(a,b){T}{A}{B}
\pstGeneralIHyperbolaTangentNode[options%keyvals](O)(a,b)[θ]{T}{A}{B}
\pstGeneralConicEquation{A}{B}{C}{D}{E}{F}{a,b,c,d,e,f}
\pstGeneralConicEquation[options%keyvals]{A}{B}{C}{D}{E}{F}{a,b,c,d,e,f}
\pstGeneralEllipseEquation(O)(a,b){a,b,c,d,e,f}
\pstGeneralEllipseEquation[options%keyvals](O)(a,b){a,b,c,d,e,f}
\pstGeneralEllipseEquation(O)(a,b)[θ]{a,b,c,d,e,f}
\pstGeneralEllipseEquation[options%keyvals](O)(a,b)[θ]{a,b,c,d,e,f}
\pstGeneralHyperbolaEquation(O)(a,b){a,b,c,d,e,f}
\pstGeneralHyperbolaEquation(O)(a,b)[θ]{a,b,c,d,e,f}
\pstGeneralHyperbolaEquation[options%keyvals](O)(a,b){a,b,c,d,e,f}
\pstGeneralHyperbolaEquation[options%keyvals](O)(a,b)[θ]{a,b,c,d,e,f}
\pstGeneralParabolaEquation(O){p}{a,b,c,d,e,f}
\pstGeneralParabolaEquation(O){p}[θ]{a,b,c,d,e,f}
\pstGeneralParabolaEquation[options%keyvals](O){p}{a,b,c,d,e,f}
\pstGeneralParabolaEquation[options%keyvals](O){p}[θ]{a,b,c,d,e,f}
\pstGeneralConicLineInter{A}{B}{a,b,c,d,e,f}{C}{D}
\pstGeneralConicLineInter[options%keyvals]{A}{B}{a,b,c,d,e,f}{C}{D}
\pstGeneralConicCircleInter{O}{A}{a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicCircleInter[options%keyvals]{O}{A}{a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicEllipseInter(O)(m,n){a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicEllipseInter[options%keyvals](O)(m,n){a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicHyperbolaInter(O)(m,n){a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicHyperbolaInter[options%keyvals](O)(m,n){a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicIHyperbolaInter(O)(m,n){a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicIHyperbolaInter[options%keyvals](O)(m,n){a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicParabolaInter(O){p}{a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicParabolaInter[options%keyvals](O){p}{a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicIParabolaInter(O){p}{a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicIParabolaInter[options%keyvals](O){p}{a,b,c,d,e,f}{C}{D}{E}{F}
\pstGeneralConicInter{a,b,c,d,e,f}{a',b',c',d',e',f'}{C}{D}{E}{F}
\pstGeneralConicTangentLine{A}{a,b,c,d,e,f}{B}
\pstGeneralConicTangentLine[options%keyvals]{A}{a,b,c,d,e,f}{B}
\pstGeneralConicTangentChord{T}{a,b,c,d,e,f}{A}{B}
\pstGeneralConicTangentChord[options%keyvals]{T}{a,b,c,d,e,f}{A}{B}
\pstSymO{O}{M1,...,Mn}
\pstSymO{O}{M1,...,Mn}[M1',...,Mn']
\pstSymO[options%keyvals]{O}{M1,...,Mn}
\pstSymO[options%keyvals]{O}{M1,...,Mn}[M1',...,Mn']
\pstOrtSym{A}{B}{M1,...,Mn}
\pstOrtSym{A}{B}{M1,...,Mn}[M1',...,Mn']
\pstOrtSym[options%keyvals]{A}{B}{M1,...,Mn}
\pstOrtSym[options%keyvals]{A}{B}{M1,...,Mn}[M1',...,Mn']
\pstRotation{O}{M1,...,Mn}
\pstRotation{O}{M1,...,Mn}[M1',...,Mn']
\pstRotation[options%keyvals]{O}{M1,...,Mn}
\pstRotation[options%keyvals]{O}{M1,...,Mn}[M1',...,Mn']
\pstAngleAOB{A}{O}{B}
\pstTranslation{A}{B}{M1,...,Mn}
\pstTranslation{A}{B}{M1,...,Mn}[M1',...,Mn']
\pstTranslation[options%keyvals]{A}{B}{M1,...,Mn}
\pstTranslation[options%keyvals]{A}{B}{M1,...,Mn}[M1',...,Mn']
\pstHomO{O}{M1,...,Mn}
\pstHomO{O}{M1,...,Mn}[M1',...,Mn']
\pstHomO[options%keyvals]{O}{M1,...,Mn}
\pstHomO[options%keyvals]{O}{M1,...,Mn}[M1',...,Mn']
\pstProjection{A}{B}{M1,...,Mn}
\pstProjection{A}{B}{M1,...,Mn}[M1',...,Mn']
\pstProjection[options%keyvals]{A}{B}{M1,...,Mn}
\pstProjection[options%keyvals]{A}{B}{M1,...,Mn}[M1',...,Mn']
\pstMiddleAB{A}{B}{I}
\pstMiddleAB[options%keyvals]{A}{B}{I}
\pstCGravABC{A}{B}{C}{G}
\pstCGravABC[options%keyvals]{A}{B}{C}{G}
\pstCircleABC{A}{B}{C}{O}
\pstCircleABC[options%keyvals]{A}{B}{C}{O}
\pstMediatorAB{A}{B}{I}{M}
\pstMediatorAB[options%keyvals]{A}{B}{I}{M}
\pstBissectBAC{B}{A}{C}{N}
\pstBissectBAC[options%keyvals]{B}{A}{C}{N}
\pstOutBissectBAC{B}{A}{C}{N}
\pstOutBissectBAC[options%keyvals]{B}{A}{C}{N}
\pstInterLL{A}{B}{C}{D}{M}
\pstInterLL[options%keyvals]{A}{B}{C}{D}{M}
\pstInterLC{A}{B}{O}{C}{M1}{M2}
\pstInterLC[options%keyvals]{A}{B}{O}{C}{M1}{M2}
\pstInterCC{O1}{B}{O2}{C}{M1}{M2}
\pstInterCC[options%keyvals]{O1}{B}{O2}{C}{M1}{M2}
\pstInterFF{f%definition}{g%definition}{x0}{M}
\pstInterFF[options%keyvals]{f%definition}{g%definition}{x0}{M}
\pstInterFL{f%definition}{A}{B}{x0}{M}
\pstInterFL[options%keyvals]{f%definition}{A}{B}{x0}{M}
\pstInterFC{f%definition}{O}{A}{x0}{M}
\pstInterFC[options%keyvals]{f%definition}{O}{A}{x0}{M}
\psGetDistanceAB(x1,y1)(x2,y2){name}
\psGetDistanceAB[options%keyvals](x1,y1)(x2,y2){name}
\psGetAngleABC(x1,y1)(x2,y2)(x3,y3){name}
\psGetAngleABC[options%keyvals](x1,y1)(x2,y2)(x3,y3){name}

# not documented
\AngleMarkCirc#S
\AngleMarkCros#S
\AngleMarkCross#S
\AngleMarkHash#S
\AngleMarkHashh#S
\AngleMarkHashhh#S
\Anglepstslash#S
\Anglepstslashh#S
\Anglepstslashhh#S
\Anglepstslashslash#S
\Anglepstslashslashslash#S
\LastValidPN#S
\LastValidSS#S
\MarkArrow#*
\MarkArroww#*
\MarkArrowww#*
\MarkCirc#*
\MarkCros#*
\MarkCross#*
\MarkHash#*
\MarkHashh#*
\MarkHashhh#*
\OldPointName#S
\OldPointNameSep#S
\OldPointSymbol#S
\OldPosAngle#S
\PstParamListFirst{arg}#S
\PstParamListLasts{arg}#S
\SegSymLst#*
\pstParseArg{prefix}{element list}{value list}#*
\pstPolygon(%<A1%>)(%<A2%>)%<...(An)%>#*
\pstPolygon[%<options%>](%<A1%>)(%<A2%>)%<...(An)%>#*
\pstShowCoor{A}#*
\pstslash#*
\pstslashh#*
\pstslashhh#*
\pstslashslash#*
\pstslashslashslash#*
\resetEUCLvalues#*
\psMarkHashLength#*
\psMarkHashSep#*
\PSTEuclideLoaded#S