// Copyright 2016 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/xfa_basic_data.h"

#include "xfa/fxfa/include/fxfa_basic.h"

const XFA_ATTRIBUTEENUMINFO g_XFAEnumData[] = {
    {0x2a, L"*", XFA_ATTRIBUTEENUM_Asterisk},
    {0x2f, L"/", XFA_ATTRIBUTEENUM_Slash},
    {0x5c, L"\\", XFA_ATTRIBUTEENUM_Backslash},
    {0x239bd, L"on", XFA_ATTRIBUTEENUM_On},
    {0x25356, L"tb", XFA_ATTRIBUTEENUM_Tb},
    {0x25885, L"up", XFA_ATTRIBUTEENUM_Up},
    {0x91b281, L"metaData", XFA_ATTRIBUTEENUM_MetaData},
    {0x1f8dedb, L"delegate", XFA_ATTRIBUTEENUM_Delegate},
    {0x2a6c55a, L"postSubmit", XFA_ATTRIBUTEENUM_PostSubmit},
    {0x31b19c1, L"name", XFA_ATTRIBUTEENUM_Name},
    {0x378a38a, L"cross", XFA_ATTRIBUTEENUM_Cross},
    {0x3848b3f, L"next", XFA_ATTRIBUTEENUM_Next},
    {0x48b6670, L"none", XFA_ATTRIBUTEENUM_None},
    {0x51aafe5, L"shortEdge", XFA_ATTRIBUTEENUM_ShortEdge},
    {0x55264c4, L"1mod10_1mod11", XFA_ATTRIBUTEENUM_1mod10_1mod11},
    {0x5a5c519, L"height", XFA_ATTRIBUTEENUM_Height},
    {0x89ce549, L"crossDiagonal", XFA_ATTRIBUTEENUM_CrossDiagonal},
    {0x9f9d0f9, L"all", XFA_ATTRIBUTEENUM_All},
    {0x9f9db48, L"any", XFA_ATTRIBUTEENUM_Any},
    {0xa126261, L"toRight", XFA_ATTRIBUTEENUM_ToRight},
    {0xa36de29, L"matchTemplate", XFA_ATTRIBUTEENUM_MatchTemplate},
    {0xa48d040, L"dpl", XFA_ATTRIBUTEENUM_Dpl},
    {0xa559c05, L"invisible", XFA_ATTRIBUTEENUM_Invisible},
    {0xa7d48e3, L"fit", XFA_ATTRIBUTEENUM_Fit},
    {0xa8a8f80, L"width", XFA_ATTRIBUTEENUM_Width},
    {0xab466bb, L"preSubmit", XFA_ATTRIBUTEENUM_PreSubmit},
    {0xacc5785, L"ipl", XFA_ATTRIBUTEENUM_Ipl},
    {0xafab0f8, L"flateCompress", XFA_ATTRIBUTEENUM_FlateCompress},
    {0xb355816, L"med", XFA_ATTRIBUTEENUM_Med},
    {0xb69ef77, L"odd", XFA_ATTRIBUTEENUM_Odd},
    {0xb69f9bb, L"off", XFA_ATTRIBUTEENUM_Off},
    {0xb843dba, L"pdf", XFA_ATTRIBUTEENUM_Pdf},
    {0xbb912b8, L"row", XFA_ATTRIBUTEENUM_Row},
    {0xbedaf33, L"top", XFA_ATTRIBUTEENUM_Top},
    {0xc56afcc, L"xdp", XFA_ATTRIBUTEENUM_Xdp},
    {0xc56ba02, L"xfd", XFA_ATTRIBUTEENUM_Xfd},
    {0xc56ddf1, L"xml", XFA_ATTRIBUTEENUM_Xml},
    {0xc8b65f3, L"zip", XFA_ATTRIBUTEENUM_Zip},
    {0xc8b89d6, L"zpl", XFA_ATTRIBUTEENUM_Zpl},
    {0xf55d7ee, L"visible", XFA_ATTRIBUTEENUM_Visible},
    {0xfe3596a, L"exclude", XFA_ATTRIBUTEENUM_Exclude},
    {0x109d7ce7, L"mouseEnter", XFA_ATTRIBUTEENUM_MouseEnter},
    {0x10f1bc0c, L"pair", XFA_ATTRIBUTEENUM_Pair},
    {0x1154efe6, L"filter", XFA_ATTRIBUTEENUM_Filter},
    {0x125bc94b, L"moveLast", XFA_ATTRIBUTEENUM_MoveLast},
    {0x12e1f1f0, L"exportAndImport", XFA_ATTRIBUTEENUM_ExportAndImport},
    {0x13000c60, L"push", XFA_ATTRIBUTEENUM_Push},
    {0x138ee315, L"portrait", XFA_ATTRIBUTEENUM_Portrait},
    {0x14da2125, L"default", XFA_ATTRIBUTEENUM_Default},
    {0x157749a5, L"storedProc", XFA_ATTRIBUTEENUM_StoredProc},
    {0x16641198, L"stayBOF", XFA_ATTRIBUTEENUM_StayBOF},
    {0x16b2fc5b, L"stayEOF", XFA_ATTRIBUTEENUM_StayEOF},
    {0x17fad373, L"postPrint", XFA_ATTRIBUTEENUM_PostPrint},
    {0x193207d0, L"usCarrier", XFA_ATTRIBUTEENUM_UsCarrier},
    {0x193ade3e, L"right", XFA_ATTRIBUTEENUM_Right},
    {0x1bfc72d9, L"preOpen", XFA_ATTRIBUTEENUM_PreOpen},
    {0x1cc9317a, L"actual", XFA_ATTRIBUTEENUM_Actual},
    {0x1f31df1e, L"rest", XFA_ATTRIBUTEENUM_Rest},
    {0x1fb1bf14, L"topCenter", XFA_ATTRIBUTEENUM_TopCenter},
    {0x207de667, L"standardSymbol", XFA_ATTRIBUTEENUM_StandardSymbol},
    {0x2196a452, L"initialize", XFA_ATTRIBUTEENUM_Initialize},
    {0x23bd40c7, L"justifyAll", XFA_ATTRIBUTEENUM_JustifyAll},
    {0x247cf3e9, L"normal", XFA_ATTRIBUTEENUM_Normal},
    {0x25aa946b, L"landscape", XFA_ATTRIBUTEENUM_Landscape},
    {0x2739b5c9, L"nonInteractive", XFA_ATTRIBUTEENUM_NonInteractive},
    {0x27410f03, L"mouseExit", XFA_ATTRIBUTEENUM_MouseExit},
    {0x2854e62c, L"minus", XFA_ATTRIBUTEENUM_Minus},
    {0x287e936a, L"diagonalLeft", XFA_ATTRIBUTEENUM_DiagonalLeft},
    {0x2972a98f, L"simplexPaginated", XFA_ATTRIBUTEENUM_SimplexPaginated},
    {0x29d8225f, L"document", XFA_ATTRIBUTEENUM_Document},
    {0x2a9d3016, L"warning", XFA_ATTRIBUTEENUM_Warning},
    {0x2b35b6d9, L"auto", XFA_ATTRIBUTEENUM_Auto},
    {0x2c1653d9, L"below", XFA_ATTRIBUTEENUM_Below},
    {0x2c1f0540, L"bottomLeft", XFA_ATTRIBUTEENUM_BottomLeft},
    {0x2c44e816, L"bottomCenter", XFA_ATTRIBUTEENUM_BottomCenter},
    {0x2cd3e9f3, L"tcpl", XFA_ATTRIBUTEENUM_Tcpl},
    {0x2d08af85, L"text", XFA_ATTRIBUTEENUM_Text},
    {0x2dc478eb, L"grouping", XFA_ATTRIBUTEENUM_Grouping},
    {0x2ef3afdd, L"secureSymbol", XFA_ATTRIBUTEENUM_SecureSymbol},
    {0x2f2dd29a, L"preExecute", XFA_ATTRIBUTEENUM_PreExecute},
    {0x33c43dec, L"docClose", XFA_ATTRIBUTEENUM_DocClose},
    {0x33f25bb5, L"keyset", XFA_ATTRIBUTEENUM_Keyset},
    {0x34e363da, L"vertical", XFA_ATTRIBUTEENUM_Vertical},
    {0x361fa1b6, L"preSave", XFA_ATTRIBUTEENUM_PreSave},
    {0x36f1c6d8, L"preSign", XFA_ATTRIBUTEENUM_PreSign},
    {0x399f02b5, L"bottom", XFA_ATTRIBUTEENUM_Bottom},
    {0x3b0ab096, L"toTop", XFA_ATTRIBUTEENUM_ToTop},
    {0x3c752495, L"verify", XFA_ATTRIBUTEENUM_Verify},
    {0x3ce05d68, L"first", XFA_ATTRIBUTEENUM_First},
    {0x3ecead94, L"contentArea", XFA_ATTRIBUTEENUM_ContentArea},
    {0x40623b5b, L"solid", XFA_ATTRIBUTEENUM_Solid},
    {0x42c6cd8d, L"pessimistic", XFA_ATTRIBUTEENUM_Pessimistic},
    {0x43ddc6bf, L"duplexPaginated", XFA_ATTRIBUTEENUM_DuplexPaginated},
    {0x442f68c8, L"round", XFA_ATTRIBUTEENUM_Round},
    {0x45efb847, L"remerge", XFA_ATTRIBUTEENUM_Remerge},
    {0x46972265, L"ordered", XFA_ATTRIBUTEENUM_Ordered},
    {0x46f95531, L"percent", XFA_ATTRIBUTEENUM_Percent},
    {0x46fd25ae, L"even", XFA_ATTRIBUTEENUM_Even},
    {0x4731d6ba, L"exit", XFA_ATTRIBUTEENUM_Exit},
    {0x4977356b, L"toolTip", XFA_ATTRIBUTEENUM_ToolTip},
    {0x49b980ee, L"orderedOccurrence", XFA_ATTRIBUTEENUM_OrderedOccurrence},
    {0x4a7e2dfe, L"readOnly", XFA_ATTRIBUTEENUM_ReadOnly},
    {0x4c4e8acb, L"currency", XFA_ATTRIBUTEENUM_Currency},
    {0x4dcf25f8, L"concat", XFA_ATTRIBUTEENUM_Concat},
    {0x4febb826, L"Thai", XFA_ATTRIBUTEENUM_Thai},
    {0x50ef95b2, L"embossed", XFA_ATTRIBUTEENUM_Embossed},
    {0x516e35ce, L"formdata", XFA_ATTRIBUTEENUM_Formdata},
    {0x52fa6f0e, L"Greek", XFA_ATTRIBUTEENUM_Greek},
    {0x54034c2f, L"decimal", XFA_ATTRIBUTEENUM_Decimal},
    {0x542c7300, L"select", XFA_ATTRIBUTEENUM_Select},
    {0x551f0ae5, L"longEdge", XFA_ATTRIBUTEENUM_LongEdge},
    {0x55520a8a, L"protected", XFA_ATTRIBUTEENUM_Protected},
    {0x559f76f3, L"bottomRight", XFA_ATTRIBUTEENUM_BottomRight},
    {0x568cb500, L"zero", XFA_ATTRIBUTEENUM_Zero},
    {0x56bcecb7, L"forwardOnly", XFA_ATTRIBUTEENUM_ForwardOnly},
    {0x56bf456b, L"docReady", XFA_ATTRIBUTEENUM_DocReady},
    {0x573cb40c, L"hidden", XFA_ATTRIBUTEENUM_Hidden},
    {0x582e3424, L"include", XFA_ATTRIBUTEENUM_Include},
    {0x58a3dd29, L"dashed", XFA_ATTRIBUTEENUM_Dashed},
    {0x5955b22b, L"multiSelect", XFA_ATTRIBUTEENUM_MultiSelect},
    {0x598d5c53, L"inactive", XFA_ATTRIBUTEENUM_Inactive},
    {0x59c8f27d, L"embed", XFA_ATTRIBUTEENUM_Embed},
    {0x5e7555e8, L"static", XFA_ATTRIBUTEENUM_Static},
    {0x606d4def, L"onEntry", XFA_ATTRIBUTEENUM_OnEntry},
    {0x6195eafb, L"Cyrillic", XFA_ATTRIBUTEENUM_Cyrillic},
    {0x6491b0f3, L"nonBlank", XFA_ATTRIBUTEENUM_NonBlank},
    {0x67bef031, L"topRight", XFA_ATTRIBUTEENUM_TopRight},
    {0x67df5ebd, L"Hebrew", XFA_ATTRIBUTEENUM_Hebrew},
    {0x6aea98be, L"topLeft", XFA_ATTRIBUTEENUM_TopLeft},
    {0x6c51afc1, L"center", XFA_ATTRIBUTEENUM_Center},
    {0x7145e6bf, L"moveFirst", XFA_ATTRIBUTEENUM_MoveFirst},
    {0x7375465c, L"diamond", XFA_ATTRIBUTEENUM_Diamond},
    {0x7461aef4, L"pageOdd", XFA_ATTRIBUTEENUM_PageOdd},
    {0x75f8aeb2, L"1mod10", XFA_ATTRIBUTEENUM_1mod10},
    {0x76d708e0, L"Korean", XFA_ATTRIBUTEENUM_Korean},
    {0x789f14d7, L"aboveEmbedded", XFA_ATTRIBUTEENUM_AboveEmbedded},
    {0x792ea39f, L"zipCompress", XFA_ATTRIBUTEENUM_ZipCompress},
    {0x7a5b7193, L"numeric", XFA_ATTRIBUTEENUM_Numeric},
    {0x7abec0d2, L"circle", XFA_ATTRIBUTEENUM_Circle},
    {0x7afbba38, L"toBottom", XFA_ATTRIBUTEENUM_ToBottom},
    {0x7b95e661, L"inverted", XFA_ATTRIBUTEENUM_Inverted},
    {0x7baca2e3, L"update", XFA_ATTRIBUTEENUM_Update},
    {0x7eb5da2c, L"isoname", XFA_ATTRIBUTEENUM_Isoname},
    {0x7f6fd3d7, L"server", XFA_ATTRIBUTEENUM_Server},
    {0x814f82b5, L"position", XFA_ATTRIBUTEENUM_Position},
    {0x82deacf0, L"middleCenter", XFA_ATTRIBUTEENUM_MiddleCenter},
    {0x83a49dc6, L"optional", XFA_ATTRIBUTEENUM_Optional},
    {0x861a116f, L"usePrinterSetting", XFA_ATTRIBUTEENUM_UsePrinterSetting},
    {0x86701ce0, L"outline", XFA_ATTRIBUTEENUM_Outline},
    {0x8808385e, L"indexChange", XFA_ATTRIBUTEENUM_IndexChange},
    {0x891f4606, L"change", XFA_ATTRIBUTEENUM_Change},
    {0x89939f36, L"pageArea", XFA_ATTRIBUTEENUM_PageArea},
    {0x8b5c3b25, L"once", XFA_ATTRIBUTEENUM_Once},
    {0x8b5c6962, L"only", XFA_ATTRIBUTEENUM_Only},
    {0x8b90e1f2, L"open", XFA_ATTRIBUTEENUM_Open},
    {0x8bcfe96e, L"caption", XFA_ATTRIBUTEENUM_Caption},
    {0x8ce83ef8, L"raised", XFA_ATTRIBUTEENUM_Raised},
    {0x8d269cae, L"justify", XFA_ATTRIBUTEENUM_Justify},
    {0x8fd520dc, L"refAndDescendants", XFA_ATTRIBUTEENUM_RefAndDescendants},
    {0x9041d4b0, L"short", XFA_ATTRIBUTEENUM_Short},
    {0x90c94426, L"pageFront", XFA_ATTRIBUTEENUM_PageFront},
    {0x936beee5, L"monospace", XFA_ATTRIBUTEENUM_Monospace},
    {0x947fa00f, L"middle", XFA_ATTRIBUTEENUM_Middle},
    {0x9528a7b4, L"prePrint", XFA_ATTRIBUTEENUM_PrePrint},
    {0x959ab231, L"always", XFA_ATTRIBUTEENUM_Always},
    {0x96d61bf0, L"unknown", XFA_ATTRIBUTEENUM_Unknown},
    {0x997194ee, L"toLeft", XFA_ATTRIBUTEENUM_ToLeft},
    {0x9a83a3cd, L"above", XFA_ATTRIBUTEENUM_Above},
    {0x9d0d71c7, L"dashDot", XFA_ATTRIBUTEENUM_DashDot},
    {0x9df56f3e, L"gregorian", XFA_ATTRIBUTEENUM_Gregorian},
    {0x9f6723fd, L"Roman", XFA_ATTRIBUTEENUM_Roman},
    {0x9f693b21, L"mouseDown", XFA_ATTRIBUTEENUM_MouseDown},
    {0xa1429b36, L"symbol", XFA_ATTRIBUTEENUM_Symbol},
    {0xa5aa45cb, L"pageEven", XFA_ATTRIBUTEENUM_PageEven},
    {0xa68635f1, L"sign", XFA_ATTRIBUTEENUM_Sign},
    {0xa7315093, L"addNew", XFA_ATTRIBUTEENUM_AddNew},
    {0xa7a773fa, L"star", XFA_ATTRIBUTEENUM_Star},
    {0xa7d57b45, L"optimistic", XFA_ATTRIBUTEENUM_Optimistic},
    {0xa8077321, L"rl-tb", XFA_ATTRIBUTEENUM_Rl_tb},
    {0xa8f1468d, L"middleRight", XFA_ATTRIBUTEENUM_MiddleRight},
    {0xaa84a1f1, L"maintain", XFA_ATTRIBUTEENUM_Maintain},
    {0xab40b12c, L"package", XFA_ATTRIBUTEENUM_Package},
    {0xac8b4d85, L"SimplifiedChinese", XFA_ATTRIBUTEENUM_SimplifiedChinese},
    {0xadae6744, L"toCenter", XFA_ATTRIBUTEENUM_ToCenter},
    {0xb0129df1, L"back", XFA_ATTRIBUTEENUM_Back},
    {0xb0f088cf, L"unspecified", XFA_ATTRIBUTEENUM_Unspecified},
    {0xb1271067, L"batchOptimistic", XFA_ATTRIBUTEENUM_BatchOptimistic},
    {0xb18313a1, L"bold", XFA_ATTRIBUTEENUM_Bold},
    {0xb1833cad, L"both", XFA_ATTRIBUTEENUM_Both},
    {0xb221123f, L"butt", XFA_ATTRIBUTEENUM_Butt},
    {0xb40c36bf, L"client", XFA_ATTRIBUTEENUM_Client},
    {0xb56c7053, L"2mod10", XFA_ATTRIBUTEENUM_2mod10},
    {0xb683a345, L"imageOnly", XFA_ATTRIBUTEENUM_ImageOnly},
    {0xb7732dea, L"horizontal", XFA_ATTRIBUTEENUM_Horizontal},
    {0xb88652a4, L"dotted", XFA_ATTRIBUTEENUM_Dotted},
    {0xbb2f2880, L"userControl", XFA_ATTRIBUTEENUM_UserControl},
    {0xbbb79c5d, L"diagonalRight", XFA_ATTRIBUTEENUM_DiagonalRight},
    {0xbd077154, L"consumeData", XFA_ATTRIBUTEENUM_ConsumeData},
    {0xbd3fb11e, L"check", XFA_ATTRIBUTEENUM_Check},
    {0xbde9abda, L"data", XFA_ATTRIBUTEENUM_Data},
    {0xbf5a02d8, L"down", XFA_ATTRIBUTEENUM_Down},
    {0xbf7450ee, L"sansSerif", XFA_ATTRIBUTEENUM_SansSerif},
    {0xc02d649f, L"inline", XFA_ATTRIBUTEENUM_Inline},
    {0xc11a9e3a, L"TraditionalChinese", XFA_ATTRIBUTEENUM_TraditionalChinese},
    {0xc16169d8, L"warn", XFA_ATTRIBUTEENUM_Warn},
    {0xc16f071f, L"refOnly", XFA_ATTRIBUTEENUM_RefOnly},
    {0xc27c8ba5, L"interactiveForms", XFA_ATTRIBUTEENUM_InteractiveForms},
    {0xc2d1b15c, L"word", XFA_ATTRIBUTEENUM_Word},
    {0xc3621288, L"unordered", XFA_ATTRIBUTEENUM_Unordered},
    {0xc5251981, L"required", XFA_ATTRIBUTEENUM_Required},
    {0xc7088e7d, L"importOnly", XFA_ATTRIBUTEENUM_ImportOnly},
    {0xc72cf0e3, L"belowEmbedded", XFA_ATTRIBUTEENUM_BelowEmbedded},
    {0xc819cf07, L"Japanese", XFA_ATTRIBUTEENUM_Japanese},
    {0xcdce56b3, L"full", XFA_ATTRIBUTEENUM_Full},
    {0xce0122e3, L"rl-row", XFA_ATTRIBUTEENUM_Rl_row},
    {0xcf7d71f1, L"Vietnamese", XFA_ATTRIBUTEENUM_Vietnamese},
    {0xcfde3e09, L"EastEuropeanRoman", XFA_ATTRIBUTEENUM_EastEuropeanRoman},
    {0xd576d08e, L"mouseUp", XFA_ATTRIBUTEENUM_MouseUp},
    {0xd7a92904, L"exportOnly", XFA_ATTRIBUTEENUM_ExportOnly},
    {0xd8ed1467, L"clear", XFA_ATTRIBUTEENUM_Clear},
    {0xd95657a6, L"click", XFA_ATTRIBUTEENUM_Click},
    {0xd96c7de5, L"base64", XFA_ATTRIBUTEENUM_Base64},
    {0xd9f47f36, L"close", XFA_ATTRIBUTEENUM_Close},
    {0xdb075bde, L"host", XFA_ATTRIBUTEENUM_Host},
    {0xdb103411, L"global", XFA_ATTRIBUTEENUM_Global},
    {0xdb647188, L"blank", XFA_ATTRIBUTEENUM_Blank},
    {0xdb9be968, L"table", XFA_ATTRIBUTEENUM_Table},
    {0xdf590fbb, L"import", XFA_ATTRIBUTEENUM_Import},
    {0xe0e573fb, L"custom", XFA_ATTRIBUTEENUM_Custom},
    {0xe0ecc79a, L"middleLeft", XFA_ATTRIBUTEENUM_MiddleLeft},
    {0xe1452019, L"postExecute", XFA_ATTRIBUTEENUM_PostExecute},
    {0xe1911d98, L"radix", XFA_ATTRIBUTEENUM_Radix},
    {0xe25fa7b8, L"postOpen", XFA_ATTRIBUTEENUM_PostOpen},
    {0xe28dce7e, L"enter", XFA_ATTRIBUTEENUM_Enter},
    {0xe2c44de4, L"ignore", XFA_ATTRIBUTEENUM_Ignore},
    {0xe2cd8c61, L"lr-tb", XFA_ATTRIBUTEENUM_Lr_tb},
    {0xe2da8336, L"fantasy", XFA_ATTRIBUTEENUM_Fantasy},
    {0xe31d5396, L"italic", XFA_ATTRIBUTEENUM_Italic},
    {0xe7ada113, L"author", XFA_ATTRIBUTEENUM_Author},
    {0xe8e7cc18, L"toEdge", XFA_ATTRIBUTEENUM_ToEdge},
    {0xe97aa98b, L"choice", XFA_ATTRIBUTEENUM_Choice},
    {0xeafd2a38, L"disabled", XFA_ATTRIBUTEENUM_Disabled},
    {0xeb2b7972, L"crossHatch", XFA_ATTRIBUTEENUM_CrossHatch},
    {0xeb2db2d7, L"dataRef", XFA_ATTRIBUTEENUM_DataRef},
    {0xec35dc6e, L"dashDotDot", XFA_ATTRIBUTEENUM_DashDotDot},
    {0xef85d351, L"square", XFA_ATTRIBUTEENUM_Square},
    {0xf2102445, L"dynamic", XFA_ATTRIBUTEENUM_Dynamic},
    {0xf272c7be, L"manual", XFA_ATTRIBUTEENUM_Manual},
    {0xf2bbb64d, L"etched", XFA_ATTRIBUTEENUM_Etched},
    {0xf3b8fc6c, L"validationState", XFA_ATTRIBUTEENUM_ValidationState},
    {0xf42f2b81, L"cursive", XFA_ATTRIBUTEENUM_Cursive},
    {0xf54481d4, L"last", XFA_ATTRIBUTEENUM_Last},
    {0xf5ad782b, L"left", XFA_ATTRIBUTEENUM_Left},
    {0xf616da2e, L"link", XFA_ATTRIBUTEENUM_Link},
    {0xf6b4afb0, L"long", XFA_ATTRIBUTEENUM_Long},
    {0xf8636460, L"internationalCarrier",
     XFA_ATTRIBUTEENUM_InternationalCarrier},
    {0xf9fb37ac, L"PDF1.3", XFA_ATTRIBUTEENUM_PDF1_3},
    {0xf9fb37af, L"PDF1.6", XFA_ATTRIBUTEENUM_PDF1_6},
    {0xfbce7f19, L"serif", XFA_ATTRIBUTEENUM_Serif},
    {0xfc82d695, L"postSave", XFA_ATTRIBUTEENUM_PostSave},
    {0xfcef86b5, L"ready", XFA_ATTRIBUTEENUM_Ready},
    {0xfd54fbb7, L"postSign", XFA_ATTRIBUTEENUM_PostSign},
    {0xfdc0aae2, L"Arabic", XFA_ATTRIBUTEENUM_Arabic},
    {0xfe06d2ca, L"error", XFA_ATTRIBUTEENUM_Error},
    {0xfefc4885, L"urlencoded", XFA_ATTRIBUTEENUM_Urlencoded},
    {0xff795ad2, L"lowered", XFA_ATTRIBUTEENUM_Lowered},
};
const int32_t g_iXFAEnumCount =
    sizeof(g_XFAEnumData) / sizeof(XFA_ATTRIBUTEENUMINFO);
