package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSslVpnServers invokes the vpc.DescribeSslVpnServers API synchronously
func (client *Client) DescribeSslVpnServers(request *DescribeSslVpnServersRequest) (response *DescribeSslVpnServersResponse, err error) {
	response = CreateDescribeSslVpnServersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSslVpnServersWithChan invokes the vpc.DescribeSslVpnServers API asynchronously
func (client *Client) DescribeSslVpnServersWithChan(request *DescribeSslVpnServersRequest) (<-chan *DescribeSslVpnServersResponse, <-chan error) {
	responseChan := make(chan *DescribeSslVpnServersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSslVpnServers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSslVpnServersWithCallback invokes the vpc.DescribeSslVpnServers API asynchronously
func (client *Client) DescribeSslVpnServersWithCallback(request *DescribeSslVpnServersRequest, callback func(response *DescribeSslVpnServersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSslVpnServersResponse
		var err error
		defer close(result)
		response, err = client.DescribeSslVpnServers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSslVpnServersRequest is the request struct for api DescribeSslVpnServers
type DescribeSslVpnServersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	SslVpnServerId       string           `position:"Query" name:"SslVpnServerId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	VpnGatewayId         string           `position:"Query" name:"VpnGatewayId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
}

// DescribeSslVpnServersResponse is the response struct for api DescribeSslVpnServers
type DescribeSslVpnServersResponse struct {
	*responses.BaseResponse
	PageSize      int           `json:"PageSize" xml:"PageSize"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	PageNumber    int           `json:"PageNumber" xml:"PageNumber"`
	TotalCount    int           `json:"TotalCount" xml:"TotalCount"`
	SslVpnServers SslVpnServers `json:"SslVpnServers" xml:"SslVpnServers"`
}

// CreateDescribeSslVpnServersRequest creates a request to invoke DescribeSslVpnServers API
func CreateDescribeSslVpnServersRequest() (request *DescribeSslVpnServersRequest) {
	request = &DescribeSslVpnServersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeSslVpnServers", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSslVpnServersResponse creates a response to parse from DescribeSslVpnServers response
func CreateDescribeSslVpnServersResponse() (response *DescribeSslVpnServersResponse) {
	response = &DescribeSslVpnServersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
