# About QGIS

[![Build Status](https://travis-ci.org/qgis/QGIS.svg?branch=master)](https://travis-ci.org/qgis/QGIS)

QGIS is an Open Source Geographic Information System. The project was born in
May of 2002 and was established as a project on SourceForge in June of the same
year. We've worked hard to make GIS software (which is traditionally expensive
commercial software) a viable prospect for anyone with basic access to a
Personal Computer.  QGIS currently runs on most Unix platforms, Windows, and OS
X. QGIS is developed using the Qt toolkit (http://qt.io) and C++.  This
means that QGIS feels snappy to use and has a pleasing, easy to use graphical
user interface.

QGIS aims to be an easy to use GIS, providing common functions and
features. The initial goal was to provide a GIS data viewer. QGIS has
reached that point in its evolution and is being used by many for their
daily GIS data viewing and editing needs. QGIS supports a number of raster
and vector data formats, with new support easily added using the plugin
architecture.

QGIS is released under the GNU Public License (GPL) Version 2. Developing
QGIS under this license means that you can (if you want to) inspect and
modify the source code and guarantees that you, our happy user will always
have access to a GIS program that is free of cost and can be freely
modified.

## Supported raster formats include:

 * Grass
 * USGS DEM
 * ArcInfo binary grid
 * ArcInfo ASCII grid
 * ERDAS Imagine
 * SDTS
 * GeoTiff
 * Tiff with world file

## Supported vector formats include:

 * ESRI Shapefiles
 * PostgreSQL/PostGIS
 * GRASS
 * Spatialite
 * Other OGR supported formats

## Note

Please follow the installation instructions carefully.
After extracting the distribution, you can find the HTML version of the
installation document in qgis/doc/index.html. The installation document is
also available as PDF in the same directory.

## Help us
Please submit bug reports using the [QGIS bug tracker](http://hub.qgis.org/).
When reporting a bug, either login or, if you don't have a qgis trac, provide
an email address where we can request additional information.

## Support
You can get support in the following ways:

 -  Using the QGIS community site at http://qgis.org
 -  Joining the [qgis-users mailing list](http://lists.osgeo.org/mailman/listinfo/qgis-user)
 -  Using IRC by joining the #qgis channel on irc.freenode.net. Please wait
    around for a response to your question as many folks on the channel are
    doing other things and it may take a while for them to notice your question.

QGIS is on GitHub at http://github.com/qgis/QGIS. If you wish to contribute
patches you can fork the project, make your changes, commit to your
repository, and then issue a pull request. The development team can then
review your contribution and commit it upstream as appropriate. See
http://help.github.com/forking/ and http://help.github.com/pull-requests/
for more details.
