///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_VECTOR_CONTROLLER_UI_H
#define __OVITO_VECTOR_CONTROLLER_UI_H

#include <core/Core.h>
#include "FloatControllerUI.h"

namespace Core {

/******************************************************************************
* A parameter UI for parameters controlled by a VectorController object.
* This ParameterUI lets the user edit one of the X, Y and Z components of the vector.
******************************************************************************/
class CORE_DLLEXPORT VectorControllerUI : public FloatControllerUI
{
public:

	/// Constructor.
	VectorControllerUI(PropertiesEditor* parentEditor, const PropertyFieldDescriptor& refField, size_t vectorComponent);
	
	/// This method updates the displayed value of the parameter UI.
	virtual void updateUI();
	
	/// Takes the value entered by the user and stores it in the parameter object
	/// this parameter UI is bound to. 
	virtual void updateParameterValue();
	
private:

	/// The vector component to control (0 - 2).
	size_t component;

	Q_OBJECT
	DECLARE_ABSTRACT_PLUGIN_CLASS(VectorControllerUI)
};

};

#endif // __OVITO_VECTOR_CONTROLLER_UI_H
