/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_BIOSElement.h"

CMPIObjectPath* BIOS_OpenDRIM_BIOSElement_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_BIOSElement& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_BIOSElement_classnames[0], OpenDRIM_BIOSElement_NAMESPACE);

	if (!instance.Name_isNULL)
		op.addKey("Name", instance.Name);

	if (!instance.Version_isNULL)
		op.addKey("Version", instance.Version);

	if (!instance.SoftwareElementState_isNULL)
		op.addKey("SoftwareElementState", instance.SoftwareElementState);

	if (!instance.SoftwareElementID_isNULL)
		op.addKey("SoftwareElementID", instance.SoftwareElementID);

	if (!instance.TargetOperatingSystem_isNULL)
		op.addKey("TargetOperatingSystem", instance.TargetOperatingSystem);

	_L_;
	return op.getHdl();
}

CMPIInstance* BIOS_OpenDRIM_BIOSElement_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_BIOSElement& instance) {
	_E_;
	Objectpath op(broker, BIOS_OpenDRIM_BIOSElement_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.InstanceID_isNULL)
		ci.setProperty("InstanceID", instance.InstanceID);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.OtherTargetOS_isNULL)
		ci.setProperty("OtherTargetOS", instance.OtherTargetOS);

	if (!instance.BuildNumber_isNULL)
		ci.setProperty("BuildNumber", instance.BuildNumber);

	if (!instance.SerialNumber_isNULL)
		ci.setProperty("SerialNumber", instance.SerialNumber);

	if (!instance.CodeSet_isNULL)
		ci.setProperty("CodeSet", instance.CodeSet);

	if (!instance.IdentificationCode_isNULL)
		ci.setProperty("IdentificationCode", instance.IdentificationCode);

	if (!instance.LanguageEdition_isNULL)
		ci.setProperty("LanguageEdition", instance.LanguageEdition);

	if (!instance.Manufacturer_isNULL)
		ci.setProperty("Manufacturer", instance.Manufacturer);

	if (!instance.PrimaryBIOS_isNULL)
		ci.setProperty("PrimaryBIOS", instance.PrimaryBIOS);

	if (!instance.ListOfLanguages_isNULL)
		ci.setProperty("ListOfLanguages", instance.ListOfLanguages);

	if (!instance.CurrentLanguage_isNULL)
		ci.setProperty("CurrentLanguage", instance.CurrentLanguage);

	if (!instance.LoadedStartingAddress_isNULL)
		ci.setProperty("LoadedStartingAddress", instance.LoadedStartingAddress);

	if (!instance.LoadedEndingAddress_isNULL)
		ci.setProperty("LoadedEndingAddress", instance.LoadedEndingAddress);

	if (!instance.LoadUtilityInformation_isNULL)
		ci.setProperty("LoadUtilityInformation", instance.LoadUtilityInformation);

	if (!instance.ReleaseDate_isNULL)
		ci.setPropertyDatetime("ReleaseDate", instance.ReleaseDate);

	if (!instance.RegistryURIs_isNULL)
		ci.setProperty("RegistryURIs", instance.RegistryURIs);

	_L_;
	return ci.getHdl();
}

void BIOS_OpenDRIM_BIOSElement_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_BIOSElement& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (op.getKey("Version", instance.Version) == OK)
		instance.Version_isNULL = false;

	if (op.getKey("TargetOperatingSystem", instance.TargetOperatingSystem) == OK)
		instance.TargetOperatingSystem_isNULL = false;

	if (op.getKey("SoftwareElementID", instance.SoftwareElementID) == OK)
		instance.SoftwareElementID_isNULL = false;

	if (op.getKey("SoftwareElementState", instance.SoftwareElementState) == OK)
		instance.SoftwareElementState_isNULL = false;

	_L_;
}

void BIOS_OpenDRIM_BIOSElement_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_BIOSElement& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("Version", instance.Version) == OK)
		instance.Version_isNULL = false;

	if (inst.getProperty("SoftwareElementState", instance.SoftwareElementState) == OK)
		instance.SoftwareElementState_isNULL = false;

	if (inst.getProperty("SoftwareElementID", instance.SoftwareElementID) == OK)
		instance.SoftwareElementID_isNULL = false;

	if (inst.getProperty("TargetOperatingSystem", instance.TargetOperatingSystem) == OK)
		instance.TargetOperatingSystem_isNULL = false;

	if (inst.getProperty("OtherTargetOS", instance.OtherTargetOS) == OK)
		instance.OtherTargetOS_isNULL = false;

	if (inst.getProperty("BuildNumber", instance.BuildNumber) == OK)
		instance.BuildNumber_isNULL = false;

	if (inst.getProperty("SerialNumber", instance.SerialNumber) == OK)
		instance.SerialNumber_isNULL = false;

	if (inst.getProperty("CodeSet", instance.CodeSet) == OK)
		instance.CodeSet_isNULL = false;

	if (inst.getProperty("IdentificationCode", instance.IdentificationCode) == OK)
		instance.IdentificationCode_isNULL = false;

	if (inst.getProperty("LanguageEdition", instance.LanguageEdition) == OK)
		instance.LanguageEdition_isNULL = false;

	if (inst.getProperty("Manufacturer", instance.Manufacturer) == OK)
		instance.Manufacturer_isNULL = false;

	if (inst.getProperty("PrimaryBIOS", instance.PrimaryBIOS) == OK)
		instance.PrimaryBIOS_isNULL = false;

	if (inst.getProperty("ListOfLanguages", instance.ListOfLanguages) == OK)
		instance.ListOfLanguages_isNULL = false;

	if (inst.getProperty("CurrentLanguage", instance.CurrentLanguage) == OK)
		instance.CurrentLanguage_isNULL = false;

	if (inst.getProperty("LoadedStartingAddress", instance.LoadedStartingAddress) == OK)
		instance.LoadedStartingAddress_isNULL = false;

	if (inst.getProperty("LoadedEndingAddress", instance.LoadedEndingAddress) == OK)
		instance.LoadedEndingAddress_isNULL = false;

	if (inst.getProperty("LoadUtilityInformation", instance.LoadUtilityInformation) == OK)
		instance.LoadUtilityInformation_isNULL = false;

	if (inst.getPropertyDatetime("ReleaseDate", instance.ReleaseDate) == OK)
		instance.ReleaseDate_isNULL = false;

	if (inst.getProperty("RegistryURIs", instance.RegistryURIs) == OK)
		instance.RegistryURIs_isNULL = false;

	_L_;
}

