/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_BIOSServiceCapabilities.h"

CMPIObjectPath* BIOS_OpenDRIM_BIOSServiceCapabilities_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_BIOSServiceCapabilities& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_BIOSServiceCapabilities_classnames[0], OpenDRIM_BIOSServiceCapabilities_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* BIOS_OpenDRIM_BIOSServiceCapabilities_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_BIOSServiceCapabilities& instance) {
	_E_;
	Objectpath op(broker, BIOS_OpenDRIM_BIOSServiceCapabilities_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.MethodsSupported_isNULL)
		ci.setProperty("MethodsSupported", instance.MethodsSupported);

	if (!instance.SupportedPasswordAlgorithms_isNULL)
		ci.setProperty("SupportedPasswordAlgorithms", instance.SupportedPasswordAlgorithms);

	if (!instance.SupportedPasswordEncodings_isNULL)
		ci.setProperty("SupportedPasswordEncodings", instance.SupportedPasswordEncodings);

	_L_;
	return ci.getHdl();
}

void BIOS_OpenDRIM_BIOSServiceCapabilities_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_BIOSServiceCapabilities& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void BIOS_OpenDRIM_BIOSServiceCapabilities_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_BIOSServiceCapabilities& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("MethodsSupported", instance.MethodsSupported) == OK)
		instance.MethodsSupported_isNULL = false;

	if (inst.getProperty("SupportedPasswordAlgorithms", instance.SupportedPasswordAlgorithms) == OK)
		instance.SupportedPasswordAlgorithms_isNULL = false;

	if (inst.getProperty("SupportedPasswordEncodings", instance.SupportedPasswordEncodings) == OK)
		instance.SupportedPasswordEncodings_isNULL = false;

	_L_;
}

