# What's new in octocatalog-diff 1.0

#### Summary

The most significant change in version 1.0 is the addition of the <a href="/doc/dev/api.md">V1 API</a>, which permits developers to build catalogs (<code>--catalog-only</code>) and compare/diff catalogs using octocatalog-diff. Under the hood, we've rearranged the code to support these APIs, which should also improve the reliability and allow faster development cycles.

There are also some additional capabilities including:

- Better display of whitespace differences
- Override ENC parameters with `--to-enc-override` and `--from-enc-override`

#### Breaking changes

The format of the output from <code>--output-format json</code> has changed. In version 0.x of the software, each difference was represented by an array. In version 1.x, each difference is represented by a hash with meaningful English keys. We have added an option <code>--output-format legacy_json</code> which outputs in the old format.

If you have written code that calls the octocatalog-diff command line and expects JSON output, you will need to update your code to the new format, or add or update `--output-format legacy_json` in your call to octocatalog-diff.

#### API stability

The API is versioned, and `v1` will be valid for all 1.x releases. We may add capabilities but will preserve existing functionality as it exists in the initial 1.0 release.

Each API version change will correspond to a new major release number. In other words, a `v2` API would be introduced in a 2.0 release.
