/* NVTV actions -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * Header: X actions.
 *
 */

#ifndef _ACTIONS_H
#define _ACTIONS_H

#include <X11/Xlib.h>

#include "tv_chip.h"
#include "data.h" /* only for make_vidmode */

Bool has_vidmode (Display *display);
void switch_vidmode (Display *display, int screen, int res_x, int res_y);


Bool get_vidmode (Display *display, int screen, int *res_x, int *res_y, 
  TVCrtcRegs *crt, make_vidmode make);
Bool find_vidmode (Display *display, int screen, int res_x, int res_y, 
  TVCrtcRegs *crt, make_vidmode make);

void center_window (Display *display, int screen, Window window,
  int res_x, int res_y);

Window Select_Window (Display *dpy, int screen);
Window Window_With_Name (Display *dpy, Window top, char *name);

#endif
