# Copyright 2013 the V8 project authors. All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#     * Neither the name of Google Inc. nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# This file is automatically generated from the V8 source and should not
# be modified manually, run 'make grokdump' instead to update this file.

# List of known V8 instance types.
INSTANCE_TYPES = {
  64: "STRING_TYPE",
  68: "ONE_BYTE_STRING_TYPE",
  65: "CONS_STRING_TYPE",
  69: "CONS_ONE_BYTE_STRING_TYPE",
  67: "SLICED_STRING_TYPE",
  71: "SLICED_ONE_BYTE_STRING_TYPE",
  66: "EXTERNAL_STRING_TYPE",
  70: "EXTERNAL_ONE_BYTE_STRING_TYPE",
  74: "EXTERNAL_STRING_WITH_ONE_BYTE_DATA_TYPE",
  82: "SHORT_EXTERNAL_STRING_TYPE",
  86: "SHORT_EXTERNAL_ONE_BYTE_STRING_TYPE",
  90: "SHORT_EXTERNAL_STRING_WITH_ONE_BYTE_DATA_TYPE",
  0: "INTERNALIZED_STRING_TYPE",
  4: "ONE_BYTE_INTERNALIZED_STRING_TYPE",
  2: "EXTERNAL_INTERNALIZED_STRING_TYPE",
  6: "EXTERNAL_ONE_BYTE_INTERNALIZED_STRING_TYPE",
  10: "EXTERNAL_INTERNALIZED_STRING_WITH_ONE_BYTE_DATA_TYPE",
  18: "SHORT_EXTERNAL_INTERNALIZED_STRING_TYPE",
  22: "SHORT_EXTERNAL_ONE_BYTE_INTERNALIZED_STRING_TYPE",
  26: "SHORT_EXTERNAL_INTERNALIZED_STRING_WITH_ONE_BYTE_DATA_TYPE",
  128: "SYMBOL_TYPE",
  129: "MAP_TYPE",
  130: "CODE_TYPE",
  131: "ODDBALL_TYPE",
  181: "CELL_TYPE",
  183: "PROPERTY_CELL_TYPE",
  132: "HEAP_NUMBER_TYPE",
  133: "MUTABLE_HEAP_NUMBER_TYPE",
  134: "FLOAT32X4_TYPE",
  135: "FOREIGN_TYPE",
  136: "BYTE_ARRAY_TYPE",
  137: "FREE_SPACE_TYPE",
  138: "EXTERNAL_INT8_ARRAY_TYPE",
  139: "EXTERNAL_UINT8_ARRAY_TYPE",
  140: "EXTERNAL_INT16_ARRAY_TYPE",
  141: "EXTERNAL_UINT16_ARRAY_TYPE",
  142: "EXTERNAL_INT32_ARRAY_TYPE",
  143: "EXTERNAL_UINT32_ARRAY_TYPE",
  144: "EXTERNAL_FLOAT32_ARRAY_TYPE",
  145: "EXTERNAL_FLOAT64_ARRAY_TYPE",
  146: "EXTERNAL_UINT8_CLAMPED_ARRAY_TYPE",
  147: "FIXED_INT8_ARRAY_TYPE",
  148: "FIXED_UINT8_ARRAY_TYPE",
  149: "FIXED_INT16_ARRAY_TYPE",
  150: "FIXED_UINT16_ARRAY_TYPE",
  151: "FIXED_INT32_ARRAY_TYPE",
  152: "FIXED_UINT32_ARRAY_TYPE",
  153: "FIXED_FLOAT32_ARRAY_TYPE",
  154: "FIXED_FLOAT64_ARRAY_TYPE",
  155: "FIXED_UINT8_CLAMPED_ARRAY_TYPE",
  157: "FILLER_TYPE",
  158: "DECLARED_ACCESSOR_DESCRIPTOR_TYPE",
  159: "DECLARED_ACCESSOR_INFO_TYPE",
  160: "EXECUTABLE_ACCESSOR_INFO_TYPE",
  161: "ACCESSOR_PAIR_TYPE",
  162: "ACCESS_CHECK_INFO_TYPE",
  163: "INTERCEPTOR_INFO_TYPE",
  164: "CALL_HANDLER_INFO_TYPE",
  165: "FUNCTION_TEMPLATE_INFO_TYPE",
  166: "OBJECT_TEMPLATE_INFO_TYPE",
  167: "SIGNATURE_INFO_TYPE",
  168: "TYPE_SWITCH_INFO_TYPE",
  170: "ALLOCATION_MEMENTO_TYPE",
  169: "ALLOCATION_SITE_TYPE",
  171: "SCRIPT_TYPE",
  172: "CODE_CACHE_TYPE",
  173: "POLYMORPHIC_CODE_CACHE_TYPE",
  174: "TYPE_FEEDBACK_INFO_TYPE",
  175: "ALIASED_ARGUMENTS_ENTRY_TYPE",
  176: "BOX_TYPE",
  184: "PROTOTYPE_INFO_TYPE",
  179: "FIXED_ARRAY_TYPE",
  156: "FIXED_DOUBLE_ARRAY_TYPE",
  180: "SHARED_FUNCTION_INFO_TYPE",
  182: "WEAK_CELL_TYPE",
  188: "JS_MESSAGE_OBJECT_TYPE",
  187: "JS_VALUE_TYPE",
  189: "JS_DATE_TYPE",
  190: "JS_OBJECT_TYPE",
  191: "JS_CONTEXT_EXTENSION_OBJECT_TYPE",
  192: "JS_GENERATOR_OBJECT_TYPE",
  193: "JS_MODULE_TYPE",
  194: "JS_GLOBAL_OBJECT_TYPE",
  195: "JS_BUILTINS_OBJECT_TYPE",
  196: "JS_GLOBAL_PROXY_TYPE",
  197: "JS_ARRAY_TYPE",
  198: "JS_ARRAY_BUFFER_TYPE",
  199: "JS_TYPED_ARRAY_TYPE",
  200: "JS_DATA_VIEW_TYPE",
  186: "JS_PROXY_TYPE",
  201: "JS_SET_TYPE",
  202: "JS_MAP_TYPE",
  203: "JS_SET_ITERATOR_TYPE",
  204: "JS_MAP_ITERATOR_TYPE",
  205: "JS_WEAK_MAP_TYPE",
  206: "JS_WEAK_SET_TYPE",
  207: "JS_REGEXP_TYPE",
  208: "JS_FUNCTION_TYPE",
  185: "JS_FUNCTION_PROXY_TYPE",
  177: "DEBUG_INFO_TYPE",
  178: "BREAK_POINT_INFO_TYPE",
}

# List of known V8 maps.
KNOWN_MAPS = {
  0x08081: (136, "ByteArrayMap"),
  0x080ad: (129, "MetaMap"),
  0x080d9: (131, "NullMap"),
  0x08105: (179, "FixedArrayMap"),
  0x08131: (4, "OneByteInternalizedStringMap"),
  0x0815d: (182, "WeakCellMap"),
  0x08189: (131, "UndefinedMap"),
  0x081b5: (132, "HeapNumberMap"),
  0x081e1: (137, "FreeSpaceMap"),
  0x0820d: (157, "OnePointerFillerMap"),
  0x08239: (157, "TwoPointerFillerMap"),
  0x08265: (131, "TheHoleMap"),
  0x08291: (131, "BooleanMap"),
  0x082bd: (131, "UninitializedMap"),
  0x082e9: (181, "CellMap"),
  0x08315: (183, "GlobalPropertyCellMap"),
  0x08341: (180, "SharedFunctionInfoMap"),
  0x0836d: (133, "MutableHeapNumberMap"),
  0x08399: (134, "Float32x4Map"),
  0x083c5: (179, "NativeContextMap"),
  0x083f1: (130, "CodeMap"),
  0x0841d: (179, "ScopeInfoMap"),
  0x08449: (179, "FixedCOWArrayMap"),
  0x08475: (156, "FixedDoubleArrayMap"),
  0x084a1: (68, "OneByteStringMap"),
  0x084cd: (179, "FunctionContextMap"),
  0x084f9: (131, "NoInterceptorResultSentinelMap"),
  0x08525: (131, "ArgumentsMarkerMap"),
  0x08551: (131, "ExceptionMap"),
  0x0857d: (131, "TerminationExceptionMap"),
  0x085a9: (179, "HashTableMap"),
  0x085d5: (179, "OrderedHashTableMap"),
  0x08601: (128, "SymbolMap"),
  0x0862d: (64, "StringMap"),
  0x08659: (69, "ConsOneByteStringMap"),
  0x08685: (65, "ConsStringMap"),
  0x086b1: (67, "SlicedStringMap"),
  0x086dd: (71, "SlicedOneByteStringMap"),
  0x08709: (66, "ExternalStringMap"),
  0x08735: (74, "ExternalStringWithOneByteDataMap"),
  0x08761: (70, "ExternalOneByteStringMap"),
  0x0878d: (70, "NativeSourceStringMap"),
  0x087b9: (82, "ShortExternalStringMap"),
  0x087e5: (90, "ShortExternalStringWithOneByteDataMap"),
  0x08811: (0, "InternalizedStringMap"),
  0x0883d: (2, "ExternalInternalizedStringMap"),
  0x08869: (10, "ExternalInternalizedStringWithOneByteDataMap"),
  0x08895: (6, "ExternalOneByteInternalizedStringMap"),
  0x088c1: (18, "ShortExternalInternalizedStringMap"),
  0x088ed: (26, "ShortExternalInternalizedStringWithOneByteDataMap"),
  0x08919: (22, "ShortExternalOneByteInternalizedStringMap"),
  0x08945: (86, "ShortExternalOneByteStringMap"),
  0x08971: (138, "ExternalInt8ArrayMap"),
  0x0899d: (139, "ExternalUint8ArrayMap"),
  0x089c9: (140, "ExternalInt16ArrayMap"),
  0x089f5: (141, "ExternalUint16ArrayMap"),
  0x08a21: (142, "ExternalInt32ArrayMap"),
  0x08a4d: (143, "ExternalUint32ArrayMap"),
  0x08a79: (144, "ExternalFloat32ArrayMap"),
  0x08aa5: (145, "ExternalFloat64ArrayMap"),
  0x08ad1: (146, "ExternalUint8ClampedArrayMap"),
  0x08afd: (148, "FixedUint8ArrayMap"),
  0x08b29: (147, "FixedInt8ArrayMap"),
  0x08b55: (150, "FixedUint16ArrayMap"),
  0x08b81: (149, "FixedInt16ArrayMap"),
  0x08bad: (152, "FixedUint32ArrayMap"),
  0x08bd9: (151, "FixedInt32ArrayMap"),
  0x08c05: (153, "FixedFloat32ArrayMap"),
  0x08c31: (154, "FixedFloat64ArrayMap"),
  0x08c5d: (155, "FixedUint8ClampedArrayMap"),
  0x08c89: (179, "SloppyArgumentsElementsMap"),
  0x08cb5: (179, "CatchContextMap"),
  0x08ce1: (179, "WithContextMap"),
  0x08d0d: (179, "BlockContextMap"),
  0x08d39: (179, "ModuleContextMap"),
  0x08d65: (179, "ScriptContextMap"),
  0x08d91: (179, "ScriptContextTableMap"),
  0x08dbd: (188, "JSMessageObjectMap"),
  0x08de9: (135, "ForeignMap"),
  0x08e15: (190, "NeanderMap"),
  0x08e41: (190, "ExternalMap"),
  0x08e6d: (170, "AllocationMementoMap"),
  0x08e99: (169, "AllocationSiteMap"),
  0x08ec5: (173, "PolymorphicCodeCacheMap"),
  0x08ef1: (171, "ScriptMap"),
  0x0907d: (176, "BoxMap"),
  0x090a9: (160, "ExecutableAccessorInfoMap"),
  0x090d5: (161, "AccessorPairMap"),
  0x09101: (162, "AccessCheckInfoMap"),
  0x0912d: (163, "InterceptorInfoMap"),
  0x09159: (164, "CallHandlerInfoMap"),
  0x09185: (165, "FunctionTemplateInfoMap"),
  0x091b1: (166, "ObjectTemplateInfoMap"),
  0x091dd: (168, "TypeSwitchInfoMap"),
  0x09209: (172, "CodeCacheMap"),
  0x09235: (174, "TypeFeedbackInfoMap"),
  0x09261: (175, "AliasedArgumentsEntryMap"),
  0x0928d: (177, "DebugInfoMap"),
  0x092b9: (178, "BreakPointInfoMap"),
  0x092e5: (184, "PrototypeInfoMap"),
}

# List of known V8 objects.
KNOWN_OBJECTS = {
  ("OLD_SPACE", 0x08081): "NullValue",
  ("OLD_SPACE", 0x08091): "EmptyDescriptorArray",
  ("OLD_SPACE", 0x08099): "EmptyFixedArray",
  ("OLD_SPACE", 0x080bd): "UndefinedValue",
  ("OLD_SPACE", 0x080e5): "NanValue",
  ("OLD_SPACE", 0x080f1): "TheHoleValue",
  ("OLD_SPACE", 0x08111): "TrueValue",
  ("OLD_SPACE", 0x08131): "FalseValue",
  ("OLD_SPACE", 0x08155): "empty_string",
  ("OLD_SPACE", 0x08161): "UninitializedValue",
  ("OLD_SPACE", 0x0818d): "EmptyByteArray",
  ("OLD_SPACE", 0x08195): "NoInterceptorResultSentinel",
  ("OLD_SPACE", 0x081d1): "ArgumentsMarker",
  ("OLD_SPACE", 0x081fd): "Exception",
  ("OLD_SPACE", 0x08225): "TerminationException",
  ("OLD_SPACE", 0x08259): "NumberStringCache",
  ("OLD_SPACE", 0x08a61): "SingleCharacterStringCache",
  ("OLD_SPACE", 0x08ef9): "StringSplitCache",
  ("OLD_SPACE", 0x09301): "RegExpMultipleCache",
  ("OLD_SPACE", 0x09709): "EmptyExternalInt8Array",
  ("OLD_SPACE", 0x09715): "EmptyExternalUint8Array",
  ("OLD_SPACE", 0x09721): "EmptyExternalInt16Array",
  ("OLD_SPACE", 0x0972d): "EmptyExternalUint16Array",
  ("OLD_SPACE", 0x09739): "EmptyExternalInt32Array",
  ("OLD_SPACE", 0x09745): "EmptyExternalUint32Array",
  ("OLD_SPACE", 0x09751): "EmptyExternalFloat32Array",
  ("OLD_SPACE", 0x0975d): "EmptyExternalFloat64Array",
  ("OLD_SPACE", 0x09769): "EmptyExternalUint8ClampedArray",
  ("OLD_SPACE", 0x09775): "EmptyFixedUint8Array",
  ("OLD_SPACE", 0x0977d): "EmptyFixedInt8Array",
  ("OLD_SPACE", 0x09785): "EmptyFixedUint16Array",
  ("OLD_SPACE", 0x0978d): "EmptyFixedInt16Array",
  ("OLD_SPACE", 0x09795): "EmptyFixedUint32Array",
  ("OLD_SPACE", 0x0979d): "EmptyFixedInt32Array",
  ("OLD_SPACE", 0x097a5): "EmptyFixedFloat32Array",
  ("OLD_SPACE", 0x097ad): "EmptyFixedFloat64Array",
  ("OLD_SPACE", 0x097b5): "EmptyFixedUint8ClampedArray",
  ("OLD_SPACE", 0x097bd): "InfinityValue",
  ("OLD_SPACE", 0x097c9): "MinusZeroValue",
  ("OLD_SPACE", 0x097d5): "MessageListeners",
  ("OLD_SPACE", 0x097f1): "CodeStubs",
  ("OLD_SPACE", 0x12439): "ArrayProtector",
  ("OLD_SPACE", 0x12dfd): "KeyedLoadDummyVector",
  ("OLD_SPACE", 0x13cc5): "NonMonomorphicCache",
  ("OLD_SPACE", 0x14009): "PolymorphicCodeCache",
  ("OLD_SPACE", 0x14011): "NativesSourceCache",
  ("OLD_SPACE", 0x142d1): "ExperimentalNativesSourceCache",
  ("OLD_SPACE", 0x14309): "ExtraNativesSourceCache",
  ("OLD_SPACE", 0x14315): "EmptyScript",
  ("OLD_SPACE", 0x14351): "IntrinsicFunctionNames",
  ("OLD_SPACE", 0x233d5): "UndefinedCell",
  ("OLD_SPACE", 0x233dd): "ObservationState",
  ("OLD_SPACE", 0x233e9): "SymbolRegistry",
  ("OLD_SPACE", 0x2429d): "EmptySlowElementDictionary",
  ("OLD_SPACE", 0x242c5): "AllocationSitesScratchpad",
  ("OLD_SPACE", 0x246cd): "WeakObjectToCodeTable",
  ("OLD_SPACE", 0x4a5c1): "StringTable",
  ("CODE_SPACE", 0x180c1): "JsEntryCode",
  ("CODE_SPACE", 0x25c41): "JsConstructEntryCode",
}
