# read-file [![NPM version](https://badge.fury.io/js/read-file.svg)](http://badge.fury.io/js/read-file)

> Thin wrapper around fs.readFile and fs.readFileSync that also strips byte order marks when `utf8` encoding is chosen. Also optionally replaces windows newlines with unix newlines.

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i read-file --save
```

## Usage

```js
var read = require('read-file');

// async
read('foo.txt', function(err, buffer) {
  //=> <Buffer 74 68 69 73 20 69 73 20 66 6f 6f>
});

// sync
var buffer = read.sync('foo.txt');
//=> <Buffer 74 68 69 73 20 69 73 20 66 6f 6f>
```

### BOM

if `utf8` encoding is used, byte order marks will be stripped

**async**

```js
read('foo.txt', 'utf8', function(err, buffer) {
  //=> 'some contents...'
});

// or
read('foo.txt', {encoding: 'utf8'} function(err, buffer) {
  //=> 'some contents...'
});
```

**sync**

```js
read.sync('foo.txt', 'utf8');
// or
read('foo.txt', {encoding: 'utf8'});
```

### options.normalize

Pass `{ normalize: true }` on the options to strip windows carriage returns. This will also return a `utf8` string.

## Related projects

* [copy](https://github.com/jonschlinkert/copy): Copy files or directories using globs.
* [read-yaml](https://github.com/jonschlinkert/read-yaml): Very thin wrapper around js-yaml for directly reading in YAML files.
* [read-data](https://github.com/jonschlinkert/read-data): Read JSON or YAML files.
* [write](https://github.com/jonschlinkert/write): Write files to disk, creating intermediate directories if they don't exist.

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/read-file/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on July 17, 2015._