<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Frame](./puppeteer.frame.md) &gt; [waitForFunction](./puppeteer.frame.waitforfunction.md)

## Frame.waitForFunction() method

<b>Signature:</b>

```typescript
waitForFunction(pageFunction: Function | string, options?: FrameWaitForFunctionOptions, ...args: SerializableOrJSHandle[]): Promise<JSHandle>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  pageFunction | Function \| string | the function to evaluate in the frame context. |
|  options | [FrameWaitForFunctionOptions](./puppeteer.framewaitforfunctionoptions.md) | options to configure the polling method and timeout. |
|  args | [SerializableOrJSHandle](./puppeteer.serializableorjshandle.md)\[\] | arguments to pass to the <code>pageFunction</code>. |

<b>Returns:</b>

Promise&lt;[JSHandle](./puppeteer.jshandle.md)&gt;

the promise which resolve when the `pageFunction` returns a truthy value.

## Remarks


## Example

The `waitForFunction` can be used to observe viewport size change:

```js
const puppeteer = require('puppeteer');

(async () => {
.  const browser = await puppeteer.launch();
.  const page = await browser.newPage();
.  const watchDog = page.mainFrame().waitForFunction('window.innerWidth < 100');
.  page.setViewport({width: 50, height: 50});
.  await watchDog;
.  await browser.close();
})();

```
To pass arguments from Node.js to the predicate of `page.waitForFunction` function:

```js
const selector = '.foo';
await frame.waitForFunction(
  selector => !!document.querySelector(selector),
  {}, // empty options object
  selector
);

```

