/*===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
*/

#include <ngs/ReadGroup.hpp>

namespace ngs
{

    ReadGroup & ReadGroup :: operator = ( ReadGroupRef ref )
        throw ()
    {
        self -> Release ();
        self = ref;

        return * this;
    }
        
    ReadGroup :: ReadGroup ( ReadGroupRef ref )
            throw ()
        : self ( ref )
    {
    }

    ReadGroup & ReadGroup :: operator = ( const ReadGroup & obj )
        throw ()
    {
        self -> Release ();
        self = obj . self -> Duplicate ();

        return * this;
    }
        
    ReadGroup :: ReadGroup ( const ReadGroup & obj )
            throw ()
        : self ( obj . self -> Duplicate () )
    {
    }

    ReadGroup :: ~ ReadGroup ()
        throw ()
    {
        self -> Release ();
        self = 0;
    }

} // namespace ngs