# Copyright 2015 Cloudbase Solutions SRL
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""
Unit tests for the Hyper-V Mechanism Driver.
"""

from hyperv.neutron import constants
from hyperv.neutron.ml2 import mech_hyperv
from hyperv.tests import base


class TestHypervMechanismDriver(base.BaseTestCase):

    def setUp(self):
        super(TestHypervMechanismDriver, self).setUp()
        self.mech_hyperv = mech_hyperv.HypervMechanismDriver()

    def test_get_allowed_network_types(self):
        agent = {'configurations': {'tunnel_types': []}}
        actual_net_types = self.mech_hyperv.get_allowed_network_types(agent)

        network_types = [constants.TYPE_LOCAL, constants.TYPE_FLAT,
                         constants.TYPE_VLAN]
        self.assertEqual(network_types, actual_net_types)

    def test_get_allowed_network_types_nvgre(self):
        agent = {'configurations': {'tunnel_types': [constants.TYPE_NVGRE]}}
        actual_net_types = self.mech_hyperv.get_allowed_network_types(agent)

        network_types = [constants.TYPE_LOCAL, constants.TYPE_FLAT,
                         constants.TYPE_VLAN, constants.TYPE_NVGRE]
        self.assertEqual(network_types, actual_net_types)
