# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['netmiko',
 'netmiko.a10',
 'netmiko.accedian',
 'netmiko.adtran',
 'netmiko.adva',
 'netmiko.alcatel',
 'netmiko.allied_telesis',
 'netmiko.apresia',
 'netmiko.arista',
 'netmiko.arris',
 'netmiko.aruba',
 'netmiko.audiocode',
 'netmiko.broadcom',
 'netmiko.brocade',
 'netmiko.calix',
 'netmiko.casa',
 'netmiko.cdot',
 'netmiko.centec',
 'netmiko.checkpoint',
 'netmiko.ciena',
 'netmiko.cisco',
 'netmiko.citrix',
 'netmiko.cli_tools',
 'netmiko.cloudgenix',
 'netmiko.coriant',
 'netmiko.dell',
 'netmiko.digi',
 'netmiko.dlink',
 'netmiko.eltex',
 'netmiko.endace',
 'netmiko.enterasys',
 'netmiko.ericsson',
 'netmiko.extreme',
 'netmiko.f5',
 'netmiko.fiberstore',
 'netmiko.flexvnf',
 'netmiko.fortinet',
 'netmiko.hillstone',
 'netmiko.hp',
 'netmiko.huawei',
 'netmiko.ipinfusion',
 'netmiko.juniper',
 'netmiko.keymile',
 'netmiko.linux',
 'netmiko.maipu',
 'netmiko.mellanox',
 'netmiko.mikrotik',
 'netmiko.mrv',
 'netmiko.netapp',
 'netmiko.netgear',
 'netmiko.nokia',
 'netmiko.oneaccess',
 'netmiko.ovs',
 'netmiko.paloalto',
 'netmiko.pluribus',
 'netmiko.quanta',
 'netmiko.rad',
 'netmiko.raisecom',
 'netmiko.ruckus',
 'netmiko.ruijie',
 'netmiko.sixwind',
 'netmiko.sophos',
 'netmiko.supermicro',
 'netmiko.teldat',
 'netmiko.terminal_server',
 'netmiko.tplink',
 'netmiko.ubiquiti',
 'netmiko.vyos',
 'netmiko.watchguard',
 'netmiko.yamaha',
 'netmiko.zte',
 'netmiko.zyxel']

package_data = \
{'': ['*']}

install_requires = \
['ntc-templates>=2.0.0',
 'paramiko>=2.9.5',
 'pyserial>=3.3',
 'pyyaml>=5.3',
 'scp>=0.13.6',
 'textfsm>=1.1.3']

entry_points = \
{'console_scripts': ['netmiko-cfg = netmiko.cli_tools.netmiko_cfg:main_ep',
                     'netmiko-grep = netmiko.cli_tools.netmiko_grep:main_ep',
                     'netmiko-show = netmiko.cli_tools.netmiko_show:main_ep']}

setup_kwargs = {
    'name': 'netmiko',
    'version': '4.3.0',
    'description': 'Multi-vendor library to simplify legacy CLI connections to network devices',
    'long_description': '[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/netmiko.svg)](https://img.shields.io/pypi/pyversions/netmiko)\n[![PyPI](https://img.shields.io/pypi/v/netmiko.svg)](https://pypi.python.org/pypi/netmiko)\n[![Downloads](https://static.pepy.tech/badge/netmiko)](https://static.pepy.tech/badge/netmiko)\n[![GitHub contributors](https://img.shields.io/github/contributors/ktbyers/netmiko.svg)](https://GitHub.com/ktbyers/netmiko/graphs/contributors/)\n[![Code Style](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n\n<img src="https://ktbyers.github.io/netmiko/images/netmiko_logo_gh.png" width="320">\n\nNetmiko\n=======\n\nMulti-vendor library to simplify CLI connections to network devices\n\n<br />\n\n## Contributing to Netmiko\n\n[CONTRIBUTING.md](https://github.com/ktbyers/netmiko/blob/develop/CONTRIBUTING.md)\n\n<br />\n\n## Why Netmiko?\nNetwork automation to screen-scraping devices is primarily concerned with gathering output from show commands and with making configuration changes.\n\nNetmiko aims to accomplish both of these operations and to do it across a very broad set of platforms. It seeks to do this while abstracting away low-level state control (i.e. eliminate low-level regex pattern matching to the extent practical).\n\n<br />\n\n## Getting Started\n- [Getting Started](#getting-started-1)\n\n<br />\n\n## Examples\n*You really should look here.*\n\n- [Netmiko Examples](https://github.com/ktbyers/netmiko/blob/develop/EXAMPLES.md)\n\n<br />\n\n\n## Supported Platforms\n\n[PLATFORMS](PLATFORMS.md)\n\n<br />\n\n\n## Installation\n\nTo install netmiko, simply us pip:\n\n```\n$ pip install netmiko\n```\n\n<br />\n\n## API-Documentation\n\n[API-Documentation](https://ktbyers.github.io/netmiko/docs/netmiko/index.html)\n\n<br />\n\n## Common Issues/FAQ\n\nAnswers to some [common questions](COMMON_ISSUES.md)\n\n<br />\n\n### Tutorials\n\n- [Netmiko Overview](https://pynet.twb-tech.com/blog/automation/netmiko.html)\n- [Secure Copy](https://pynet.twb-tech.com/blog/automation/netmiko-scp.html)\n- [Netmiko through SSH Proxy](https://pynet.twb-tech.com/blog/automation/netmiko-proxy.html)\n- [Netmiko and TextFSM](https://pynet.twb-tech.com/blog/automation/netmiko-textfsm.html)\n- [Netmiko and what constitutes done](https://pynet.twb-tech.com/blog/automation/netmiko-what-is-done.html)\n\n<br />\n\n### Getting Started:\n\n#### Create a dictionary representing the device.\n\nSupported device_types can be found in [ssh_dispatcher.py](https://github.com/ktbyers/netmiko/blob/master/netmiko/ssh_dispatcher.py), see CLASS_MAPPER keys.\n```py\nfrom netmiko import ConnectHandler\n\ncisco_881 = {\n    \'device_type\': \'cisco_ios\',\n    \'host\':   \'10.10.10.10\',\n    \'username\': \'test\',\n    \'password\': \'password\',\n    \'port\' : 8022,          # optional, defaults to 22\n    \'secret\': \'secret\',     # optional, defaults to \'\'\n}\n\n```\n\n#### Establish an SSH connection to the device by passing in the device dictionary.\n\n```py\nnet_connect = ConnectHandler(**cisco_881)\n```\n\n#### Execute show commands.\n\n```py\noutput = net_connect.send_command(\'show ip int brief\')\nprint(output)\n```\n```\nInterface                  IP-Address      OK? Method Status                Protocol\nFastEthernet0              unassigned      YES unset  down                  down\nFastEthernet1              unassigned      YES unset  down                  down\nFastEthernet2              unassigned      YES unset  down                  down\nFastEthernet3              unassigned      YES unset  down                  down\nFastEthernet4              10.10.10.10     YES manual up                    up\nVlan1                      unassigned      YES unset  down                  down\n```\n\n#### Execute configuration change commands (will automatically enter into config mode)\n\n```py\nconfig_commands = [ \'logging buffered 20000\',\n                    \'logging buffered 20010\',\n                    \'no logging console\' ]\noutput = net_connect.send_config_set(config_commands)\nprint(output)\n```\n```\npynet-rtr1#config term\nEnter configuration commands, one per line.  End with CNTL/Z.\npynet-rtr1(config)#logging buffered 20000\npynet-rtr1(config)#logging buffered 20010\npynet-rtr1(config)#no logging console\npynet-rtr1(config)#end\npynet-rtr1#\n```\n\n<br />\n\n## API-Documentation\n\n<a href="https://ktbyers.github.io/netmiko/docs/netmiko/index.html" title="Docs">API Documentation</a>\n\nBelow are some of the particularly handy Classes/functions for easy reference:\n- [Base Connection Object](https://ktbyers.github.io/netmiko/docs/netmiko/base_connection.html)\n- [SSH Autodetect](https://ktbyers.github.io/netmiko/docs/netmiko/index.html#netmiko.SSHDetect)\n- [SSH Dispatcher](https://ktbyers.github.io/netmiko/docs/netmiko/index.html#netmiko.ssh_dispatcher)\n- [Redispatch](https://ktbyers.github.io/netmiko/docs/netmiko/index.html#netmiko.redispatch)\n\n<br />\n\n## Contributing\n\nContributors are welcome.\n\nYou can contribute to Netmiko in a variety of ways: answering questions on Slack (see below in Questions/Discussions), responding to issues, adding to the common issues, reporting/fixing bugs, or even adding your own device type.\n\nBefore contributing a new vendor/platform device type, remember that any code added needs to be supported in some fashion. To add a vendor/platform you can follow the outline [here](VENDOR.md). Once you\'ve worked on your first pass of your driver and have it functional, you\'ll need to include test data in order for it to be merged into develop, you can see the general flow of how to do that [here](TESTING.md).\n\nFor all code contributions, please ensure that you have ran `black` against the code or your code will fail the Travis CI build.\n\n<br />\n\n## Questions/Discussion\n\nIf you find an issue with Netmiko, then you can open an issue on this projects issue page here: [https://github.com/ktbyers/netmiko/issues](https://github.com/ktbyers/netmiko/issues). Please make sure you\'ve read through the common issues and examples prior to opening an issue. Please only open issues for bugs, feature requests, or other topics related to development of Netmiko. If you simply have a question, join us on Slack...\n\nIf you have questions or would like to discuss Netmiko, a #netmiko channel exists in [this Slack](https://pynet.slack.com) workspace. To join, use [this invitation](https://join.slack.com/t/pynet/shared_invite/zt-km2k3upf-AkWHY4YEx3sI1R5irMmc7Q). Once you have entered the workspace, then you can join the #netmiko channel.\n\n\n---\nKirk Byers  \nPython for Network Engineers  \nhttps://pynet.twb-tech.com  \n',
    'author': 'Kirk Byers',
    'author_email': 'ktbyers@twb-tech.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ktbyers/netmiko',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
