/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2011 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2011 Sun Microsystems, Inc.
 */
package org.netbeans.modules.refactoring.java.test;

import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.JavaMoveMembersProperties.Visibility;

/**
 *
 * @author Ralph Ruijs
 */
public class MoveMethodTest extends MoveBaseTest {

    public MoveMethodTest(String name) {
        super(name);
    }
    
    public void test236877() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/SourceClass.java", "package t;\n"
                + "public class SourceClass {\n"
                + "    public void movedMethod(SourceClass a) {\n"
                + "    }\n"
                + "}\n"),
                new File("u/TargetClass.java", "package u;\n"
                + "public class TargetClass {\n"
                + "}\n"));
        performMove(src.getFileObject("t/SourceClass.java"), new int[]{1}, src.getFileObject("u/TargetClass.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/SourceClass.java", "package t;\n"
                + "public class SourceClass {\n"
                + "}\n"),
                new File("u/TargetClass.java", "package u;\n"
                + "import t.SourceClass;\n"
                + "public class TargetClass {\n"
                + "    public void movedMethod(SourceClass a) {\n"
                + "    }\n"
                + "}\n"));
    }
    
    public void testMoveComments() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                        + "public class A {\n"
                        + "    public void doStuff() {\n"
                        + "        // do stuff dude!\n"
                        + "        //more stuff\n"
                        + "        int i = 2 + 2;\n"
                        + "        assert i == 4;\n"
                        + "        // more stuff\n"
                        + "        // do stuff dude!\n"
                        + "        //more stuff\n"
                        + "        i = 2 + 2;\n"
                        + "        assert i == 4;\n"
                        + "        // more stuff\n"
                        + "        // do stuff dude!\n"
                        + "        //more stuff\n"
                        + "        i = 2 + 2;\n"
                        + "        assert i == 4;\n"
                        + "        // more stuff\n"
                        + "        // do stuff dude!\n"
                        + "        //more stuff\n"
                        + "        i = 2 + 2;\n"
                        + "        assert i == 4;\n"
                        + "        // more stuff\n"
                        + "        // do stuff dude!\n"
                        + "        //more stuff\n"
                        + "        i = 2 + 2;\n"
                        + "        assert i == 4;\n"
                        + "        // more stuff\n"
                        + "    }\n"
                        + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public void doStuff() {\n"
                + "        // do stuff dude!\n"
                + "        //more stuff\n"
                + "        int i = 2 + 2;\n"
                + "        assert i == 4;\n"
                + "        // more stuff\n"
                + "        // do stuff dude!\n"
                + "        //more stuff\n"
                + "        i = 2 + 2;\n"
                + "        assert i == 4;\n"
                + "        // more stuff\n"
                + "        // do stuff dude!\n"
                + "        //more stuff\n"
                + "        i = 2 + 2;\n"
                + "        assert i == 4;\n"
                + "        // more stuff\n"
                + "        // do stuff dude!\n"
                + "        //more stuff\n"
                + "        i = 2 + 2;\n"
                + "        assert i == 4;\n"
                + "        // more stuff\n"
                + "        // do stuff dude!\n"
                + "        //more stuff\n"
                + "        i = 2 + 2;\n"
                + "        assert i == 4;\n"
                + "        // more stuff\n"
                + "    }\n"
                + "}\n"));
    }
    
    public void testMoveGenericReturn() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "import java.util.List;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    List<String> i() { return null; }\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(a.i());\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "import java.util.List;\n"
                + "public class A {\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "import java.util.List;\n"
                + "public class B {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "    /** Something about i */\n"
                + "    public List<String> i() { return null; }\n"
                + "}\n"));
    }
    
    public void testMoveKeepOld() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public static String param = \"a\";\n"
                + "    \n"
                + "    public static void movedMethod(String p) {\n"
                + "        \n"
                + "    }\n"
                + "    \n"
                + "    public void test() {\n"
                + "        movedMethod(param);\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{2}, src.getFileObject("t/B.java"), Visibility.ASIS, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public static String param = \"a\";\n"
                + "    \n"
                + "    public void test() {\n"
                + "        B.movedMethod(param);\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    \n"
                + "    public static void movedMethod(String p) {\n"
                + "        \n"
                + "    }\n"
                + "}\n"));
    }
    
    public void test232604() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    int i(D d, B b) { return b.b; }\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(i(null, new B()));\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public int b = 5;\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(a.i(null, this));\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(a.i(null, b));\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(new B().i(null));\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public int b = 5;\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(i(null));\n"
                + "    }\n"
                + "    /** Something about i */\n"
                + "    public int i(D d) { return this.b; }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.i(null));\n"
                + "    }\n"
                + "}\n"));
    }

    public void test232902() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "\n"
                + "    private void instanceMethod() {\n"
                + "    }\n"
                + "\n"
                + "    public void usage(InnerTarget ic) throws IOException {\n"
                + "        instanceMethod();\n"
                + "    }\n"
                + "\n"
                + "    public class InnerTarget {\n"
                + "\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{2}, "t.A.InnerTarget", Visibility.ESCALATE);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "\n"
                + "    public void usage(InnerTarget ic) throws IOException {\n"
                + "        ic.instanceMethod();\n"
                + "    }\n"
                + "\n"
                + "    public class InnerTarget {\n"
                + "\n"
                + "    private void instanceMethod() {\n"
                + "    }\n"
                + "\n"
                + "    }\n"
                + "}\n"));
    }
    
    public void test222403() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public Runnable create() {\n"
                + "        return new Runnable() {\n"
                + "            public void run() {\n"
                + "            }\n"
                + "        };\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public Runnable create() {\n"
                + "        return new Runnable() {\n"
                + "            public void run() {\n"
                + "            }\n"
                + "        };\n"
                + "    }\n"
                + "}\n"));
    }
    
    public void test215809() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    int i() { return 1; }\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    /** Something about i */\n"
                + "    int i(boolean j) { return 2; }\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(a.i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(a.i());\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    /** Something about i */\n"
                + "    int i(boolean j) { return 2; }\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "    /** Something about i */\n"
                + "    public int i() { return 1; }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.i());\n"
                + "    }\n"
                + "}\n"));
    }
    
    public void testMoveAbstractPolymorphic() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public void foo() {\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "    public abstract void bar();\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B extends A {\n"
                + "    public void foo() {\n"
                + "        System.out.println(j());\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public interface C {\n"
                + "    void doo();"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/C.java"), Visibility.PUBLIC, false, new Problem(true, "ERR_MoveMethodPolymorphic"));
        performMove(src.getFileObject("t/A.java"), new int[]{2}, src.getFileObject("t/C.java"), Visibility.PUBLIC, false, new Problem(true, "ERR_MoveAbstractMember"));
        performMove(src.getFileObject("t/C.java"), new int[]{0}, src.getFileObject("t/A.java"), Visibility.PUBLIC, false, new Problem(true, "ERR_MoveFromClass"));
    }

    public void test209620() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/SourceClass.java", "package t;\n"
                + "public class SourceClass {\n"
                + "    static int field;\n"
                + "\n"
                + "    public void movedMethod() {\n"
                + "        if(field==1) field++;\n"
                + "        java.util.Random r = new java.util.Random(field);\n"
                + "        field = r.nextInt();\n"
                + "    }\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        t.SourceClass.this.movedMethod();\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "public class TargetClass {\n"
                + "}\n"));
        performMove(src.getFileObject("t/SourceClass.java"), new int[]{}, null, Visibility.ASIS, false, new Problem(true, "ERR_NothingSelected"));
        verifyContent(src,
                new File("t/SourceClass.java", "package t;\n"
                + "public class SourceClass {\n"
                + "    static int field;\n"
                + "\n"
                + "    public void movedMethod() {\n"
                + "        if(field==1) field++;\n"
                + "        java.util.Random r = new java.util.Random(field);\n"
                + "        field = r.nextInt();\n"
                + "    }\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        t.SourceClass.this.movedMethod();\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "public class TargetClass {\n"
                + "}\n"));
    }

    public void test207833() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/SourceClass.java", "package t;\n"
                + "public class SourceClass {\n"
                + "    static int field;\n"
                + "\n"
                + "    public void movedMethod() {\n"
                + "        if(field==1) field++;\n"
                + "        java.util.Random r = new java.util.Random(field);\n"
                + "        field = r.nextInt();\n"
                + "    }\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        t.SourceClass.this.movedMethod();\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "public class TargetClass {\n"
                + "}\n"));
        performMove(src.getFileObject("t/SourceClass.java"), new int[]{2}, src.getFileObject("t/TargetClass.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/SourceClass.java", "package t;\n"
                + "public class SourceClass {\n"
                + "    static int field;\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        tClass.movedMethod();\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "import java.util.Random;\n"
                + "public class TargetClass {\n"
                + "    public void movedMethod() {\n"
                + "        if (SourceClass.field == 1) { SourceClass.field++; }\n"
                + "        Random r = new Random(SourceClass.field);\n"
                + "        SourceClass.field = r.nextInt();\n"
                + "    }\n"
                + "\n"
                + "}\n"));
    }

    public void testMoveImports() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/SourceClass.java", "package t;\n"
                + "import java.util.Random;\n"
                + "public class SourceClass {\n"
                + "    static int field;\n"
                + "\n"
                + "    public void movedMethod() {\n"
                + "        if(field==1) field++;\n"
                + "        Random r = new Random(field);\n"
                + "        field = r.nextInt();\n"
                + "    }\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        movedMethod();\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "public class TargetClass {\n"
                + "}\n"));
        performMove(src.getFileObject("t/SourceClass.java"), new int[]{2}, src.getFileObject("t/TargetClass.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/SourceClass.java", "package t;\n"
                + "import java.util.Random;\n"
                + "public class SourceClass {\n"
                + "    static int field;\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        tClass.movedMethod();\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "import java.util.Random;\n"
                + "public class TargetClass {\n"
                + "    public void movedMethod() {\n"
                + "        if (SourceClass.field == 1) { SourceClass.field++; }\n"
                + "        Random r = new Random(SourceClass.field);\n"
                + "        SourceClass.field = r.nextInt();\n"
                + "    }\n"
                + "\n"
                + "}\n"));
    }
    
    public void testMoveImportsb() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/SourceClass.java", "package t;\n"
                + "import java.util.Random;\n"
                + "public class SourceClass {\n"
                + "\n"
                + "    public Random movedMethod() {\n"
                + "        return null;\n"
                + "    }\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        Random r = movedMethod();\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "public class TargetClass {\n"
                + "}\n"));
        performMove(src.getFileObject("t/SourceClass.java"), new int[]{1}, src.getFileObject("t/TargetClass.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/SourceClass.java", "package t;\n"
                + "import java.util.Random;\n"
                + "public class SourceClass {\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        Random r = tClass.movedMethod();\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "import java.util.Random;\n"
                + "public class TargetClass {\n"
                + "    public Random movedMethod() {\n"
                + "        return null;\n"
                + "    }\n"
                + "\n"
                + "}\n"));
    }

    public void testMoveParameterNotNeeded() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/SourceClass.java", "package t;\n"
                + "public class SourceClass {\n"
                + "    static int field;\n"
                + "\n"
                + "    public void movedMethod() {\n"
                + "        if(field==1) field++;\n"
                + "    }\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        movedMethod();\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "public class TargetClass {\n"
                + "}\n"));
        performMove(src.getFileObject("t/SourceClass.java"), new int[]{2}, src.getFileObject("t/TargetClass.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/SourceClass.java", "package t;\n"
                + "public class SourceClass {\n"
                + "    static int field;\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        tClass.movedMethod();\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "public class TargetClass {\n"
                + "    public void movedMethod() {\n"
                + "        if (SourceClass.field == 1) { SourceClass.field++; }\n"
                + "    }\n"
                + "\n"
                + "}\n"));
    }

    public void testMoveParameterMissing() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/SourceClass.java", "package t;\n"
                + "public class SourceClass {\n"
                + "    int field;\n"
                + "\n"
                + "    public void movedMethod() {\n"
                + "        if(field==1) field++;\n"
                + "    }\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        movedMethod();\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "public class TargetClass {\n"
                + "}\n"));
        performMove(src.getFileObject("t/SourceClass.java"), new int[]{2}, src.getFileObject("t/TargetClass.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/SourceClass.java", "package t;\n"
                + "public class SourceClass {\n"
                + "    int field;\n"
                + "\n"
                + "    public void usage() {\n"
                + "        TargetClass tClass = new TargetClass();\n"
                + "        tClass.movedMethod(this);\n"
                + "    }\n"
                + "}\n"),
                new File("t/TargetClass.java", "package t;\n"
                + "public class TargetClass {\n"
                + "    public void movedMethod(SourceClass sourceClass) {\n"
                + "        if (sourceClass.field == 1) { sourceClass.field++; }\n"
                + "    }\n"
                + "\n"
                + "}\n"));
    }

    public void testMoveExists() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    static int i() { return 1; }\n"
                + "    public void foo() {\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    /** Something about j */\n"
                + "    static int i() { return 1; }\n"
                + "    public void foo() {\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false, new Problem(true, "ERR_existingMethod"));
    }

    public void testMoveToLibrary() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    static int i() { return 1; }\n"
                + "    public void foo() {\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, "java.lang.String", Visibility.PUBLIC, new Problem(true, "ERR_MoveToLibrary"));
    }

//    TODO: Fix
//    public void testMoveFromLibrary() throws Exception {
//        writeFilesAndWaitForScan(src,
//                new File("t/A.java", "package t;\n"
//                + "public class A {\n"
//                + "    /** Something about i */\n"
//                + "    static int i() { return 1; }\n"
//                + "    public void foo() {\n"
//                + "        System.out.println(i());\n"
//                + "    }\n"
//                + "}\n"));
//        performMove("java.lang.String", new int[]{1}, src.getFileObject("t/A.java"), Visibility.PUBLIC, new Problem(true, "ERR_MoveFromLibrary"));
//    }
    public void testMoveSubSuper() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    static int i() { return 1; }\n"
                + "    public void foo() {\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B extends A {\n"
                + "    /** Something about j */\n"
                + "    static int j() { return 1; }\n"
                + "    public void foo() {\n"
                + "        System.out.println(j());\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/A.java"), Visibility.PUBLIC, false, new Problem(true, "ERR_MoveToSameClass"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false, new Problem(true, "ERR_MoveToSubClass"));
        performMove(src.getFileObject("t/B.java"), new int[]{1}, src.getFileObject("t/A.java"), Visibility.PUBLIC, false, new Problem(true, "ERR_MoveToSuperClass"));
    }

    public void testMoveToStatic() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    int i() { return 1; }\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public static void main(String[] args) {\n"
                + "        A a = new A();\n"
                + "        System.out.println(a.i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(a.i());\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false, new Problem(false, "WRN_NoAccessor"));
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public static void main(String[] args) {\n"
                + "        A a = new A();\n"
                + "        System.out.println(a.i());\n"
                + "    }\n"
                + "    /** Something about i */\n"
                + "    public int i() { return 1; }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.i());\n"
                + "    }\n"
                + "}\n"));
    }

    public void testMoveStatic() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    static int i(B b) { return b.i; }\n"
                + "    public void foo() {\n"
                + "        System.out.println(i(new B()));\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public int i = 42;\n"
                + "    public void foo() {\n"
                + "        System.out.println(A.i(this));\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        System.out.println(A.i(new B()));\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public void foo() {\n"
                + "        System.out.println(B.i(new B()));\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    /** Something about i */\n"
                + "    public static int i(B b) { return b.i; }\n"
                + "    public int i = 42;\n"
                + "    public void foo() {\n"
                + "        System.out.println(i(this));\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        System.out.println(B.i(new B()));\n"
                + "    }\n"
                + "}\n"));
    }
    
    public void test216700() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public static void method() {\n"
                + "        A.method();\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A.method();\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public static void method() {\n"
                + "        B.method();\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        B.method();\n"
                + "    }\n"
                + "}\n"));
    }

    public void testMoveNoAccessor() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    int i() { return 1; }\n"
                + "    public void foo() {\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(a.i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(a.i());\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false, new Problem(false, "WRN_NoAccessor"));
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public void foo() {\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "    /** Something about i */\n"
                + "    public int i() { return 1; }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.i());\n"
                + "    }\n"
                + "}\n"));
    }

    public void testMoveGeneric() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A <E> {\n"
                + "    /** Something about i */\n"
                + "    E i() { return null; }\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public void foo() {\n"
                + "        A<String> a = new A<String>();\n"
                + "        System.out.println(a.i());\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A <E> {\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.<E>i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public void foo() {\n"
                + "        A<String> a = new A<String>();\n"
                + "        System.out.println(this.<String>i());\n"
                + "    }\n"
                + "    /** Something about i */\n"
                + "    public <E> E i() { return null; }\n"
                + "}\n"));
    }

    public void testMoveInstance() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    int i() { return 1; }\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(a.i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(a.i());\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "    /** Something about i */\n"
                + "    public int i() { return 1; }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.i());\n"
                + "    }\n"
                + "}\n"));
    }

    public void testMoveDelegate() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    int i(B b) { return b.b; }\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(i(new B()));\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public int b = 5;\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(a.i(this));\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(a.i(b));\n"
                + "    }\n"
                + "}\n"));

        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, true);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    int i(B b) { return b.i(); }\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(i(new B()));\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public int b = 5;\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(a.i(this));\n"
                + "    }\n"
                + "    /** Something about i */\n"
                + "    public int i() { return this.b; }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(a.i(b));\n"
                + "    }\n"
                + "}\n"));
    }

    public void testMoveInstanceParameter() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    int i(B b) { return b.b; }\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(i(new B()));\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public int b = 5;\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(a.i(this));\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(a.i(b));\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(new B().i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public int b = 5;\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "    /** Something about i */\n"
                + "    public int i() { return this.b; }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.i());\n"
                + "    }\n"
                + "}\n"));
    }

    public void testMoveInstanceLocalAccessors() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    /** Something about i */\n"
                + "    int i(B b) { return b.b; }\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(i(new B()));\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public int b = 5;\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(a.i(this));\n"
                + "    }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(a.i(b));\n"
                + "    }\n"
                + "}\n"));
        performMove(src.getFileObject("t/A.java"), new int[]{1}, src.getFileObject("t/B.java"), Visibility.PUBLIC, false);
        verifyContent(src,
                new File("t/A.java", "package t;\n"
                + "public class A {\n"
                + "    public void foo() {\n"
                + "        B b = new B();\n"
                + "        System.out.println(new B().i());\n"
                + "    }\n"
                + "}\n"),
                new File("t/B.java", "package t;\n"
                + "public class B {\n"
                + "    public int b = 5;\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        System.out.println(i());\n"
                + "    }\n"
                + "    /** Something about i */\n"
                + "    public int i() { return this.b; }\n"
                + "}\n"),
                new File("t/C.java", "package t;\n"
                + "public class C {\n"
                + "    public void foo() {\n"
                + "        A a = new A();\n"
                + "        B b = new B();\n"
                + "        System.out.println(b.i());\n"
                + "    }\n"
                + "}\n"));
    }

    public void testVideoStore() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("videostore/Movie.java", "package videostore;\n"
                + "\n"
                + "public class Movie {\n"
                + "    \n"
                + "    public static final int CHILDRENS = 2;\n"
                + "    public static final int REGULAR = 0;\n"
                + "    public static final int NEW_RELEASE = 1;\n"
                + "\n"
                + "    private String title;\n"
                + "    private int priceCode;\n"
                + "\n"
                + "    public Movie(String title, int priceCode) {\n"
                + "        this.title = title;\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public int getPriceCode() {\n"
                + "        return priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public void setPriceCode(int priceCode) {\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public String getTitle() {\n"
                + "        return title;\n"
                + "    }\n"
                + "}"),
                new File("videostore/Rental.java", "package videostore;\n"
                + "\n"
                + "public class Rental {\n"
                + "\n"
                + "    private Movie movie;\n"
                + "    private int daysRent;\n"
                + "\n"
                + "    public Rental(Movie movie, int daysRent) {\n"
                + "        this.movie = movie;\n"
                + "        this.daysRent = daysRent;\n"
                + "    }\n"
                + "\n"
                + "    public Movie getMovie() {\n"
                + "        return movie;\n"
                + "    }\n"
                + "\n"
                + "    public int getDaysRent() {\n"
                + "        return daysRent;\n"
                + "    }\n"
                + "}"),
                new File("videostore/Customer.java", "package videostore;\n"
                + "\n"
                + "import java.util.Enumeration;\n"
                + "import java.util.Vector;\n"
                + "\n"
                + "public class Customer {\n"
                + "\n"
                + "    private String name;\n"
                + "    private Vector rentals = new Vector();\n"
                + "\n"
                + "    public Customer(String name) {\n"
                + "        this.name = name;\n"
                + "    }\n"
                + "    \n"
                + "    public void addRental(Rental rental) {\n"
                + "        rentals.addElement(rental);\n"
                + "    }\n"
                + "\n"
                + "    public String getName() {\n"
                + "        return name;\n"
                + "    }\n"
                + "    \n"
                + "    public String statement() {\n"
                + "        double totalAmount = 0;\n"
                + "        int frequentRenterpoints = 0;\n"
                + "        Enumeration rentalelements = rentals.elements();\n"
                + "        String result = \"Rental Record for \" + getName() + \"\\n\";\n"
                + "        while(rentalelements.hasMoreElements()) {\n"
                + "            Rental each = (Rental) rentalelements.nextElement();\n"
                + "            double thisAmount = amountFor(each);\n"
                + "            \n"
                + "            // add frequent renter points\n"
                + "            frequentRenterpoints++;\n"
                + "            // add bonus for a two day new release rental\n"
                + "            if((each.getMovie().getPriceCode() == Movie.NEW_RELEASE) &&\n"
                + "                    each.getDaysRent() > 1) frequentRenterpoints++;\n"
                + "            \n"
                + "            // show figures for this rental\n"
                + "            result += \"\\t\" + each.getMovie().getTitle() + \"\\t\" +\n"
                + "                    String.valueOf(thisAmount) + \"\\n\";\n"
                + "            totalAmount += thisAmount;\n"
                + "        }\n"
                + "        // add footer lines\n"
                + "        result += \"Amount owed is \" + String.valueOf(totalAmount) + \"\\n\";\n"
                + "        result += \"You earned \" + String.valueOf(frequentRenterpoints) +\n"
                + "                \" frequent renter points\";\n"
                + "        return result;\n"
                + "    }\n"
                + "\n"
                + "    private double amountFor(Rental rental) {\n"
                + "        // determine amounts for each line\n"
                + "        double result = 0;\n"
                + "        switch(rental.getMovie().getPriceCode()) {\n"
                + "            case Movie.REGULAR:\n"
                + "                result += 2;\n"
                + "                if(rental.getDaysRent() > 2)\n"
                + "                    result += (rental.getDaysRent() - 2) * 1.5;\n"
                + "                break;\n"
                + "            case Movie.NEW_RELEASE:\n"
                + "                result += rental.getDaysRent() * 3;\n"
                + "                break;\n"
                + "            case Movie.CHILDRENS:\n"
                + "                result += 1.5;\n"
                + "                if(rental.getDaysRent() > 3)\n"
                + "                    result += (rental.getDaysRent() -3) * 1.5;\n"
                + "                break;\n"
                + "        }\n"
                + "        return result;\n"
                + "    }\n"
                + "}"));
        performMove(src.getFileObject("videostore/Customer.java"), new int[]{6}, src.getFileObject("videostore/Rental.java"), Visibility.ESCALATE, false);
        verifyContent(src,
                new File("videostore/Movie.java", "package videostore;\n"
                + "\n"
                + "public class Movie {\n"
                + "    \n"
                + "    public static final int CHILDRENS = 2;\n"
                + "    public static final int REGULAR = 0;\n"
                + "    public static final int NEW_RELEASE = 1;\n"
                + "\n"
                + "    private String title;\n"
                + "    private int priceCode;\n"
                + "\n"
                + "    public Movie(String title, int priceCode) {\n"
                + "        this.title = title;\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public int getPriceCode() {\n"
                + "        return priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public void setPriceCode(int priceCode) {\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public String getTitle() {\n"
                + "        return title;\n"
                + "    }\n"
                + "}"),
                new File("videostore/Rental.java", "package videostore;\n"
                + "\n"
                + "public class Rental {\n"
                + "\n"
                + "    private Movie movie;\n"
                + "    private int daysRent;\n"
                + "\n"
                + "    public Rental(Movie movie, int daysRent) {\n"
                + "        this.movie = movie;\n"
                + "        this.daysRent = daysRent;\n"
                + "    }\n"
                + "\n"
                + "    public Movie getMovie() {\n"
                + "        return movie;\n"
                + "    }\n"
                + "\n"
                + "    public int getDaysRent() {\n"
                + "        return daysRent;\n"
                + "    }\n"
                + "\n"
                + "    double amountFor() {\n"
                + "        // determine amounts for each line\n"
                + "        double result = 0;\n"
                + "        switch (this.getMovie().getPriceCode()) {\n"
                + "            case Movie.REGULAR:\n"
                + "                result += 2;\n"
                + "                if (this.getDaysRent() > 2) {\n"
                + "                    result += (this.getDaysRent() - 2) * 1.5;\n"
                + "                }\n"
                + "                break;\n"
                + "            case Movie.NEW_RELEASE:\n"
                + "                result += this.getDaysRent() * 3;\n"
                + "                break;\n"
                + "            case Movie.CHILDRENS:\n"
                + "                result += 1.5;\n"
                + "                if (this.getDaysRent() > 3) {\n"
                + "                    result += (this.getDaysRent() - 3) * 1.5;\n"
                + "                }\n"
                + "                break;\n"
                + "        }\n"
                + "        return result;\n"
                + "    }\n"
                + "}"),
                new File("videostore/Customer.java", "package videostore;\n"
                + "\n"
                + "import java.util.Enumeration;\n"
                + "import java.util.Vector;\n"
                + "\n"
                + "public class Customer {\n"
                + "\n"
                + "    private String name;\n"
                + "    private Vector rentals = new Vector();\n"
                + "\n"
                + "    public Customer(String name) {\n"
                + "        this.name = name;\n"
                + "    }\n"
                + "    \n"
                + "    public void addRental(Rental rental) {\n"
                + "        rentals.addElement(rental);\n"
                + "    }\n"
                + "\n"
                + "    public String getName() {\n"
                + "        return name;\n"
                + "    }\n"
                + "    \n"
                + "    public String statement() {\n"
                + "        double totalAmount = 0;\n"
                + "        int frequentRenterpoints = 0;\n"
                + "        Enumeration rentalelements = rentals.elements();\n"
                + "        String result = \"Rental Record for \" + getName() + \"\\n\";\n"
                + "        while(rentalelements.hasMoreElements()) {\n"
                + "            Rental each = (Rental) rentalelements.nextElement();\n"
                + "            double thisAmount = each.amountFor();\n"
                + "            \n"
                + "            // add frequent renter points\n"
                + "            frequentRenterpoints++;\n"
                + "            // add bonus for a two day new release rental\n"
                + "            if((each.getMovie().getPriceCode() == Movie.NEW_RELEASE) &&\n"
                + "                    each.getDaysRent() > 1) frequentRenterpoints++;\n"
                + "            \n"
                + "            // show figures for this rental\n"
                + "            result += \"\\t\" + each.getMovie().getTitle() + \"\\t\" +\n"
                + "                    String.valueOf(thisAmount) + \"\\n\";\n"
                + "            totalAmount += thisAmount;\n"
                + "        }\n"
                + "        // add footer lines\n"
                + "        result += \"Amount owed is \" + String.valueOf(totalAmount) + \"\\n\";\n"
                + "        result += \"You earned \" + String.valueOf(frequentRenterpoints) +\n"
                + "                \" frequent renter points\";\n"
                + "        return result;\n"
                + "    }\n"
                + "\n"
                + "}"));
    }

    public void testVideoStore2() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("videostore/Movie.java", "package videostore;\n"
                + "\n"
                + "public class Movie {\n"
                + "    \n"
                + "    public static final int CHILDRENS = 2;\n"
                + "    public static final int REGULAR = 0;\n"
                + "    public static final int NEW_RELEASE = 1;\n"
                + "\n"
                + "    private String title;\n"
                + "    private int priceCode;\n"
                + "\n"
                + "    public Movie(String title, int priceCode) {\n"
                + "        this.title = title;\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public int getPriceCode() {\n"
                + "        return priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public void setPriceCode(int priceCode) {\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public String getTitle() {\n"
                + "        return title;\n"
                + "    }\n"
                + "}"),
                new File("videostore/Rental.java", "package videostore;\n"
                + "\n"
                + "public class Rental {\n"
                + "\n"
                + "    private Movie movie;\n"
                + "    private int daysRent;\n"
                + "\n"
                + "    public Rental(Movie movie, int daysRent) {\n"
                + "        this.movie = movie;\n"
                + "        this.daysRent = daysRent;\n"
                + "    }\n"
                + "\n"
                + "    public Movie getMovie() {\n"
                + "        return movie;\n"
                + "    }\n"
                + "\n"
                + "    public int getDaysRent() {\n"
                + "        return daysRent;\n"
                + "    }\n"
                + "\n"
                + "    double amountFor() {\n"
                + "        // determine amounts for each line\n"
                + "        double result = 0;\n"
                + "        switch (getMovie().getPriceCode()) {\n"
                + "            case Movie.REGULAR:\n"
                + "                result += 2;\n"
                + "                if (this.getDaysRent() > 2) {\n"
                + "                    result += (this.getDaysRent() - 2) * 1.5;\n"
                + "                }\n"
                + "                break;\n"
                + "            case Movie.NEW_RELEASE:\n"
                + "                result += getDaysRent() * 3;\n"
                + "                break;\n"
                + "            case Movie.CHILDRENS:\n"
                + "                result += 1.5;\n"
                + "                if (this.getDaysRent() > 3) {\n"
                + "                    result += (getDaysRent() - 3) * 1.5;\n"
                + "                }\n"
                + "                break;\n"
                + "        }\n"
                + "        return result;\n"
                + "    }\n"
                + "}"),
                new File("videostore/Customer.java", "package videostore;\n"
                + "\n"
                + "import java.util.Enumeration;\n"
                + "import java.util.Vector;\n"
                + "\n"
                + "public class Customer {\n"
                + "\n"
                + "    private String name;\n"
                + "    private Vector rentals = new Vector();\n"
                + "\n"
                + "    public Customer(String name) {\n"
                + "        this.name = name;\n"
                + "    }\n"
                + "    \n"
                + "    public void addRental(Rental rental) {\n"
                + "        rentals.addElement(rental);\n"
                + "    }\n"
                + "\n"
                + "    public String getName() {\n"
                + "        return name;\n"
                + "    }\n"
                + "    \n"
                + "    public String statement() {\n"
                + "        double totalAmount = 0;\n"
                + "        int frequentRenterpoints = 0;\n"
                + "        Enumeration rentalelements = rentals.elements();\n"
                + "        String result = \"Rental Record for \" + getName() + \"\\n\";\n"
                + "        while(rentalelements.hasMoreElements()) {\n"
                + "            Rental each = (Rental) rentalelements.nextElement();\n"
                + "            double thisAmount = each.amountFor();\n"
                + "            \n"
                + "            // add frequent renter points\n"
                + "            frequentRenterpoints++;\n"
                + "            // add bonus for a two day new release rental\n"
                + "            if((each.getMovie().getPriceCode() == Movie.NEW_RELEASE) &&\n"
                + "                    each.getDaysRent() > 1) frequentRenterpoints++;\n"
                + "            \n"
                + "            // show figures for this rental\n"
                + "            result += \"\\t\" + each.getMovie().getTitle() + \"\\t\" +\n"
                + "                    String.valueOf(thisAmount) + \"\\n\";\n"
                + "            totalAmount += thisAmount;\n"
                + "        }\n"
                + "        // add footer lines\n"
                + "        result += \"Amount owed is \" + String.valueOf(totalAmount) + \"\\n\";\n"
                + "        result += \"You earned \" + String.valueOf(frequentRenterpoints) +\n"
                + "                \" frequent renter points\";\n"
                + "        return result;\n"
                + "    }\n"
                + "\n"
                + "}"));
        performMove(src.getFileObject("videostore/Rental.java"), new int[]{5}, src.getFileObject("videostore/Customer.java"), Visibility.PRIVATE, false);
        verifyContent(src,
                new File("videostore/Movie.java", "package videostore;\n"
                + "\n"
                + "public class Movie {\n"
                + "    \n"
                + "    public static final int CHILDRENS = 2;\n"
                + "    public static final int REGULAR = 0;\n"
                + "    public static final int NEW_RELEASE = 1;\n"
                + "\n"
                + "    private String title;\n"
                + "    private int priceCode;\n"
                + "\n"
                + "    public Movie(String title, int priceCode) {\n"
                + "        this.title = title;\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public int getPriceCode() {\n"
                + "        return priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public void setPriceCode(int priceCode) {\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public String getTitle() {\n"
                + "        return title;\n"
                + "    }\n"
                + "}"),
                new File("videostore/Rental.java", "package videostore;\n"
                + "\n"
                + "public class Rental {\n"
                + "\n"
                + "    private Movie movie;\n"
                + "    private int daysRent;\n"
                + "\n"
                + "    public Rental(Movie movie, int daysRent) {\n"
                + "        this.movie = movie;\n"
                + "        this.daysRent = daysRent;\n"
                + "    }\n"
                + "\n"
                + "    public Movie getMovie() {\n"
                + "        return movie;\n"
                + "    }\n"
                + "\n"
                + "    public int getDaysRent() {\n"
                + "        return daysRent;\n"
                + "    }\n"
                + "}"),
                new File("videostore/Customer.java", "package videostore;\n"
                + "\n"
                + "import java.util.Enumeration;\n"
                + "import java.util.Vector;\n"
                + "\n"
                + "public class Customer {\n"
                + "\n"
                + "    private String name;\n"
                + "    private Vector rentals = new Vector();\n"
                + "\n"
                + "    public Customer(String name) {\n"
                + "        this.name = name;\n"
                + "    }\n"
                + "    \n"
                + "    public void addRental(Rental rental) {\n"
                + "        rentals.addElement(rental);\n"
                + "    }\n"
                + "\n"
                + "    public String getName() {\n"
                + "        return name;\n"
                + "    }\n"
                + "    \n"
                + "    public String statement() {\n"
                + "        double totalAmount = 0;\n"
                + "        int frequentRenterpoints = 0;\n"
                + "        Enumeration rentalelements = rentals.elements();\n"
                + "        String result = \"Rental Record for \" + getName() + \"\\n\";\n"
                + "        while(rentalelements.hasMoreElements()) {\n"
                + "            Rental each = (Rental) rentalelements.nextElement();\n"
                + "            double thisAmount = amountFor(each);\n"
                + "            \n"
                + "            // add frequent renter points\n"
                + "            frequentRenterpoints++;\n"
                + "            // add bonus for a two day new release rental\n"
                + "            if((each.getMovie().getPriceCode() == Movie.NEW_RELEASE) &&\n"
                + "                    each.getDaysRent() > 1) frequentRenterpoints++;\n"
                + "            \n"
                + "            // show figures for this rental\n"
                + "            result += \"\\t\" + each.getMovie().getTitle() + \"\\t\" +\n"
                + "                    String.valueOf(thisAmount) + \"\\n\";\n"
                + "            totalAmount += thisAmount;\n"
                + "        }\n"
                + "        // add footer lines\n"
                + "        result += \"Amount owed is \" + String.valueOf(totalAmount) + \"\\n\";\n"
                + "        result += \"You earned \" + String.valueOf(frequentRenterpoints) +\n"
                + "                \" frequent renter points\";\n"
                + "        return result;\n"
                + "    }\n"
                + "\n"
                + "    private double amountFor(Rental rental) {\n"
                + "        // determine amounts for each line\n"
                + "        double result = 0;\n"
                + "        switch (rental.getMovie().getPriceCode()) {\n"
                + "            case Movie.REGULAR:\n"
                + "                result += 2;\n"
                + "                if (rental.getDaysRent() > 2) {\n"
                + "                    result += (rental.getDaysRent() - 2) * 1.5;\n"
                + "                }\n"
                + "                break;\n"
                + "            case Movie.NEW_RELEASE:\n"
                + "                result += rental.getDaysRent() * 3;\n"
                + "                break;\n"
                + "            case Movie.CHILDRENS:\n"
                + "                result += 1.5;\n"
                + "                if (rental.getDaysRent() > 3) {\n"
                + "                    result += (rental.getDaysRent() - 3) * 1.5;\n"
                + "                }\n"
                + "                break;\n"
                + "        }\n"
                + "        return result;\n"
                + "    }\n"
                + "}"));
    }

    public void testVideoStore3() throws Exception {
        writeFilesAndWaitForScan(src,
                new File("video/Movie.java", "package video;\n"
                + "\n"
                + "public class Movie {\n"
                + "    \n"
                + "    public static final int CHILDRENS = 2;\n"
                + "    public static final int REGULAR = 0;\n"
                + "    public static final int NEW_RELEASE = 1;\n"
                + "\n"
                + "    private String title;\n"
                + "    private int priceCode;\n"
                + "\n"
                + "    public Movie(String title, int priceCode) {\n"
                + "        this.title = title;\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public int getPriceCode() {\n"
                + "        return priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public void setPriceCode(int priceCode) {\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public String getTitle() {\n"
                + "        return title;\n"
                + "    }\n"
                + "}"),
                new File("video/Rental.java", "package video;\n"
                + "\n"
                + "public class Rental {\n"
                + "\n"
                + "    private Movie movie;\n"
                + "    private int daysRent;\n"
                + "\n"
                + "    public Rental(Movie movie, int daysRent) {\n"
                + "        this.movie = movie;\n"
                + "        this.daysRent = daysRent;\n"
                + "    }\n"
                + "\n"
                + "    public Movie getMovie() {\n"
                + "        return movie;\n"
                + "    }\n"
                + "\n"
                + "    public int getDaysRent() {\n"
                + "        return daysRent;\n"
                + "    }\n"
                + "}"),
                new File("videostore/Customer.java", "package videostore;\n"
                + "\n"
                + "import video.Movie;\n"
                + "import video.Rental;\n"
                + "import java.util.Enumeration;\n"
                + "import java.util.Vector;\n"
                + "\n"
                + "public class Customer {\n"
                + "\n"
                + "    private String name;\n"
                + "    private Vector rentals = new Vector();\n"
                + "\n"
                + "    public Customer(String name) {\n"
                + "        this.name = name;\n"
                + "    }\n"
                + "    \n"
                + "    public void addRental(Rental rental) {\n"
                + "        rentals.addElement(rental);\n"
                + "    }\n"
                + "\n"
                + "    public String getName() {\n"
                + "        return name;\n"
                + "    }\n"
                + "    \n"
                + "    public String statement() {\n"
                + "        double totalAmount = 0;\n"
                + "        int frequentRenterpoints = 0;\n"
                + "        Enumeration rentalelements = rentals.elements();\n"
                + "        String result = \"Rental Record for \" + getName() + \"\\n\";\n"
                + "        while(rentalelements.hasMoreElements()) {\n"
                + "            Rental each = (Rental) rentalelements.nextElement();\n"
                + "            double thisAmount = amountFor(each);\n"
                + "            \n"
                + "            // add frequent renter points\n"
                + "            frequentRenterpoints++;\n"
                + "            // add bonus for a two day new release rental\n"
                + "            if((each.getMovie().getPriceCode() == Movie.NEW_RELEASE) &&\n"
                + "                    each.getDaysRent() > 1) frequentRenterpoints++;\n"
                + "            \n"
                + "            // show figures for this rental\n"
                + "            result += \"\\t\" + each.getMovie().getTitle() + \"\\t\" +\n"
                + "                    String.valueOf(thisAmount) + \"\\n\";\n"
                + "            totalAmount += thisAmount;\n"
                + "        }\n"
                + "        // add footer lines\n"
                + "        result += \"Amount owed is \" + String.valueOf(totalAmount) + \"\\n\";\n"
                + "        result += \"You earned \" + String.valueOf(frequentRenterpoints) +\n"
                + "                \" frequent renter points\";\n"
                + "        return result;\n"
                + "    }\n"
                + "\n"
                + "    private double amountFor(Rental rental) {\n"
                + "        // determine amounts for each line\n"
                + "        double result = 0;\n"
                + "        switch(rental.getMovie().getPriceCode()) {\n"
                + "            case Movie.REGULAR:\n"
                + "                result += 2;\n"
                + "                if(rental.getDaysRent() > 2)\n"
                + "                    result += (rental.getDaysRent() - 2) * 1.5;\n"
                + "                break;\n"
                + "            case Movie.NEW_RELEASE:\n"
                + "                result += rental.getDaysRent() * 3;\n"
                + "                break;\n"
                + "            case Movie.CHILDRENS:\n"
                + "                result += 1.5;\n"
                + "                if(rental.getDaysRent() > 3)\n"
                + "                    result += (rental.getDaysRent() -3) * 1.5;\n"
                + "                break;\n"
                + "        }\n"
                + "        return result;\n"
                + "    }\n"
                + "}"));
        performMove(src.getFileObject("videostore/Customer.java"), new int[]{6}, src.getFileObject("video/Rental.java"), Visibility.ESCALATE, false);
        verifyContent(src,
                new File("video/Movie.java", "package video;\n"
                + "\n"
                + "public class Movie {\n"
                + "    \n"
                + "    public static final int CHILDRENS = 2;\n"
                + "    public static final int REGULAR = 0;\n"
                + "    public static final int NEW_RELEASE = 1;\n"
                + "\n"
                + "    private String title;\n"
                + "    private int priceCode;\n"
                + "\n"
                + "    public Movie(String title, int priceCode) {\n"
                + "        this.title = title;\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public int getPriceCode() {\n"
                + "        return priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public void setPriceCode(int priceCode) {\n"
                + "        this.priceCode = priceCode;\n"
                + "    }\n"
                + "\n"
                + "    public String getTitle() {\n"
                + "        return title;\n"
                + "    }\n"
                + "}"),
                new File("video/Rental.java", "package video;\n"
                + "\n"
                + "public class Rental {\n"
                + "\n"
                + "    private Movie movie;\n"
                + "    private int daysRent;\n"
                + "\n"
                + "    public Rental(Movie movie, int daysRent) {\n"
                + "        this.movie = movie;\n"
                + "        this.daysRent = daysRent;\n"
                + "    }\n"
                + "\n"
                + "    public Movie getMovie() {\n"
                + "        return movie;\n"
                + "    }\n"
                + "\n"
                + "    public int getDaysRent() {\n"
                + "        return daysRent;\n"
                + "    }\n"
                + "\n"
                + "    public double amountFor() {\n"
                + "        // determine amounts for each line\n"
                + "        double result = 0;\n"
                + "        switch (this.getMovie().getPriceCode()) {\n"
                + "            case Movie.REGULAR:\n"
                + "                result += 2;\n"
                + "                if (this.getDaysRent() > 2) {\n"
                + "                    result += (this.getDaysRent() - 2) * 1.5;\n"
                + "                }\n"
                + "                break;\n"
                + "            case Movie.NEW_RELEASE:\n"
                + "                result += this.getDaysRent() * 3;\n"
                + "                break;\n"
                + "            case Movie.CHILDRENS:\n"
                + "                result += 1.5;\n"
                + "                if (this.getDaysRent() > 3) {\n"
                + "                    result += (this.getDaysRent() - 3) * 1.5;\n"
                + "                }\n"
                + "                break;\n"
                + "        }\n"
                + "        return result;\n"
                + "    }\n"
                + "}"),
                new File("videostore/Customer.java", "package videostore;\n"
                + "\n"
                + "import video.Movie;\n"
                + "import video.Rental;\n"
                + "import java.util.Enumeration;\n"
                + "import java.util.Vector;\n"
                + "\n"
                + "public class Customer {\n"
                + "\n"
                + "    private String name;\n"
                + "    private Vector rentals = new Vector();\n"
                + "\n"
                + "    public Customer(String name) {\n"
                + "        this.name = name;\n"
                + "    }\n"
                + "    \n"
                + "    public void addRental(Rental rental) {\n"
                + "        rentals.addElement(rental);\n"
                + "    }\n"
                + "\n"
                + "    public String getName() {\n"
                + "        return name;\n"
                + "    }\n"
                + "    \n"
                + "    public String statement() {\n"
                + "        double totalAmount = 0;\n"
                + "        int frequentRenterpoints = 0;\n"
                + "        Enumeration rentalelements = rentals.elements();\n"
                + "        String result = \"Rental Record for \" + getName() + \"\\n\";\n"
                + "        while(rentalelements.hasMoreElements()) {\n"
                + "            Rental each = (Rental) rentalelements.nextElement();\n"
                + "            double thisAmount = each.amountFor();\n"
                + "            \n"
                + "            // add frequent renter points\n"
                + "            frequentRenterpoints++;\n"
                + "            // add bonus for a two day new release rental\n"
                + "            if((each.getMovie().getPriceCode() == Movie.NEW_RELEASE) &&\n"
                + "                    each.getDaysRent() > 1) frequentRenterpoints++;\n"
                + "            \n"
                + "            // show figures for this rental\n"
                + "            result += \"\\t\" + each.getMovie().getTitle() + \"\\t\" +\n"
                + "                    String.valueOf(thisAmount) + \"\\n\";\n"
                + "            totalAmount += thisAmount;\n"
                + "        }\n"
                + "        // add footer lines\n"
                + "        result += \"Amount owed is \" + String.valueOf(totalAmount) + \"\\n\";\n"
                + "        result += \"You earned \" + String.valueOf(frequentRenterpoints) +\n"
                + "                \" frequent renter points\";\n"
                + "        return result;\n"
                + "    }\n"
                + "\n"
                + "}"));
    }
}
