/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2013 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2013 Sun Microsystems, Inc.
 */
package org.netbeans.modules.php.twig.editor.ui.options;

import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.twig.editor.actions.ToggleBlockCommentAction;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.NbBundle;

@NbBundle.Messages("TwigPanel.options.keywords.tabTitle=Frameworks & Tools")
@OptionsPanelController.Keywords(
    keywords = {
        "php", "twig"
    },
    location = UiUtils.OPTIONS_PATH,
    tabTitle = "#TwigPanel.options.keywords.tabTitle"
)
final class TwigPanel extends javax.swing.JPanel {

    private final TwigOptionsPanelController controller;
    private boolean firstOpening = true;

    TwigPanel(TwigOptionsPanelController controller) {
        this.controller = controller;
        initComponents();
        setDefaultValues();
        // TODO listen to changes in form fields and call controller.changed()
    }
    
    private void setDefaultValues() {
        ToggleBlockCommentAction.ToggleCommentType toggleCommentType = TwigOptions.getInstance().getToggleCommentType();
        if (toggleCommentType == ToggleBlockCommentAction.ToggleCommentType.AS_TWIG_EVERYWHERE) {
            asTwigEverywhereRadioButton.setSelected(true);
        } else {
            languageSensitiveRadioButton.setSelected(true);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        toggleCommentButtonGroup = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        asTwigEverywhereRadioButton = new javax.swing.JRadioButton();
        languageSensitiveRadioButton = new javax.swing.JRadioButton();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(TwigPanel.class, "TwigPanel.jLabel1.text")); // NOI18N

        toggleCommentButtonGroup.add(asTwigEverywhereRadioButton);
        asTwigEverywhereRadioButton.setMnemonic('t');
        org.openide.awt.Mnemonics.setLocalizedText(asTwigEverywhereRadioButton, org.openide.util.NbBundle.getMessage(TwigPanel.class, "TwigPanel.asTwigEverywhereRadioButton.text")); // NOI18N
        asTwigEverywhereRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                asTwigEverywhereRadioButtonActionPerformed(evt);
            }
        });

        toggleCommentButtonGroup.add(languageSensitiveRadioButton);
        languageSensitiveRadioButton.setMnemonic('l');
        org.openide.awt.Mnemonics.setLocalizedText(languageSensitiveRadioButton, org.openide.util.NbBundle.getMessage(TwigPanel.class, "TwigPanel.languageSensitiveRadioButton.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(asTwigEverywhereRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(languageSensitiveRadioButton)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(asTwigEverywhereRadioButton)
                    .addComponent(languageSensitiveRadioButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void asTwigEverywhereRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_asTwigEverywhereRadioButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_asTwigEverywhereRadioButtonActionPerformed

    void load() {
        if(firstOpening || !changed()) { // if panel is not modified by the user and he switches back to this panel, set to default
            firstOpening = false;
            ToggleBlockCommentAction.ToggleCommentType toggleCommentType = TwigOptions.getInstance().getToggleCommentType();
            if (toggleCommentType == ToggleBlockCommentAction.ToggleCommentType.AS_TWIG_EVERYWHERE) {
                asTwigEverywhereRadioButton.setSelected(true);
            } else {
                languageSensitiveRadioButton.setSelected(true);
            }
        }
    }

    void store() {
        ToggleBlockCommentAction.ToggleCommentType toggleCommentType;
        if (asTwigEverywhereRadioButton.isSelected()) {
            toggleCommentType = ToggleBlockCommentAction.ToggleCommentType.AS_TWIG_EVERYWHERE;
        } else {
            toggleCommentType = ToggleBlockCommentAction.ToggleCommentType.LANGUAGE_SENSITIVE;
        }
        TwigOptions.getInstance().setToggleCommentType(toggleCommentType);
    }

    boolean valid() {
        // TODO check whether form is consistent and complete
        return true;
    }
    
    void cancel() {
        if (changed()) { // if panel is modified by the user and options window closes, discard any changes
            ToggleBlockCommentAction.ToggleCommentType toggleCommentType = TwigOptions.getInstance().getToggleCommentType();
            if (toggleCommentType == ToggleBlockCommentAction.ToggleCommentType.AS_TWIG_EVERYWHERE) {
                asTwigEverywhereRadioButton.setSelected(true);
            } else {
                languageSensitiveRadioButton.setSelected(true);
            }
        }
    }

    boolean changed() {
        if (TwigOptions.getInstance().getToggleCommentType() == ToggleBlockCommentAction.ToggleCommentType.AS_TWIG_EVERYWHERE) {
            return !asTwigEverywhereRadioButton.isSelected();
        } 
        return !languageSensitiveRadioButton.isSelected();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton asTwigEverywhereRadioButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JRadioButton languageSensitiveRadioButton;
    private javax.swing.ButtonGroup toggleCommentButtonGroup;
    // End of variables declaration//GEN-END:variables
}
