/*  
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types;

import javax.swing.JLabel;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;

import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;

class FallbackBreakpointPanel extends BreakpointPanel {

    private FallbackBreakpoint fb;

    private JLabel eventspecLabel;
    private JTextField eventspecText;

    @Override
    public void seed(NativeBreakpoint breakpoint) {
	seedCommonComponents(breakpoint);
	fb = (FallbackBreakpoint) breakpoint;

	eventspecText.setText(fb.getEventspec());
    }

    /*
     * Constructors
     */

    public FallbackBreakpointPanel() {
	this(new FallbackBreakpoint(NativeBreakpoint.TOPLEVEL), false);
    }

    public FallbackBreakpointPanel(NativeBreakpoint b) {
	this((FallbackBreakpoint)b, true);
    }

    /** Creates new form FallbackBreakpointPanel */
    public FallbackBreakpointPanel(FallbackBreakpoint breakpoint,
				boolean customizing) {
	super(breakpoint, customizing);
	fb = breakpoint;

	initComponents();
	addCommonComponents(1);

	seed(breakpoint);

	// Arrange to revalidate on changes
	eventspecText.getDocument().addDocumentListener(this);
    }

    @Override
    public void setDescriptionEnabled(boolean enabled) {
	// eventspecLabel.setEnabled(false);
	eventspecText.setEnabled(false);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
	panel_settings.setLayout(new java.awt.GridBagLayout());

	eventspecLabel = new JLabel();
	eventspecText = new JTextField();
	    java.awt.GridBagConstraints gbc;
	    eventspecLabel.setText(Catalog.get("LBL_Eventspec")); // NOI18N
	    eventspecLabel.setDisplayedMnemonic(
		Catalog.getMnemonic("MNEM_Eventspec"));		// NOI18N
	    eventspecLabel.setLabelFor(eventspecText);
	    gbc = new java.awt.GridBagConstraints();
	    gbc.ipadx = 5;
	    gbc.anchor = java.awt.GridBagConstraints.WEST;
	    panel_settings.add(eventspecLabel, gbc);

	    gbc = new java.awt.GridBagConstraints();
	    gbc.gridwidth = 3;
	    gbc.fill = java.awt.GridBagConstraints.HORIZONTAL;
	    gbc.weightx = 1.0;
	    panel_settings.add(eventspecText, gbc);

	// a11y
	eventspecText.getAccessibleContext().setAccessibleDescription(
	    Catalog.get("ACSD_Eventspec") // NOI18N
	);
    }

    @Override
    protected void assignProperties() {
	fb.setEventspec(eventspecText.getText(), null);
    }
    
    @Override
    protected boolean propertiesAreValid() {
	// No good way to judge the validity of unanticipated engine eventspecs
	// But at least it shouldn't be null
	if (IpeUtils.isEmpty(eventspecText.getText()))
	    return false;
	return true;
    }
}
