/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.toolbars;

import java.awt.BorderLayout;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.prefs.Preferences;

import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

/**
 * This class contains methods to keep a set of toolbars persistent.
 * <p> 
 * The class uses the preferences framework of the java runtime, and installs a 
 * shutdown hook to save the toolbars state on application exit.
 * <p>
 * Warning : this class cannot be run from a sandboxed (untrusted) environment 
 *  (unsigned applet/ java web start) as it uses classes requiring a SecurityManager 
 * (Preferences API and Runtime shutdown hook).
 * <p>
 * Call loadToolBarLayout() upon application startup, after registering all ToolBars.
 *
 * @author Michael Westergaard, revised by Lilian Chamontin.
 *
 * @see ToolBarIO
 */
public class ToolBarPersistence implements Runnable {
  private final static String TOOLBAR_LAYOUT = "toolbar_layout"; //$NON-NLS-1$
  private ToolBarContainer container;
  private ToolBarIO io;
  private Preferences prefs;
  
  /**
   * Construct a new set of persistent toolbars.
   *
   * @param mainClass the main class of the application.  Will be used to
   * generate a reasonable name for the preferences to store toolbar
   * configuration
   * @param container the toolbarcontainer to keep persistent
   * @throws SecurityException if this class is invoked from an untrusted environment
   */
  public ToolBarPersistence(Object mainClass, ToolBarContainer container) {
    this.container = container;
    this.io = new ToolBarIO(container);
    String nodeName = mainClass.getClass().getName().replaceFirst(mainClass.getClass().getPackage().getName() + ".", ""); //$NON-NLS-1$ //$NON-NLS-2$
    prefs = Preferences.userNodeForPackage(mainClass.getClass()).node(nodeName);
    Runtime.getRuntime().addShutdownHook(new Thread(this));
    
  }
  
  protected void handleUnloadedToolBar(VLToolBar toolbar) {
    ToolBarPanel panel =
        container.getToolBarPanelAt(BorderLayout.NORTH);
    if (panel != null)
      panel.add(toolbar, new ToolBarConstraints());
  }
  
  /**
   * Load the toolbar configuration.
   *
   * @throws IOException
   * @throws ParserConfigurationException
   * @throws SAXException
   */
  public void loadToolBarLayout() throws IOException, ParserConfigurationException, SAXException {
    byte data[] = prefs.getByteArray(TOOLBAR_LAYOUT, null);
    if (data != null) {
      InputStream in = new ByteArrayInputStream(data);
      ToolBarIOReadInfo tri = io.readXML(in);
      Collection unloadedToolBars = tri.getNotInstalledToolbars();
      in.close();
      for (Iterator i = unloadedToolBars.iterator(); i.hasNext(); ) {
        VLToolBar toolbar = (VLToolBar) i.next();
        handleUnloadedToolBar(toolbar);
      }
    }
  }
  
  /**
   * Save the toolbar configuration.  
   *<p> Masks all errors.
   *<p> don't call this method directly : it is used by the shudown hook.
   *
   * @see java.lang.Runnable#run()
   */
  public void run() {
    try {
      saveToolBarLayout();
    } catch (Exception exception) {
      // Mask error as we are quitting anyway
    }
  }
  
  /**
   * Save the toolbar configuration.
   *
   * @throws IOException
   */
  public void saveToolBarLayout() throws IOException {
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    io.writeXML(out);
    out.close();
    prefs.putByteArray(TOOLBAR_LAYOUT, out.toByteArray());
  }
}