/* ----- encode/953x3, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_953x3_checksums[] = {
  "10e5142e79d1a21b1a3b0284f3d31e258af25438003715cb3b2ae05175ed685c",
  "bb632a3b15fa172fb6b90dc7cdbca546cc677213571c71b52abf407208bff5d8",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_953x3_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_953x3_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_953x3_ITEMBYTES

static void *storage_encode_953x3_s;
static unsigned char *test_encode_953x3_s;
static void *storage_encode_953x3_x;
static unsigned char *test_encode_953x3_x;
static void *storage_encode_953x3_s2;
static unsigned char *test_encode_953x3_s2;
static void *storage_encode_953x3_x2;
static unsigned char *test_encode_953x3_x2;

#define precomputed_encode_953x3_NUM 4

static const unsigned char precomputed_encode_953x3_s[precomputed_encode_953x3_NUM][crypto_encode_STRBYTES] = {
  {246,211,102,31,128,244,33,26,8,70,156,73,95,172,228,23,92,24,115,224,34,216,110,138,201,200,157,161,147,233,136,44,84,182,144,109,16,30,209,18,94,9,68,194,218,118,139,210,100,67,76,190,69,87,36,60,86,198,179,37,56,57,126,90,109,195,116,73,132,140,237,235,62,181,207,104,186,102,192,247,188,9,203,94,182,37,85,211,9,61,194,202,152,138,126,96,41,251,44,251,178,126,112,86,239,253,239,83,41,247,50,154,203,174,234,214,112,70,127,67,87,143,185,86,241,117,100,221,13,23,158,229,155,4,66,31,225,211,184,166,222,224,194,135,57,117,234,164,186,190,246,80,47,56,218,66,94,230,38,252,158,83,253,74,74,21,186,229,43,25,151,64,21,194,95,62,138,92,222,33,205,214,102,250,168,172,127,208,63,188,21,180,189,179,28,134,166,35,61,95,206,106,224,84,9,56,96,136,63,199,4,48,145,143,114,139,91,178,15,209,221,72,247,151,219,109,144,41,8,180,202,27,184,75,184,185,179,114,132},
  {78,91,100,252,42,42,106,11,170,4,69,49,251,124,195,133,150,50,169,10,189,173,67,242,99,254,250,81,255,59,85,58,20,7,132,120,190,102,204,114,62,244,12,81,127,159,231,5,247,25,25,4,40,181,163,37,58,255,255,207,80,175,223,25,194,27,105,46,184,195,170,219,83,80,237,71,147,167,33,202,15,94,60,95,251,149,194,130,166,41,83,15,135,38,176,196,135,186,98,114,83,1,215,139,41,116,213,7,28,109,52,18,235,164,151,121,228,36,218,123,222,61,65,251,37,105,220,122,141,56,37,243,135,176,200,91,203,129,206,46,145,218,115,62,134,195,139,32,164,91,192,96,97,83,125,13,29,197,242,65,73,218,199,220,118,19,22,152,143,52,96,169,217,100,204,107,102,164,182,65,202,43,110,142,77,215,99,197,124,204,41,131,153,41,224,232,241,54,252,53,187,252,141,94,23,64,123,55,1,213,98,51,8,119,253,205,21,240,77,161,44,75,252,167,8,132,21,19,25,183,154,247,169,76,62,63,7,22,206},
  {81,152,218,10,143,115,240,85,91,35,184,118,159,58,132,169,20,234,92,84,64,19,191,208,3,68,89,18,175,226,168,181,171,70,238,85,40,145,191,1,211,92,252,28,85,152,143,93,208,189,252,213,145,38,22,135,108,90,37,234,51,225,89,186,14,71,39,236,99,61,5,61,254,251,158,153,36,191,57,144,203,42,251,11,219,135,133,98,235,183,210,72,98,21,139,25,174,28,42,52,153,115,250,124,230,75,4,113,124,33,239,94,224,203,1,239,93,233,131,136,24,186,3,222,107,160,37,127,217,78,162,128,25,2,135,180,144,5,47,199,170,16,130,222,211,154,236,255,236,232,14,226,107,138,152,251,119,203,37,35,195,196,198,45,140,148,203,35,84,212,207,12,124,125,146,237,241,175,74,127,28,143,83,183,217,46,198,54,194,234,226,96,24,6,87,222,158,168,42,245,103,215,14,29,214,214,203,64,24,166,200,87,122,66,14,254,43,171,190,76,228,38,147,243,130,13,133,165,90,103,81,38,120,216,100,27,56,72,72},
  {66,7,212,138,4,222,239,124,189,83,155,220,34,223,42,186,39,86,74,22,209,191,161,158,105,105,243,64,52,231,145,213,243,157,59,196,42,187,195,221,153,107,122,64,32,45,191,213,15,185,83,118,130,231,52,88,252,154,231,178,198,99,15,24,255,6,8,207,176,72,60,220,80,235,24,64,152,98,19,202,94,19,177,25,27,59,10,72,155,7,36,129,80,144,23,131,211,124,209,220,29,248,191,24,67,12,190,162,21,234,138,31,2,56,39,221,56,235,125,112,110,25,253,174,109,41,151,185,12,223,174,142,99,45,246,20,23,52,70,13,35,44,28,233,195,44,239,124,81,3,243,107,69,235,243,246,85,183,146,170,0,145,6,4,31,135,155,206,95,43,40,175,223,44,229,201,213,119,200,172,34,156,17,224,15,209,155,45,42,25,160,56,66,47,8,157,103,242,6,229,182,212,175,61,253,29,93,82,201,15,46,249,155,223,253,221,30,167,244,1,194,231,226,117,90,164,108,157,37,138,34,94,238,15,11,243,158,249,206},
} ;

static const unsigned char precomputed_encode_953x3_x[precomputed_encode_953x3_NUM][crypto_encode_ITEMS] = {
  {161,44,177,81,30,132,205,226,169,98,50,251,134,65,172,238,255,63,227,208,231,158,36,184,204,68,155,61,165,176,126,214,183,55,46,5,45,169,58,74,215,44,44,80,208,193,102,159,242,142,114,51,127,246,72,102,23,166,234,69,42,18,1,129,47,166,196,236,15,209,19,125,122,157,251,202,215,121,233,157,133,122,194,221,203,198,242,206,97,106,37,187,229,100,32,15,160,93,78,130,151,7,152,245,196,113,16,247,72,201,218,177,46,104,211,133,80,193,188,198,235,130,60,2,71,196,236,199,15,40,21,68,233,2,3,141,211,206,195,228,112,10,240,154,63,99,163,159,53,213,208,89,52,174,33,70,81,167,5,14,149,225,23,114,60,2,211,133,71,6,37,253,101,66,32,52,81,201,181,55,185,174,219,164,246,104,122,140,141,200,101,162,103,222,55,187,22,206,50,146,227,253,74,94,229,41,94,20,88,22,224,33,38,155,195,173,127,240,9,112,111,130,23,104,29,173,191,65,173,169,70,15,234,221,56,74,0,88,223,250,123,158,35,151,156,206,169,206,21,65,29,81,165,28,107,69,112,70,201,224,66,79,251,109,247,158,75,96,156,226,133,2,131,111,159,168,171,7,171,91,76,235,34,50,158,198,254,244,93,247,79,199,60,101,141,135,18,118,21,33,67,100,28,22,173,94,128,253,237,245,9,59,23,25,103,130,214,143,177,178,191,46,255,212,8,171,52,11,90,211,81,27,213,41,193,54,93,77,237,216,96,184,249,128,128,144,184,187,46,236,78,179,104,171,134,169,76,23,64,253,221,232,103,78,13,210,94,145,107,166,196,8,109,158,145,93,109,55,102,114,59,76,50,202,28,206,48,226,122,243,118,68,27,147,7,160,10,175,250,165,113,43,24,63,229,97,160,99,235,40,77,155,177,8,207,181,242,166,197,11,148,17,245,186,34,66,19,141,194,199,22,83,232,23,101,133,242,220,192,73,105,161,243,139,9,111,16,6,218,39,116,195,133,41,91,226,237,250,204,244,217,82,14,54,255,191,162,248,225,180,96,93,98,126,245,2,162,79,5,167,170,82,53,111,114,6,131,86,124,82,222,99,113,252,178,22,236,108,148,147,24,114,236,182,203,77,197,215,160,222,7,236,136,208,179,91,74,18,87,23,177,86,224,57,92,13,236,125,74,215,142,163,231,130,224,15,181,18,23,18,226,150,161,50,184,233,31,153,202,237,224,240,99,252,65,92,193,88,15,41,141,155,169,0,123,100,172,203,101,234,70,92,198,163,102,122,112,65,255,226,96,244,47,160,93,210,35,115,43,237,43,103,237,54,38,65,181,157,40,47,165,3,91,109,163,90,111,44,142,3,112,1,159,125,169,67,233,11,7,92,185,145,235,145,229,153,184,241,141,69,199,14,57,142,106,159,15,246,80,223,189,79,57,47,142,168,41,129,112,18,255,56,13,182,229,3,13,122,28,13,240,224,161,61,197,140,15,146,80,60,69,136,122,39,72,77,132,60,97,209,174,173,118,230,155,28,214,2,140,77,160,200,49,219,133,214,114,226,65,104,209,34,241,250,57,123,193,128,199,12,49,160,161,30,143,22,140,252,241,9,228,1,65,114,149,7,13,108,61,113,137,198,141,226,205,183,179,24,252,158,95,246,58,110,222,123,210,57,227,190,194,6,58,60,140,60,127,238,171,198,88,142,67,96,127,212,25,48,20,25,239,32,42,41,85,41,191,38,23,184,253,53,190,42,209,60,221,135,106,209,190,93,244,133,98,67,14,163,23,248,57,148,167,86,161,121,185,224,167,185,64,92,135,70,110,202,48,169,130,123,71,51,57,93,147,78,148,80,167,35,68,187,210,150,248,193,234,202,110,150,31,196,220,147,59,52,77,224,192,91,197,171,2,246,122,135,137,73,47,198,118,44,237,165,38,20,245,153,125,104,252,230,66,58,45,211,52,30,181,198,172,115,177,68,111,13,217,255,66,56,152,100,82,212,10,4,22,168,197,186,104,84,254,18,115,138,174,135,180,228,181,53,103,135,199,99,147,119,79,92,77,146,230,250,54,176,29,224,243,196,182,80,18,221,251,131,139,70,64,247,144,237,242,140,50,247,217,203,161,219,169,142,131},
  {13,39,21,148,194,9,42,254,115,195,181,181,11,43,183,58,241,165,9,151,61,222,18,76,201,99,152,137,214,208,230,61,253,22,12,233,187,225,151,68,8,170,8,155,232,97,19,29,86,156,158,192,47,26,233,228,30,76,238,73,172,89,242,184,61,85,187,232,9,237,82,184,0,93,242,171,141,198,253,145,72,160,150,1,144,102,55,75,174,76,29,1,45,132,138,51,178,247,236,91,129,154,200,65,241,41,237,53,104,129,113,142,10,140,179,137,30,194,80,99,232,54,196,164,161,69,251,218,95,68,205,38,70,191,87,128,135,170,128,252,71,63,170,45,137,88,180,237,17,144,228,186,19,1,226,109,57,213,113,154,93,143,101,68,239,120,229,250,95,86,20,95,216,181,209,117,202,184,64,150,22,157,88,213,58,102,28,160,80,184,32,154,162,232,26,99,144,61,8,175,224,193,94,52,191,104,5,168,55,223,202,2,192,60,147,102,10,33,168,17,52,35,141,37,177,33,35,210,106,204,1,120,230,237,173,165,74,124,176,57,235,112,97,73,198,225,69,183,158,123,252,37,92,154,4,67,213,134,128,6,98,93,251,149,0,141,218,221,45,119,21,2,183,239,27,97,186,25,33,149,161,153,57,203,6,160,136,230,226,187,47,149,131,190,36,109,252,47,102,186,10,122,180,63,170,5,4,69,94,205,76,84,140,140,181,247,221,90,51,112,206,239,119,15,105,212,253,214,203,79,158,204,202,144,240,44,222,198,151,197,188,237,17,131,137,1,242,71,25,253,170,186,229,43,144,135,108,114,70,57,150,182,153,0,186,188,29,185,70,207,91,64,21,119,194,207,39,237,124,7,195,51,42,33,62,149,130,94,197,72,228,185,177,35,165,110,125,220,255,45,90,109,203,33,208,191,154,13,218,226,214,127,254,46,48,94,24,127,208,23,187,245,29,39,80,128,195,136,50,208,232,195,227,165,57,79,160,42,217,229,87,26,170,98,29,104,212,111,34,37,6,146,151,122,237,252,94,221,195,181,148,164,56,246,211,159,160,133,91,45,12,168,93,222,183,13,74,195,9,29,205,239,68,243,176,186,149,140,228,98,132,117,110,14,92,173,12,149,67,53,220,34,67,218,191,170,78,109,249,127,151,171,164,93,30,205,223,149,27,60,232,42,228,32,214,34,108,70,66,228,26,235,167,57,93,24,119,107,129,197,214,128,119,31,78,146,138,53,72,97,202,119,165,5,100,114,93,223,220,125,184,201,138,151,145,177,247,95,218,49,60,107,5,237,227,84,77,229,237,122,30,128,125,34,34,209,125,32,15,107,241,100,35,143,191,60,118,24,187,42,119,125,148,3,235,148,17,247,164,30,171,213,6,182,242,56,56,128,151,206,232,232,55,171,188,27,182,117,208,72,212,169,157,32,244,213,156,200,147,216,240,45,185,87,101,60,87,67,202,74,140,79,203,123,229,186,185,70,141,242,102,106,139,144,253,141,17,122,175,221,30,185,74,48,7,75,215,162,4,145,143,35,79,64,116,232,96,189,208,253,192,7,75,141,205,103,211,221,75,190,178,221,211,71,193,140,106,162,35,83,158,96,69,31,146,142,144,91,115,3,245,188,233,244,190,190,38,219,245,41,40,56,201,244,138,48,52,1,76,168,70,163,231,21,174,216,208,188,84,63,182,167,211,205,210,116,39,100,72,37,132,0,193,189,234,221,73,161,216,207,143,177,52,112,58,213,191,51,100,55,147,36,207,214,128,47,142,138,181,111,243,225,63,58,248,96,80,240,37,130,202,103,72,26,95,222,145,47,196,249,153,28,13,11,13,184,174,145,89,65,151,97,177,59,118,224,179,128,130,160,106,161,248,177,175,180,140,41,221,62,129,143,241,253,106,105,105,73,203,202,192,71,198,7,140,42,236,55,18,159,200,84,70,160,184,222,29,219,67,170,167,121,24,128,62,4,244,222,182,26,151,80,232,214,242,185,38,255,175,222,28,227,206,85,243,120,167,11,158,56,119,242,39,170,148,51,174,182,174,104,247,76,120,127,181,240,246,67,82,81,181,152,247,23,210,100,208,157,172,62,175,111,15,78,11,224,145,190,218,255,26,8,19,6,82,180,121,232,225,184,60,45,205},
  {252,216,174,183,71,111,156,138,229,16,38,192,37,12,42,171,118,13,157,211,126,88,144,173,15,79,233,95,24,190,187,153,186,119,19,197,206,100,127,74,255,13,51,88,217,106,150,101,110,115,165,239,157,126,69,0,47,120,18,228,152,231,146,92,83,175,35,90,181,80,118,197,219,3,222,165,175,176,73,28,211,194,17,52,50,79,117,60,198,169,96,184,215,9,12,223,10,201,196,49,91,17,245,212,76,62,124,32,125,192,128,145,174,235,184,230,145,199,82,31,199,163,160,148,216,38,23,242,142,218,186,47,225,236,62,14,5,253,138,100,104,94,82,28,39,191,223,99,200,109,164,214,254,235,4,162,80,227,129,127,166,178,133,71,67,233,58,170,123,71,85,31,7,20,171,211,164,99,109,64,143,121,217,249,134,241,187,45,44,247,112,96,219,240,10,85,112,122,85,171,163,217,102,73,60,161,12,244,136,89,197,228,85,159,16,112,65,68,203,139,162,232,59,233,107,167,137,238,185,167,207,15,8,50,36,143,45,106,148,6,186,109,11,143,120,65,69,63,168,203,107,78,73,239,230,60,93,187,203,39,118,71,186,11,198,123,190,57,3,21,164,88,74,9,122,12,92,207,197,248,204,97,78,102,40,220,113,97,73,236,143,135,62,194,62,230,117,137,155,108,12,62,232,151,243,7,132,166,114,18,187,76,240,49,223,161,103,133,84,178,198,36,186,146,113,189,47,194,94,110,69,217,58,35,175,16,170,223,10,75,146,200,140,63,116,107,201,22,13,32,52,33,178,45,127,245,122,14,15,35,17,183,217,84,99,240,109,228,141,212,183,219,216,2,166,30,130,189,232,29,48,121,127,147,165,225,119,247,187,247,59,90,153,43,17,158,175,128,191,13,132,120,30,184,222,188,73,183,233,59,245,154,47,250,161,68,221,85,118,48,174,46,97,102,131,211,118,62,188,196,237,62,7,188,59,110,72,33,60,85,6,229,20,203,137,76,61,158,243,2,125,115,98,57,91,58,8,249,48,87,254,159,130,16,104,140,71,100,112,233,88,92,58,73,73,233,23,127,30,13,199,187,169,222,213,84,120,163,86,166,152,129,9,76,157,70,110,46,231,174,151,169,109,197,212,47,212,24,142,183,20,154,212,156,76,38,21,209,138,32,249,1,241,189,79,199,212,162,104,51,85,217,85,218,143,44,94,69,184,189,203,21,228,152,143,211,194,141,184,18,163,234,198,225,69,253,106,202,122,193,93,198,206,40,147,30,47,139,249,49,191,62,89,228,138,132,62,128,148,200,233,139,99,96,35,133,138,59,78,11,195,204,23,92,53,255,151,75,193,255,245,61,181,22,109,136,60,33,18,53,19,124,209,93,39,234,143,173,88,122,222,166,175,101,38,79,192,3,210,153,188,182,60,93,126,125,222,208,151,33,202,249,156,252,235,165,143,140,33,104,119,193,128,186,187,27,51,65,228,123,195,27,101,31,126,218,173,183,54,122,91,224,167,194,197,152,43,29,6,170,202,32,255,237,7,108,248,98,215,124,18,209,164,237,225,231,57,225,80,254,20,133,91,183,220,84,103,244,22,97,4,14,201,7,189,157,90,144,65,42,23,248,109,224,182,193,188,219,42,153,207,198,70,67,177,44,156,174,199,163,77,251,246,245,105,222,65,254,157,177,148,117,185,141,112,90,85,80,172,241,5,186,214,49,179,198,8,15,175,201,67,203,53,63,120,244,178,140,90,110,229,229,97,92,237,235,11,160,39,75,180,51,17,109,41,230,112,132,22,55,150,31,48,80,2,128,56,216,69,253,156,59,96,26,124,49,25,190,135,184,121,94,61,247,218,255,194,150,251,120,1,108,183,167,119,8,45,101,65,238,67,12,52,55,158,217,4,67,137,55,136,37,73,53,169,109,197,181,78,57,137,148,253,216,114,101,193,95,162,237,224,48,213,253,166,37,235,171,198,124,11,145,188,82,113,76,3,56,2,27,97,71,78,224,33,15,73,181,29,161,76,135,237,134,124,61,44,112,216,90,61,249,13,178,183,7,14,245,3,152,192,63,164,48,145,52,183,92,119,59,136,5,27,182,129,2,83,27,13,206,218,219,216,224,151,11,42,94,71,27,44,138,71},
  {41,205,197,121,70,107,148,66,131,11,173,148,109,226,0,121,19,75,143,138,125,115,76,162,150,121,30,233,159,210,12,122,184,72,161,222,242,243,184,7,118,184,243,95,15,254,152,164,69,70,75,95,150,225,107,163,129,181,184,144,205,70,40,36,34,68,50,10,93,201,32,14,61,14,192,18,137,238,176,158,176,215,179,117,86,45,46,70,164,30,139,122,29,103,225,162,8,239,5,228,80,49,88,182,218,201,198,217,71,121,40,145,215,134,163,107,98,108,164,81,176,235,206,216,124,209,28,152,254,240,198,110,156,199,65,10,246,200,233,129,183,206,68,229,173,246,5,220,186,67,26,204,138,185,40,58,100,21,81,35,212,28,220,221,190,102,96,135,157,22,171,170,123,44,152,9,179,154,203,180,176,54,61,222,90,96,157,103,120,250,230,71,74,56,89,8,248,239,227,42,254,52,111,33,225,92,185,77,81,83,21,197,134,71,23,246,163,63,136,255,215,75,160,248,207,82,133,153,157,214,73,139,46,137,56,11,149,198,87,101,21,247,104,252,90,77,16,254,202,116,62,157,83,36,102,206,62,43,108,244,145,60,47,165,11,186,120,197,86,141,251,1,191,51,217,9,247,67,183,230,191,198,177,204,39,188,183,172,19,206,83,234,206,14,57,60,223,117,221,141,75,172,91,137,79,169,69,156,141,44,189,116,122,253,117,200,205,26,116,84,9,248,114,36,150,186,64,61,128,227,21,60,152,215,233,181,70,124,61,219,50,93,8,47,53,192,172,11,167,35,48,19,38,120,60,70,98,140,94,169,31,188,92,140,244,82,215,122,207,195,242,132,15,79,227,59,130,104,110,183,6,138,36,203,210,239,151,234,19,105,159,198,108,140,22,94,219,223,231,183,184,56,15,29,171,206,104,1,218,232,207,36,107,66,221,222,206,160,110,47,143,46,111,142,93,239,249,251,65,175,197,204,44,21,148,124,121,87,88,121,49,5,7,38,194,98,168,24,137,213,249,213,47,1,223,55,62,45,218,201,56,244,28,251,215,91,34,234,66,89,19,187,16,186,19,168,31,167,62,158,93,235,169,186,24,207,183,64,188,59,140,49,57,20,245,38,96,198,246,177,208,153,74,252,242,108,246,57,112,109,124,178,171,171,134,200,30,27,44,5,213,105,238,204,157,23,28,94,86,50,191,144,4,137,67,134,205,73,195,242,175,212,24,233,58,234,46,188,167,226,211,42,77,93,191,117,188,99,191,62,106,117,37,29,247,116,193,60,87,176,75,192,164,172,100,148,170,77,197,93,255,162,241,105,110,35,126,107,115,137,117,141,236,100,140,67,62,96,179,123,142,196,76,121,210,69,27,18,208,228,125,135,174,174,155,38,46,88,29,241,13,145,201,139,176,8,211,52,106,158,32,110,45,220,90,68,245,244,201,112,79,67,101,108,48,243,40,99,65,204,176,237,159,200,15,128,166,9,168,194,174,213,139,94,222,18,162,140,229,113,233,245,78,11,5,85,190,58,247,127,127,229,108,204,142,247,119,150,114,90,47,171,247,144,242,246,64,104,247,177,228,196,164,205,144,4,74,185,46,89,41,144,79,37,29,95,99,61,36,231,193,19,108,216,79,86,222,23,244,250,46,252,63,139,170,186,126,27,165,254,32,91,139,21,250,71,159,73,80,230,51,139,125,194,53,172,88,111,255,75,99,222,151,140,139,154,19,143,241,183,106,62,202,52,56,3,115,112,176,166,44,83,177,255,206,129,88,207,33,71,150,132,209,164,77,210,136,242,156,86,185,174,3,203,11,25,213,191,222,219,81,4,12,95,34,201,192,214,85,233,96,194,114,137,220,35,74,76,97,175,222,136,64,253,204,150,142,115,226,93,213,225,188,187,200,155,179,17,142,170,181,99,102,249,224,125,172,215,194,62,192,138,2,218,133,81,160,220,250,114,105,180,3,171,203,101,176,55,6,187,97,47,173,250,82,12,109,49,145,211,87,13,208,180,84,233,5,28,177,106,139,105,66,144,231,0,83,28,132,65,116,82,208,124,33,96,81,61,227,123,89,149,174,49,73,200,110,67,101,117,186,155,166,133,76,49,30,50,73,237,50,219,44,41,25,180,222,78,88,151,175,220,205},
} ;

static void test_encode_953x3_impl(long long impl)
{
  unsigned char *s = test_encode_953x3_s;
  unsigned char *x = test_encode_953x3_x;
  unsigned char *s2 = test_encode_953x3_s2;
  unsigned char *x2 = test_encode_953x3_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_953x3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_953x3(impl);
    printf("encode_953x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953x3_implementation(impl),ntruprime_dispatch_encode_953x3_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_953x3;
    printf("encode_953x3 selected implementation %s compiler %s\n",ntruprime_encode_953x3_implementation(),ntruprime_encode_953x3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_953x3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_953x3_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_953x3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_953x3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_953x3_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_953x3_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_953x3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953x3")) return;
  storage_encode_953x3_s = callocplus(crypto_encode_STRBYTES);
  test_encode_953x3_s = aligned(storage_encode_953x3_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_953x3_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_953x3_x = aligned(storage_encode_953x3_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_953x3_s2 = callocplus(maxalloc);
  test_encode_953x3_s2 = aligned(storage_encode_953x3_s2,crypto_encode_STRBYTES);
  storage_encode_953x3_x2 = callocplus(maxalloc);
  test_encode_953x3_x2 = aligned(storage_encode_953x3_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_953x3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_953x3();++impl)
      forked(test_encode_953x3_impl,impl);
    ++test_encode_953x3_s;
    ++test_encode_953x3_x;
    ++test_encode_953x3_s2;
    ++test_encode_953x3_x2;
  }
  free(storage_encode_953x3_x2);
  free(storage_encode_953x3_s2);
  free(storage_encode_953x3_x);
  free(storage_encode_953x3_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

