/* ----- decode/int16, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_int16_checksums[] = {
  "7f59625680d504bdd9bff199c54792455ddfd077779962836a92543c88bea2fa",
  "cdc27065db4d2f6e2356756b9a0bae31699e6255f0caf0011ba18ef3d2229ed8",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_int16_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_int16_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_int16_ITEMBYTES

static void *storage_decode_int16_x;
static unsigned char *test_decode_int16_x;
static void *storage_decode_int16_s;
static unsigned char *test_decode_int16_s;
static void *storage_decode_int16_x2;
static unsigned char *test_decode_int16_x2;
static void *storage_decode_int16_s2;
static unsigned char *test_decode_int16_s2;

#define precomputed_decode_int16_NUM 16

static const uint16_t precomputed_decode_int16_x[precomputed_decode_int16_NUM][crypto_decode_ITEMS] = {
  {27282},
  {6324},
  {29636},
  {29418},
  {57190},
  {51674},
  {52177},
  {45544},
  {49890},
  {63047},
  {21664},
  {40722},
  {28944},
  {61677},
  {22244},
  {5118},
} ;

static const unsigned char precomputed_decode_int16_s[precomputed_decode_int16_NUM][crypto_decode_STRBYTES] = {
  {146,106},
  {180,24},
  {196,115},
  {234,114},
  {102,223},
  {218,201},
  {209,203},
  {232,177},
  {226,194},
  {71,246},
  {160,84},
  {18,159},
  {16,113},
  {237,240},
  {228,86},
  {254,19},
} ;

static void test_decode_int16_impl(long long impl)
{
  unsigned char *x = test_decode_int16_x;
  unsigned char *s = test_decode_int16_s;
  unsigned char *x2 = test_decode_int16_x2;
  unsigned char *s2 = test_decode_int16_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_int16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_int16(impl);
    printf("decode_int16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_int16_implementation(impl),ntruprime_dispatch_decode_int16_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_int16;
    printf("decode_int16 selected implementation %s compiler %s\n",ntruprime_decode_int16_implementation(),ntruprime_decode_int16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_int16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_int16_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_int16_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_int16_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_int16_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_int16_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_int16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"int16")) return;
  storage_decode_int16_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_int16_x = aligned(storage_decode_int16_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_int16_s = callocplus(crypto_decode_STRBYTES);
  test_decode_int16_s = aligned(storage_decode_int16_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_int16_x2 = callocplus(maxalloc);
  test_decode_int16_x2 = aligned(storage_decode_int16_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_int16_s2 = callocplus(maxalloc);
  test_decode_int16_s2 = aligned(storage_decode_int16_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_int16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_int16();++impl)
      forked(test_decode_int16_impl,impl);
    ++test_decode_int16_x;
    ++test_decode_int16_s;
    ++test_decode_int16_x2;
    ++test_decode_int16_s2;
  }
  free(storage_decode_int16_s2);
  free(storage_decode_int16_x2);
  free(storage_decode_int16_s);
  free(storage_decode_int16_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

