; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X32
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X64

; Used movq to load i64 into a v2i64 when the top i64 is 0.

define <2 x i64> @foo1(i64* %y) nounwind  {
; X32-LABEL: foo1:
; X32:       # BB#0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X32-NEXT:    retl
;
; X64-LABEL: foo1:
; X64:       # BB#0: # %entry
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    retq
entry:
  %tmp1 = load i64, i64* %y, align 8
  %s2v = insertelement <2 x i64> undef, i64 %tmp1, i32 0
  %loadl = shufflevector <2 x i64> zeroinitializer, <2 x i64> %s2v, <2 x i32> <i32 2, i32 1>
  ret <2 x i64> %loadl
}


define <4 x float> @foo2(i64* %p) nounwind {
; X32-LABEL: foo2:
; X32:       # BB#0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X32-NEXT:    retl
;
; X64-LABEL: foo2:
; X64:       # BB#0: # %entry
; X64-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    retq
entry:
  %load = load i64, i64* %p
  %s2v = insertelement <2 x i64> undef, i64 %load, i32 0
  %loadl = shufflevector <2 x i64> zeroinitializer, <2 x i64> %s2v, <2 x i32> <i32 2, i32 1>
  %0 = bitcast <2 x i64> %loadl to <4 x float>
  ret <4 x float> %0
}
