; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+zbkb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64ZBKB

declare i64 @llvm.riscv.brev8(i64)

define i64 @brev8(i64 %a) nounwind {
; RV64ZBKB-LABEL: brev8:
; RV64ZBKB:       # %bb.0:
; RV64ZBKB-NEXT:    brev8 a0, a0
; RV64ZBKB-NEXT:    ret
  %val = call i64 @llvm.riscv.brev8(i64 %a)
  ret i64 %val
}

; Test that rev8 is recognized as preserving zero extension.
define zeroext i16 @brev8_knownbits(i16 zeroext %a) nounwind {
; RV64ZBKB-LABEL: brev8_knownbits:
; RV64ZBKB:       # %bb.0:
; RV64ZBKB-NEXT:    brev8 a0, a0
; RV64ZBKB-NEXT:    ret
  %zext = zext i16 %a to i64
  %val = call i64 @llvm.riscv.brev8(i64 %zext)
  %trunc = trunc i64 %val to i16
  ret i16 %trunc
}

declare i64 @llvm.bswap.i64(i64)

define i64 @rev8_i64(i64 %a) {
; RV64ZBKB-LABEL: rev8_i64:
; RV64ZBKB:       # %bb.0:
; RV64ZBKB-NEXT:    rev8 a0, a0
; RV64ZBKB-NEXT:    ret
  %1 = call i64 @llvm.bswap.i64(i64 %a)
  ret i64 %1
}
