package latexDraw.parsers.svg;

import latexDraw.parsers.svg.elements.SVGElement;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 * Defines a text node.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/31/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 */
public class SVGText extends SVGElement implements Text
{
	/** The content of the text node. @since 0.1 */
	protected String data;
	
	public static final String TEXT_NODE_NAME = "#text";//$NON-NLS-1$
	
	
	/**
	 * Creates a text node.
	 * @param text The content of the node.
	 * @param owner The owner document.
	 */
	public SVGText(String text, SVGDocument owner)
	{
		super();
		
		if(text==null)
			throw new IllegalArgumentException();
		
		ownerDocument = owner;
		data = text;
		setNodeName(TEXT_NODE_NAME);
	}
	
	
	@Override
	public String getNodeValue() throws DOMException
	{
		return data;
	}
	
	
	public void appendData(String arg) throws DOMException
	{
		if(arg!=null)
			setData(getData()+arg);
	}
	
	
	public String getData() throws DOMException
	{
		return data;
	}

	
	public int getLength()
	{
		return data.length();
	}

	
	@Override
	public short getNodeType()
	{
		return Node.TEXT_NODE;
	}


	@Override
	public boolean checkAttributes()
	{
		return true;
	}


	@Override
	public boolean enableRendering()
	{
		return false;
	}
	
	
	public void setData(String data) throws DOMException
	{
		if(data!=null)
			this.data = data; 
	}
	
	
	
	public String getWholeText()
	{ throw new DOMException(DOMException.INVALID_ACCESS_ERR, SVGDocument.ACTION_NOT_IMPLEMENTED); }

	public boolean isElementContentWhitespace()
	{ throw new DOMException(DOMException.INVALID_ACCESS_ERR, SVGDocument.ACTION_NOT_IMPLEMENTED); }

	public Text replaceWholeText(String content) throws DOMException
	{ throw new DOMException(DOMException.INVALID_ACCESS_ERR, SVGDocument.ACTION_NOT_IMPLEMENTED); }

	public Text splitText(int offset) throws DOMException
	{ throw new DOMException(DOMException.INVALID_ACCESS_ERR, SVGDocument.ACTION_NOT_IMPLEMENTED); }

	public void deleteData(int offset, int count) throws DOMException
	{ throw new DOMException(DOMException.INVALID_ACCESS_ERR, SVGDocument.ACTION_NOT_IMPLEMENTED); }

	public void insertData(int offset, String arg) throws DOMException
	{ throw new DOMException(DOMException.INVALID_ACCESS_ERR, SVGDocument.ACTION_NOT_IMPLEMENTED); }

	public void replaceData(int offset, int count, String arg) throws DOMException
	{ throw new DOMException(DOMException.INVALID_ACCESS_ERR, SVGDocument.ACTION_NOT_IMPLEMENTED); }

	public String substringData(int offset, int count) throws DOMException
	{ throw new DOMException(DOMException.INVALID_ACCESS_ERR, SVGDocument.ACTION_NOT_IMPLEMENTED); }
}
