/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "filtermodel.h"

FilterModel::FilterModel( QObject *parent )
  : QAbstractListModel( parent )
{
}

FilterModel::~FilterModel()
{
}

QString FilterModel::filter( const QModelIndex &index, const QString &userInput, FilterCriterion criterion ) const
{
  if ( !index.isValid() )
    return QString();

  QString attribute = index.model()->data( index, AttributeRole ).toString();

  QString filter;
  if ( criterion == FilterContains )
    filter = QString( "(%1=*%2*)" ).arg( attribute, userInput );
  else if ( criterion == FilterEquals )
    filter = QString( "(%1=%2)" ).arg( attribute, userInput );
  else if ( criterion == FilterStartsWith )
    filter = QString( "(%1=%2*)" ).arg( attribute, userInput );
  else if ( criterion == FilterEndsWith )
    filter = QString( "(%1=*%2)" ).arg( attribute, userInput );

  return filter;
}

