#pragma once

/*
 *      Copyright (C) 2017 Team Kodi
 *      http://kodi.tv
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

extern "C" {
#include "libhts/htsmsg.h"
}

namespace tvheadend
{

/*
 * HTSP Connection Listener interface
 */
class IHTSPConnectionListener
{
public:
  virtual ~IHTSPConnectionListener() = default;

  virtual void Disconnected() = 0;
  virtual bool Connected() = 0;
  virtual bool ProcessMessage(const char *method, htsmsg_t *msg) = 0;
};

} // namespace tvheadend
