/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WIDGETRESOLUTION_H
#define WIDGETRESOLUTION_H

#include <QWidget>
#include "tirage.h"

class WidgetResolution : public QWidget {
	Q_OBJECT
	
  public:
	WidgetResolution( QWidget *parent=0 ); //constructeur
	
	bool bloque; //les operations et la gomme sont bloqus s'il est  true
	
	int x, y; //position dans la grille de rsolution
	
	//valeurs des cases de la grille de rsolution
	vector <int> a; //colonne de la premire plaque
	vector <int> b; //colonne d'opration
	vector <int> c; //colonne de la deuxime plaque
	vector<int> total; //colonne du total
	
	int position; //identifiant de la plaque en cours (de 100  114)
	
	pair<int,int> cible; //compte  atteindre

	//pas d'antcdent : -1, sinon, numro de l'antcdent stock dans le vecteur.
	//l'antcdent d'une plaque de la grille de rsolution = plaque du tirage ou de la grille utilise
	vector<int> antecedents;
	
  public slots:
	void gestionPlaque(int, int);
	void init();     //fonction pour effacer toutes les plaques
	void gomme();
	void bloque_le_module(bool); //pour bloquer/dbloquer le module
	
  signals:
	void changePlaque(int, int);
	void changeEtat(int, int);
	void la_victoire();
	void non_Cliquable(int);
};

#endif
