/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Util {
    static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String WSIDNotAvailable = "";
    private static final Logger utilLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.Util");
    private static final int leapDaysBeforeSQLBaseDate = Util.leapDaysBeforeYear(1900);
    static final char LEFT_BRACKET = '[';
    static final char RIGHT_BRACKET = ']';
    static final char[] DOUBLE_RIGHT_BRACKET = new char[]{']', ']'};
    private static final int MAX_SINGLE_BYTE_LENGTH = 255;
    private static final int MAX_DOUBLE_BYTE_LENGTH = 65535;

    Util() {
    }

    static short readShort(byte[] byArray, int n) {
        return (short)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8);
    }

    static int readUnsignedShort(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    static int readUnsignedShortBigEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    static void writeShort(short s, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(s >> 0 & 0xFF);
        byArray[n + 1] = (byte)(s >> 8 & 0xFF);
    }

    static void writeShortBigEndian(short s, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(s >> 8 & 0xFF);
        byArray[n + 1] = (byte)(s >> 0 & 0xFF);
    }

    static int readInt(byte[] byArray, int n) {
        int n2 = byArray[n + 0] & 0xFF;
        int n3 = (byArray[n + 1] & 0xFF) << 8;
        int n4 = (byArray[n + 2] & 0xFF) << 16;
        int n5 = (byArray[n + 3] & 0xFF) << 24;
        return n5 | n4 | n3 | n2;
    }

    static int readIntBigEndian(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) << 0 | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 0] & 0xFF) << 24;
    }

    static void writeInt(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n >> 0 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
    }

    static void writeIntBigEndian(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n >> 24 & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 0 & 0xFF);
    }

    static long readLong(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 7; i > 0; --i) {
            l += (long)(byArray[n + i] & 0xFF);
            l <<= 8;
        }
        return l + (long)(byArray[n] & 0xFF);
    }

    static int majorVersion() {
        return 1;
    }

    static String minorVersion() {
        String string = "2";
        return string;
    }

    static String getProgramName_65() {
        return "SQLServer";
    }

    static String nameAndVersion(boolean bl) {
        String string = "Microsoft SQL Server 2005 JDBC Driver";
        if (!bl) {
            return string;
        }
        return string + "(" + Util.majorVersion() + "." + Util.minorVersion() + ")";
    }

    static String javaSqlTypeToString(int n) {
        switch (n) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
        }
        return "UNKNOWN" + n;
    }

    private static int leapDaysBeforeYear(int n) {
        return (n - 1) / 4 - (n - 1) / 100 + (n - 1) / 400;
    }

    static void writeTimestamp(Calendar calendar, TDSWriter tDSWriter) throws SQLServerException {
        int n = calendar.get(1);
        int n2 = calendar.get(6) - 1 + (n - 1900) * 365 + Util.leapDaysBeforeYear(n) - leapDaysBeforeSQLBaseDate;
        int n3 = calendar.get(14) + 1000 * calendar.get(13) + 60000 * calendar.get(12) + 3600000 * calendar.get(11);
        if (86399999 == n3) {
            ++n2;
            n3 = 0;
        }
        tDSWriter.writeInt(n2);
        tDSWriter.writeInt((3 * n3 + 5) / 10);
    }

    static String normalizePropertyNames(String string) {
        int n;
        if (null == string) {
            return string;
        }
        for (n = 0; n < SQLServerDriver.driverPropertiesSynonyms.length; ++n) {
            if (!SQLServerDriver.driverPropertiesSynonyms[n][0].equalsIgnoreCase(string)) continue;
            return SQLServerDriver.driverPropertiesSynonyms[n][1];
        }
        for (n = 0; n < SQLServerDriver.driverProperties.length; ++n) {
            if (!SQLServerDriver.driverProperties[n].equalsIgnoreCase(string)) continue;
            return SQLServerDriver.driverProperties[n];
        }
        if (utilLogger.isLoggable(Level.FINE)) {
            utilLogger.fine("Unknown property" + string);
        }
        return null;
    }

    static Properties parseUrl(String string) throws SQLServerException {
        Properties properties = new Properties();
        String string2 = string;
        String string3 = "jdbc:sqlserver://";
        String string4 = WSIDNotAvailable;
        String string5 = WSIDNotAvailable;
        String string6 = WSIDNotAvailable;
        if (!string2.startsWith(string3)) {
            return null;
        }
        string2 = string2.substring(string3.length());
        int n = 0;
        int n2 = 0;
        block18: for (n = 0; n < string2.length(); ++n) {
            char c = string2.charAt(n);
            switch (n2) {
                case 0: {
                    if (c == ';') {
                        n2 = 7;
                        continue block18;
                    }
                    string4 = string4 + c;
                    n2 = 1;
                    continue block18;
                }
                case 1: {
                    if (c == ';' || c == ':' || c == '\\') {
                        if ((string4 = string4.trim()).length() > 0) {
                            properties.put("serverName", string4);
                            if (utilLogger.isLoggable(Level.FINE)) {
                                utilLogger.fine("Property : serverName Value:" + string4);
                            }
                        }
                        string4 = WSIDNotAvailable;
                        if (c == ';') {
                            n2 = 7;
                            continue block18;
                        }
                        if (c == ':') {
                            n2 = 2;
                            continue block18;
                        }
                        n2 = 3;
                        continue block18;
                    }
                    string4 = string4 + c;
                    continue block18;
                }
                case 2: {
                    if (c == ';') {
                        string4 = string4.trim();
                        if (utilLogger.isLoggable(Level.FINE)) {
                            utilLogger.fine("Property : portNumber Value:" + string4);
                        }
                        properties.put("portNumber", string4);
                        string4 = WSIDNotAvailable;
                        n2 = 7;
                        continue block18;
                    }
                    string4 = string4 + c;
                    continue block18;
                }
                case 3: {
                    if (c == ';' || c == ':') {
                        string4 = string4.trim();
                        if (utilLogger.isLoggable(Level.FINE)) {
                            utilLogger.fine("Property : instanceName Value:" + string6);
                        }
                        properties.put("instanceName", string4.toLowerCase(Locale.US));
                        string4 = WSIDNotAvailable;
                        if (c == ';') {
                            n2 = 7;
                            continue block18;
                        }
                        n2 = 2;
                        continue block18;
                    }
                    string4 = string4 + c;
                    continue block18;
                }
                case 7: {
                    if (c == '=') {
                        if ((string5 = string5.trim()).length() <= 0) {
                            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        }
                        n2 = 6;
                        continue block18;
                    }
                    if (c == ';') {
                        if ((string5 = string5.trim()).length() <= 0) continue block18;
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        continue block18;
                    }
                    string5 = string5 + c;
                    continue block18;
                }
                case 6: {
                    if (c == ';') {
                        string6 = string6.trim();
                        if (null != (string5 = Util.normalizePropertyNames(string5))) {
                            if (utilLogger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                                utilLogger.fine("Property:" + string5 + "Value:" + string6);
                            }
                            properties.put(string5, string6);
                        }
                        string5 = WSIDNotAvailable;
                        string6 = WSIDNotAvailable;
                        n2 = 7;
                        continue block18;
                    }
                    if (c == '{') {
                        n2 = 4;
                        if ((string6 = string6.trim()).length() <= 0) continue block18;
                        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                        continue block18;
                    }
                    string6 = string6 + c;
                    continue block18;
                }
                case 4: {
                    if (c == '}') {
                        if (null != (string5 = Util.normalizePropertyNames(string5))) {
                            if (utilLogger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                                utilLogger.fine("Property:" + string5 + "Value:" + string6);
                            }
                            properties.put(string5, string6);
                        }
                        string5 = WSIDNotAvailable;
                        string6 = WSIDNotAvailable;
                        n2 = 5;
                        continue block18;
                    }
                    string6 = string6 + c;
                    continue block18;
                }
                case 5: {
                    if (c == ';') {
                        n2 = 7;
                        continue block18;
                    }
                    if (c == ' ') continue block18;
                    SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                }
            }
        }
        switch (n2) {
            case 1: {
                string4 = string4.trim();
                if (string4.length() <= 0) break;
                if (utilLogger.isLoggable(Level.FINE)) {
                    utilLogger.fine("Property : serverName Value:" + string4);
                }
                properties.put("serverName", string4);
                break;
            }
            case 2: {
                string4 = string4.trim();
                if (utilLogger.isLoggable(Level.FINE)) {
                    utilLogger.fine("Property : portNumber Value:" + string4);
                }
                properties.put("portNumber", string4);
            }
            case 3: {
                string4 = string4.trim();
                if (utilLogger.isLoggable(Level.FINE)) {
                    utilLogger.fine("Property : instanceName Value:" + string4);
                }
                properties.put("instanceName", string4);
                break;
            }
            case 6: {
                string6 = string6.trim();
                string5 = Util.normalizePropertyNames(string5);
                if (null == string5) break;
                if (utilLogger.isLoggable(Level.FINE) && !string5.equals("user") && !string5.equals("password")) {
                    utilLogger.fine("Property:" + string5 + "Value:" + string6);
                }
                properties.put(string5, string6);
                break;
            }
            case 0: 
            case 5: {
                break;
            }
            case 7: {
                string5 = string5.trim();
                if (string5.length() <= 0) break;
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
                break;
            }
            default: {
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_errorConnectionString"), null, true);
            }
        }
        return properties;
    }

    static byte[] GUIDToBytes(String string) throws SQLServerException {
        int n = string.length();
        byte[] byArray = new byte[16];
        int n2 = 0;
        int n3 = 0;
        if (n != 36) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_stringNotInHex"), null, false);
        }
        while (n2 + 1 < n && 16 != n3) {
            char c;
            if ((c = string.charAt(n2++)) == '-') {
                if (9 == n2 || 14 == n2 || 19 == n2 || 24 == n2) continue;
                SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_stringNotInHex"), null, false);
            }
            byte by = ParameterUtils.CharToHex(c);
            by = (byte)(by << 4);
            c = string.charAt(n2++);
            byte by2 = ParameterUtils.CharToHex(c);
            int n4 = n3;
            if (n3 == 0) {
                n4 = 3;
            }
            if (n3 == 1) {
                n4 = 2;
            }
            if (n3 == 2) {
                n4 = 1;
            }
            if (n3 == 3) {
                n4 = 0;
            }
            if (n3 == 4) {
                n4 = 5;
            }
            if (n3 == 5) {
                n4 = 4;
            }
            if (n3 == 6) {
                n4 = 7;
            }
            if (n3 == 7) {
                n4 = 6;
            }
            byArray[n4] = (byte)(by + by2);
            ++n3;
        }
        return byArray;
    }

    static SQLServerException notSupportedBySQLServer(String string) throws SQLServerException {
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_notSupportedBySQL"));
        Object[] objectArray = new Object[]{new String(string)};
        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "0A000", false);
        return null;
    }

    static boolean isBigInt(int n, int n2) {
        return n == 38 && n2 == 8;
    }

    static void println(String string) {
        System.out.println(string);
    }

    static void print(String string) {
        System.out.print(string);
    }

    static String escapeSQLId(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('[');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (']' == c) {
                stringBuffer.append(DOUBLE_RIGHT_BRACKET);
                continue;
            }
            stringBuffer.append(c);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static void checkSingleByteLength(int n) throws SQLServerException {
        if (n < 0 || n > 255) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidDataLength"));
            Object[] objectArray = new Object[]{new Integer(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static void checkDoubleByteLength(int n) throws SQLServerException {
        if (n < 0 || n > 65535) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidDataLength"));
            Object[] objectArray = new Object[]{new Integer(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static String readUnicodeString(byte[] byArray, int n, int n2) throws SQLServerException {
        try {
            return new String(byArray, n, n2, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_stringReadError"));
            Object[] objectArray = new Object[]{new Integer(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_stringReadError"));
            Object[] objectArray = new Object[]{new Integer(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static int writeUnicodeString(byte[] byArray, int n, String string) throws SQLServerException {
        try {
            byte[] byArray2 = string.getBytes("UTF-16LE");
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            return byArray2.length;
        }
        catch (IOException iOException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_stringWriteError"));
            Object[] objectArray = new Object[]{new Integer(n)};
            throw new SQLServerException(null, messageFormat.format(objectArray), null, 0, true);
        }
    }

    static String byteToHexDisplayString(byte[] byArray) {
        if (null == byArray) {
            return "(null)";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2 + 2);
        stringBuffer.append("0x");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuffer.append(hexChars[(n & 0xF0) >> 4]);
            stringBuffer.append(hexChars[n & 0xF]);
        }
        return stringBuffer.toString();
    }

    static String bytesToHexString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            stringBuffer.append(hexChars[(n2 & 0xF0) >> 4]);
            stringBuffer.append(hexChars[n2 & 0xF]);
        }
        return stringBuffer.toString();
    }

    static String lookupHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (null != inetAddress) {
                String string = inetAddress.getHostName();
                if (null != string && string.length() > 0) {
                    return string;
                }
                string = inetAddress.getHostAddress();
                if (null != string && string.length() > 0) {
                    return string;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            return WSIDNotAvailable;
        }
        return WSIDNotAvailable;
    }
}

