/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.codeInsight.completion;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.ElementFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author peter
 */
class ExcludeFilter implements ElementFilter {
  private final PsiElement myExcluded;

  ExcludeFilter(@NotNull PsiVariable excluded) {
    myExcluded = excluded;
  }

  @Override
  public boolean isAcceptable(Object element, @Nullable PsiElement context) {
    return element != myExcluded;
  }

  @Override
  public boolean isClassAcceptable(Class hintClass) {
    return true;
  }
}
