# Contributing to the Ice Builder for Gradle

Thank you for your interest in contributing to the Ice Builder for Gradle!

## How to Contribute

Follow these steps to contribute code or documentation to this project:

1. Download and review carefully our [Contributor Agreement](https://zeroc.com/download/ZeroCContributorAgreement.pdf), and send us a completed and signed copy.

   Please sign this agreement with a pen, as we do not accept electronic signatures.<br/>
   Then email a scanned copy of this agreement to contributing@zeroc.com, or send us an original paper copy by [snail mail](https://zeroc.com/about.html#contact).

   You need to do this only once, before your first contribution.

2. For large contributions (see below), make sure to first discuss your ideas with the [community](https://forums.zeroc.com) or by sending us an email.

3. Fork this repository.

4. Follow this project's naming and coding conventions when implementing your contribution - we want to keep all our source code consistent.

5. Update the test suite if appropriate for your contribution.

6. Submit a pull request.

We review carefully any contribution that we accept, and these reviews may take some time. Please keep in mind there is no guarantee your contribution will be accepted: we may reject a pull request for any reason, or no reason.

## Our Favorite Contributions

We prefer small contributions as they are easier to review and integrate. If you want to contribute but don't know where to start, consider one of these areas:

 * New sample programs (in the [ice-demos](https://github.com/zeroc-ice/ice-demos) repository)

 * Small bug fixes that affect only one or a few source files

 * Fixes for the documentation

 * Ports to new platforms and compilers

## Large Contributions

Please don't spend weeks or months on a new feature without checking with us first!

Some contributions are troublesome and therefore difficult to accept:

 * New features that require a new version of the Ice encoding or Ice protocol<br/>
   For example, adding a new Slice type would most likely require a new version of the Ice encoding

 * New features that may be useful for your project but are not obviously useful to other projects<br/>
   We want to keep our software lean and focused!

 * Any update that breaks source compatibility with the most recent release

## Contact

 * Community Forums: https://forums.zeroc.com
 * Twitter: https://twitter.com/zeroc
 * Email: contributing@zeroc.com
