---
title: Andika - Character Set Support
fontversion: 6.200
---

This font supports over 2,400 characters from [The Unicode Standard](https://unicode.org/) as well as a number of [Private Use Area (PUA)](https://scripts.sil.org/SILPUAassignments) characters. In total, over 4,000 glyphs are included, supporting stylistic alternates for a number of characters as well as a large number of ligated sequences (e.g., contour tone letters used in phonetic transcription of tonal languages). 

## Supported characters

The following character ranges are supported by this font:

Unicode block | Charis SIL support
------------- | ---------------
C0 Controls and Basic Latin*|U+0020..U+007E
C1 Controls and Latin-1 Supplement*|U+00A0..U+00FF
Latin Extended-A|U+0100..U+0148, U+014A..U+017F
Latin Extended-B*|U+0180..U+024F
IPA Extensions*|U+0250..U+02AF
Spacing Modifier Letters*|U+02B0..U+02FF
Combining Diacritical Marks|U+0300..U+033F, U+0346..U+036F
Greek and Coptic|U+0387, U+0393..U+0394, U+0398, U+039E, U+03A0, U+03A8..U+03A9, U+03B1..U+03B4, U+03B8, U+03BB..U+03BC, U+03C0..U+03C1, U+03C3, U+03C6..U+03C7, U+03C9, U+03D1, U+03F4
Cyrillic|U+0400..U+045F, U+0462..U+0463, U+0472..U+0475, U+048A..U+04FF
Cyrillic Supplement*|U+0500..U+052F
Combining Diacritical Marks Extended|U+1AB0..U+1ABA. U+1ABF..U+1AC0, U+1AC6..U+1ACE
Phonetic Extensions*|U+1D00..U+1D7F
Phonetic Extensions Supplement*|U+1D80..U+1DBF
Combining Diacritical Marks Supplement|U+1DC2, U+1DC4..U+1DCD, U+1DDA, U+1DDC, U+1DF5, U+1DFC..U+1DFF
Latin Extended Additional*|U+1E00..U+1EFF
General Punctuation|U+2000..U+2042, U+2044, U+204A, U+2053, U+2057, U+2060..U+2063, U+206A..U+206F
Superscripts and Subscripts*|U+2070..U+2071, U+2074..U+208E, U+2090..U+209C
Currency Symbols*|U+20A0..U+20C0
Combining Diacritical Marks for Symbols|U+20E5, U+20EC..U+20EF
Letterlike Symbols|U+210C, U+2113, U+2116..U+2117, U+211F, U+2122..U+2123, U+2126, U+212D, U+2135, U+214F
Number Forms*|U+2150..U+218B
Arrows|U+2190..U+219B, U+21A8, U+21B6..U+21B7, U+21Ba..U+21BB, U+21D0..U+21D5
Mathematical Operators|U+2202..U+2206, U+220F, U+2211..U+2213, U+2215, U+2219..U+221A, U+221E, U+2221, U+2225..U+2228, U+222B, U+2234..U+2235, U+223C, U+2248, U+225F, U+2260..U+2262, U+2264..U+2265, U+226E..U+226F, U+U+2282..U+2287
Miscellaneous Technical|U+2308..U+230B, U+2318, U+231C..U+231F, U+2329..U+232A, U+239B..U+23AD
Control Pictures|U+2423
Geometric Shapes|U+25C9, U+25CA..U+25CC
Miscellaneous Symbols|U+2610..U+2612, U+2639..U+263A, U+2640, U+2642, U+266D, U+266F
Dingbats|U+2713, U+2717, U+274D
Misc. Math. Symbols-A|U+27C2, U+27E6..U+27E9
Misc. Math. Symbols-B|U+2980
Supplemental Math. Operators|U+2AFD
Latin Extended-C*|U+2C60..U+2C7F
Coptic|U+2C88
Supplemental Punctuation|U+2E00..U+2E0D, U+2E13, U+2E14, U+2E17, U+2E22..U+2E25, U+2E3A..U+2E3B, U+2E3E
Modifier Tone Letters*|U+A700..U+A71F
Latin Extended-D|U+A720..U+A799, U+A7A0..U+A7AF, U+A7B0..U+A7BF, U+A7C4..U+A7CA, U+A7F2..U+A7F4, U+A7F7..U+A7FF
Kayah Li|U+A92E
Latin Extended-E|U+AB30, U+AB53, U+AB5C, U+AB5E, U+AB64..U+AB6B
PUA: Specials|U+F130..U+F133
PUA: Modifier letters (e.g. superscripts)|U+F1A1, U+F1A3..U+F1A4, U+F1AB, U+F1AE, U+F1B4..U+F1B5, U+F1BC, U+F1CD..U+F1CE, U+F1F1..U+F1F9
PUA: Latin|U+F20D, U+F234..U+F235, U+F258..U+F259, U+F267..U+F269, U+F26C..U+F26D
PUA: Cyrillic|U+F326..U+F327
Alphabetic Presentation Forms|U+FB00..U+FB04
Variation Selectors*|U+FE00..U+FE0F
Combining Half Marks|U+FE20..U+FE23
Arabic Presentation Forms-B|U+FEFF (zero-width no-break space)
Specials*|U+FFF9..U+FFFD
Latin Extended-F*|U+10780..U+10785, U+10787..U+107B0, U+107B2..U+107BA
Mathematical Alphanumeric Symbols|U+1D40C, U+1D504..U+1D505, U+1D50A, U+1D50E..U+1D510, U+1D513..U+1D514, U+1D516..U+1D517, U+1D519
Latin Extended-G*|U+1DF00..U+1DF1E, U+1DF25..U+1DF2A
Cyrillic Extended-D|U+1E030..U+1E049, U+1E04B..U+1E06B, U+1E06D, U+1E06F
Enclosed Alphanumeric Supplement|U+1F12F
Emoticons|U+1F610

*This block is fully supported as of Unicode 15.0.

## Private-use (PUA) characters

There are a number of private-use characters that are supported in this font. These conform to [SIL International’s corporate registry](https://scripts.sil.org/PUA_home) for usage of the Unicode private-use areas. Characters which are not yet in Unicode are shown below. 

### Specials

- U+F130  FONT BASELINE AND SIDE-BEARING MARKER LEFT
- U+F131  FONT BASELINE AND SIDE-BEARING MARKER RIGHT
- U+F132  FONT VERTICAL METRICS MARKER LEFT
- U+F133  FONT VERTICAL METRICS MARKER RIGHT

### Modifier Letters

- U+F1CD  MODIFIER LETTER SMALL CAPITAL U BAR

### Latin

- U+F20D  LATIN CAPITAL LETTER D WITH STROKE AND HOOK
- U+F258  LATIN LETTER SMALL CAPITAL I OVER SMALL SCHWA
- U+F259  LATIN LETTER SMALL UPSILON OVER SMALL SCHWA
- U+F26D  LATIN SMALL LETTER B WITH LEFT HOOK
- U+F26E  LATIN CAPITAL LETTER RAMS HORN

### Cyrillic

- U+F326  CYRILLIC CAPITAL LETTER GHE WITH STROKE AND DESCENDER
- U+F327  CYRILLIC SMALL LETTER GHE WITH STROKE AND DESCENDER

### Deprecated SIL Corporate PUA characters

Some characters formerly in the PUA have been added to Unicode, and so have been deprecated in our fonts. Those PUA characters are displayed as black boxes containing a white image of the deprecated glyph.

## Andika New Basic supported characters

The supported character set for Andika New Basic is much smaller than for the main Andika font. The *Basic* fonts support only the Basic Latin and Latin-1 Supplement Unicode ranges, plus a selection of the more commonly used extended Latin characters, with miscellaneous diacritical marks, symbols and punctuation. In particular, these fonts do not support:

* Full extended Latin IPA
* Complete support for Central European languages
* Cyrillic

A much more complete character set is supported in the Andika fonts. The *Basic* fonts were intended as a way to provide additional weights for basic font users before the complete Andika character set was finished. So please don’t request additional glyphs or characters to be supported in the Basic fonts—use Andika.

Unicode block | Andika New Basic support
------------- | ---------------
C0 Controls and Basic Latin|U+0020..U+007E
C1 Controls and Latin-1 Supplement|U+00A0..U+00FF
Latin Extended-A|U+0100..U+0103, U+0106..U+010E, U+0110..U+0117, U+011A..U+0121, U+0124..U+0125, U+0128..U+012D, U+0130..U+0133, U+0139..U+013A, U+0141..U+0144, U+0147..U+0148, U+014A..U+0155, U+0158..U+0164, U+0168..U+0171, U+00174..U+017E
Latin Extended-B|U+0181, U+0186, U+0189..U+018A, U+018E..U+0190, U+0192, U+0196..U+019A, U+019D, U+019F..U+01A1, U+01A9..U+01AA, U+01AF..U+01B4, U+01B7, U+01CD..U+01E3, U+01E6..U+01E9, U+01EE..U+01EF, U+01F4..U+01F5, U+01F8..U+01FF, U+021E..U+021F, U+0226..U+0233, U+0237, U+023D, U+0241..U+0242, U+0244..U+0245, U+024A..U+024B
IPA Extensions|U+0251, U+0253..U+0254, U+0256..U+0257, U+0259, U+025B, U+0263, U+0268..U+0269, U+026B, U+0272, U+0275, U+0283, U+0289..U+028C, U+0292, U+0294, U+02A0
Spacing Modifier Letters|U+02BC, U+02C0, U+02C6..U+02C7, U+02C9..U+02CB, U+02CD, U+02D7..U+02DD
Combining Diacritical Marks|U+0300..U+0304, U+0306..U+030C, U+030F, U+031B, U+0323..U+0324, U+0326..U+0328, U+0331, U+033F, U+035E..U+035F
Greek and Coptic|U+03A0, U+03A9, U+03C0
Latin Extended Additional|U+1E02..U+1E0F, U+1E14..U+1E17, U+1E1C..U+1E27, U+1E2E..U+1E3B, U+1E3E..U+1E49, U+1E4C..U+1E6F, U+1E78..U+1E99, U+1EA0..U+1EF9
General Punctuation|U+2010..U+2011, U+2013..U+2015, U+2018..U+201A, U+201C..U+201E, U+2020..U+2022, U+2026, U+2030, U+2039..U+203A, U+2044
Currency Symbols|U+20AC
Letterlike Symbols|U+2122, U+2126
Mathematical Operators|U+2202, U+2205..U+2206, U+220F, U+2211..U+2212, U+2219..U+221A, U+221E, U+222B, U+2248, U+2260, U+2264..U+2265
Geometric Shapes|U+25CA, U+25CC
Latin Extended-C|U+2C60..U+2C62, U+2C72..U+2C73
Latin Extended-D|U+A789..U+A78C
Alphabetic Presentation Forms|U+FB01..U+FB02
SIL PUA|U+F130..U+F131
