/* device-properties.c generated by valac 0.35.3.10-6b27, the Vala compiler
 * generated from device-properties.vala, do not modify */

/*
 * Copyright (C) 2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <bluez-test.h>
#include <folks-test.h>
#include <gio/gio.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_DEVICE_PROPERTIES_TESTS (device_properties_tests_get_type ())
#define DEVICE_PROPERTIES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE_PROPERTIES_TESTS, DevicePropertiesTests))
#define DEVICE_PROPERTIES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE_PROPERTIES_TESTS, DevicePropertiesTestsClass))
#define IS_DEVICE_PROPERTIES_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE_PROPERTIES_TESTS))
#define IS_DEVICE_PROPERTIES_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE_PROPERTIES_TESTS))
#define DEVICE_PROPERTIES_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE_PROPERTIES_TESTS, DevicePropertiesTestsClass))

typedef struct _DevicePropertiesTests DevicePropertiesTests;
typedef struct _DevicePropertiesTestsClass DevicePropertiesTestsClass;
typedef struct _DevicePropertiesTestsPrivate DevicePropertiesTestsPrivate;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DEVICE, DeviceIface))

typedef struct _Device Device;
typedef struct _DeviceIface DeviceIface;

#define TYPE_DEVICE_PROXY (device_proxy_get_type ())
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef GDBusProxy DeviceProxy;
typedef GDBusProxyClass DeviceProxyClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DevicePropertiesTests {
	BluezTestTestCase parent_instance;
	DevicePropertiesTestsPrivate * priv;
};

struct _DevicePropertiesTestsClass {
	BluezTestTestCaseClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	DevicePropertiesTests* self;
	GMainLoop* main_loop;
};

struct _Block2Data {
	int _ref_count_;
	DevicePropertiesTests* self;
	GMainLoop* main_loop;
};

struct _Block3Data {
	int _ref_count_;
	DevicePropertiesTests* self;
	FolksPersonaStore* real_store;
	gchar* display_name;
	GMainLoop* main_loop;
};

struct _DeviceIface {
	GTypeInterface parent_iface;
	gchar* (*get_alias) (Device* self);
	void (*set_alias) (Device* self, const gchar* value);
};


static gpointer device_properties_tests_parent_class = NULL;

GType device_properties_tests_get_type (void) G_GNUC_CONST;
enum  {
	DEVICE_PROPERTIES_TESTS_DUMMY_PROPERTY
};
DevicePropertiesTests* device_properties_tests_new (void);
DevicePropertiesTests* device_properties_tests_construct (GType object_type);
void device_properties_tests_test_device_pairing (DevicePropertiesTests* self);
static void _device_properties_tests_test_device_pairing_folks_test_case_test_method (gpointer self);
void device_properties_tests_test_blocked_device (DevicePropertiesTests* self);
static void _device_properties_tests_test_blocked_device_folks_test_case_test_method (gpointer self);
void device_properties_tests_test_device_alias (DevicePropertiesTests* self);
static void _device_properties_tests_test_device_alias_folks_test_case_test_method (gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_, GObject* o, GAsyncResult* r);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda5_ (Block1Data* _data1_, GObject* o, GAsyncResult* r);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda6_ (Block2Data* _data2_, GObject* o, GAsyncResult* r);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda7_ (Block2Data* _data2_, GObject* o, GAsyncResult* r);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda8_ (Block2Data* _data2_, GObject* o, GAsyncResult* r);
static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda9_ (Block3Data* _data3_, GParamSpec* p);
static void ___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType device_get_type (void) G_GNUC_CONST;
GType device_proxy_get_type (void) G_GNUC_CONST;
guint device_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (const gchar* value);
void device_set_alias (Device* self, const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (GHashTable* value);
gchar* device_get_alias (Device* self);
static void device_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar* device_dbus_proxy_get_alias (Device* self);
static void device_dbus_proxy_set_alias (Device* self, const gchar* value);
static void device_proxy_device_interface_init (DeviceIface* iface);
static void device_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* device_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_device_get_alias (Device* self);
static gboolean device_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_device_set_alias (Device* self, GVariant* _value);
static void _device_unregister_object (gpointer user_data);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusMethodInfo * const _device_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _device_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _device_dbus_property_info_alias = {-1, "Alias", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo * const _device_dbus_property_info[] = {&_device_dbus_property_info_alias, NULL};
static const GDBusInterfaceInfo _device_dbus_interface_info = {-1, "org.bluez.Device1", (GDBusMethodInfo **) (&_device_dbus_method_info), (GDBusSignalInfo **) (&_device_dbus_signal_info), (GDBusPropertyInfo **) (&_device_dbus_property_info)};
static const GDBusInterfaceVTable _device_dbus_interface_vtable = {device_dbus_interface_method_call, device_dbus_interface_get_property, device_dbus_interface_set_property};

static void _device_properties_tests_test_device_pairing_folks_test_case_test_method (gpointer self) {
#line 30 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	device_properties_tests_test_device_pairing ((DevicePropertiesTests*) self);
#line 172 "device-properties.c"
}


static void _device_properties_tests_test_blocked_device_folks_test_case_test_method (gpointer self) {
#line 31 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	device_properties_tests_test_blocked_device ((DevicePropertiesTests*) self);
#line 179 "device-properties.c"
}


static void _device_properties_tests_test_device_alias_folks_test_case_test_method (gpointer self) {
#line 32 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	device_properties_tests_test_device_alias ((DevicePropertiesTests*) self);
#line 186 "device-properties.c"
}


DevicePropertiesTests* device_properties_tests_construct (GType object_type) {
	DevicePropertiesTests * self = NULL;
#line 28 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	self = (DevicePropertiesTests*) bluez_test_test_case_construct (object_type, "DeviceProperties");
#line 30 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "device pairing", _device_properties_tests_test_device_pairing_folks_test_case_test_method, g_object_ref (self), g_object_unref);
#line 31 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "blocked device", _device_properties_tests_test_blocked_device_folks_test_case_test_method, g_object_ref (self), g_object_unref);
#line 32 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "device alias", _device_properties_tests_test_device_alias_folks_test_case_test_method, g_object_ref (self), g_object_unref);
#line 26 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	return self;
#line 202 "device-properties.c"
}


DevicePropertiesTests* device_properties_tests_new (void) {
#line 26 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	return device_properties_tests_construct (TYPE_DEVICE_PROPERTIES_TESTS);
#line 209 "device-properties.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	return _data1_;
#line 218 "device-properties.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 227 "device-properties.c"
		DevicePropertiesTests* self;
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		self = _data1_->self;
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_main_loop_unref0 (_data1_->main_loop);
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (self);
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_slice_free (Block1Data, _data1_);
#line 237 "device-properties.c"
	}
}


static void __lambda4_ (Block1Data* _data1_, GObject* o, GAsyncResult* r) {
	DevicePropertiesTests* self;
	GMainLoop* _tmp2_;
	GError * _inner_error_ = NULL;
#line 69 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	self = _data1_->self;
#line 69 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_return_if_fail (r != NULL);
#line 250 "device-properties.c"
	{
		GAsyncResult* _tmp0_;
#line 73 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp0_ = r;
#line 73 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		folks_test_utils_aggregator_prepare_and_wait_for_quiescence_finish (_tmp0_, &_inner_error_);
#line 73 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 259 "device-properties.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e2 = NULL;
		const gchar* _tmp1_;
#line 71 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		e2 = _inner_error_;
#line 71 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_inner_error_ = NULL;
#line 77 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp1_ = e2->message;
#line 77 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_error ("device-properties.vala:77: Error preparing aggregator: %s", _tmp1_);
#line 71 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_error_free0 (e2);
#line 278 "device-properties.c"
	}
	__finally1:
#line 71 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 71 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 71 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_clear_error (&_inner_error_);
#line 71 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		return;
#line 289 "device-properties.c"
	}
#line 80 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp2_ = _data1_->main_loop;
#line 80 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_main_loop_quit (_tmp2_);
#line 295 "device-properties.c"
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 68 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	__lambda4_ (self, source_object, res);
#line 68 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	block1_data_unref (self);
#line 304 "device-properties.c"
}


static void __lambda5_ (Block1Data* _data1_, GObject* o, GAsyncResult* r) {
	DevicePropertiesTests* self;
	GAsyncResult* _tmp0_;
	GMainLoop* _tmp1_;
#line 94 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	self = _data1_->self;
#line 94 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_return_if_fail (r != NULL);
#line 96 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp0_ = r;
#line 96 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_aggregator_wait_for_individuals_finish (_tmp0_);
#line 97 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp1_ = _data1_->main_loop;
#line 97 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_main_loop_quit (_tmp1_);
#line 324 "device-properties.c"
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	__lambda5_ (self, source_object, res);
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	block1_data_unref (self);
#line 333 "device-properties.c"
}


void device_properties_tests_test_device_pairing (DevicePropertiesTests* self) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	BluezTestBackend* _tmp15_;
	FolksIndividualAggregator* aggregator;
	FolksIndividualAggregator* _tmp16_;
	GMainLoop* _tmp17_;
	FolksBackend* real_backend;
	FolksBackendStore* _tmp18_;
	FolksBackendStore* _tmp19_;
	FolksBackend* _tmp20_;
	GeeMap* _tmp21_;
	GeeMap* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GeeMap* _tmp25_;
	GeeMap* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar** _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	GMainLoop* _tmp41_;
	GError * _inner_error_ = NULL;
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_return_if_fail (self != NULL);
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data1_->_ref_count_ = 1;
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data1_->self = g_object_ref (self);
#line 40 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 40 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data1_->main_loop = _tmp0_;
#line 377 "device-properties.c"
	{
		BluezTestBackend* _tmp1_;
		orgbluezMock* _tmp2_;
		orgbluezMock* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		BluezTestBackend* _tmp6_;
		orgbluezMock* _tmp7_;
		orgbluezMock* _tmp8_;
		BluezTestBackend* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp1_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp2_ = bluez_test_backend_get_mock_bluez (_tmp1_);
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp3_ = _tmp2_;
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp4_ = org_bluez_mock_add_adapter (_tmp3_, "hci0", "Test System", &_inner_error_);
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp5_ = _tmp4_;
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_free0 (_tmp5_);
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 408 "device-properties.c"
				goto __catch0_g_io_error;
			}
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			block1_data_unref (_data1_);
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_data1_ = NULL;
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_clear_error (&_inner_error_);
#line 45 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			return;
#line 421 "device-properties.c"
		}
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp6_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp7_ = bluez_test_backend_get_mock_bluez (_tmp6_);
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp8_ = _tmp7_;
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp9_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp10_ = bluez_test_backend_get_primary_device_address (_tmp9_);
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp11_ = _tmp10_;
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp12_ = org_bluez_mock_add_device (_tmp8_, "hci0", _tmp11_, "My Phone", &_inner_error_);
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp13_ = _tmp12_;
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_free0 (_tmp13_);
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 445 "device-properties.c"
				goto __catch0_g_io_error;
			}
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			block1_data_unref (_data1_);
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_data1_ = NULL;
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_clear_error (&_inner_error_);
#line 46 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			return;
#line 458 "device-properties.c"
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp14_;
#line 43 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		e1 = _inner_error_;
#line 43 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_inner_error_ = NULL;
#line 51 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp14_ = e1->message;
#line 51 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_error ("device-properties.vala:51: Error setting up mock BlueZ device: %s", _tmp14_);
#line 43 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_error_free0 (e1);
#line 476 "device-properties.c"
	}
	__finally0:
#line 43 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 43 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		block1_data_unref (_data1_);
#line 43 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_data1_ = NULL;
#line 43 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 43 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_clear_error (&_inner_error_);
#line 43 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		return;
#line 491 "device-properties.c"
	}
#line 55 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp15_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 55 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	bluez_test_backend_set_simple_device_vcard (_tmp15_, "BEGIN:VCARD\n" "VERSION:3.0\n" "N:Jones;Pam;Mrs.\n" "FN:Pam Jones\n" "TEL:0123456789\n" "END:VCARD\n");
#line 65 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_setenv ("FOLKS_PRIMARY_STORE", "", TRUE);
#line 67 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp16_ = folks_individual_aggregator_dup ();
#line 67 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	aggregator = _tmp16_;
#line 68 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_aggregator_prepare_and_wait_for_quiescence (aggregator, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
#line 83 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp17_ = _data1_->main_loop;
#line 83 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_loop_run_with_timeout (_tmp17_, 5);
#line 85 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp18_ = folks_individual_aggregator_get_backend_store (aggregator);
#line 85 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp19_ = _tmp18_;
#line 85 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp20_ = folks_backend_store_dup_backend_by_name (_tmp19_, "bluez");
#line 85 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	real_backend = _tmp20_;
#line 89 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp21_ = folks_individual_aggregator_get_individuals (aggregator);
#line 89 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp22_ = _tmp21_;
#line 89 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp23_ = gee_map_get_size (_tmp22_);
#line 89 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp24_ = _tmp23_;
#line 89 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_vala_assert (_tmp24_ == 0, "aggregator.individuals.size == 0");
#line 90 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp25_ = folks_backend_get_persona_stores (real_backend);
#line 90 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp26_ = _tmp25_;
#line 90 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp27_ = gee_map_get_size (_tmp26_);
#line 90 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp28_ = _tmp27_;
#line 90 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_vala_assert (_tmp28_ == 0, "real_backend.persona_stores.size == 0");
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp29_ = g_strdup ("Pam Jones");
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp30_ = g_new0 (gchar*, 1 + 1);
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp30_[0] = _tmp29_;
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp31_ = _tmp30_;
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp31__length1 = 1;
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp32_ = g_new0 (gchar*, 0 + 1);
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp33_ = _tmp32_;
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp33__length1 = 0;
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_aggregator_wait_for_individuals (aggregator, _tmp31_, 1, _tmp33_, 0, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
#line 93 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
#line 559 "device-properties.c"
	{
		BluezTestBackend* _tmp34_;
		orgbluezMock* _tmp35_;
		orgbluezMock* _tmp36_;
		BluezTestBackend* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp34_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp35_ = bluez_test_backend_get_mock_bluez (_tmp34_);
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp36_ = _tmp35_;
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp37_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp38_ = bluez_test_backend_get_primary_device_address (_tmp37_);
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp39_ = _tmp38_;
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		org_bluez_mock_pair_device (_tmp36_, "hci0", _tmp39_, &_inner_error_);
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 585 "device-properties.c"
				goto __catch2_g_io_error;
			}
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (real_backend);
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (aggregator);
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			block1_data_unref (_data1_);
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_data1_ = NULL;
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_clear_error (&_inner_error_);
#line 103 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			return;
#line 602 "device-properties.c"
		}
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e4 = NULL;
		const gchar* _tmp40_;
#line 101 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		e4 = _inner_error_;
#line 101 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_inner_error_ = NULL;
#line 108 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp40_ = e4->message;
#line 108 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_error ("device-properties.vala:108: Error pairing mock BlueZ device: %s", _tmp40_);
#line 101 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_error_free0 (e4);
#line 620 "device-properties.c"
	}
	__finally2:
#line 101 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 101 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (real_backend);
#line 101 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (aggregator);
#line 101 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		block1_data_unref (_data1_);
#line 101 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_data1_ = NULL;
#line 101 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 101 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_clear_error (&_inner_error_);
#line 101 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		return;
#line 639 "device-properties.c"
	}
#line 111 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp41_ = _data1_->main_loop;
#line 111 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_loop_run_with_timeout (_tmp41_, 5);
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_g_object_unref0 (real_backend);
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_g_object_unref0 (aggregator);
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	block1_data_unref (_data1_);
#line 38 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data1_ = NULL;
#line 653 "device-properties.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	return _data2_;
#line 662 "device-properties.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 671 "device-properties.c"
		DevicePropertiesTests* self;
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		self = _data2_->self;
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_main_loop_unref0 (_data2_->main_loop);
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (self);
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_slice_free (Block2Data, _data2_);
#line 681 "device-properties.c"
	}
}


static void __lambda6_ (Block2Data* _data2_, GObject* o, GAsyncResult* r) {
	DevicePropertiesTests* self;
	GError * _inner_error_ = NULL;
#line 146 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	self = _data2_->self;
#line 146 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_return_if_fail (r != NULL);
#line 693 "device-properties.c"
	{
		GAsyncResult* _tmp0_;
#line 150 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp0_ = r;
#line 150 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		folks_test_utils_aggregator_prepare_and_wait_for_quiescence_finish (_tmp0_, &_inner_error_);
#line 150 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 702 "device-properties.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e2 = NULL;
		const gchar* _tmp1_;
#line 148 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		e2 = _inner_error_;
#line 148 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_inner_error_ = NULL;
#line 154 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp1_ = e2->message;
#line 154 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_error ("device-properties.vala:154: Error preparing aggregator: %s", _tmp1_);
#line 148 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_error_free0 (e2);
#line 721 "device-properties.c"
	}
	__finally4:
#line 148 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_clear_error (&_inner_error_);
#line 148 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		return;
#line 732 "device-properties.c"
	}
#line 157 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_main_loop_quit (_data2_->main_loop);
#line 736 "device-properties.c"
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 145 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	__lambda6_ (self, source_object, res);
#line 145 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	block2_data_unref (self);
#line 745 "device-properties.c"
}


static void __lambda7_ (Block2Data* _data2_, GObject* o, GAsyncResult* r) {
	DevicePropertiesTests* self;
	GAsyncResult* _tmp0_;
#line 171 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	self = _data2_->self;
#line 171 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_return_if_fail (r != NULL);
#line 173 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp0_ = r;
#line 173 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_aggregator_wait_for_individuals_finish (_tmp0_);
#line 174 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_main_loop_quit (_data2_->main_loop);
#line 762 "device-properties.c"
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	__lambda7_ (self, source_object, res);
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	block2_data_unref (self);
#line 771 "device-properties.c"
}


static void __lambda8_ (Block2Data* _data2_, GObject* o, GAsyncResult* r) {
	DevicePropertiesTests* self;
	GAsyncResult* _tmp0_;
#line 192 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	self = _data2_->self;
#line 192 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_return_if_fail (r != NULL);
#line 194 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp0_ = r;
#line 194 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_aggregator_wait_for_individuals_finish (_tmp0_);
#line 195 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_main_loop_quit (_data2_->main_loop);
#line 788 "device-properties.c"
}


static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	__lambda8_ (self, source_object, res);
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	block2_data_unref (self);
#line 797 "device-properties.c"
}


void device_properties_tests_test_blocked_device (DevicePropertiesTests* self) {
	Block2Data* _data2_;
	GMainLoop* _tmp0_;
	BluezTestBackend* _tmp1_;
	FolksIndividualAggregator* aggregator;
	FolksIndividualAggregator* _tmp9_;
	FolksBackend* real_backend;
	FolksBackendStore* _tmp10_;
	FolksBackendStore* _tmp11_;
	FolksBackend* _tmp12_;
	GeeMap* _tmp13_;
	GeeMap* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GeeMap* _tmp17_;
	GeeMap* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	GeeMap* _tmp45_;
	GeeMap* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GeeMap* _tmp49_;
	GeeMap* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	GError * _inner_error_ = NULL;
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_return_if_fail (self != NULL);
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data2_->_ref_count_ = 1;
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data2_->self = g_object_ref (self);
#line 119 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 119 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data2_->main_loop = _tmp0_;
#line 122 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp1_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 122 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	bluez_test_backend_create_simple_device_with_vcard (_tmp1_, "BEGIN:VCARD\n" "VERSION:3.0\n" "N:Jones;Pam;Mrs.\n" "FN:Pam Jones\n" "TEL:0123456789\n" "END:VCARD\n", NULL, NULL);
#line 858 "device-properties.c"
	{
		BluezTestBackend* _tmp2_;
		orgbluezMock* _tmp3_;
		orgbluezMock* _tmp4_;
		BluezTestBackend* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp2_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp3_ = bluez_test_backend_get_mock_bluez (_tmp2_);
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp4_ = _tmp3_;
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp5_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp6_ = bluez_test_backend_get_primary_device_address (_tmp5_);
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp7_ = _tmp6_;
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		org_bluez_mock_block_device (_tmp4_, "hci0", _tmp7_, &_inner_error_);
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 884 "device-properties.c"
				goto __catch3_g_io_error;
			}
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			block2_data_unref (_data2_);
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_data2_ = NULL;
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_clear_error (&_inner_error_);
#line 132 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			return;
#line 897 "device-properties.c"
		}
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp8_;
#line 130 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		e1 = _inner_error_;
#line 130 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_inner_error_ = NULL;
#line 137 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp8_ = e1->message;
#line 137 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_error ("device-properties.vala:137: Error blocking device: %s", _tmp8_);
#line 130 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_error_free0 (e1);
#line 915 "device-properties.c"
	}
	__finally3:
#line 130 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 130 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		block2_data_unref (_data2_);
#line 130 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_data2_ = NULL;
#line 130 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 130 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_clear_error (&_inner_error_);
#line 130 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		return;
#line 930 "device-properties.c"
	}
#line 142 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_setenv ("FOLKS_PRIMARY_STORE", "", TRUE);
#line 144 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp9_ = folks_individual_aggregator_dup ();
#line 144 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	aggregator = _tmp9_;
#line 145 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_aggregator_prepare_and_wait_for_quiescence (aggregator, ___lambda6__gasync_ready_callback, block2_data_ref (_data2_));
#line 160 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_loop_run_with_timeout (_data2_->main_loop, 5);
#line 162 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp10_ = folks_individual_aggregator_get_backend_store (aggregator);
#line 162 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp11_ = _tmp10_;
#line 162 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp12_ = folks_backend_store_dup_backend_by_name (_tmp11_, "bluez");
#line 162 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	real_backend = _tmp12_;
#line 166 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp13_ = folks_individual_aggregator_get_individuals (aggregator);
#line 166 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp14_ = _tmp13_;
#line 166 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp15_ = gee_map_get_size (_tmp14_);
#line 166 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp16_ = _tmp15_;
#line 166 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_vala_assert (_tmp16_ == 0, "aggregator.individuals.size == 0");
#line 167 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp17_ = folks_backend_get_persona_stores (real_backend);
#line 167 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp18_ = _tmp17_;
#line 167 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp19_ = gee_map_get_size (_tmp18_);
#line 167 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp20_ = _tmp19_;
#line 167 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_vala_assert (_tmp20_ == 0, "real_backend.persona_stores.size == 0");
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp21_ = g_strdup ("Pam Jones");
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp22_ = g_new0 (gchar*, 1 + 1);
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp22_[0] = _tmp21_;
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp23_ = _tmp22_;
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp23__length1 = 1;
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp24_ = g_new0 (gchar*, 0 + 1);
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp25_ = _tmp24_;
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp25__length1 = 0;
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_aggregator_wait_for_individuals (aggregator, _tmp23_, 1, _tmp25_, 0, ___lambda7__gasync_ready_callback, block2_data_ref (_data2_));
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
#line 170 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 992 "device-properties.c"
	{
		BluezTestBackend* _tmp26_;
		orgbluezMock* _tmp27_;
		orgbluezMock* _tmp28_;
		BluezTestBackend* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp26_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp27_ = bluez_test_backend_get_mock_bluez (_tmp26_);
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp28_ = _tmp27_;
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp29_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp30_ = bluez_test_backend_get_primary_device_address (_tmp29_);
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp31_ = _tmp30_;
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		org_bluez_mock_pair_device (_tmp28_, "hci0", _tmp31_, &_inner_error_);
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1018 "device-properties.c"
				goto __catch5_g_io_error;
			}
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (real_backend);
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (aggregator);
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			block2_data_unref (_data2_);
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_data2_ = NULL;
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_clear_error (&_inner_error_);
#line 180 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			return;
#line 1035 "device-properties.c"
		}
	}
	goto __finally5;
	__catch5_g_io_error:
	{
		GError* e4 = NULL;
		const gchar* _tmp32_;
#line 178 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		e4 = _inner_error_;
#line 178 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_inner_error_ = NULL;
#line 185 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp32_ = e4->message;
#line 185 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_error ("device-properties.vala:185: Error blocking device: %s", _tmp32_);
#line 178 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_error_free0 (e4);
#line 1053 "device-properties.c"
	}
	__finally5:
#line 178 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 178 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (real_backend);
#line 178 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (aggregator);
#line 178 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		block2_data_unref (_data2_);
#line 178 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_data2_ = NULL;
#line 178 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 178 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_clear_error (&_inner_error_);
#line 178 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		return;
#line 1072 "device-properties.c"
	}
#line 188 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_loop_run_with_timeout (_data2_->main_loop, 5);
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp33_ = g_new0 (gchar*, 0 + 1);
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp34_ = _tmp33_;
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp34__length1 = 0;
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp35_ = g_strdup ("Pam Jones");
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp36_ = g_new0 (gchar*, 1 + 1);
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp36_[0] = _tmp35_;
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp37_ = _tmp36_;
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp37__length1 = 1;
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_aggregator_wait_for_individuals (aggregator, _tmp34_, 0, _tmp37_, 1, ___lambda8__gasync_ready_callback, block2_data_ref (_data2_));
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp37_ = (_vala_array_free (_tmp37_, _tmp37__length1, (GDestroyNotify) g_free), NULL);
#line 191 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
#line 1098 "device-properties.c"
	{
		BluezTestBackend* _tmp38_;
		orgbluezMock* _tmp39_;
		orgbluezMock* _tmp40_;
		BluezTestBackend* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp38_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp39_ = bluez_test_backend_get_mock_bluez (_tmp38_);
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp40_ = _tmp39_;
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp41_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp42_ = bluez_test_backend_get_primary_device_address (_tmp41_);
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp43_ = _tmp42_;
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		org_bluez_mock_block_device (_tmp40_, "hci0", _tmp43_, &_inner_error_);
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1124 "device-properties.c"
				goto __catch6_g_io_error;
			}
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (real_backend);
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (aggregator);
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			block2_data_unref (_data2_);
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_data2_ = NULL;
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_clear_error (&_inner_error_);
#line 201 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			return;
#line 1141 "device-properties.c"
		}
	}
	goto __finally6;
	__catch6_g_io_error:
	{
		GError* e5 = NULL;
		const gchar* _tmp44_;
#line 199 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		e5 = _inner_error_;
#line 199 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_inner_error_ = NULL;
#line 206 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp44_ = e5->message;
#line 206 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_error ("device-properties.vala:206: Error blocking device again: %s", _tmp44_);
#line 199 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_error_free0 (e5);
#line 1159 "device-properties.c"
	}
	__finally6:
#line 199 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 199 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (real_backend);
#line 199 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (aggregator);
#line 199 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		block2_data_unref (_data2_);
#line 199 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_data2_ = NULL;
#line 199 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 199 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_clear_error (&_inner_error_);
#line 199 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		return;
#line 1178 "device-properties.c"
	}
#line 209 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_loop_run_with_timeout (_data2_->main_loop, 5);
#line 212 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp45_ = folks_individual_aggregator_get_individuals (aggregator);
#line 212 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp46_ = _tmp45_;
#line 212 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp47_ = gee_map_get_size (_tmp46_);
#line 212 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp48_ = _tmp47_;
#line 212 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_vala_assert (_tmp48_ == 0, "aggregator.individuals.size == 0");
#line 213 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp49_ = folks_backend_get_persona_stores (real_backend);
#line 213 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp50_ = _tmp49_;
#line 213 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp51_ = gee_map_get_size (_tmp50_);
#line 213 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp52_ = _tmp51_;
#line 213 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_vala_assert (_tmp52_ == 0, "real_backend.persona_stores.size == 0");
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_g_object_unref0 (real_backend);
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_g_object_unref0 (aggregator);
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	block2_data_unref (_data2_);
#line 117 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data2_ = NULL;
#line 1210 "device-properties.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	return _data3_;
#line 1219 "device-properties.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1228 "device-properties.c"
		DevicePropertiesTests* self;
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		self = _data3_->self;
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_main_loop_unref0 (_data3_->main_loop);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_free0 (_data3_->display_name);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (_data3_->real_store);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (self);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_slice_free (Block3Data, _data3_);
#line 1242 "device-properties.c"
	}
}


static void __lambda9_ (Block3Data* _data3_, GParamSpec* p) {
	DevicePropertiesTests* self;
	FolksPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	GMainLoop* _tmp2_;
#line 252 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	self = _data3_->self;
#line 252 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_return_if_fail (p != NULL);
#line 254 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp0_ = _data3_->real_store;
#line 254 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_object_get ((GObject*) _tmp0_, "display-name", &_data3_->display_name, NULL);
#line 255 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp1_ = _data3_->display_name;
#line 255 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_vala_assert (g_strcmp0 (_tmp1_, "New Alias!") == 0, "display_name == \"New Alias!\"");
#line 256 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp2_ = _data3_->main_loop;
#line 256 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_main_loop_quit (_tmp2_);
#line 1268 "device-properties.c"
}


static void ___lambda9__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 252 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	__lambda9_ (self, pspec);
#line 1275 "device-properties.c"
}


static void _g_free0_ (gpointer var) {
#line 266 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	var = (g_free (var), NULL);
#line 1282 "device-properties.c"
}


static void _g_variant_unref0_ (gpointer var) {
#line 266 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
#line 1289 "device-properties.c"
}


static GVariant* _variant_new1 (const gchar* value) {
#line 267 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	return g_variant_ref_sink (g_variant_new_string (value));
#line 1296 "device-properties.c"
}


static GVariant* _variant_new2 (const gchar* value) {
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	return g_variant_ref_sink (g_variant_new_string (value));
#line 1303 "device-properties.c"
}


static GVariant* _variant_new3 (GHashTable* value) {
	GVariantBuilder _tmp43_;
	GHashTableIter _tmp44_;
	gpointer _tmp45_;
	gpointer _tmp46_;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_hash_table_iter_init (&_tmp44_, value);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_variant_builder_init (&_tmp43_, G_VARIANT_TYPE ("a{sv}"));
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	while (g_hash_table_iter_next (&_tmp44_, &_tmp45_, &_tmp46_)) {
#line 1318 "device-properties.c"
		gchar* _key;
		GVariant* _value;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_key = (gchar*) _tmp45_;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_value = (GVariant*) _tmp46_;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_variant_builder_add (&_tmp43_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
#line 1327 "device-properties.c"
	}
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	return g_variant_ref_sink (g_variant_builder_end (&_tmp43_));
#line 1331 "device-properties.c"
}


void device_properties_tests_test_device_alias (DevicePropertiesTests* self) {
	Block3Data* _data3_;
	gchar* device_path;
	gchar* _tmp0_;
	BluezTestBackend* _tmp1_;
	gchar* _tmp2_ = NULL;
	FolksIndividualAggregator* aggregator;
	FolksIndividualAggregator* _tmp3_;
	FolksIndividualAggregator* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	FolksBackend* real_backend;
	FolksIndividualAggregator* _tmp8_;
	FolksBackendStore* _tmp9_;
	FolksBackendStore* _tmp10_;
	FolksBackend* _tmp11_;
	FolksBackend* _tmp12_;
	GeeMap* _tmp13_;
	GeeMap* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	FolksBackend* _tmp17_;
	GeeMap* _tmp18_;
	GeeMap* _tmp19_;
	BluezTestBackend* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gpointer _tmp23_;
	gchar* _tmp24_;
	FolksPersonaStore* _tmp25_;
	const gchar* _tmp26_;
	GMainLoop* _tmp27_;
	FolksPersonaStore* _tmp28_;
	GMainLoop* _tmp55_;
	GError * _inner_error_ = NULL;
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_return_if_fail (self != NULL);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data3_->_ref_count_ = 1;
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data3_->self = g_object_ref (self);
#line 221 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp0_ = g_strdup ("");
#line 221 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	device_path = _tmp0_;
#line 222 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp1_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 222 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	bluez_test_backend_create_simple_device_with_vcard (_tmp1_, "BEGIN:VCARD\n" "VERSION:3.0\n" "N:Jones;Pam;Mrs.\n" "FN:Pam Jones\n" "TEL:0123456789\n" "END:VCARD\n", NULL, &_tmp2_);
#line 222 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_g_free0 (device_path);
#line 222 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	device_path = _tmp2_;
#line 231 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp3_ = folks_individual_aggregator_dup ();
#line 231 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	aggregator = _tmp3_;
#line 232 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp4_ = aggregator;
#line 232 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp5_ = g_strdup ("Pam Jones");
#line 232 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp6_ = g_new0 (gchar*, 1 + 1);
#line 232 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp6_[0] = _tmp5_;
#line 232 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp7_ = _tmp6_;
#line 232 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp7__length1 = 1;
#line 232 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_aggregator_prepare_and_wait_for_individuals_sync_with_timeout (_tmp4_, _tmp7_, 1, 5);
#line 232 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
#line 236 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp8_ = aggregator;
#line 236 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp9_ = folks_individual_aggregator_get_backend_store (_tmp8_);
#line 236 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp10_ = _tmp9_;
#line 236 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp11_ = folks_backend_store_dup_backend_by_name (_tmp10_, "bluez");
#line 236 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	real_backend = _tmp11_;
#line 238 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp12_ = real_backend;
#line 238 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp13_ = folks_backend_get_persona_stores (_tmp12_);
#line 238 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp14_ = _tmp13_;
#line 238 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp15_ = gee_map_get_size (_tmp14_);
#line 238 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp16_ = _tmp15_;
#line 238 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_vala_assert (_tmp16_ == 1, "real_backend.persona_stores.size == 1");
#line 240 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp17_ = real_backend;
#line 240 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp18_ = folks_backend_get_persona_stores (_tmp17_);
#line 240 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp19_ = _tmp18_;
#line 240 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp20_ = ((BluezTestTestCase*) self)->bluez_backend;
#line 240 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp21_ = bluez_test_backend_get_primary_device_address (_tmp20_);
#line 240 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp22_ = _tmp21_;
#line 240 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp23_ = gee_map_get (_tmp19_, _tmp22_);
#line 240 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data3_->real_store = (FolksPersonaStore*) _tmp23_;
#line 246 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp24_ = g_strdup ("");
#line 246 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data3_->display_name = _tmp24_;
#line 247 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp25_ = _data3_->real_store;
#line 247 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_object_get ((GObject*) _tmp25_, "display-name", &_data3_->display_name, NULL);
#line 248 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp26_ = _data3_->display_name;
#line 248 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_vala_assert (g_strcmp0 (_tmp26_, "My Phone") == 0, "display_name == \"My Phone\"");
#line 251 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp27_ = g_main_loop_new (NULL, FALSE);
#line 251 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data3_->main_loop = _tmp27_;
#line 252 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp28_ = _data3_->real_store;
#line 252 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_signal_connect_data ((GObject*) _tmp28_, "notify::display-name", (GCallback) ___lambda9__g_object_notify, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 1470 "device-properties.c"
	{
		Device* mock_device;
		const gchar* _tmp29_;
		Device* _tmp30_;
		orgfreedesktopDBusMock* mock;
		const gchar* _tmp31_;
		orgfreedesktopDBusMock* _tmp32_;
		GHashTable* props;
		GHashFunc _tmp33_;
		GEqualFunc _tmp34_;
		GHashTable* _tmp35_;
		GHashTable* _tmp36_;
		gchar* _tmp37_;
		GVariant* _tmp38_;
		Device* _tmp39_;
		orgfreedesktopDBusMock* _tmp40_;
		GVariant* _tmp41_;
		GHashTable* _tmp42_;
		GVariant* _tmp47_;
		const GVariantType* _tmp48_;
		GVariant** _tmp49_;
		GVariant** _tmp50_;
		gint _tmp50__length1;
		GVariant* _tmp51_;
		GVariant** _tmp52_;
		GVariant** _tmp53_;
		gint _tmp53__length1;
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp29_ = device_path;
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp30_ = g_initable_new (TYPE_DEVICE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.bluez", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp29_, "g-interface-name", "org.bluez.Device1", "g-interface-info", g_type_get_qdata (TYPE_DEVICE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		mock_device = (Device*) _tmp30_;
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1508 "device-properties.c"
				goto __catch7_g_io_error;
			}
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (real_backend);
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (aggregator);
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_free0 (device_path);
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			block3_data_unref (_data3_);
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_data3_ = NULL;
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_clear_error (&_inner_error_);
#line 261 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			return;
#line 1527 "device-properties.c"
		}
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp31_ = device_path;
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp32_ = g_initable_new (ORG_FREEDESKTOP_DBUS_TYPE_MOCK_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.bluez", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp31_, "g-interface-name", "org.freedesktop.DBus.Mock", "g-interface-info", g_type_get_qdata (ORG_FREEDESKTOP_DBUS_TYPE_MOCK, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		mock = (orgfreedesktopDBusMock*) _tmp32_;
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (mock_device);
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1541 "device-properties.c"
				goto __catch7_g_io_error;
			}
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (mock_device);
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (real_backend);
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (aggregator);
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_free0 (device_path);
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			block3_data_unref (_data3_);
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_data3_ = NULL;
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_clear_error (&_inner_error_);
#line 263 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			return;
#line 1562 "device-properties.c"
		}
#line 266 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp33_ = g_str_hash;
#line 266 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp34_ = g_str_equal;
#line 266 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp35_ = g_hash_table_new_full (_tmp33_, _tmp34_, _g_free0_, _g_variant_unref0_);
#line 266 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		props = _tmp35_;
#line 267 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp36_ = props;
#line 267 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp37_ = g_strdup ("Alias");
#line 267 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp38_ = _variant_new1 ("New Alias!");
#line 267 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_hash_table_insert (_tmp36_, _tmp37_, _tmp38_);
#line 269 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp39_ = mock_device;
#line 269 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		device_set_alias (_tmp39_, "New Alias!");
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp40_ = mock;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp41_ = _variant_new2 ("org.bluez.Device1");
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp42_ = props;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp47_ = _variant_new3 (_tmp42_);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp48_ = G_VARIANT_TYPE_STRING;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp49_ = g_new0 (GVariant*, 0 + 1);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp50_ = _tmp49_;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp50__length1 = 0;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp51_ = g_variant_new_array (_tmp48_, _tmp50_, 0);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_variant_ref_sink (_tmp51_);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp52_ = g_new0 (GVariant*, 3 + 1);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp52_[0] = _tmp41_;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp52_[1] = _tmp47_;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp52_[2] = _tmp51_;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp53_ = _tmp52_;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp53__length1 = 3;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		org_freedesktop_dbus_mock_emit_signal (_tmp40_, "org.freedesktop.DBus.Properties", "PropertiesChanged", "sa{sv}as", _tmp53_, 3, &_inner_error_);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp53_ = (_vala_array_free (_tmp53_, _tmp53__length1, (GDestroyNotify) g_variant_unref), NULL);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp50_ = (_vala_array_free (_tmp50_, _tmp50__length1, (GDestroyNotify) g_variant_unref), NULL);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_hash_table_unref0 (props);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (mock);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (mock_device);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1632 "device-properties.c"
				goto __catch7_g_io_error;
			}
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_hash_table_unref0 (props);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (mock);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (mock_device);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (real_backend);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_object_unref0 (aggregator);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_g_free0 (device_path);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			block3_data_unref (_data3_);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			_data3_ = NULL;
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			g_clear_error (&_inner_error_);
#line 270 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
			return;
#line 1657 "device-properties.c"
		}
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_hash_table_unref0 (props);
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (mock);
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (mock_device);
#line 1665 "device-properties.c"
	}
	goto __finally7;
	__catch7_g_io_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp54_;
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		e1 = _inner_error_;
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_inner_error_ = NULL;
#line 280 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_tmp54_ = e1->message;
#line 280 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_error ("device-properties.vala:280: Error setting device alias: %s", _tmp54_);
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_error_free0 (e1);
#line 1682 "device-properties.c"
	}
	__finally7:
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (real_backend);
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_object_unref0 (aggregator);
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_g_free0 (device_path);
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		block3_data_unref (_data3_);
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		_data3_ = NULL;
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		g_clear_error (&_inner_error_);
#line 259 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		return;
#line 1703 "device-properties.c"
	}
#line 283 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp55_ = _data3_->main_loop;
#line 283 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_utils_loop_run_with_timeout (_tmp55_, 5);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_g_object_unref0 (real_backend);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_g_object_unref0 (aggregator);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_g_free0 (device_path);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	block3_data_unref (_data3_);
#line 218 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_data3_ = NULL;
#line 1719 "device-properties.c"
}


static void device_properties_tests_class_init (DevicePropertiesTestsClass * klass) {
#line 24 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	device_properties_tests_parent_class = g_type_class_peek_parent (klass);
#line 1726 "device-properties.c"
}


static void device_properties_tests_instance_init (DevicePropertiesTests * self) {
}


GType device_properties_tests_get_type (void) {
	static volatile gsize device_properties_tests_type_id__volatile = 0;
	if (g_once_init_enter (&device_properties_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DevicePropertiesTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) device_properties_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DevicePropertiesTests), 0, (GInstanceInitFunc) device_properties_tests_instance_init, NULL };
		GType device_properties_tests_type_id;
		device_properties_tests_type_id = g_type_register_static (BLUEZ_TEST_TYPE_TEST_CASE, "DevicePropertiesTests", &g_define_type_info, 0);
		g_once_init_leave (&device_properties_tests_type_id__volatile, device_properties_tests_type_id);
	}
	return device_properties_tests_type_id__volatile;
}


gchar* device_get_alias (Device* self) {
#line 292 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 292 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	return DEVICE_GET_INTERFACE (self)->get_alias (self);
#line 1751 "device-properties.c"
}


void device_set_alias (Device* self, const gchar* value) {
#line 292 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_return_if_fail (self != NULL);
#line 292 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	DEVICE_GET_INTERFACE (self)->set_alias (self, value);
#line 1760 "device-properties.c"
}


static void device_base_init (DeviceIface * iface) {
#line 289 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	static gboolean initialized = FALSE;
#line 289 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	if (!initialized) {
#line 289 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
		initialized = TRUE;
#line 1771 "device-properties.c"
	}
}


GType device_get_type (void) {
	static volatile gsize device_type_id__volatile = 0;
	if (g_once_init_enter (&device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DeviceIface), (GBaseInitFunc) device_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType device_type_id;
		device_type_id = g_type_register_static (G_TYPE_INTERFACE, "Device", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (device_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (device_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) device_proxy_get_type);
		g_type_set_qdata (device_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.Device1");
		g_type_set_qdata (device_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_device_dbus_interface_info));
		g_type_set_qdata (device_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) device_register_object);
		g_once_init_leave (&device_type_id__volatile, device_type_id);
	}
	return device_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DeviceProxy, device_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_DEVICE, device_proxy_device_interface_init) )
static void device_proxy_class_init (DeviceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = device_proxy_g_signal;
}


static void device_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void device_proxy_init (DeviceProxy* self) {
}


static gchar* device_dbus_proxy_get_alias (Device* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Alias");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static void device_dbus_proxy_set_alias (Device* self, const gchar* value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static void device_proxy_device_interface_init (DeviceIface* iface) {
	iface->get_alias = device_dbus_proxy_get_alias;
	iface->set_alias = device_dbus_proxy_set_alias;
}


static void device_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* _dbus_device_get_alias (Device* self) {
	gchar* result;
	GVariant* _reply;
	result = device_get_alias (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* device_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Alias") == 0) {
		return _dbus_device_get_alias (object);
	}
	return NULL;
}


static void _dbus_device_set_alias (Device* self, GVariant* _value) {
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	device_set_alias (self, value);
	_g_free0 (value);
}


static gboolean device_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Alias") == 0) {
		_dbus_device_set_alias (object, value);
		return TRUE;
	}
	return FALSE;
}


guint device_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_device_dbus_interface_info), &_device_dbus_interface_vtable, data, _device_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _device_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	DevicePropertiesTests* tests;
	DevicePropertiesTests* _tmp0_;
#line 297 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_test_init (&args_length1, &args, NULL);
#line 299 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_tmp0_ = device_properties_tests_new ();
#line 299 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	tests = _tmp0_;
#line 300 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_case_register ((FolksTestCase*) tests);
#line 301 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	g_test_run ();
#line 302 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	folks_test_case_final_tear_down ((FolksTestCase*) tests);
#line 304 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	result = 0;
#line 304 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	_g_object_unref0 (tests);
#line 304 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	return result;
#line 1956 "device-properties.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 295 "/opt/gnome/source/folks/tests/bluez/device-properties.vala"
	return _vala_main (argv, argc);
#line 1966 "device-properties.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



